/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.message.AbstractHeaderImpl;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class StringHeader
extends AbstractHeaderImpl {
    protected final QName name;
    protected final String value;
    protected boolean mustUnderstand = false;
    protected SOAPVersion soapVersion;
    protected static final String MUST_UNDERSTAND = "mustUnderstand";
    protected static final String S12_MUST_UNDERSTAND_TRUE = "true";
    protected static final String S11_MUST_UNDERSTAND_TRUE = "1";

    public StringHeader(@NotNull QName qName, @NotNull String string) {
        assert (qName != null);
        assert (string != null);
        this.name = qName;
        this.value = string;
    }

    public StringHeader(@NotNull QName qName, @NotNull String string, @NotNull SOAPVersion sOAPVersion, boolean bl) {
        this.name = qName;
        this.value = string;
        this.soapVersion = sOAPVersion;
        this.mustUnderstand = bl;
    }

    @Override
    @NotNull
    public String getNamespaceURI() {
        return this.name.getNamespaceURI();
    }

    @Override
    @NotNull
    public String getLocalPart() {
        return this.name.getLocalPart();
    }

    @Override
    @Nullable
    public String getAttribute(@NotNull String string, @NotNull String string2) {
        if (this.mustUnderstand && this.soapVersion.nsUri.equals(string) && MUST_UNDERSTAND.equals(string2)) {
            return StringHeader.getMustUnderstandLiteral(this.soapVersion);
        }
        return null;
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
        XMLStreamWriter xMLStreamWriter = mutableXMLStreamBuffer.createFromXMLStreamWriter();
        this.writeTo(xMLStreamWriter);
        return mutableXMLStreamBuffer.readAsXMLStreamReader();
    }

    @Override
    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("", this.name.getLocalPart(), this.name.getNamespaceURI());
        xMLStreamWriter.writeDefaultNamespace(this.name.getNamespaceURI());
        if (this.mustUnderstand) {
            xMLStreamWriter.writeNamespace("S", this.soapVersion.nsUri);
            xMLStreamWriter.writeAttribute("S", this.soapVersion.nsUri, MUST_UNDERSTAND, StringHeader.getMustUnderstandLiteral(this.soapVersion));
        }
        xMLStreamWriter.writeCharacters(this.value);
        xMLStreamWriter.writeEndElement();
    }

    @Override
    public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
        SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
        if (sOAPHeader == null) {
            sOAPHeader = sOAPMessage.getSOAPPart().getEnvelope().addHeader();
        }
        SOAPHeaderElement sOAPHeaderElement = sOAPHeader.addHeaderElement(this.name);
        if (this.mustUnderstand) {
            sOAPHeaderElement.setMustUnderstand(true);
        }
        sOAPHeaderElement.addTextNode(this.value);
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        String string = this.name.getNamespaceURI();
        String string2 = this.name.getLocalPart();
        contentHandler.startPrefixMapping("", string);
        if (this.mustUnderstand) {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute(this.soapVersion.nsUri, MUST_UNDERSTAND, "S:mustUnderstand", "CDATA", StringHeader.getMustUnderstandLiteral(this.soapVersion));
            contentHandler.startElement(string, string2, string2, attributesImpl);
        } else {
            contentHandler.startElement(string, string2, string2, EMPTY_ATTS);
        }
        contentHandler.characters(this.value.toCharArray(), 0, this.value.length());
        contentHandler.endElement(string, string2, string2);
    }

    private static String getMustUnderstandLiteral(SOAPVersion sOAPVersion) {
        if (sOAPVersion == SOAPVersion.SOAP_12) {
            return S12_MUST_UNDERSTAND_TRUE;
        }
        return S11_MUST_UNDERSTAND_TRUE;
    }
}

