/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.server;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.org.glassfish.gmbal.ManagedObjectManager;
import com.sun.xml.internal.ws.api.Component;
import com.sun.xml.internal.ws.api.ComponentRegistry;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.internal.ws.api.config.management.ManagedEndpointFactory;
import com.sun.xml.internal.ws.api.databinding.MetadataReader;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.Engine;
import com.sun.xml.internal.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.internal.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.ThrowableContainerPropertySet;
import com.sun.xml.internal.ws.api.server.BoundEndpoint;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.EndpointComponent;
import com.sun.xml.internal.ws.api.server.Invoker;
import com.sun.xml.internal.ws.api.server.Module;
import com.sun.xml.internal.ws.api.server.SDDocumentSource;
import com.sun.xml.internal.ws.api.server.ServiceDefinition;
import com.sun.xml.internal.ws.api.server.TransportBackChannel;
import com.sun.xml.internal.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.server.EndpointAwareTube;
import com.sun.xml.internal.ws.server.EndpointFactory;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.OperationDispatcher;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public abstract class WSEndpoint<T>
implements ComponentRegistry {
    @NotNull
    public abstract Codec createCodec();

    @NotNull
    public abstract QName getServiceName();

    @NotNull
    public abstract QName getPortName();

    @NotNull
    public abstract Class<T> getImplementationClass();

    @NotNull
    public abstract WSBinding getBinding();

    @NotNull
    public abstract Container getContainer();

    @Nullable
    public abstract WSDLPort getPort();

    public abstract void setExecutor(@NotNull Executor var1);

    public final void schedule(@NotNull Packet packet, @NotNull CompletionCallback completionCallback) {
        this.schedule(packet, completionCallback, null);
    }

    public abstract void schedule(@NotNull Packet var1, @NotNull CompletionCallback var2, @Nullable FiberContextSwitchInterceptor var3);

    public void process(@NotNull Packet packet, @NotNull CompletionCallback completionCallback, @Nullable FiberContextSwitchInterceptor fiberContextSwitchInterceptor) {
        this.schedule(packet, completionCallback, fiberContextSwitchInterceptor);
    }

    public Engine getEngine() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public abstract PipeHead createPipeHead();

    public abstract void dispose();

    @Nullable
    public abstract ServiceDefinition getServiceDefinition();

    public List<BoundEndpoint> getBoundEndpoints() {
        Module module = this.getContainer().getSPI(Module.class);
        return module != null ? module.getBoundEndpoints() : null;
    }

    @NotNull
    public abstract Set<EndpointComponent> getComponentRegistry();

    @Override
    @NotNull
    public Set<Component> getComponents() {
        return Collections.emptySet();
    }

    @Override
    @Nullable
    public <S> S getSPI(@NotNull Class<S> clazz) {
        Set<Component> set = this.getComponents();
        if (set != null) {
            for (Component component : set) {
                S s = component.getSPI(clazz);
                if (s == null) continue;
                return s;
            }
        }
        return this.getContainer().getSPI(clazz);
    }

    @Nullable
    public abstract SEIModel getSEIModel();

    public abstract PolicyMap getPolicyMap();

    @NotNull
    public abstract ManagedObjectManager getManagedObjectManager();

    public abstract void closeManagedObjectManager();

    @NotNull
    public abstract ServerTubeAssemblerContext getAssemblerContext();

    public static <T> WSEndpoint<T> create(@NotNull Class<T> clazz, boolean bl, @Nullable Invoker invoker, @Nullable QName qName, @Nullable QName qName2, @Nullable Container container, @Nullable WSBinding wSBinding, @Nullable SDDocumentSource sDDocumentSource, @Nullable Collection<? extends SDDocumentSource> collection, @Nullable EntityResolver entityResolver, boolean bl2) {
        return WSEndpoint.create(clazz, bl, invoker, qName, qName2, container, wSBinding, sDDocumentSource, collection, entityResolver, bl2, true);
    }

    public static <T> WSEndpoint<T> create(@NotNull Class<T> clazz, boolean bl, @Nullable Invoker invoker, @Nullable QName qName, @Nullable QName qName2, @Nullable Container container, @Nullable WSBinding wSBinding, @Nullable SDDocumentSource sDDocumentSource, @Nullable Collection<? extends SDDocumentSource> collection, @Nullable EntityResolver entityResolver, boolean bl2, boolean bl3) {
        WSEndpoint<T> wSEndpoint = EndpointFactory.createEndpoint(clazz, bl, invoker, qName, qName2, container, wSBinding, sDDocumentSource, collection, entityResolver, bl2, bl3);
        Iterator<ManagedEndpointFactory> iterator = ServiceFinder.find(ManagedEndpointFactory.class).iterator();
        if (iterator.hasNext()) {
            ManagedEndpointFactory managedEndpointFactory = iterator.next();
            EndpointCreationAttributes endpointCreationAttributes = new EndpointCreationAttributes(bl, invoker, entityResolver, bl2);
            WSEndpoint<T> wSEndpoint2 = managedEndpointFactory.createEndpoint(wSEndpoint, endpointCreationAttributes);
            if (wSEndpoint.getAssemblerContext().getTerminalTube() instanceof EndpointAwareTube) {
                ((EndpointAwareTube)wSEndpoint.getAssemblerContext().getTerminalTube()).setEndpoint(wSEndpoint2);
            }
            return wSEndpoint2;
        }
        return wSEndpoint;
    }

    @Deprecated
    public static <T> WSEndpoint<T> create(@NotNull Class<T> clazz, boolean bl, @Nullable Invoker invoker, @Nullable QName qName, @Nullable QName qName2, @Nullable Container container, @Nullable WSBinding wSBinding, @Nullable SDDocumentSource sDDocumentSource, @Nullable Collection<? extends SDDocumentSource> collection, @Nullable EntityResolver entityResolver) {
        return WSEndpoint.create(clazz, bl, invoker, qName, qName2, container, wSBinding, sDDocumentSource, collection, entityResolver, false);
    }

    public static <T> WSEndpoint<T> create(@NotNull Class<T> clazz, boolean bl, @Nullable Invoker invoker, @Nullable QName qName, @Nullable QName qName2, @Nullable Container container, @Nullable WSBinding wSBinding, @Nullable SDDocumentSource sDDocumentSource, @Nullable Collection<? extends SDDocumentSource> collection, @Nullable URL uRL) {
        return WSEndpoint.create(clazz, bl, invoker, qName, qName2, container, wSBinding, sDDocumentSource, collection, XmlUtil.createEntityResolver(uRL), false);
    }

    @NotNull
    public static QName getDefaultServiceName(Class clazz) {
        return WSEndpoint.getDefaultServiceName(clazz, true, null);
    }

    @NotNull
    public static QName getDefaultServiceName(Class clazz, MetadataReader metadataReader) {
        return WSEndpoint.getDefaultServiceName(clazz, true, metadataReader);
    }

    @NotNull
    public static QName getDefaultServiceName(Class clazz, boolean bl) {
        return WSEndpoint.getDefaultServiceName(clazz, bl, null);
    }

    @NotNull
    public static QName getDefaultServiceName(Class clazz, boolean bl, MetadataReader metadataReader) {
        return EndpointFactory.getDefaultServiceName(clazz, bl, metadataReader);
    }

    @NotNull
    public static QName getDefaultPortName(@NotNull QName qName, Class clazz) {
        return WSEndpoint.getDefaultPortName(qName, clazz, null);
    }

    @NotNull
    public static QName getDefaultPortName(@NotNull QName qName, Class clazz, MetadataReader metadataReader) {
        return WSEndpoint.getDefaultPortName(qName, clazz, true, metadataReader);
    }

    @NotNull
    public static QName getDefaultPortName(@NotNull QName qName, Class clazz, boolean bl) {
        return WSEndpoint.getDefaultPortName(qName, clazz, bl, null);
    }

    @NotNull
    public static QName getDefaultPortName(@NotNull QName qName, Class clazz, boolean bl, MetadataReader metadataReader) {
        return EndpointFactory.getDefaultPortName(qName, clazz, bl, metadataReader);
    }

    public abstract <T extends EndpointReference> T getEndpointReference(Class<T> var1, String var2, String var3, Element ... var4);

    public abstract <T extends EndpointReference> T getEndpointReference(Class<T> var1, String var2, String var3, List<Element> var4, List<Element> var5);

    public boolean equalsProxiedInstance(WSEndpoint wSEndpoint) {
        if (wSEndpoint == null) {
            return false;
        }
        return this.equals(wSEndpoint);
    }

    @Nullable
    public abstract OperationDispatcher getOperationDispatcher();

    public abstract Packet createServiceResponseForException(ThrowableContainerPropertySet var1, Packet var2, SOAPVersion var3, WSDLPort var4, SEIModel var5, WSBinding var6);

    public static interface CompletionCallback {
        public void onCompletion(@NotNull Packet var1);
    }

    public static interface PipeHead {
        @NotNull
        public Packet process(@NotNull Packet var1, @Nullable WebServiceContextDelegate var2, @Nullable TransportBackChannel var3);
    }
}

