/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import panels.Scalable;
import panels.ScaleListener;

public class ScalableIcon
extends ImageIcon
implements Scalable {
    protected BufferedImage image;
    private float preferredScale = 1.0f;
    private float prevPreferredScale;
    private float prevPrevPreferredScale;
    private boolean integerScaling;
    private Scalable scaleParent = this;
    private JComponent owner;
    private final LinkedList<ScaleListener> listeners = new LinkedList();

    protected ScalableIcon() {
    }

    public ScalableIcon(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public ScalableIcon derive() {
        final ScalableIcon scalableIcon = this;
        final ScalableIcon scalableIcon2 = new ScalableIcon(){

            @Override
            protected BufferedImage getBaseImage() {
                return scalableIcon.getBaseImage();
            }
        };
        this.addScaleListener(new ScaleListener(){

            @Override
            public void setPreferredScale(float f) {
                scalableIcon2.setPreferredScale(scalableIcon2.getScale());
            }

            @Override
            public void setIntegerScaling(boolean bl) {
            }
        });
        return scalableIcon2;
    }

    public void setOwner(JComponent jComponent) {
        this.owner = jComponent;
    }

    @Override
    public float getScale() {
        return this.preferredScale;
    }

    @Override
    public final float getPreferredScale() {
        return this.preferredScale <= 0.0f ? this.getScale() : this.preferredScale;
    }

    @Override
    public final boolean isIntegerScaling() {
        return this.integerScaling;
    }

    @Override
    public final void setScaleParent(Scalable scalable) {
        if (scalable == null) {
            throw new IllegalArgumentException("ScaleParent must not be null.");
        }
        if (scalable != this.scaleParent && this.scaleParent != null) {
            this.scaleParent.removeScaleListener(this);
        }
        this.scaleParent = scalable;
        this.prevPreferredScale = 0.0f;
        this.prevPrevPreferredScale = 0.0f;
        scalable.addScaleListener(this);
    }

    @Override
    public final void setPreferredScale(float f) {
        if (f < this.prevPreferredScale || f != this.prevPrevPreferredScale) {
            this.preferredScale = f;
        }
        this.prevPrevPreferredScale = this.prevPreferredScale;
        this.prevPreferredScale = f;
        BufferedImage bufferedImage = this.getBaseImage();
        if (bufferedImage != null) {
            int n = (int)((float)bufferedImage.getWidth() * this.preferredScale);
            int n2 = (int)((float)bufferedImage.getHeight() * this.preferredScale);
            if (this.getImage() == null || this.getImage().getWidth(null) != n || this.getImage().getHeight(null) != n2) {
                BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null);
                graphics2D.dispose();
                this.setImage(bufferedImage2);
            }
        }
    }

    protected void update() {
        BufferedImage bufferedImage = (BufferedImage)this.getImage();
        if (bufferedImage != null) {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.setComposite(composite);
            graphics2D.drawImage(this.getBaseImage(), 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
            graphics2D.dispose();
            if (this.owner != null) {
                this.owner.repaint();
            }
        }
    }

    protected BufferedImage getBaseImage() {
        return this.image;
    }

    @Override
    public void setImage(Image image) {
        super.setImage(image);
        for (ScaleListener scaleListener : this.listeners) {
            scaleListener.setPreferredScale(this.getScale());
        }
        if (this.owner != null) {
            this.owner.revalidate();
            this.owner.repaint();
        }
    }

    @Override
    public final void setIntegerScaling(boolean bl) {
        this.integerScaling = bl;
    }

    @Override
    public final void addScaleListener(ScaleListener scaleListener) {
        if (scaleListener == this) {
            throw new IllegalArgumentException("A scalable must not listen to itself.");
        }
        if (!this.listeners.contains(scaleListener)) {
            this.listeners.add(scaleListener);
            scaleListener.setPreferredScale(this.getScale());
        }
    }

    @Override
    public final void removeScaleListener(ScaleListener scaleListener) {
        this.listeners.remove(scaleListener);
    }
}

