/*
 * Decompiled with CFR 0.152.
 */
package panels;

import changes.Change;
import changes.ChangeListener;
import data.Palette;
import data.Tiles;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mastersystem.Renderer;
import panels.ScalablePanel;
import transactions.TransactionManager;

public class TilesPanel
extends ScalablePanel {
    private static final int WIDTH = 256;
    private final Cursor defaultCursor;
    private BufferedImage image;
    private BufferedImage buffer;
    private final Color[] colors = new Color[32];
    private Tiles tiles;
    private Palette palette;
    private int[] vram;
    private int[][] selectedTiles = new int[][]{new int[1]};
    private int pal;
    private int mirrored;
    private boolean selectionEnabled = true;
    private boolean multiSelectionEnabled = true;
    private boolean allowDiscontinuousSelection = true;
    private boolean selectOnChange = true;
    private boolean adjustingSelection;
    private boolean dragging;
    private boolean selecting;
    private boolean dragRemove;
    private int offsetX;
    private int offsetY;
    private float scale = 1.0f;
    private boolean matchParentWidth;
    private final LinkedList<ActionListener> listeners = new LinkedList();
    private final ChangeListener tilesChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (TilesPanel.this.selectOnChange) {
                int n = change.getData(TilesPanel.this.tiles);
                boolean bl = false;
                int n2 = 0;
                while (n2 < TilesPanel.this.selectedTiles.length) {
                    int n3 = 0;
                    while (n3 < TilesPanel.this.selectedTiles[n2].length) {
                        if (n == TilesPanel.this.selectedTiles[n2][n3]) {
                            bl = true;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                if (!bl && n >= 0) {
                    TilesPanel.this.selectedTiles = new int[][]{{n}};
                }
            }
            TilesPanel.this.update();
            if (TilesPanel.this.selectOnChange) {
                TilesPanel.this.fireActionPerformed();
            }
        }
    };
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(TilesPanel.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                if (n2 == 2 || n2 == TilesPanel.this.pal) {
                    int n3 = TilesPanel.this.pal * 16;
                    int n4 = n3 + (1 << TilesPanel.this.tiles.getBPP());
                    int n5 = n3;
                    while (n5 < n4) {
                        int n6 = TilesPanel.this.palette.getColors()[n5];
                        int n7 = (n6 & 0x30) >> 4;
                        int n8 = (n6 & 0xC) >> 2;
                        int n9 = n6 & 3;
                        ((TilesPanel)TilesPanel.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                        ++n5;
                    }
                }
            } else if (n >= TilesPanel.this.pal * 16 && n < TilesPanel.this.pal * 16 + (1 << TilesPanel.this.tiles.getBPP())) {
                int n10 = TilesPanel.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((TilesPanel)TilesPanel.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
                TilesPanel.this.render();
            }
        }
    };

    public TilesPanel(Tiles tiles, Palette palette) {
        this.setTiles(tiles, palette);
        this.defaultCursor = this.getCursor();
        final Cursor cursor = Cursor.getPredefinedCursor(11);
        final Cursor cursor2 = Cursor.getPredefinedCursor(12);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    int n;
                    int n2 = TilesPanel.this.toScreenX(mouseEvent.getX());
                    int n3 = n2 >= 0 ? n2 / 8 : n2 / 8 - 1;
                    int n4 = TilesPanel.this.toScreenY(mouseEvent.getY()) / 8;
                    if (n3 < 0 || n3 >= 32) {
                        return;
                    }
                    int n5 = n4 * 32 + n3;
                    if (TilesPanel.this.selectionEnabled) {
                        if (TilesPanel.this.multiSelectionEnabled) {
                            if (mouseEvent.isShiftDown()) {
                                if (n5 < TilesPanel.this.getFirstSelectedTile()) {
                                    TilesPanel.this.adjustingSelection = true;
                                    n = TilesPanel.this.getFirstSelectedTile() - 1;
                                    while (n >= n5) {
                                        if (!TilesPanel.this.isSelectedTile(n)) {
                                            TilesPanel.this.toggleSelectedTile(n);
                                        }
                                        --n;
                                    }
                                    TilesPanel.this.repaint();
                                    TilesPanel.this.fireActionPerformed();
                                } else if (n5 > TilesPanel.this.getFirstSelectedTile() && n5 < TilesPanel.this.getLastSelectedTile()) {
                                    TilesPanel.this.adjustingSelection = true;
                                    n = TilesPanel.this.getLastSelectedTile();
                                    while (n > n5) {
                                        TilesPanel.this.toggleSelectedTile(n);
                                        --n;
                                    }
                                    TilesPanel.this.repaint();
                                    TilesPanel.this.fireActionPerformed();
                                } else if (n5 > TilesPanel.this.getLastSelectedTile()) {
                                    TilesPanel.this.adjustingSelection = true;
                                    n = TilesPanel.this.getLastSelectedTile() + 1;
                                    while (n <= n5) {
                                        if (!TilesPanel.this.isSelectedTile(n)) {
                                            TilesPanel.this.toggleSelectedTile(n);
                                        }
                                        ++n;
                                    }
                                    TilesPanel.this.repaint();
                                    TilesPanel.this.fireActionPerformed();
                                }
                            } else if ((mouseEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                                TilesPanel.this.dragRemove = TilesPanel.this.isSelectedTile(n5);
                                TilesPanel.this.toggleSelectedTile(n5);
                            } else {
                                TilesPanel.this.setSelectedTile(n5);
                            }
                        } else {
                            TilesPanel.this.setSelectedTile(n5);
                        }
                    }
                    n = TilesPanel.this.tiles.getLength() / 32;
                    TilesPanel.this.dragging = false;
                    if (n5 == n && TilesPanel.this.tiles.canAddTileToTileset()) {
                        TilesPanel.this.dragging = true;
                    }
                    TilesPanel.this.selecting = !TilesPanel.this.dragging;
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                TilesPanel.this.dragging = false;
                TilesPanel.this.selecting = false;
                TilesPanel.this.dragRemove = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = TilesPanel.this.toScreenX(mouseEvent.getX());
                int n2 = TilesPanel.this.toScreenY(mouseEvent.getY());
                int n3 = n >= 0 ? n / 8 : n / 8 - 1;
                int n4 = n2 >= 0 ? n2 / 8 : n2 / 8 - 1;
                int n5 = n4 * 32 + n3;
                int n6 = TilesPanel.this.tiles.getLength() / 32;
                if (n3 >= 0 && n3 < 32 && n4 >= 0 && n4 < (n6 - 1 + 1) / 32 + 1) {
                    if (n5 == n6 && TilesPanel.this.tiles.canAddTileToTileset()) {
                        TilesPanel.this.setCursor(cursor);
                    } else if (TilesPanel.this.selectionEnabled && n5 < n6) {
                        TilesPanel.this.setCursor(cursor2);
                    } else {
                        TilesPanel.this.setCursor(TilesPanel.this.defaultCursor);
                    }
                } else {
                    TilesPanel.this.setCursor(TilesPanel.this.defaultCursor);
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = TilesPanel.this.toScreenX(mouseEvent.getX());
                int n2 = n >= 0 ? n / 8 : n / 8 - 1;
                int n3 = TilesPanel.this.toScreenY(mouseEvent.getY()) / 8 * 32 + n2;
                int n4 = TilesPanel.this.tiles.getLength() / 32;
                if (TilesPanel.this.selecting) {
                    if (TilesPanel.this.selectionEnabled && TilesPanel.this.multiSelectionEnabled && TilesPanel.this.isSelectedTile(n3) == TilesPanel.this.dragRemove) {
                        TilesPanel.this.toggleSelectedTile(n3);
                    }
                } else if (TilesPanel.this.dragging && (Math.abs(n3 - n4) == 1 || n3 / 32 == n4 / 32)) {
                    if (n3 > n4) {
                        TransactionManager.getInstance().runTransaction(new Runnable(){

                            @Override
                            public void run() {
                                TilesPanel.this.tiles.addTile();
                            }
                        });
                    } else if (n3 < n4) {
                        TransactionManager.getInstance().runTransaction(new Runnable(){

                            @Override
                            public void run() {
                                TilesPanel.this.tiles.removeTile();
                            }
                        });
                    }
                    TilesPanel.this.dragging = n2 >= 0 && n2 < 32;
                    if (!TilesPanel.this.dragging) {
                        TilesPanel.this.setCursor(TilesPanel.this.defaultCursor);
                    }
                }
            }
        });
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        TilesPanel.this.tiles.moveLeft(TilesPanel.this.selectedTiles);
                    }
                });
            }
        }, KeyStroke.getKeyStroke(37, 2), 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        TilesPanel.this.tiles.moveUp(TilesPanel.this.selectedTiles);
                    }
                });
            }
        }, KeyStroke.getKeyStroke(38, 2), 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        TilesPanel.this.tiles.moveRight(TilesPanel.this.selectedTiles);
                    }
                });
            }
        }, KeyStroke.getKeyStroke(39, 2), 2);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        TilesPanel.this.tiles.moveDown(TilesPanel.this.selectedTiles);
                    }
                });
            }
        }, KeyStroke.getKeyStroke(40, 2), 2);
    }

    public void setSelectionEnabled(boolean bl) {
        this.selectionEnabled = bl;
        this.repaint();
    }

    public void setMultiSelectionEnabled(boolean bl) {
        this.multiSelectionEnabled = bl;
        this.repaint();
    }

    public void setAllowDiscontinuousSelection(boolean bl) {
        this.allowDiscontinuousSelection = bl;
        this.repaint();
    }

    public void setSelectOnChange(boolean bl) {
        this.selectOnChange = bl;
    }

    public void copyToClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new Transferable(){
            private BufferedImage data;
            {
                this.data = new BufferedImage(TilesPanel.this.image.getColorModel(), TilesPanel.this.image.copyData(null), TilesPanel.this.image.isAlphaPremultiplied(), null);
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.imageFlavor.equals(dataFlavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return this.data;
            }
        }, null);
    }

    public void copyTilesToClipboard() {
        final BufferedImage bufferedImage = new BufferedImage(this.selectedTiles[0].length * 8, this.selectedTiles.length * 8, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n = 0;
        while (n < this.selectedTiles.length) {
            int n2 = 0;
            while (n2 < this.selectedTiles[n].length) {
                if (this.selectedTiles[n][n2] >= 0) {
                    Renderer.renderCharacter(this.tiles.getVRAM(), this.pal << 11 | this.tiles.getDestination() / 32 + this.selectedTiles[n][n2], n2 * 8, n * 8, this.colors, graphics2D);
                }
                ++n2;
            }
            ++n;
        }
        graphics2D.dispose();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new Transferable(){

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.imageFlavor.equals(dataFlavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return bufferedImage;
            }
        }, null);
    }

    public boolean canPasteFromClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.imageFlavor);
    }

    public void pasteFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor)) {
                Image image = (Image)clipboard.getData(DataFlavor.imageFlavor);
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
                graphics2D.dispose();
                this.setPixels(bufferedImage);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void pasteTileFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor)) {
                Image image = (Image)clipboard.getData(DataFlavor.imageFlavor);
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
                graphics2D.dispose();
                this.setPixels(this.selectedTiles, bufferedImage);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setTiles(Tiles tiles, Palette palette) {
        int n;
        if (this.tiles == tiles && this.palette == palette) {
            return;
        }
        if (this.tiles != null && this.tiles != tiles) {
            this.tiles.removeChangeListener(this.tilesChangeListener);
        }
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        this.tiles = tiles;
        this.palette = palette;
        int n2 = 0;
        int[] nArray = palette.getColors();
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            n = nArray[n4];
            int n5 = (n & 0x30) >> 4;
            int n6 = (n & 0xC) >> 2;
            int n7 = n & 3;
            this.colors[n2++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n4;
        }
        if (this.selectedTiles != null) {
            n2 = 0;
            while (n2 < this.selectedTiles.length) {
                n = 0;
                while (n < this.selectedTiles[n2].length) {
                    if (this.selectedTiles[n2][n] >= tiles.getLength() / 32) {
                        this.selectedTiles = new int[][]{new int[1]};
                        break;
                    }
                    ++n;
                }
                ++n2;
            }
        } else {
            this.selectedTiles = new int[][]{new int[1]};
        }
        tiles.addChangeListener(this.tilesChangeListener);
        palette.addChangeListener(this.paletteChangeListener);
        this.setCursor(this.defaultCursor);
        this.update();
    }

    public void setSelectedTile(int n) {
        if (n < this.tiles.getLength() / 32) {
            this.selectedTiles = new int[][]{{n}};
            this.repaint();
            this.fireActionPerformed();
        }
    }

    public boolean isSelectedTile(int n) {
        if (this.selectedTiles == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.selectedTiles.length) {
            int n3 = 0;
            while (n3 < this.selectedTiles[n2].length) {
                if (this.selectedTiles[n2][n3] == n) {
                    return true;
                }
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    public int getSelectedTile() {
        return this.getFirstSelectedTile();
    }

    public int getFirstSelectedTile() {
        if (this.selectedTiles == null) {
            return -1;
        }
        return this.selectedTiles[0][0];
    }

    public int getLastSelectedTile() {
        if (this.selectedTiles == null) {
            return -1;
        }
        int n = this.selectedTiles[this.selectedTiles.length - 1].length - 1;
        while (n >= 0) {
            if (this.selectedTiles[this.selectedTiles.length - 1][n] >= 0) {
                return this.selectedTiles[this.selectedTiles.length - 1][n];
            }
            --n;
        }
        return -1;
    }

    public void setSelectedTiles(int[][] nArray) {
        this.selectedTiles = nArray;
        this.repaint();
        this.fireActionPerformed();
    }

    public void toggleSelectedTile(int n) {
        if (n < this.tiles.getLength() / 32) {
            int n2 = 0;
            int[] nArray = new int[this.selectedTiles.length * this.selectedTiles[0].length];
            if (!this.allowDiscontinuousSelection && (n < this.getFirstSelectedTile() - 1 || n > this.getLastSelectedTile() + 1 || n > this.getFirstSelectedTile() && n < this.getLastSelectedTile())) {
                return;
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = this.selectedTiles[n3 / this.selectedTiles[0].length][n3 % this.selectedTiles[0].length];
                if (nArray[n3] < 0) break;
                ++n2;
                ++n3;
            }
            nArray = Arrays.copyOf(nArray, n2);
            n3 = 0;
            int n4 = 0;
            while (n4 < nArray.length && n3 == 0) {
                int[] nArray2;
                if (n == nArray[n4]) {
                    nArray2 = new int[nArray.length - 1];
                    if (n4 > 0) {
                        System.arraycopy(nArray, 0, nArray2, 0, n4);
                    }
                    System.arraycopy(nArray, n4 + 1, nArray2, n4, nArray.length - (n4 + 1));
                    nArray = nArray2;
                    n3 = 1;
                } else if (n < nArray[n4]) {
                    if (nArray[nArray.length - 1] > -1) {
                        nArray2 = new int[nArray.length + 1];
                        if (n4 > 0) {
                            System.arraycopy(nArray, 0, nArray2, 0, n4);
                        }
                        System.arraycopy(nArray, n4, nArray2, n4 + 1, nArray.length - n4);
                        nArray2[n4] = n;
                        nArray = nArray2;
                    } else {
                        int n5 = nArray.length - 1;
                        while (n5 > 0) {
                            nArray[n5] = nArray[n5 - 1];
                            --n5;
                        }
                        nArray[0] = n;
                    }
                    n3 = 1;
                }
                ++n4;
            }
            if (n3 == 0) {
                nArray = Arrays.copyOf(nArray, nArray.length + 1);
                nArray[nArray.length - 1] = n;
            }
            if (this.allowDiscontinuousSelection) {
                if (nArray.length < 1) {
                    this.selectedTiles = new int[][]{{n}};
                } else if (nArray.length == 1) {
                    this.selectedTiles = new int[][]{nArray};
                } else {
                    this.selectedTiles = this.selectedTiles[0].length > 1 ? new int[(nArray.length - 1) / this.selectedTiles[0].length + 1][this.selectedTiles[0].length] : new int[(nArray.length - 1) / 2 + 1][2];
                    Arrays.fill(this.selectedTiles[this.selectedTiles.length - 1], -1);
                    n4 = 0;
                    while (n4 < nArray.length) {
                        this.selectedTiles[n4 / this.selectedTiles[0].length][n4 % this.selectedTiles[0].length] = nArray[n4];
                        ++n4;
                    }
                }
            } else {
                this.selectedTiles = nArray.length < 1 ? (Object)new int[][]{{n}} : (int[][])new int[][]{nArray};
            }
            if (!this.adjustingSelection) {
                this.repaint();
                this.fireActionPerformed();
            }
        }
    }

    public void setPal(int n) {
        if (this.pal != n) {
            this.pal = n;
            this.render();
        }
    }

    public void setMirrored(boolean bl) {
        if (this.mirrored != (bl ? 1 : 0)) {
            this.mirrored = bl ? 1 : 0;
            this.render();
        }
    }

    public void flipH() {
        if (this.selectedTiles != null) {
            TransactionManager.getInstance().runTransaction(new Runnable(){

                @Override
                public void run() {
                    TilesPanel.this.tiles.flipH(TilesPanel.this.selectedTiles);
                }
            });
        }
    }

    public void flipV() {
        if (this.selectedTiles != null) {
            TransactionManager.getInstance().runTransaction(new Runnable(){

                @Override
                public void run() {
                    TilesPanel.this.tiles.flipV(TilesPanel.this.selectedTiles);
                }
            });
        }
    }

    public void setPixel(final int n, final int n2, final int n3, final int n4) {
        if (this.selectedTiles != null) {
            TransactionManager.getInstance().runTransaction(new Runnable(){

                @Override
                public void run() {
                    TilesPanel.this.tiles.setPixel(TilesPanel.this.selectedTiles[n][n2], n3, n4);
                }
            });
        }
    }

    public int getPixel(int n, int n2, int n3) {
        if (this.selectedTiles != null) {
            return this.tiles.getPixel(this.selectedTiles[n][n2], n3);
        }
        return 0;
    }

    public void setPixels(BufferedImage bufferedImage) {
        int n = Math.min(this.image.getHeight(), bufferedImage.getHeight());
        int n2 = Math.min(this.image.getWidth(), bufferedImage.getWidth());
        final int[][] nArray = new int[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                Color color = new Color(bufferedImage.getRGB(n4, n3), true);
                int n5 = 0;
                if (color.getAlpha() > 0) {
                    double d = Double.MAX_VALUE;
                    int n6 = 0;
                    while (n6 < 1 << this.tiles.getBPP()) {
                        int n7;
                        int n8;
                        int n9 = this.colors[(this.pal == 1 ? 16 : 0) + n6].getRed() - color.getRed();
                        double d2 = Math.sqrt(n9 * n9 + (n8 = this.colors[(this.pal == 1 ? 16 : 0) + n6].getGreen() - color.getGreen()) * n8 + (n7 = this.colors[(this.pal == 1 ? 16 : 0) + n6].getBlue() - color.getBlue()) * n7);
                        if (d2 < d) {
                            d = d2;
                            n5 = n6;
                        }
                        ++n6;
                    }
                }
                nArray[n3][n4] = n5;
                ++n4;
            }
            ++n3;
        }
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                TilesPanel.this.tiles.setPixels(nArray);
            }
        });
    }

    public void setPixels(final int n, BufferedImage bufferedImage) {
        int n2 = Math.min(8, bufferedImage.getHeight());
        int n3 = Math.min(8, bufferedImage.getWidth());
        final int[][] nArray = new int[n2][n3];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n3) {
                Color color = new Color(bufferedImage.getRGB(n5, n4));
                int n6 = 0;
                double d = Double.MAX_VALUE;
                int n7 = 0;
                while (n7 < 1 << this.tiles.getBPP()) {
                    int n8;
                    int n9;
                    int n10 = this.colors[(this.pal == 1 ? 16 : 0) + n7].getRed() - color.getRed();
                    double d2 = Math.sqrt(n10 * n10 + (n9 = this.colors[(this.pal == 1 ? 16 : 0) + n7].getGreen() - color.getGreen()) * n9 + (n8 = this.colors[(this.pal == 1 ? 16 : 0) + n7].getBlue() - color.getBlue()) * n8);
                    if (d2 < d) {
                        d = d2;
                        n6 = n7;
                    }
                    ++n7;
                }
                nArray[n4][n5] = n6;
                ++n5;
            }
            ++n4;
        }
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                TilesPanel.this.tiles.setPixels(n, nArray);
            }
        });
    }

    public void setPixels(final int[][] nArray, BufferedImage bufferedImage) {
        final int[][][][] nArray2 = new int[nArray.length][nArray[0].length][][];
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                int n3 = Math.min(8, bufferedImage.getHeight() - n * 8);
                int n4 = Math.min(8, bufferedImage.getWidth() - n2 * 8);
                if (n4 > 0 && n3 > 0) {
                    nArray2[n][n2] = new int[n3][n4];
                    int n5 = 0;
                    while (n5 < n3) {
                        int n6 = 0;
                        while (n6 < n4) {
                            Color color = new Color(bufferedImage.getRGB(n2 * 8 + n6, n * 8 + n5));
                            int n7 = 0;
                            double d = Double.MAX_VALUE;
                            int n8 = 0;
                            while (n8 < 1 << this.tiles.getBPP()) {
                                int n9;
                                int n10;
                                int n11 = this.colors[(this.pal == 1 ? 16 : 0) + n8].getRed() - color.getRed();
                                double d2 = Math.sqrt(n11 * n11 + (n10 = this.colors[(this.pal == 1 ? 16 : 0) + n8].getGreen() - color.getGreen()) * n10 + (n9 = this.colors[(this.pal == 1 ? 16 : 0) + n8].getBlue() - color.getBlue()) * n9);
                                if (d2 < d) {
                                    d = d2;
                                    n7 = n8;
                                }
                                ++n8;
                            }
                            nArray2[n][n2][n5][n6] = n7;
                            ++n6;
                        }
                        ++n5;
                    }
                }
                ++n2;
            }
            ++n;
        }
        TransactionManager.getInstance().runTransaction(new Runnable(){

            @Override
            public void run() {
                TilesPanel.this.tiles.setPixels(nArray, nArray2);
            }
        });
    }

    public int[][] getSelectedTileIndices() {
        return this.selectedTiles;
    }

    public int[][][] getSelectedTiles() {
        if (this.selectedTiles == null) {
            return null;
        }
        int[][][] nArray = new int[this.selectedTiles.length][this.selectedTiles[0].length][];
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[n].length) {
                if (this.selectedTiles[n][n2] >= 0) {
                    nArray[n][n2] = this.tiles.getTile(this.selectedTiles[n][n2]);
                }
                ++n2;
            }
            ++n;
        }
        return nArray;
    }

    public void setMatchParentWidth(boolean bl) {
        this.matchParentWidth = bl;
    }

    private void update() {
        this.vram = this.tiles.getVRAM();
        this.render();
        if (this.selectedTiles != null) {
            int n = this.tiles.getLength() / 32;
            int n2 = 0;
            while (n2 < this.selectedTiles.length) {
                int n3 = 0;
                while (n3 < this.selectedTiles[n2].length) {
                    if (this.selectedTiles[n2][n3] >= n) {
                        this.selectedTiles[n2][n3] = n - 1;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    private void render() {
        Graphics2D graphics2D;
        int n;
        int n2 = this.tiles.getLength() / 32;
        int n3 = n = this.tiles.canAddTileToTileset() ? n2 + 1 : n2;
        if (this.image == null || this.image.getHeight() != ((n - 1) / 32 + 1) * 8 || this.image.getWidth() != Math.min(256, n * 8)) {
            this.image = new BufferedImage(Math.min(256, n * 8), ((n - 1) / 32 + 1) * 8, 2);
            this.buffer = new BufferedImage(this.image.getWidth(), this.image.getHeight(), this.image.getType());
            this.revalidate();
        } else {
            graphics2D = this.image.createGraphics();
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
            graphics2D.setComposite(composite);
            graphics2D.dispose();
        }
        graphics2D = this.image.createGraphics();
        int n4 = 0;
        while (n4 < n2) {
            Renderer.renderCharacter(this.vram, this.pal << 11 | this.mirrored << 9 | this.tiles.getDestination() / 32 + n4, n4 % 32 * 8, n4 / 32 * 8, this.colors, graphics2D);
            ++n4;
        }
        graphics2D.dispose();
        this.repaint();
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public Dimension getPreferredSize() {
        float f = this.getPreferredScale();
        if (this.matchParentWidth && this.getParent() != null && this.getParent().getWidth() > 0) {
            f = (float)this.getParent().getWidth() / 256.0f;
            if (this.isIntegerScaling()) {
                f = (int)f;
            }
        }
        return new Dimension((int)((float)(256 + (this.tiles.canAddTileToTileset() ? 16 : 0)) * f), (int)((float)this.image.getHeight() * f));
    }

    private int toScreenX(int n) {
        return n >= this.offsetX ? (int)((float)(n - this.offsetX) / this.scale) : (int)((float)(n - this.offsetX) / this.scale) - 1;
    }

    private int toScreenY(int n) {
        return n >= this.offsetY ? (int)((float)(n - this.offsetY) / this.scale) : (int)((float)(n - this.offsetY) / this.scale) - 1;
    }

    protected final void fireActionPerformed() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
        this.adjustingSelection = false;
    }

    public final void addActionListener(ActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    public final void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = this.buffer.createGraphics();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        graphics2D.setComposite(composite);
        graphics2D.drawImage((Image)this.image, 0, 0, null);
        if (this.selectionEnabled && this.selectedTiles != null) {
            int n2 = 0;
            while (n2 < this.selectedTiles.length) {
                n = 0;
                while (n < this.selectedTiles[n2].length) {
                    if (this.selectedTiles[n2][n] >= 0) {
                        graphics2D.setColor(Color.WHITE);
                        graphics2D.drawRect(this.selectedTiles[n2][n] % 32 * 8, this.selectedTiles[n2][n] / 32 * 8, 8, 8);
                    }
                    ++n;
                }
                ++n2;
            }
        }
        graphics2D.dispose();
        Insets insets = this.getInsets();
        n = this.getWidth() - (insets.left + insets.right);
        int n3 = this.getHeight() - (insets.top + insets.bottom);
        float f = (float)n / (float)this.buffer.getWidth();
        float f2 = (float)n3 / (float)this.buffer.getHeight();
        float f3 = Math.min(f, f2);
        if (this.isIntegerScaling()) {
            float f4;
            if ((this.scale != (float)((int)this.scale) || f3 - this.scale < 0.0f || f3 - this.scale >= 1.0f) && this.scale != (f4 = this.matchParentWidth ? (float)Math.max(1, (int)f3) : (float)Math.max(1, (int)(this.scale + Math.max(-1.0f, Math.min(1.0f, (f3 - this.scale) * 1.0f)))))) {
                this.scale = f4;
                this.scaleUpdated();
            }
        } else if (Math.abs(f3 - this.scale) * (float)this.buffer.getWidth() > 2.0f && Math.abs(f3 - this.scale) * (float)this.buffer.getHeight() > 2.0f) {
            this.scale += (f3 - this.scale) * 0.5f;
            this.scaleUpdated();
        }
        this.offsetX = Math.max(0, (int)(((float)n - (float)this.buffer.getWidth() * this.scale) / 2.0f)) + insets.left;
        this.offsetY = Math.max(0, (int)(((float)n3 - (float)this.buffer.getHeight() * this.scale) / 2.0f)) + insets.right;
        graphics.drawImage(this.buffer, this.offsetX, this.offsetY, (int)((float)this.buffer.getWidth() * this.scale), (int)((float)this.buffer.getHeight() * this.scale), null);
        if (this.tiles.canAddTileToTileset()) {
            graphics2D = (Graphics2D)graphics;
            int n4 = this.tiles.getLength() / 32;
            float f5 = (float)this.offsetX + (float)(n4 % 32 * 8) * this.scale;
            float f6 = (float)this.offsetY + (float)(n4 / 32 * 8) * this.scale;
            float f7 = f6 + 8.0f * this.scale / 2.0f;
            graphics2D.setStroke(new BasicStroke(this.scale / 2.0f));
            graphics2D.setColor(Color.DARK_GRAY);
            graphics2D.fillRect((int)f5, (int)f6, (int)(8.0f * this.scale), (int)(8.0f * this.scale));
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.drawLine((int)f5, (int)f6, (int)(f5 + 8.0f * this.scale), (int)f6);
            graphics2D.drawLine((int)(f5 + 8.0f * this.scale), (int)f6, (int)(f5 + 8.0f * this.scale), (int)(f6 + 8.0f * this.scale));
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine((int)f5, (int)f6, (int)f5, (int)(f6 + 8.0f * this.scale));
            graphics2D.drawLine((int)f5, (int)(f6 + 8.0f * this.scale), (int)(f5 + 8.0f * this.scale), (int)(f6 + 8.0f * this.scale));
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawLine((int)(f5 + 3.0f * this.scale), (int)f7, (int)(f5 + 5.0f * this.scale), (int)f7);
            int n5 = (int)this.scale;
            int n6 = (int)(2.0f * this.scale);
            graphics2D.fillPolygon(new int[]{(int)(f5 + 2.0f * this.scale), (int)(f5 + 2.0f * this.scale) + n5, (int)(f5 + 2.0f * this.scale) + n5}, new int[]{(int)f7, (int)f7 + n6, (int)f7 - n6}, 3);
            graphics2D.fillPolygon(new int[]{(int)(f5 + 5.0f * this.scale), (int)(f5 + 5.0f * this.scale), (int)(f5 + 5.0f * this.scale) + n5}, new int[]{(int)f7 + n6, (int)f7 - n6, (int)f7}, 3);
        }
    }
}

