/*
 * Decompiled with CFR 0.152.
 */
package mastersystem;

import editormodels.GameEditorModelManager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import rom.RomManager;

public final class Renderer {
    private static final int[] MIRRORED_BITS;
    private static final int[] STRETCHED_BITPLANE;
    private static boolean disabled;

    static {
        int n;
        MIRRORED_BITS = new int[256];
        STRETCHED_BITPLANE = new int[256];
        int n2 = 0;
        while (n2 < MIRRORED_BITS.length) {
            n = n2;
            int n3 = 8;
            while (n > 0) {
                int n4 = n2;
                MIRRORED_BITS[n4] = MIRRORED_BITS[n4] << 1;
                int n5 = n2;
                MIRRORED_BITS[n5] = MIRRORED_BITS[n5] | n & 1;
                n >>= 1;
                --n3;
            }
            int n6 = n2++;
            MIRRORED_BITS[n6] = MIRRORED_BITS[n6] << n3;
        }
        n2 = 0;
        while (n2 < STRETCHED_BITPLANE.length) {
            n = 0;
            while (n < 8) {
                if ((n2 & 1 << n) != 0) {
                    int n7 = n2;
                    STRETCHED_BITPLANE[n7] = STRETCHED_BITPLANE[n7] | 1 << (n << 2);
                }
                ++n;
            }
            ++n2;
        }
    }

    private Renderer() {
    }

    public static void setDisabled(boolean bl) {
        disabled = bl;
    }

    public static void renderMetaTile(int[] nArray, int[] nArray2, int n, int n2, boolean bl, Color[] colorArray, Graphics2D graphics2D) {
        if (disabled) {
            return;
        }
        int n3 = bl ? 255 : 15;
        int n4 = 0;
        while (n4 < nArray2.length / 2) {
            Renderer.renderCharacter(nArray, (nArray2[n4 * 2 + 1] & n3) << 8 | nArray2[n4 * 2], n + n4 % 2 * 8, n2 + n4 / 2 * 8, colorArray, graphics2D);
            ++n4;
        }
    }

    public static void blankLeftMostColumn(Color[] colorArray, BufferedImage bufferedImage) {
        if (disabled) {
            return;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(colorArray[16]);
        int n = 0;
        while (n < bufferedImage.getHeight()) {
            graphics2D.fillRect(0, n, 8, 1);
            ++n;
        }
        graphics2D.dispose();
    }

    public static void renderCharacter(int[] nArray, int n, int n2, int n3, Color[] colorArray, Graphics2D graphics2D) {
        int n4;
        if (disabled) {
            return;
        }
        int n5 = (n & 0x800) >> 7;
        boolean bl = (n & 0x400) != 0;
        boolean bl2 = (n & 0x200) != 0;
        int n6 = (n & 0xFFF) << 3;
        int n7 = (n6 & 0xFFF) << 2;
        if (bl) {
            n7 ^= 0x1C;
        }
        int n8 = 0;
        while (n8 < 8) {
            n4 = nArray[n7];
            int n9 = nArray[n7 | 1];
            int n10 = nArray[n7 | 2];
            int n11 = nArray[n7 | 3];
            if (n4 == 0 && n9 == 0 && n10 == 0 && n11 == 0) {
                graphics2D.setColor(colorArray[n5]);
                graphics2D.fillRect(n2, n3, 8, 1);
            } else {
                if (!bl2) {
                    n4 = MIRRORED_BITS[n4];
                    n9 = MIRRORED_BITS[n9];
                    n10 = MIRRORED_BITS[n10];
                    n11 = MIRRORED_BITS[n11];
                }
                int n12 = STRETCHED_BITPLANE[n11] << 3 | STRETCHED_BITPLANE[n10] << 2 | STRETCHED_BITPLANE[n9] << 1 | STRETCHED_BITPLANE[n4];
                int n13 = 0;
                while (n13 < 8) {
                    int n14 = n12 & 0xF;
                    n12 >>= 4;
                    graphics2D.setColor(colorArray[n5 | n14]);
                    graphics2D.fillRect(n2 + n13, n3, 1, 1);
                    ++n13;
                }
            }
            ++n6;
            n7 += bl ? -4 : 4;
            ++n3;
            ++n8;
        }
        n3 -= 8;
        n8 = n & 0xFF;
        n4 = n >> 8;
        switch (n4 >> 5) {
            case 1: {
                graphics2D.setColor(Color.CYAN);
                graphics2D.drawString("~", n2, n3 + 8);
                break;
            }
            case 2: {
                if (n8 < RomManager.StaticAccess.readByte(15461)) {
                    graphics2D.setColor(Color.YELLOW);
                    graphics2D.drawString("$", n2, n3 + 8);
                    break;
                }
                graphics2D.setColor(Color.ORANGE);
                graphics2D.drawString("S", n2, n3 + 8);
                break;
            }
            case 3: {
                if (n8 < RomManager.StaticAccess.readByte(15573)) {
                    if (n8 == 63) {
                        graphics2D.setColor(Color.GREEN);
                        graphics2D.drawString("#", n2, n3 + 8);
                        break;
                    }
                    graphics2D.setColor(Color.RED);
                    graphics2D.drawString("X", n2, n3 + 8);
                    break;
                }
                graphics2D.setColor(Color.YELLOW);
                graphics2D.drawString("S", n2, n3 + 8);
                break;
            }
            case 4: {
                graphics2D.setColor(Color.RED);
                graphics2D.drawRect(n2, n3, 7, 7);
                break;
            }
            case 5: {
                if (n8 == 63) {
                    graphics2D.setColor(Color.GREEN);
                    graphics2D.drawString("L", n2, n3 + 8);
                    break;
                }
                graphics2D.setColor(Color.GREEN);
                graphics2D.drawString("T", n2, n3 + 8);
                break;
            }
            case 6: {
                graphics2D.setColor(Color.GRAY);
                graphics2D.drawString("*", n2 + 2, n3 + 8 + 2);
                break;
            }
            case 7: {
                graphics2D.setColor(Color.MAGENTA);
                graphics2D.drawString("?", n2, n3 + 8);
            }
        }
        if ((n4 & 0x10) != 0) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(n2 + 4, n3 + 4, 3, 3);
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(n2 + 5, n3 + 5, 3, 3);
        }
    }

    public static boolean renderSpriteCharacter(int[] nArray, int n, int n2, int n3, Color[] colorArray, BufferedImage bufferedImage) {
        if (disabled) {
            return true;
        }
        boolean bl = false;
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n4 = GameEditorModelManager.getGameDataModel().getSpriteAttributeTableAddress();
        int n5 = 0;
        while (n5 < 8 && n3 + n5 < bufferedImage.getHeight()) {
            int n6 = n4 | n << 5 | n5 << 2;
            int n7 = MIRRORED_BITS[nArray[n6]];
            int n8 = MIRRORED_BITS[nArray[n6 | 1]];
            int n9 = MIRRORED_BITS[nArray[n6 | 2]];
            int n10 = MIRRORED_BITS[nArray[n6 | 3]];
            if (n7 != 0 || n8 != 0 || n9 != 0 || n10 != 0) {
                int n11 = STRETCHED_BITPLANE[n10] << 3 | STRETCHED_BITPLANE[n9] << 2 | STRETCHED_BITPLANE[n8] << 1 | STRETCHED_BITPLANE[n7];
                int n12 = 0;
                while (n12 < 8 && n2 + n12 < bufferedImage.getWidth()) {
                    int n13 = n11 & 0xF;
                    n11 >>= 4;
                    if (n13 != 0) {
                        graphics2D.setColor(colorArray[0x10 | n13]);
                        graphics2D.fillRect(n2 + n12, n3 + n5, 1, 1);
                        bl = true;
                    }
                    ++n12;
                }
            }
            ++n5;
        }
        graphics2D.dispose();
        return bl;
    }
}

