/*
 * Decompiled with CFR 0.152.
 */
package editors;

import changes.UndoRedoManager;
import common.MenuItem;
import common.Properties;
import common.ScreenUtilities;
import data.Palette;
import data.Sprite;
import data.SpriteContainer;
import data.Tiles;
import data.Tileset;
import editors.HitboxEditor;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import miracleworld.MiracleWorldEditorModel;
import panels.SpritePanel;
import panels.TilesPanel;
import panels.TilesetPanel;
import rom.RomManager;
import transactions.TransactionManager;
import widgets.ScalableIcon;
import widgets.SpriteList;
import widgets.TilesetComboBox;

public class SpriteEditor
extends JDialog {
    private final ScalableIcon ICON_HITBOX;
    private static SpriteEditor editor;
    private final JFrame owner;
    private final JComboBox<String> spriteSelection;
    private final JComboBox<String> alexSpriteSelection;
    private final TilesetComboBox tilesetSelection;
    private final JComboBox<String> hitboxSelection;
    private final SpritePanel spritePanel;
    private final SpriteList frameList;
    private final TilesPanel tilesPanel;
    private final TilesetPanel tilesetPanel;
    private SpriteContainer[] alexSprites;
    private SpriteContainer[] sprites;
    private Palette palette;
    private Tileset[] tilesets;
    private Tileset alexTiles;
    private Tileset[] sortedTilesets;
    private boolean adjustingTilesSelection;

    private SpriteEditor(final JFrame jFrame, SpriteContainer[] spriteContainerArray, Palette palette, Tileset[] tilesetArray, Tiles tiles) {
        Object object;
        this.setTitle(TextProvider.get("TitleSprite"));
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.GREEN);
        graphics2D.drawRect(3, 3, 10, 10);
        graphics2D.dispose();
        this.ICON_HITBOX = new ScalableIcon(bufferedImage);
        this.owner = jFrame;
        this.setLayout(new BorderLayout());
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(this.makeMenuEdit());
        this.add((Component)this.makeToolbar(), "First");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        ArrayList<SpriteContainer> arrayList = new ArrayList<SpriteContainer>();
        ArrayList<SpriteContainer> arrayList2 = new ArrayList<SpriteContainer>();
        Object object2 = spriteContainerArray;
        int n = spriteContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            if (((SpriteContainer)object).isAlexSprite()) {
                arrayList.add((SpriteContainer)object);
            } else {
                arrayList2.add((SpriteContainer)object);
            }
            ++n2;
        }
        this.alexSprites = arrayList.toArray(new SpriteContainer[arrayList.size()]);
        this.sprites = arrayList2.toArray(new SpriteContainer[arrayList2.size()]);
        this.palette = palette;
        this.tilesets = tilesetArray;
        this.alexTiles = new Tileset(tiles);
        this.spriteSelection = new JComboBox();
        this.spriteSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = SpriteEditor.this.tilesPanel.isVisible();
                SpriteEditor.this.alexSpriteSelection.setVisible(SpriteEditor.this.spriteSelection.getSelectedIndex() == 0);
                SpriteEditor.this.tilesPanel.setVisible(SpriteEditor.this.spriteSelection.getSelectedIndex() == 0);
                SpriteEditor.this.tilesetSelection.setVisible(SpriteEditor.this.spriteSelection.getSelectedIndex() > 0);
                SpriteEditor.this.tilesetPanel.setVisible(SpriteEditor.this.spriteSelection.getSelectedIndex() > 0);
                if (SpriteEditor.this.tilesPanel.isVisible() ^ bl) {
                    if (SpriteEditor.this.tilesPanel.isVisible()) {
                        SpriteEditor.this.ICON_HITBOX.setScaleParent(SpriteEditor.this.tilesPanel);
                        SpriteEditor.this.frameList.setScaleParent(SpriteEditor.this.tilesPanel);
                        SpriteEditor.this.tilesetSelection.setScaleParent(SpriteEditor.this.tilesPanel);
                        SpriteEditor.this.spritePanel.setScaleParent(SpriteEditor.this.tilesPanel);
                    } else {
                        SpriteEditor.this.ICON_HITBOX.setScaleParent(SpriteEditor.this.tilesetPanel);
                        SpriteEditor.this.frameList.setScaleParent(SpriteEditor.this.tilesetPanel);
                        SpriteEditor.this.tilesetSelection.setScaleParent(SpriteEditor.this.tilesetPanel);
                        SpriteEditor.this.spritePanel.setScaleParent(SpriteEditor.this.tilesetPanel);
                    }
                }
                SpriteEditor.this.frameList.setSelectedIndex(0);
                if (SpriteEditor.this.spriteSelection.getSelectedIndex() > 0) {
                    SpriteContainer spriteContainer = SpriteEditor.this.sprites[SpriteEditor.this.spriteSelection.getSelectedIndex() - 1];
                    SpriteEditor.this.sortedTilesets = spriteContainer.sortTilesets(SpriteEditor.this.tilesets);
                    SpriteEditor.this.tilesetSelection.setTilesets(SpriteEditor.this.sortedTilesets, SpriteEditor.this.palette);
                    SpriteEditor.this.tilesetSelection.setSelectedIndex(0);
                    if (SpriteEditor.this.frameList.getSelectedIndex() < spriteContainer.getSprites().length) {
                        SpriteEditor.this.hitboxSelection.setSelectedIndex(spriteContainer.getSprites()[SpriteEditor.this.frameList.getSelectedIndex()].getHitboxIndex() / 4);
                    }
                } else {
                    SpriteContainer spriteContainer = SpriteEditor.this.alexSprites[SpriteEditor.this.alexSpriteSelection.getSelectedIndex()];
                    SpriteEditor.this.spritePanel.setSprite(spriteContainer, SpriteEditor.this.palette, SpriteEditor.this.alexTiles);
                    SpriteEditor.this.frameList.setSprite(spriteContainer, SpriteEditor.this.palette, SpriteEditor.this.alexTiles);
                    SpriteEditor.this.hitboxSelection.setSelectedIndex(spriteContainer.getSprites()[SpriteEditor.this.frameList.getSelectedIndex()].getHitboxIndex() / 4);
                }
            }
        });
        this.spriteSelection.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                SpriteContainer spriteContainer = SpriteEditor.this.spriteSelection.getSelectedIndex() > 0 ? SpriteEditor.this.sprites[SpriteEditor.this.spriteSelection.getSelectedIndex() - 1] : SpriteEditor.this.alexSprites[SpriteEditor.this.alexSpriteSelection.getSelectedIndex()];
                Sprite sprite = spriteContainer.getSprites()[SpriteEditor.this.frameList.getSelectedIndex()];
                switch (keyEvent.getKeyCode()) {
                    case 80: {
                        System.out.println(sprite + ": " + sprite.getSpriteCount());
                    }
                }
            }
        });
        jPanel2.add(this.spriteSelection, "North");
        this.alexSpriteSelection = new JComboBox();
        this.alexSpriteSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SpriteEditor.this.spriteSelection.getSelectedIndex() == 0) {
                    SpriteContainer spriteContainer = SpriteEditor.this.alexSprites[SpriteEditor.this.alexSpriteSelection.getSelectedIndex()];
                    SpriteEditor.this.spritePanel.setSprite(spriteContainer, SpriteEditor.this.palette, SpriteEditor.this.alexTiles);
                    SpriteEditor.this.frameList.setSprite(spriteContainer, SpriteEditor.this.palette, SpriteEditor.this.alexTiles);
                    SpriteEditor.this.frameList.setSelectedIndex(0);
                    SpriteEditor.this.hitboxSelection.setSelectedIndex(spriteContainer.getSprites()[SpriteEditor.this.frameList.getSelectedIndex()].getHitboxIndex() / 4);
                }
            }
        });
        this.updateSpriteNames();
        object = new JPanel(new BorderLayout());
        ((Container)object).add(this.alexSpriteSelection, "North");
        jPanel2.add((Component)object, "Center");
        String[] stringArray = new String[54];
        n = 0;
        while (n < stringArray.length) {
            byte by = (byte)RomManager.StaticAccess.readByte(37328 + 4 * n);
            int n3 = RomManager.StaticAccess.readByte(37328 + 4 * n + 1);
            byte by2 = (byte)RomManager.StaticAccess.readByte(37328 + 4 * n + 2);
            int n4 = RomManager.StaticAccess.readByte(37328 + 4 * n + 3);
            stringArray[n] = String.valueOf(String.format("%02X: ", n)) + TextProvider.get("Hitbox") + ": [" + by + ", " + n3 + ", " + by2 + ", " + n4 + "]";
            ++n;
        }
        this.hitboxSelection = new JComboBox<String>(stringArray);
        this.hitboxSelection.setSelectedIndex(this.alexSprites[0].getSprites()[0].getHitboxIndex() / 4);
        this.hitboxSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        SpriteContainer spriteContainer = SpriteEditor.this.spriteSelection.getSelectedIndex() > 0 ? SpriteEditor.this.sprites[SpriteEditor.this.spriteSelection.getSelectedIndex() - 1] : SpriteEditor.this.alexSprites[SpriteEditor.this.alexSpriteSelection.getSelectedIndex()];
                        spriteContainer.getSprites()[SpriteEditor.this.frameList.getSelectedIndex()].setHitboxIndex(SpriteEditor.this.hitboxSelection.getSelectedIndex() * 4);
                    }
                });
            }
        });
        jPanel2.add(this.hitboxSelection, "South");
        this.spritePanel = new SpritePanel(this.alexSprites[0], palette, this.alexTiles);
        this.spritePanel.setBackground(Color.DARK_GRAY);
        this.spritePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                SpriteContainer spriteContainer;
                SpriteEditor.this.tilesPanel.setSelectionEnabled(SpriteEditor.this.spritePanel.getSelectedSprite() >= 0);
                if (SpriteEditor.this.tilesPanel.isVisible() && SpriteEditor.this.spritePanel.getSelectedSprite() >= 0) {
                    spriteContainer = SpriteEditor.this.spriteSelection.getSelectedIndex() > 0 ? SpriteEditor.this.sprites[SpriteEditor.this.spriteSelection.getSelectedIndex() - 1] : SpriteEditor.this.alexSprites[SpriteEditor.this.alexSpriteSelection.getSelectedIndex()];
                    n = spriteContainer.getSprites()[SpriteEditor.this.frameList.getSelectedIndex()].getSpriteCharCode(SpriteEditor.this.spritePanel.getSelectedSprite());
                    SpriteEditor.this.adjustingTilesSelection = true;
                    SpriteEditor.this.tilesPanel.setSelectedTile(n);
                    SpriteEditor.this.adjustingTilesSelection = false;
                }
                SpriteEditor.this.tilesetPanel.setSelectionEnabled(SpriteEditor.this.spritePanel.getSelectedSprite() >= 0);
                if (SpriteEditor.this.tilesetPanel.isVisible() && SpriteEditor.this.spritePanel.getSelectedSprite() >= 0) {
                    spriteContainer = SpriteEditor.this.spriteSelection.getSelectedIndex() > 0 ? SpriteEditor.this.sprites[SpriteEditor.this.spriteSelection.getSelectedIndex() - 1] : SpriteEditor.this.alexSprites[SpriteEditor.this.alexSpriteSelection.getSelectedIndex()];
                    n = spriteContainer.getSprites()[SpriteEditor.this.frameList.getSelectedIndex()].getSpriteCharCode(SpriteEditor.this.spritePanel.getSelectedSprite());
                    SpriteEditor.this.adjustingTilesSelection = true;
                    SpriteEditor.this.tilesetPanel.setSelectedTile(n);
                    SpriteEditor.this.adjustingTilesSelection = false;
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.spritePanel);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jPanel.add((Component)jScrollPane, "Center");
        this.frameList = new SpriteList(this.alexSprites[0], palette, this.alexTiles);
        this.frameList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SpriteContainer spriteContainer;
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                SpriteEditor.this.spritePanel.setFrame(SpriteEditor.this.frameList.getSelectedIndex());
                SpriteContainer spriteContainer2 = spriteContainer = SpriteEditor.this.spriteSelection.getSelectedIndex() > 0 ? SpriteEditor.this.sprites[SpriteEditor.this.spriteSelection.getSelectedIndex() - 1] : SpriteEditor.this.alexSprites[SpriteEditor.this.alexSpriteSelection.getSelectedIndex()];
                if (SpriteEditor.this.frameList.getSelectedIndex() >= 0) {
                    SpriteEditor.this.hitboxSelection.setSelectedIndex(spriteContainer.getSprites()[SpriteEditor.this.frameList.getSelectedIndex()].getHitboxIndex() / 4);
                }
            }
        });
        this.frameList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                byte by;
                Sprite[] spriteArray = SpriteEditor.this.spriteSelection.getSelectedIndex() > 0 ? SpriteEditor.this.sprites[SpriteEditor.this.spriteSelection.getSelectedIndex() - 1].getSprites() : SpriteEditor.this.alexSprites[SpriteEditor.this.alexSpriteSelection.getSelectedIndex()].getSprites();
                final Sprite sprite = spriteArray[SpriteEditor.this.frameList.getSelectedIndex()];
                int by2 = 256;
                int n3 = 0;
                int n4 = 0;
                while (n4 < sprite.getSpriteCount()) {
                    if (sprite.getSpriteY(n4) < by) {
                        by = sprite.getSpriteY(n4);
                    }
                    if (sprite.getSpriteY(n4) + 8 > n3) {
                        n3 = sprite.getSpriteY(n4) + 8;
                    }
                    ++n4;
                }
                n4 = n3 - by;
                int n5 = 256;
                n3 = 0;
                int n6 = 0;
                while (n6 < sprite.getSpriteCount()) {
                    n2 = sprite.getSpriteX(n6);
                    if (n2 < n5) {
                        n5 = n2;
                    }
                    if (n2 + 8 > n3) {
                        n3 = n2 + 8;
                    }
                    ++n6;
                }
                n6 = 1;
                n2 = 0;
                while (n2 < sprite.getSpriteCount()) {
                    if ((sprite.getSpriteX(n2) - n5 & 7) != 0) {
                        n6 = 0;
                    }
                    ++n2;
                }
                if (n6 == 0 && JOptionPane.showConfirmDialog(SpriteEditor.this, TextProvider.get("MessageSpriteAlign"), TextProvider.get("TitleSpriteAlign"), 0) == 0) {
                    n2 = n5;
                    TransactionManager.getInstance().runTransaction(new Runnable(){

                        @Override
                        public void run() {
                            sprite.alignX(n2);
                        }
                    });
                    n5 = 256;
                    n3 = 0;
                    int nArray = 0;
                    while (nArray < sprite.getSpriteCount()) {
                        n = sprite.getSpriteX(nArray);
                        if (n < n5) {
                            n5 = n;
                        }
                        if (n + 8 > n3) {
                            n3 = n + 8;
                        }
                        ++nArray;
                    }
                }
                n2 = n3 - n5;
                int[][] nArray = new int[n4 / 8][n2 / 8];
                n = 0;
                while (n < nArray.length) {
                    int[] nArray2 = new int[nArray[n].length];
                    int n7 = 0;
                    int n8 = n5 + sprite.getSpriteCount() * 8;
                    int n9 = 0;
                    while (n9 < sprite.getSpriteCount() && n7 < nArray2.length) {
                        if (Math.abs(sprite.getSpriteY(n9) - by - n * 8) < 4) {
                            byte by3 = sprite.getSpriteX(n9);
                            if (by3 < n8) {
                                n8 = by3;
                                System.arraycopy(nArray2, 0, nArray2, 1, n7++);
                                nArray2[0] = sprite.isAlexSprite() ? sprite.getSpriteCharCode(n9) : 0x100 | sprite.getSpriteCharCode(n9);
                            } else {
                                nArray2[n7++] = sprite.isAlexSprite() ? sprite.getSpriteCharCode(n9) : 0x100 | sprite.getSpriteCharCode(n9);
                            }
                        }
                        ++n9;
                    }
                    n8 = (n8 - n5) / 8;
                    n9 = 0;
                    while (n9 < nArray[n].length) {
                        nArray[n][n9] = n9 >= n8 && n9 < n8 + n7 ? nArray2[n9 - n8] : -1;
                        ++n9;
                    }
                    ++n;
                }
                if (SpriteEditor.this.spriteSelection.getSelectedIndex() > 0) {
                    MiracleWorldEditorModel.openSpriteTileEditor(jFrame, SpriteEditor.this.sortedTilesets[SpriteEditor.this.tilesetSelection.getSelectedIndex()], nArray, SpriteEditor.this.palette);
                } else {
                    MiracleWorldEditorModel.openAlexTileEditor(jFrame, nArray, SpriteEditor.this.palette);
                }
            }
        });
        this.frameList.setBackground(Color.LIGHT_GRAY);
        jPanel.add((Component)this.frameList, "East");
        object2 = new JPanel();
        this.tilesPanel = new TilesPanel(tiles, palette);
        this.tilesPanel.setPal(1);
        this.tilesPanel.setMultiSelectionEnabled(false);
        this.tilesPanel.setSelectionEnabled(false);
        this.tilesPanel.setMatchParentWidth(true);
        this.tilesPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SpriteEditor.this.adjustingTilesSelection) {
                    return;
                }
                final int n = SpriteEditor.this.tilesPanel.getSelectedTile();
                final SpriteContainer spriteContainer = SpriteEditor.this.spriteSelection.getSelectedIndex() > 0 ? SpriteEditor.this.sprites[SpriteEditor.this.spriteSelection.getSelectedIndex() - 1] : SpriteEditor.this.alexSprites[SpriteEditor.this.alexSpriteSelection.getSelectedIndex()];
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        spriteContainer.getSprites()[SpriteEditor.this.frameList.getSelectedIndex()].setSpriteCharCode(SpriteEditor.this.spritePanel.getSelectedSprite(), n);
                    }
                });
            }
        });
        ((Container)object2).add(this.tilesPanel);
        this.sortedTilesets = tilesetArray;
        this.tilesetSelection = new TilesetComboBox(this.sortedTilesets, this.palette);
        this.tilesetSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpriteEditor.this.spritePanel.setSprite(SpriteEditor.this.sprites[SpriteEditor.this.spriteSelection.getSelectedIndex() - 1], SpriteEditor.this.palette, SpriteEditor.this.sortedTilesets[SpriteEditor.this.tilesetSelection.getSelectedIndex()]);
                SpriteEditor.this.frameList.setSprite(SpriteEditor.this.sprites[SpriteEditor.this.spriteSelection.getSelectedIndex() - 1], SpriteEditor.this.palette, SpriteEditor.this.sortedTilesets[SpriteEditor.this.tilesetSelection.getSelectedIndex()]);
                SpriteEditor.this.tilesetPanel.setTileset(SpriteEditor.this.sortedTilesets[SpriteEditor.this.tilesetSelection.getSelectedIndex()], SpriteEditor.this.palette);
            }
        });
        ((Container)object).add((Component)this.tilesetSelection, "South");
        this.tilesetSelection.setVisible(false);
        this.tilesetPanel = new TilesetPanel(tilesetArray[0], palette);
        this.tilesetPanel.setVisible(false);
        this.tilesetPanel.setMatchParentWidth(true);
        this.tilesetPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SpriteEditor.this.adjustingTilesSelection) {
                    return;
                }
                final int n = SpriteEditor.this.tilesetPanel.getSelectedTile();
                final SpriteContainer spriteContainer = SpriteEditor.this.spriteSelection.getSelectedIndex() > 0 ? SpriteEditor.this.sprites[SpriteEditor.this.spriteSelection.getSelectedIndex() - 1] : SpriteEditor.this.alexSprites[SpriteEditor.this.alexSpriteSelection.getSelectedIndex()];
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        spriteContainer.getSprites()[SpriteEditor.this.frameList.getSelectedIndex()].setSpriteCharCode(SpriteEditor.this.spritePanel.getSelectedSprite(), n);
                    }
                });
            }
        });
        ((Container)object2).add(this.tilesetPanel);
        jPanel.add((Component)object2, "South");
        this.ICON_HITBOX.setScaleParent(this.tilesPanel);
        this.frameList.setScaleParent(this.tilesPanel);
        this.tilesetSelection.setScaleParent(this.tilesPanel);
        this.spritePanel.setScaleParent(this.tilesPanel);
        this.spritePanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getUnitsToScroll() < 0) {
                    if (mouseWheelEvent.isAltDown()) {
                        float f = Math.max(1, (int)(SpriteEditor.this.spritePanel.getScale() + 1.5f));
                        SpriteEditor.this.spritePanel.setPreferredScale(f);
                        mouseWheelEvent.consume();
                    }
                } else if (mouseWheelEvent.getUnitsToScroll() > 0 && mouseWheelEvent.isAltDown()) {
                    float f = Math.max(1, (int)(SpriteEditor.this.spritePanel.getScale() - 0.5f));
                    SpriteEditor.this.spritePanel.setPreferredScale(f);
                    mouseWheelEvent.consume();
                }
                if (!mouseWheelEvent.isConsumed()) {
                    SpriteEditor.this.spritePanel.getParent().dispatchEvent(mouseWheelEvent);
                }
            }
        });
    }

    private JToolBar makeToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        final JToggleButton jToggleButton = new JToggleButton(this.ICON_HITBOX, false);
        this.ICON_HITBOX.setOwner(jToggleButton);
        jToggleButton.setFocusable(false);
        jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton.setToolTipText(TextProvider.get("ToolbarHitbox"));
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpriteEditor.this.spritePanel.setHitboxEnabled(jToggleButton.isSelected());
            }
        });
        jToolBar.add(jToggleButton);
        return jToolBar;
    }

    private JMenu makeMenuEdit() {
        JMenu jMenu = new JMenu(TextProvider.get("MenuEdit"));
        jMenu.setMnemonic('e');
        final MenuItem menuItem = new MenuItem(TextProvider.get("MenuUndo"), 117);
        jMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().undo(SpriteEditor.this.sprites[0].getSprites()[0]);
            }
        });
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final MenuItem menuItem2 = new MenuItem(TextProvider.get("MenuRedo"), 114);
        jMenu.add(menuItem2);
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UndoRedoManager.getInstance().redo(SpriteEditor.this.sprites[0].getSprites()[0]);
            }
        });
        menuItem2.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.addSeparator();
        MenuItem menuItem3 = new MenuItem(TextProvider.get("MenuHitbox"), 104);
        menuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                Object object;
                int n2;
                LinkedList[] linkedListArray = new LinkedList[54];
                Object object2 = SpriteEditor.this.sprites;
                int n3 = ((SpriteContainer[])object2).length;
                int n4 = 0;
                while (n4 < n3) {
                    SpriteContainer spriteContainer = object2[n4];
                    n2 = 0;
                    object = spriteContainer.getSprites();
                    n = ((Sprite[])object).length;
                    int n5 = 0;
                    while (n5 < n) {
                        Sprite sprite = object[n5];
                        int n6 = sprite.getHitboxIndex() / 4;
                        if (n6 < linkedListArray.length) {
                            String string;
                            LinkedList<String> linkedList = linkedListArray[n6];
                            if (linkedList == null) {
                                linkedListArray[sprite.getHitboxIndex() / 4] = linkedList = new LinkedList<String>();
                            }
                            if ((string = TextProvider.get(spriteContainer.toString())) == null) {
                                string = spriteContainer.toString();
                            }
                            if (spriteContainer.getSpriteCount() > 1) {
                                string = String.valueOf(string) + " (" + n2 + ")";
                            }
                            linkedList.add(string);
                            ++n2;
                        }
                        ++n5;
                    }
                    ++n4;
                }
                int n7 = 0;
                while (n7 < SpriteEditor.this.alexSprites.length) {
                    SpriteContainer spriteContainer = SpriteEditor.this.alexSprites[n7];
                    n3 = 0;
                    Sprite[] spriteArray = spriteContainer.getSprites();
                    int n8 = spriteArray.length;
                    n2 = 0;
                    while (n2 < n8) {
                        object2 = spriteArray[n2];
                        n = ((Sprite)object2).getHitboxIndex() / 4;
                        if (n < linkedListArray.length) {
                            object = linkedListArray[n];
                            if (object == null) {
                                linkedListArray[((Sprite)object2).getHitboxIndex() / 4] = object = new LinkedList();
                            }
                            String string = String.valueOf(TextProvider.get("AlexKidd")) + " " + (String)SpriteEditor.this.alexSpriteSelection.getItemAt(n7);
                            if (spriteContainer.getSpriteCount() > 1) {
                                string = String.valueOf(string) + " (" + n3 + ")";
                            }
                            ((LinkedList)object).add(string);
                            ++n3;
                        }
                        ++n2;
                    }
                    ++n7;
                }
                HitboxEditor.open(SpriteEditor.this.owner, linkedListArray);
            }
        });
        jMenu.add(menuItem3);
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                menuItem.setEnabled(UndoRedoManager.getInstance().canUndo(SpriteEditor.this.sprites[0].getSprites()[0]));
                menuItem2.setEnabled(UndoRedoManager.getInstance().canRedo(SpriteEditor.this.sprites[0].getSprites()[0]));
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                menuItem.setEnabled(true);
                menuItem2.setEnabled(true);
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private void updateSpriteNames() {
        String[] stringArray = new String[this.sprites.length + 1];
        stringArray[0] = TextProvider.get("AlexKidd");
        int n = 1;
        while (n < stringArray.length) {
            String string = this.sprites[n - 1].toString();
            if (TextProvider.get(string) != null) {
                string = TextProvider.get(string);
            }
            stringArray[n] = string;
            ++n;
        }
        this.spriteSelection.setModel(new JComboBox<String>(stringArray).getModel());
        String[] stringArray2 = new String[this.alexSprites.length];
        int n2 = 0;
        while (n2 < stringArray2.length) {
            String string = this.alexSprites[n2].toString();
            if (TextProvider.get(string) != null) {
                string = TextProvider.get(string);
            }
            stringArray2[n2] = string;
            ++n2;
        }
        this.alexSpriteSelection.setModel(new JComboBox<String>(stringArray2).getModel());
    }

    public static void open(JFrame jFrame, SpriteContainer[] spriteContainerArray, Palette palette, Tileset[] tilesetArray, Tiles tiles, Properties properties) {
        if (editor == null) {
            editor = new SpriteEditor(jFrame, spriteContainerArray, palette, tilesetArray, tiles);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            ArrayList<SpriteContainer> arrayList = new ArrayList<SpriteContainer>();
            ArrayList<SpriteContainer> arrayList2 = new ArrayList<SpriteContainer>();
            SpriteContainer[] spriteContainerArray2 = spriteContainerArray;
            int n = spriteContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SpriteContainer spriteContainer = spriteContainerArray2[n2];
                if (spriteContainer.isAlexSprite()) {
                    arrayList.add(spriteContainer);
                } else {
                    arrayList2.add(spriteContainer);
                }
                ++n2;
            }
            SpriteEditor.editor.alexSprites = arrayList.toArray(new SpriteContainer[arrayList.size()]);
            SpriteEditor.editor.sprites = arrayList2.toArray(new SpriteContainer[arrayList2.size()]);
            SpriteEditor.editor.tilesets = tilesetArray;
            SpriteEditor.editor.alexTiles = new Tileset(tiles);
            int n3 = SpriteEditor.editor.spriteSelection.getSelectedIndex();
            n2 = SpriteEditor.editor.alexSpriteSelection.getSelectedIndex();
            editor.updateSpriteNames();
            SpriteEditor.editor.spriteSelection.setSelectedIndex(n3 < arrayList2.size() + 1 ? n3 : 0);
            if (SpriteEditor.editor.spriteSelection.getSelectedIndex() == 0) {
                SpriteEditor.editor.alexSpriteSelection.setSelectedIndex(n2);
            }
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        SpriteEditor.editor.spritePanel.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
        SpriteEditor.editor.tilesPanel.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
        SpriteEditor.editor.tilesetPanel.setIntegerScaling(Boolean.parseBoolean(properties.getProperty("IntegerScaling")));
        editor.setVisible(true);
    }

    public static void close() {
        if (editor != null) {
            editor.setVisible(false);
        }
        HitboxEditor.close();
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
        HitboxEditor.destroy();
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }
}

