/*
 * Decompiled with CFR 0.152.
 */
package editors;

import common.Properties;
import common.ScreenUtilities;
import data.GameSettings;
import editors.TextProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import transactions.TransactionManager;
import widgets.BCDTextField;
import widgets.HexTextField;

public class GameSettingsEditor
extends JDialog {
    private static GameSettingsEditor editor;
    private final HexTextField score;
    private final HexTextField level;
    private final HexTextField lives;
    private final HexTextField money;
    private final HexTextField continueLives;
    private final HexTextField continueCost;

    private GameSettingsEditor(final GameSettings gameSettings) {
        BCDTextField bCDTextField;
        HexTextField hexTextField;
        this.setTitle(TextProvider.get("TitleGameSettings"));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(3, 4, 4, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        final BCDTextField bCDTextField2 = new BCDTextField(3, gameSettings.getScore(), true);
        this.score = bCDTextField2;
        this.level = hexTextField = new HexTextField(1, gameSettings.getLevel());
        final BCDTextField bCDTextField3 = new BCDTextField(1, gameSettings.getLives(), false);
        this.lives = bCDTextField3;
        final BCDTextField bCDTextField4 = new BCDTextField(3, gameSettings.getMoney(), true);
        this.money = bCDTextField4;
        final BCDTextField bCDTextField5 = new BCDTextField(1, gameSettings.getContinueLives(), false);
        this.continueLives = bCDTextField5;
        try {
            bCDTextField = new BCDTextField(3, gameSettings.getContinueCost(), true);
        }
        catch (IllegalStateException illegalStateException) {
            bCDTextField = new BCDTextField(1, 0, false);
            bCDTextField.setText("");
            bCDTextField.setEnabled(false);
        }
        this.continueCost = bCDTextField;
        this.add((Component)jPanel, "Center");
        jPanel.add(new JLabel(TextProvider.get("Score")));
        jPanel.add(bCDTextField2);
        jPanel.add(new JLabel(TextProvider.get("StartingLevel")));
        jPanel.add(hexTextField);
        jPanel.add(new JLabel(TextProvider.get("Money")));
        jPanel.add(bCDTextField4);
        jPanel.add(new JLabel(TextProvider.get("Lives")));
        jPanel.add(bCDTextField3);
        jPanel.add(new JLabel(TextProvider.get("ContinueCost")));
        jPanel.add(bCDTextField);
        jPanel.add(new JLabel(TextProvider.get("ContinueLives")));
        jPanel.add(bCDTextField5);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JButton jButton = new JButton(TextProvider.get("ButtonOK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final int n = hexTextField.getValue();
                if (n < 1 || n > 17) {
                    JOptionPane.showMessageDialog(GameSettingsEditor.this, TextProvider.get("MessageStartingLevelInvalid"), TextProvider.get("TitleStartingLevelInvalid"), 0);
                    return;
                }
                TransactionManager.getInstance().runTransaction(new Runnable(){

                    @Override
                    public void run() {
                        gameSettings.setScore(bCDTextField2.getValue());
                        gameSettings.setLevel(n);
                        gameSettings.setLives(bCDTextField3.getValue());
                        gameSettings.setMoney(bCDTextField4.getValue());
                        gameSettings.setContinueLives(bCDTextField5.getValue());
                        gameSettings.setContinueCost(GameSettingsEditor.this.continueCost.getValue());
                    }
                });
                GameSettingsEditor.this.setVisible(false);
            }
        });
        JButton jButton2 = new JButton(TextProvider.get("ButtonCancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GameSettingsEditor.this.setVisible(false);
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        this.add((Component)jPanel2, "South");
        this.setResizable(false);
        this.getRootPane().setDefaultButton(jButton);
    }

    public static void open(JFrame jFrame, GameSettings gameSettings, Properties properties) {
        if (editor == null) {
            editor = new GameSettingsEditor(gameSettings);
            try {
                editor.setLocation(properties.getInt("Window" + editor.getClass().getSimpleName() + "X"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.setLocationRelativeTo(jFrame);
            }
            try {
                editor.setSize(properties.getInt("Window" + editor.getClass().getSimpleName() + "Width"), properties.getInt("Window" + editor.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                editor.pack();
            }
        } else {
            GameSettingsEditor.editor.score.setValue(gameSettings.getScore());
            GameSettingsEditor.editor.level.setValue(gameSettings.getLevel());
            GameSettingsEditor.editor.lives.setValue(gameSettings.getLives());
            GameSettingsEditor.editor.money.setValue(gameSettings.getMoney());
            GameSettingsEditor.editor.continueLives.setValue(gameSettings.getContinueLives());
            try {
                GameSettingsEditor.editor.continueCost.setValue(gameSettings.getContinueCost());
            }
            catch (IllegalStateException illegalStateException) {
                GameSettingsEditor.editor.continueCost.setText("");
                GameSettingsEditor.editor.continueCost.setEnabled(false);
            }
        }
        if (ScreenUtilities.getScreen(editor) == null) {
            editor.setLocationRelativeTo(jFrame);
        }
        editor.setVisible(true);
    }

    public static void close() {
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public static void destroy() {
        if (editor != null) {
            editor.dispose();
        }
        editor = null;
    }

    public static void saveState(Properties properties) {
        if (editor != null) {
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Open", "" + editor.isVisible());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "X", "" + editor.getX());
            properties.setProperty("Window" + editor.getClass().getSimpleName() + "Y", "" + editor.getY());
            if (editor.isResizable()) {
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Width", "" + editor.getWidth());
                properties.setProperty("Window" + editor.getClass().getSimpleName() + "Height", "" + editor.getHeight());
            }
        }
    }
}

