/*
 * Decompiled with CFR 0.152.
 */
package data;

import changes.Changable;
import changes.Change;
import changes.ChangeListener;
import editor.Z80Factory;
import editors.KiddEd;
import editors.TextProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import mastersystem.OutputListener;
import mastersystem.TMS9918A;
import mastersystem.Z80;
import rom.RomManager;
import transactions.TransactionManager;

public class Shop
implements Changable {
    private final int address = 7428;
    private final int addressShopPriceTable = 8046;
    private boolean wasDuplicate;
    private int addressNameTableShopWindowDesc;
    private int addressShopData;
    private final HashSet<Integer> addressesNameTableShopWindowDesc = new HashSet();
    private LinkedList<ShopHandle> shopHandles;
    private HashMap<Integer, ItemHandle> itemHandles;
    private final LinkedList<ChangeListener> listeners = new LinkedList();

    public void nextItem(int n) {
        int n2 = RomManager.StaticAccess.readByte(this.addressShopData + n * 5);
        int n3 = n2 + 1;
        while (n3 <= 12) {
            ItemHandle itemHandle = this.itemHandles.get(n3);
            int n4 = 0;
            while (n4 < 3) {
                if (n4 != n && n3 == RomManager.StaticAccess.readByte(this.addressShopData + n4 * 5)) {
                    itemHandle = null;
                    break;
                }
                ++n4;
            }
            if (itemHandle != null) {
                n4 = this.addressNameTableShopWindowDesc + 4 * n + 2;
                TransactionManager.getInstance().addTransactionObject(this, n);
                RomManager.StaticAccess.writeByte(this.addressShopData + n * 5, n3);
                RomManager.StaticAccess.writeByte(n4, itemHandle.addressNameTableEntries & 0xFF);
                RomManager.StaticAccess.writeByte(n4 + 1, itemHandle.addressNameTableEntries >> 8);
                break;
            }
            ++n3;
        }
    }

    public void prevItem(int n) {
        int n2 = RomManager.StaticAccess.readByte(this.addressShopData + n * 5);
        int n3 = n2 - 1;
        while (n3 >= 1) {
            ItemHandle itemHandle = this.itemHandles.get(n3);
            int n4 = 0;
            while (n4 < 3) {
                if (n4 != n && n3 == RomManager.StaticAccess.readByte(this.addressShopData + n4 * 5)) {
                    itemHandle = null;
                    break;
                }
                ++n4;
            }
            if (itemHandle != null) {
                n4 = this.addressNameTableShopWindowDesc + 4 * n + 2;
                TransactionManager.getInstance().addTransactionObject(this, n);
                RomManager.StaticAccess.writeByte(this.addressShopData + n * 5, n3);
                RomManager.StaticAccess.writeByte(n4, itemHandle.addressNameTableEntries & 0xFF);
                RomManager.StaticAccess.writeByte(n4 + 1, itemHandle.addressNameTableEntries >> 8);
                break;
            }
            --n3;
        }
    }

    public int getItemX(int n) {
        return (RomManager.StaticAccess.readByte(this.addressShopData + n * 5 + 3) & 0x3F) >> 1;
    }

    public int getItemY(int n) {
        return RomManager.StaticAccess.readByte(this.addressShopData + n * 5 + 4) & 0x3F;
    }

    public int[] getItemNameTable(ItemHandle itemHandle) {
        return RomManager.StaticAccess.readBytes(new int[18], 98304 + (itemHandle.addressNameTableEntries & 0x3FFF));
    }

    public void setItemPrice(ItemHandle itemHandle, int n) {
        int n2 = 98304 + (itemHandle.addressNameTableEntries & 0x3FFF);
        int n3 = 8043 + itemHandle.index * 3;
        if (RomManager.StaticAccess.readByte(n3) != n) {
            TransactionManager.getInstance().addTransactionObject(this, 0);
            RomManager.StaticAccess.writeByte(n3, n);
            if (n / 16 == 0) {
                RomManager.StaticAccess.writeByte(n2, 0);
            } else {
                RomManager.StaticAccess.writeByte(n2, 192 + n / 16);
            }
            if (n == 0) {
                RomManager.StaticAccess.writeByte(n2 + 2, 0);
            } else {
                RomManager.StaticAccess.writeByte(n2 + 2, 192 + n % 16);
            }
        }
    }

    public int getItemPrice(ItemHandle itemHandle) {
        return RomManager.StaticAccess.readByte(8043 + itemHandle.index * 3);
    }

    public int getShopDataAddress(ShopHandle shopHandle) {
        return 0x8000 | shopHandle.addressShopData & 0x3FFF;
    }

    public int getShopWindowNameTableDescAddress(ShopHandle shopHandle) {
        return 0x8000 | shopHandle.addressNameTableShopWindowDesc & 0x3FFF;
    }

    public int[] getVRAM(ShopHandle shopHandle) {
        int[] nArray = this.getVRAM(shopHandle.level);
        if (this.addressShopData != shopHandle.addressShopData) {
            shopHandle.level = 0;
            while (shopHandle.level < 17) {
                nArray = this.getVRAM(shopHandle.level);
                if (this.addressShopData == shopHandle.addressShopData) {
                    return nArray;
                }
                ShopHandle shopHandle2 = shopHandle;
                shopHandle2.level = shopHandle2.level + 1;
            }
        }
        return nArray;
    }

    public boolean isValid(ShopHandle shopHandle) {
        return shopHandle.level < 17;
    }

    private int[] getVRAM(int n) {
        final int[] nArray = new int[65536];
        RomManager.StaticAccess.copyFromROM(0, nArray, 0, 49152);
        final Z80 z80 = Z80Factory.create(nArray);
        final TMS9918A tMS9918A = new TMS9918A(262);
        int[] nArray2 = tMS9918A.getVRAM();
        this.wasDuplicate = false;
        z80.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 65535) {
                    RomManager.StaticAccess.loadBank2(nArray, n2);
                } else if (n == 55249) {
                    Shop.this.addressNameTableShopWindowDesc = (nArray[65535] & 0x3F) * 16384 + (z80.getHL() & 0x3FFF);
                    if (!Shop.this.addressesNameTableShopWindowDesc.add(Shop.this.addressNameTableShopWindowDesc)) {
                        Shop.this.wasDuplicate = true;
                    }
                } else if (n >> 6 == 2) {
                    if (n2 < 0) {
                        z80.setInput(tMS9918A.readByte(n & 1, n3));
                    } else {
                        tMS9918A.processInput(n & 1, n2, n3);
                    }
                }
            }
        });
        nArray[785] = 201;
        nArray[7460] = 0;
        nArray[7461] = 0;
        nArray[9876] = 201;
        nArray[49187] = n + 1;
        nArray[49200] = 1;
        nArray[49201] = 3;
        nArray[49202] = 5;
        z80.execute(7428);
        z80.addOutputListener(new OutputListener(){

            @Override
            public void outputAvailable(int n, int n2, int n3) {
                if (n == 65535) {
                    RomManager.StaticAccess.loadBank2(nArray, n2);
                } else if (n == 57327 && z80.getHL() >= 32768 && z80.getHL() < 49152) {
                    Shop.this.addressShopData = (nArray[65535] & 0x3F) * 16384 + (z80.getHL() & 0x3FFF);
                    z80.ret();
                    z80.ret();
                }
            }
        });
        nArray[49239] = 1;
        z80.execute(7150);
        return nArray2;
    }

    public LinkedList<ShopHandle> getShopHandles() {
        if (this.shopHandles != null) {
            return new LinkedList<ShopHandle>(this.shopHandles);
        }
        this.shopHandles = new LinkedList();
        int n = 0;
        while (n < 17) {
            this.getVRAM(n);
            if (!this.wasDuplicate) {
                ShopHandle shopHandle = new ShopHandle(n, this.addressShopData, this.addressNameTableShopWindowDesc);
                this.shopHandles.add(shopHandle);
                if (this.itemHandles == null) {
                    this.itemHandles = new HashMap();
                }
                int n2 = 0;
                while (n2 < 3) {
                    int n3 = RomManager.StaticAccess.readByte(this.addressShopData + n2 * 5);
                    if (!this.itemHandles.containsKey(n3)) {
                        int n4 = this.addressNameTableShopWindowDesc + n2 * 4;
                        this.itemHandles.put(n3, new ItemHandle(n3, RomManager.StaticAccess.readWord(n4 + 2)));
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (this.itemHandles.size() < 8) {
            KiddEd.runWithOriginalROM(new Runnable(){

                @Override
                public void run() {
                    new Shop().addMissingOriginalItemHandles(Shop.this.itemHandles);
                }
            });
        }
        return new LinkedList<ShopHandle>(this.shopHandles);
    }

    public LinkedList<ItemHandle> getItemHandles() {
        if (this.itemHandles == null) {
            this.getShopHandles();
        }
        return new LinkedList<ItemHandle>(this.itemHandles.values());
    }

    protected void addMissingOriginalItemHandles(HashMap<Integer, ItemHandle> hashMap) {
        if (this.itemHandles == null) {
            this.getShopHandles();
        }
        for (Map.Entry<Integer, ItemHandle> entry : this.itemHandles.entrySet()) {
            if (hashMap.containsKey(entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final String getChangeName() {
        return TextProvider.get("ChangeShop");
    }

    @Override
    public final void fireChangeOccurred(Change change) {
        for (ChangeListener changeListener : this.listeners) {
            changeListener.changeOccurred(change);
        }
    }

    @Override
    public final void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.addFirst(changeListener);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public final class ItemHandle {
        private final int index;
        private final int addressNameTableEntries;

        ItemHandle(int n, int n2) {
            this.index = n;
            this.addressNameTableEntries = n2;
        }
    }

    public final class ShopHandle {
        private int level;
        private final int addressShopData;
        private final int addressNameTableShopWindowDesc;

        ShopHandle(int n, int n2, int n3) {
            this.level = n;
            this.addressShopData = n2;
            this.addressNameTableShopWindowDesc = n3;
        }
    }
}

