/*
 * Decompiled with CFR 0.152.
 */
package widgets;

import changes.Change;
import changes.ChangeListener;
import data.Palette;
import data.Tileset;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import mastersystem.Renderer;
import widgets.ScalableIcon;

public class MetaTileIcon
extends ScalableIcon {
    private Color[] colors = new Color[32];
    private Tileset tileset;
    private int[] metaTile;
    private Palette palette;
    private final ChangeListener tilesetChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            if (change.getData(MetaTileIcon.this.tileset) < 256) {
                MetaTileIcon.this.update();
            }
        }
    };
    private final ChangeListener paletteChangeListener = new ChangeListener(){

        @Override
        public void changeOccurred(Change change) {
            int n = change.getData(MetaTileIcon.this.palette);
            if (n < 0) {
                int n2 = -n - 1;
                int n3 = n2 * 16;
                int n4 = n3 + 16;
                if (n2 == 2) {
                    n3 = 0;
                    n4 = 32;
                }
                int n5 = n3;
                while (n5 < n4) {
                    int n6 = MetaTileIcon.this.palette.getColors()[n5];
                    int n7 = (n6 & 0x30) >> 4;
                    int n8 = (n6 & 0xC) >> 2;
                    int n9 = n6 & 3;
                    ((MetaTileIcon)MetaTileIcon.this).colors[n5] = new Color(n9 * 255 / 3, n8 * 255 / 3, n7 * 255 / 3);
                    ++n5;
                }
            } else {
                int n10 = MetaTileIcon.this.palette.getColors()[n];
                int n11 = (n10 & 0x30) >> 4;
                int n12 = (n10 & 0xC) >> 2;
                int n13 = n10 & 3;
                ((MetaTileIcon)MetaTileIcon.this).colors[n] = new Color(n13 * 255 / 3, n12 * 255 / 3, n11 * 255 / 3);
            }
            MetaTileIcon.this.update();
        }
    };

    public MetaTileIcon() {
        super(new BufferedImage(16, 16, 1));
    }

    public void setMetaTile(int[] nArray, Tileset tileset, Palette palette) {
        if (this.tileset != null && this.tileset != tileset) {
            this.tileset.removeChangeListener(this.tilesetChangeListener);
        }
        if (this.palette != null && this.palette != palette) {
            this.palette.removeChangeListener(this.paletteChangeListener);
        }
        this.tileset = tileset;
        this.metaTile = nArray;
        this.palette = palette;
        int n = 0;
        int[] nArray2 = palette.getColors();
        int n2 = nArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            int n5 = (n4 & 0x30) >> 4;
            int n6 = (n4 & 0xC) >> 2;
            int n7 = n4 & 3;
            this.colors[n++] = new Color(n7 * 255 / 3, n6 * 255 / 3, n5 * 255 / 3);
            ++n3;
        }
        tileset.addChangeListener(this.tilesetChangeListener);
        palette.addChangeListener(this.paletteChangeListener);
        this.update();
    }

    @Override
    protected void update() {
        int[] nArray = this.tileset.getVRAM();
        Graphics2D graphics2D = this.image.createGraphics();
        Renderer.renderMetaTile(nArray, this.metaTile, 0, 0, false, this.colors, graphics2D);
        graphics2D.dispose();
        super.update();
    }
}

