/*
 * Decompiled with CFR 0.152.
 */
package editors;

import editors.KiddEd;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

public final class TextProvider {
    private static Properties properties;

    static {
        Properties properties = new Properties();
        properties.setProperty("Title", "KiddEd");
        properties.setProperty("TitleBoxContent", "KiddEd - Box Content Editor");
        properties.setProperty("TitleGameSettings", "Game Settings");
        properties.setProperty("TitlePhysics", "KiddEd - Physics Editor");
        properties.setProperty("TitleLevelSettings", "Level Settings");
        properties.setProperty("TitleMetaTileset", "KiddEd - Metatileset Editor");
        properties.setProperty("TitleModifyEntity", "Modify Entity");
        properties.setProperty("TitleNameTable", "KiddEd - Name Table Editor");
        properties.setProperty("TitlePalette", "KiddEd - Palette Editor");
        properties.setProperty("TitleColorChooser", "Color Chooser");
        properties.setProperty("TitleTileset", "KiddEd - Tileset Editor");
        properties.setProperty("TitleSpriteTileset", "KiddEd - Sprite Tileset Editor");
        properties.setProperty("TitleTile", "KiddEd - Tile Editor");
        properties.setProperty("TitleTitleScreen", "KiddEd - Title Screen Editor");
        properties.setProperty("TitleShop", "KiddEd - Shop Editor");
        properties.setProperty("TitleRiddle", "KiddEd - Riddle Editor");
        properties.setProperty("TitleJankenMatch", "KiddEd - Janken Match Editor");
        properties.setProperty("TitleSound", "KiddEd - Sound Editor");
        properties.setProperty("TitleItem", "KiddEd - Item Editor");
        properties.setProperty("TitleText", "KiddEd - Text Editor");
        properties.setProperty("TitleSprite", "KiddEd - Sprite Editor");
        properties.setProperty("TitleHitbox", "KiddEd - Hitbox Editor");
        properties.setProperty("TitleSelectROM", "Select Alex Kidd ROM File");
        properties.setProperty("TitleSaveGameAs", "Save Game As");
        properties.setProperty("TitleExportSoundAs", "Export Sound As");
        properties.setProperty("TitleOpenGame", "Select Game File");
        properties.setProperty("TitleSelectEmulator", "Select Emulator");
        properties.setProperty("TitleErrorLoadROM", "Error Loading ROM File");
        properties.setProperty("TitleErrorLoadFile", "Error Loading File");
        properties.setProperty("TitleErrorSave", "Error Saving File");
        properties.setProperty("TitleWarningBigPatch", "Patch is unusually big");
        properties.setProperty("TitleWarningLoadROM", "ROM File Checksum does not match");
        properties.setProperty("TitleCannotAddScreen", "Cannot add screen");
        properties.setProperty("TitleApproveSaveAs", "Approve Save As");
        properties.setProperty("TitleStartingLevelInvalid", "Starting Level Invalid");
        properties.setProperty("TitleExpand", "Expand ROM?");
        properties.setProperty("TitleSpriteAlign", "Align sprite tiles?");
        properties.setProperty("TitleLanguageRestart", "Restart?");
        properties.setProperty("TitleUpdateAvailable", "update available!");
        properties.setProperty("TitleUpdateFailed", "update failed!");
        properties.setProperty("TitleSelectSound", "Select Sound File");
        properties.setProperty("TitleError", "Error");
        properties.setProperty("TitleWarning", "Warning");
        properties.setProperty("TitleExportLevelAs", "Export Level As");
        properties.setProperty("ToolbarModeEntity", "Entity Editing Mode");
        properties.setProperty("ToolbarModeLayout", "Layout Editing Mode");
        properties.setProperty("ToolbarAddHiddenTiles", "Add hidden tiles");
        properties.setProperty("ToolbarRemoveHiddenTiles", "Remove hidden tiles");
        properties.setProperty("ToolbarDelete", "Delete");
        properties.setProperty("ToolbarHitbox", "Show Hitbox");
        properties.setProperty("MenuFile", "File");
        properties.setProperty("MenuOpen", "Open");
        properties.setProperty("MenuApplyPatch", "Apply Patch");
        properties.setProperty("MenuSave", "Save");
        properties.setProperty("MenuSaveAs", "Save As");
        properties.setProperty("MenuExpand", "Expand ROM to");
        properties.setProperty("MenuRunInEmulator", "Run In Emulator");
        properties.setProperty("MenuRunROMinEmulator", "Run ROM In Emulator");
        properties.setProperty("MenuRunROMinEmulatorAndStartLevel", "Run ROM In Emulator And Start Level");
        properties.setProperty("MenuSelectEmulator", "Select Emulator");
        properties.setProperty("MenuNew", "New");
        properties.setProperty("MenuSelectROM", "Select Original ROM");
        properties.setProperty("MenuExit", "Exit");
        properties.setProperty("MenuOpenRecent", "Open Recent");
        properties.setProperty("MenuOpenMostRecentOnStartup", "Open most recent on startup");
        properties.setProperty("MenuEdit", "Edit");
        properties.setProperty("MenuUndo", "Undo");
        properties.setProperty("MenuRedo", "Redo");
        properties.setProperty("MenuStartScreen", "Set Start Screen");
        properties.setProperty("MenuCopyEntity", "Copy Entity");
        properties.setProperty("MenuPasteEntity", "Paste Entity");
        properties.setProperty("MenuRemoveEntity", "Remove Entity");
        properties.setProperty("MenuCopyLayout", "Copy Layout");
        properties.setProperty("MenuPasteLayout", "Paste Layout");
        properties.setProperty("MenuCopyScreen", "Copy Screen");
        properties.setProperty("MenuPasteScreen", "Paste Screen");
        properties.setProperty("MenuAddScreen", "Add Screen");
        properties.setProperty("MenuRemoveScreen", "Remove Screen");
        properties.setProperty("MenuNextScreen", "Next Screen");
        properties.setProperty("MenuPreviousScreen", "Previous Screen");
        properties.setProperty("MenuView", "View");
        properties.setProperty("MenuAnimations", "Animations");
        properties.setProperty("MenuEditors", "Editors");
        properties.setProperty("MenuPalette", "Palette Editor");
        properties.setProperty("MenuTileset", "Tileset Editor");
        properties.setProperty("MenuSpriteTileset", "Sprite Tileset Editor");
        properties.setProperty("MenuTile", "Tile Editor");
        properties.setProperty("MenuMetaTileset", "Metatileset Editor");
        properties.setProperty("MenuBoxContent", "Box Content Editor");
        properties.setProperty("MenuPhysics", "Physics Editor");
        properties.setProperty("MenuGameSettings", "Game Settings");
        properties.setProperty("MenuLevelSettings", "Level Settings");
        properties.setProperty("MenuNameTable", "Name Table Editor");
        properties.setProperty("MenuTitleScreen", "Title Screen Editor");
        properties.setProperty("MenuShop", "Shop Editor");
        properties.setProperty("MenuRiddle", "Riddle Editor");
        properties.setProperty("MenuJankenMatch", "Janken Match Editor");
        properties.setProperty("MenuSound", "Sound Editor");
        properties.setProperty("MenuItem", "Item Editor");
        properties.setProperty("MenuText", "Text Editor");
        properties.setProperty("MenuSprite", "Sprite Editor");
        properties.setProperty("MenuHitbox", "Hitbox Editor");
        properties.setProperty("MenuSettings", "Settings");
        properties.setProperty("MenuLanguage", "Language");
        properties.setProperty("MenuLanguageSystem", "System");
        properties.setProperty("MenuLanguageEn", "English");
        properties.setProperty("MenuLanguageFr", "French");
        properties.setProperty("MenuLanguagePt", "Portuguese");
        properties.setProperty("MenuLanguageEs", "Spanish");
        properties.setProperty("MenuHacks", "Hacks");
        properties.setProperty("MenuHelp", "Help");
        properties.setProperty("MenuVisitHomepage", "Visit Homepage");
        properties.setProperty("MenuReportBug", "Report a bug");
        properties.setProperty("MenuContactAuthor", "Contact the author");
        properties.setProperty("MenuJoinCommunity", "Chat with the community");
        properties.setProperty("MenuConfigureUpdates", "Configure Updates");
        properties.setProperty("MenuExportLevel", "Export Level to GSEngine");
        properties.setProperty("MenuUnits", "Units");
        properties.setProperty("MenuSubpixelsPerFrame", "Subpixels per Frame");
        properties.setProperty("MenuPixelsPerFrame", "Pixels per Frame");
        properties.setProperty("HackSkipMapOnLevelTransition", "Skip map on level transition");
        properties.setProperty("HackSkipTitleScreen", "Skip Title Screen");
        properties.setProperty("HackRemoveDemoPlay", "Remove demo play");
        properties.setProperty("HackSwapButtons", "Swap buttons");
        properties.setProperty("HackContinueIfPossible", "Continue if possible");
        properties.setProperty("HackAllowPauseInJankenMatch", "Allow pause in janken match");
        properties.setProperty("HackHideLevelCursorInPauseScreen", "Hide level cursor in pause screen");
        properties.setProperty("HackDisableItemRespawnProtection", "Disable collectible item respawn protection");
        properties.setProperty("HackMakeShopItemsStay", "Make shop items stay");
        properties.setProperty("HackShockingWaveOfDestructionHitOnlyOnce", "Make shocking waves of destruction hit only once");
        properties.setProperty("HackDontWalkFromStartInCastleLayout", "Don't walk from start in castle layout");
        properties.setProperty("HackMegaDriveStartButtonForPause", "Use Mega Drive start button for pause");
        properties.setProperty("HackMakeAlexFlashDuringInvincibility", "Make Alex flash during invincibility");
        properties.setProperty("HackMakeItemsFlashBeforeVanish", "Make items flash before they vanish");
        properties.setProperty("HackDieInPlaceUntilSoundFinishes", "Die in place until sound finishes");
        properties.setProperty("FilterROM", "Master System Games");
        properties.setProperty("FilterPSG", "PSGlib Sound Files");
        properties.setProperty("FilterVGM", "Video Game Music Files");
        properties.setProperty("FilterAllSupported", "All supported level files");
        properties.setProperty("FilterExecutable", "Executables");
        properties.setProperty("FilterSoundAllSupported", "All supported sound files");
        properties.setProperty("FilterIPS", "IPS patches");
        properties.setProperty("MessageUnsavedChanges", "There are unsaved changes!\nDo you want to save them?");
        properties.setProperty("MessageErrorLoadROM", "An error occurred while trying to load the ROM file!\nUntil now only the Alex Kidd in Miracle World [v1] ROM is supported!");
        properties.setProperty("MessageErrorLoadFile", "An error occurred while trying to load this file.");
        properties.setProperty("MessageErrorSave", "An error occurred while saving");
        properties.setProperty("MessageErrorSoundOriginalEngine", "Cannot replace sound in original engine.");
        properties.setProperty("MessageErrorInputDataEmpty", "Input data is empty.");
        properties.setProperty("MessageErrorInputDataTooLong", "Input data is too long.");
        properties.setProperty("MessageErrorInputDataInvalid", "Input data is invalid.");
        properties.setProperty("MessageErrorNotEnoughSpace", "There is not enough space.");
        properties.setProperty("MessageErrorPSGlibWrongChecksum", "The version of PSGlib is outdated. Contact the author of KiddEd to receive the correct version.");
        properties.setProperty("MessageErrorUpgradePSGlib", "Failed to upgrade the PSGlib Engine.\nContact the author of KiddEd for support.");
        properties.setProperty("MessageWarningBigPatch", "The selected patch is unusually big.\nAre you sure you have selected the correct patch?");
        properties.setProperty("MessageWarningLoadROM", "The checksum of the selected ROM file doesn't match.\nKiddEd might not work correctly.\nFor best results make sure to select the Alex Kidd in Miracle World [v1] ROM.\nDo you want to select another ROM?");
        properties.setProperty("MessageCannotAddScreen", "There is not enough space left to add a screen to this level.");
        properties.setProperty("MessageAlreadyExists", "already exists.\nDo you want to overwrite it?");
        properties.setProperty("MessageStartingLevelInvalid", "Starting level has to be between 1 and 11!");
        properties.setProperty("MessageLevelExpand", "To enable layout editing for this level the ROM needs to be expanded.\nDo you want to expand it now?");
        properties.setProperty("MessageExpand", "To perfom this action the ROM needs to be expanded.\nDo you want to expand it now?");
        properties.setProperty("MessageConvertLayoutSuccessful", "Successfully converted level layout!");
        properties.setProperty("MessageSpriteAlign", "The tiles of this sprite are unaligned.\nDo you want to align them now?");
        properties.setProperty("MessageLanguageRestart", "You need to restart the application for the changes to take effect.\nDo you want to restart now?");
        properties.setProperty("MessageUpdateSuccessful", "Update successful!");
        properties.setProperty("MessageUpdateFailed", "Update failed!\nYou can manually update {}\nby overwriting the files with the most recent version found on\nhttp://kidded.emulicious.net");
        properties.setProperty("MessageUpdateAvailable", "An update for {} is available!\nInstall now?");
        properties.setProperty("MessageWarningSoundReplace", "Applying this sound engine will restore all sounds to the orignal ones.\nAll replaced sounds will be lost.\nDo you want to continue?");
        properties.setProperty("ChangeTileset", "Tileset Change");
        properties.setProperty("ChangeTiles", "Tile Change");
        properties.setProperty("ChangePalette", "Palette Change");
        properties.setProperty("ChangeMetatileset", "Metatileset Change");
        properties.setProperty("ChangeLevel", "Level Change");
        properties.setProperty("ChangeEntity", "Entity Change");
        properties.setProperty("ChangeNameTable", "Name Table Change");
        properties.setProperty("ChangeTitleScreen", "Title Screen Change");
        properties.setProperty("ChangeShop", "Shop Change");
        properties.setProperty("ChangeRiddle", "Riddle Change");
        properties.setProperty("ChangeJankenMatch", "Janken Match Change");
        properties.setProperty("ChangeText", "Text Change");
        properties.setProperty("ChangeSprite", "Sprite Change");
        properties.setProperty("ChangeSound", "Sound Change");
        properties.setProperty("ChangeGameSettings", "Game Settings Change");
        properties.setProperty("ChangePhysics", "Physics Change");
        properties.setProperty("ButtonApply", "Apply");
        properties.setProperty("ButtonUpgrade", "Upgrade");
        properties.setProperty("ButtonOK", "OK");
        properties.setProperty("ButtonCancel", "Cancel");
        properties.setProperty("ButtonConvertToHorizontalLayout", "Convert To Horizontal Layout");
        properties.setProperty("ButtonConvertToVerticalLayout", "Convert To Vertical Layout");
        properties.setProperty("ButtonConvertToHorizontalReverseLayout", "Convert To Horizontal Reverse Layout");
        properties.setProperty("ButtonConvertToLshapeLayout", "Convert To L Shape Layout");
        properties.setProperty("ButtonConvertToJarLayout", "Convert To Jar Layout");
        properties.setProperty("ButtonConvertToRiverLayout", "Convert To River Layout");
        properties.setProperty("ButtonConvertToCastleLayout", "Convert To Castle Layout");
        properties.setProperty("ButtonSoundImport", "Import Sound");
        properties.setProperty("ButtonSoundExport", "Export Sound");
        properties.setProperty("ButtonSoundRemove", "Remove Sound");
        properties.setProperty("ButtonSoundRestore", "Restore Sound");
        properties.setProperty("CheckBoxUpdateWaterColor", "Update Water Color");
        properties.setProperty("AdjustTempoOnPAL", "Adjust Tempo on PAL");
        properties.setProperty("Score", "Score");
        properties.setProperty("Money", "Money");
        properties.setProperty("StartingLevel", "Starting Level");
        properties.setProperty("Lives", "Lives");
        properties.setProperty("ContinueLives", "Continue Lives");
        properties.setProperty("ContinueCost", "Continue Cost");
        properties.setProperty("Level", "Level");
        properties.setProperty("Music", "Music");
        properties.setProperty("LevelDimensions", "Level Dimensions");
        properties.setProperty("Height", "Height");
        properties.setProperty("Width", "Width");
        properties.setProperty("LevelTileset", "Level Tileset");
        properties.setProperty("LevelMainTileset", "Level Main Tileset");
        properties.setProperty("LevelAdditionalTileset", "Level Additional Tileset");
        properties.setProperty("LevelAdditionalTilesets", "Level Additional Tilesets");
        properties.setProperty("MetaTileset", "Metatileset");
        properties.setProperty("SpriteTileset", "Sprite Tileset");
        properties.setProperty("Palette", "Palette");
        properties.setProperty("Settings", "Settings");
        properties.setProperty("SwapWith", "Swap with");
        properties.setProperty("BoxIndex", "Level {} Box Index");
        properties.setProperty("Sprites", "Sprites");
        properties.setProperty("FlipH", "Flip H");
        properties.setProperty("FlipV", "Flip V");
        properties.setProperty("Foreground", "Foreground");
        properties.setProperty("Type", "Type");
        properties.setProperty("ExtraData", "Extra Data");
        properties.setProperty("Priority", "Priority");
        properties.setProperty("PriorityTop", "Top");
        properties.setProperty("HorizontalPosition", "Horizontal Position");
        properties.setProperty("VerticalPosition", "Vertical Position");
        properties.setProperty("SoundEngineOriginal", "Original Sound Engine");
        properties.setProperty("SoundEnginePSGlib", "PSGlib Sound Engine");
        properties.setProperty("SoundRepeat", "Repeat");
        properties.setProperty("NameTableTitleScreen0", "Title Screen Logo Top Left");
        properties.setProperty("NameTableTitleScreen1", "Title Screen Logo Bottom Right");
        properties.setProperty("NameTableTitleScreen2", "Title Screen Top Right Box");
        properties.setProperty("NameTableTitleScreen3", "Title Screen Bottom Right Box");
        properties.setProperty("NameTableTitleScreen4", "Title Screen Top Left Box");
        properties.setProperty("NameTableTitleScreen5", "Title Screen Center Left Box");
        properties.setProperty("NameTableTitleScreen6", "Title Screen Bottom Left Box");
        properties.setProperty("NameTableTitleScreen7", "Title Screen Press Button");
        properties.setProperty("NameTableShop", "Shop");
        properties.setProperty("NameTableShopExit", "Shop Exit");
        properties.setProperty("NameTableMap", "Map");
        properties.setProperty("NameTableHirotta", "Hirotta Stone");
        properties.setProperty("TilesetTitleScreen", "Title Screen Tileset");
        properties.setProperty("TilesetShop", "Shop Tileset");
        properties.setProperty("TilesetMap", "Map Tileset");
        properties.setProperty("TilesetHirotta", "Hirotta Stone Tileset");
        properties.setProperty("PaletteTitleScreen", "Title Screen Palette");
        properties.setProperty("PaletteShop", "Shop Palette");
        properties.setProperty("PaletteMap", "Map Palette");
        properties.setProperty("PaletteHirotta", "Hirotta Stone Palette");
        properties.setProperty("PaletteCycleTitleScreen", "$PaletteCycle$TitleScreen");
        properties.setProperty("PaletteCycleWater", "$PaletteCycle$Water");
        properties.setProperty("PaletteCycleInvincibility", "$PaletteCycle$Invincibility");
        properties.setProperty("PaletteCycle", "Palette Cycle");
        properties.setProperty("SettingsExpandToPowerOf2", "Always expand ROM to a power of 2");
        properties.setProperty("SettingsIntegerScaling", "Always scale to integer multiples");
        properties.setProperty("SettingsShowTileAttributes", "Tile Attributes");
        properties.setProperty("AlexKidd", "Alex Kidd");
        properties.setProperty("Items", "Items");
        properties.setProperty("Boxes", "Boxes");
        properties.setProperty("Liquids", "Liquids");
        properties.setProperty("Digits", "Digits");
        properties.setProperty("CloudAndCoinBag", "Cloud and Bag of Coins");
        properties.setProperty("AlexEating", "Alex Eating");
        properties.setProperty("TilesScore", "Score Tiles");
        properties.setProperty("HirottaStone", "Hirotta Stone");
        properties.setProperty("Tiles", "Tiles");
        properties.setProperty("InvisibleTiles", "Invisible Tiles");
        properties.setProperty("MirroredTiles", "Mirrored Tiles");
        properties.setProperty("NumberOfInvisibleTiles", "Number of Invisible Tiles");
        properties.setProperty("Shop", "Shop");
        properties.setProperty("Map", "Map");
        properties.setProperty("ShopExit", "Shop Exit");
        properties.setProperty("Font", "Font");
        properties.setProperty("TitleScreen", "Title Screen");
        properties.setProperty("JankenMatch", "Janken Match");
        properties.setProperty("Janken", "Janken the Great");
        properties.setProperty("StoneHead", "Stone Head");
        properties.setProperty("ScissorsHead", "Scissors Head");
        properties.setProperty("PaperHead", "Paper Head");
        properties.setProperty("JankenPetrified", "Petrified Janken");
        properties.setProperty("LevelName0", "Mt. Eternal");
        properties.setProperty("LevelName1", "Mt. Eternal 2");
        properties.setProperty("LevelName2", "Lake Fathom");
        properties.setProperty("LevelName3", "The Island of St. Nurari");
        properties.setProperty("LevelName4", "Lake Fathom 2");
        properties.setProperty("LevelName5", "The Village of Namui");
        properties.setProperty("LevelName6", "Mt. Kave");
        properties.setProperty("LevelName7", "The Blakwoods");
        properties.setProperty("LevelName8", "River");
        properties.setProperty("LevelName9", "Bingoo Lowland");
        properties.setProperty("LevelName10", "The Radaxian Castle");
        properties.setProperty("LevelName11", "The City of Radaxian");
        properties.setProperty("LevelName12", "Swamps");
        properties.setProperty("LevelName13", "The Kingdom of Nibana");
        properties.setProperty("LevelName14", "The Kingdom of Nibana 2");
        properties.setProperty("LevelName15", "Janken's Castle");
        properties.setProperty("LevelName16", "Cragg Lake");
        properties.setProperty("LevelNameBonus", "Bonus Level");
        properties.setProperty("SoundName0", "Title Screen");
        properties.setProperty("SoundName1", "Main Theme");
        properties.setProperty("SoundName2", "Underwater");
        properties.setProperty("SoundName3", "Castle");
        properties.setProperty("SoundName4", "Sukopako Motorcycle");
        properties.setProperty("SoundName5", "Level Start");
        properties.setProperty("SoundName6", "$JankenMatch");
        properties.setProperty("SoundName7", "$Peticopter");
        properties.setProperty("SoundName8", "Death");
        properties.setProperty("SoundName9", "Punch");
        properties.setProperty("SoundName10", "Dirt Explosion");
        properties.setProperty("SoundName11", "Breaking Block");
        properties.setProperty("SoundName12", "Flying Head Hit");
        properties.setProperty("SoundName13", "Money");
        properties.setProperty("SoundName14", "Item");
        properties.setProperty("SoundName15", "Throw Magic Capsule");
        properties.setProperty("SoundName16", "Jump");
        properties.setProperty("SoundName17", "Falling Into Water");
        properties.setProperty("SoundName18", "Petrification");
        properties.setProperty("SoundName19", "Text");
        properties.setProperty("SoundName20", "Opponent Defeated");
        properties.setProperty("SoundName21", "$JankenMatchMissile");
        properties.setProperty("SoundName22", "$MermanBubble");
        properties.setProperty("SoundName23", "$MonkeyLeaf");
        properties.setProperty("SoundName24", "$GrizzlyBearSlashing");
        properties.setProperty("SoundName26", "Falling Down From Peticopter");
        properties.setProperty("SoundName29", "$LightningCloudFiring");
        properties.setProperty("SoundName30", "Shower");
        properties.setProperty("SoundName31", "Disappearing Platform");
        properties.setProperty("SoundName33", "Falling Spike");
        properties.setProperty("SoundName34", "Breaking Box");
        properties.setProperty("SoundName35", "$ShockingWavesOfDestruction");
        properties.setProperty("SoundName36", "Magic Capsule A Spawn Alex Friend");
        properties.setProperty("SoundName38", "Alex Friend Bouncing Off Wall");
        properties.setProperty("SoundName39", "Fire Vehicle Missile");
        properties.setProperty("SoundName40", "$VehicleMissile$Explosion");
        properties.setProperty("SoundName41", "Flying");
        properties.setProperty("SoundName42", "$Invincibility");
        properties.setProperty("SoundName43", "Janken Henchman Splitting Off Head");
        properties.setProperty("SoundName44", "Countdown");
        properties.setProperty("SoundName45", "Countdown Over");
        properties.setProperty("SoundName46", "Game Over");
        properties.setProperty("SoundName47", "Ending");
        properties.setProperty("UnusedSoundEffect", "Unused Sound Effect");
        properties.setProperty("AdditionalMusic", "Additional Music");
        properties.setProperty("Invincibility", "Invincibility");
        properties.setProperty("Water", "Water");
        properties.setProperty("Copy", "Copy");
        properties.setProperty("Paste", "Paste");
        properties.setProperty("CopyTile", "Copy Selected Tiles");
        properties.setProperty("CopyAllTiles", "Copy All Tiles");
        properties.setProperty("CopyMetaTile", "Copy Metatile");
        properties.setProperty("CopyMetaTileset", "Copy Metatileset");
        properties.setProperty("PasteTile", "Paste Tile");
        properties.setProperty("PasteAllTiles", "Paste All Tiles");
        properties.setProperty("PasteMetaTile", "Paste Metatile");
        properties.setProperty("PasteMetaTileset", "Paste Metatileset");
        properties.setProperty("CopyPalette0", "Copy first row");
        properties.setProperty("CopyPalette1", "Copy second row");
        properties.setProperty("CopyBothPalettes", "Copy both rows");
        properties.setProperty("PastePalette0", "Paste first row");
        properties.setProperty("PastePalette1", "Paste second row");
        properties.setProperty("PasteBothPalettes", "Paste both rows");
        properties.setProperty("CopyNameTable", "Copy Nametable");
        properties.setProperty("PasteNameTable", "Paste Nametable");
        properties.setProperty("AlexFrame0", "Stand Right / Play Janken Match");
        properties.setProperty("AlexFrame1", "$Walking$Left");
        properties.setProperty("AlexFrame2", "$Walking$Right");
        properties.setProperty("AlexFrame3", "$Swimming$Left");
        properties.setProperty("AlexFrame4", "$Swimming$Right");
        properties.setProperty("AlexFrame5", "$Peticopter$Left");
        properties.setProperty("AlexFrame6", "$Peticopter$Right");
        properties.setProperty("AlexFrame7", "$Motorcycle");
        properties.setProperty("AlexFrame8", "$Boat");
        properties.setProperty("AlexFrame9", "Dying");
        properties.setProperty("AlexFrame10", "Janken Match Countdown");
        properties.setProperty("AlexFrame11", "$Squatting$Left");
        properties.setProperty("AlexFrame12", "$Squatting$Right");
        properties.setProperty("AlexFrame13", "Punch Left");
        properties.setProperty("AlexFrame14", "Punch Right");
        properties.setProperty("AlexFrame15", "Swimming Punch Left");
        properties.setProperty("AlexFrame16", "Swimming Punch Right");
        properties.setProperty("AlexFrame17", "Janken Match Rock");
        properties.setProperty("AlexFrame18", "Janken Match Scissors");
        properties.setProperty("AlexFrame19", "Janken Match Paper");
        properties.setProperty("AlexFrame20", "$Airborne$Left");
        properties.setProperty("AlexFrame21", "$Airborne$Right");
        properties.setProperty("AlexFrame22", "$Motorcycle$Jump");
        properties.setProperty("AlexFrame23", "Stand Left");
        properties.setProperty("AlexFrame24", "Petrified");
        properties.setProperty("AlexFrame25", "Falling Into Water");
        properties.setProperty("AlexFrame26", "$Boat$Jump");
        properties.setProperty("AlexFrame27", "Climb");
        properties.setProperty("Attribute0", "Passable");
        properties.setProperty("Attribute1", "Water");
        properties.setProperty("Attribute2", "Money");
        properties.setProperty("Attribute3", "Lethal/Interactable");
        properties.setProperty("Attribute4", "Solid");
        properties.setProperty("Attribute5", "Trigger");
        properties.setProperty("Attribute6", "Breakable");
        properties.setProperty("Attribute7", "Special");
        properties.setProperty("UpdateBehaviour", "Update Behaviour");
        properties.setProperty("UpdateAuto", "Install updates automatically");
        properties.setProperty("UpdateManual", "Check for updates but let me decide whether to install them");
        properties.setProperty("UpdateNever", "Never check for updates");
        properties.setProperty("UpdateStatus", "Update Status");
        properties.setProperty("Unknown", "Unknown");
        properties.setProperty("UpdateCheck", "Check for updates");
        properties.setProperty("UpdateNow", "Update now");
        properties.setProperty("UpdateUpToDate", "is up to date");
        properties.setProperty("UpdateCouldntCheck", "Couldn't check for updates");
        properties.setProperty("MonitorUpdating", "Updating");
        properties.setProperty("MonitorCompleted", "Completed");
        properties.setProperty("Hitbox", "Hitbox");
        properties.setProperty("Acceleration", "Acceleration");
        properties.setProperty("OppositeAcceleration", "Opposite Acceleration");
        properties.setProperty("MinVelocity", "Min Velocity");
        properties.setProperty("MaxVelocity", "Max Velocity");
        properties.setProperty("Deceleration", "Deceleration");
        properties.setProperty("Velocity", "Velocity");
        properties.setProperty("Radius", "Radius");
        properties.setProperty("Duration", "Duration");
        properties.setProperty("Gravity", "Gravity");
        properties.setProperty("InitialJumpVelocity", "Initial Jump Velocity");
        properties.setProperty("JumpVelocity", "Jump Velocity");
        properties.setProperty("HorizontalVelocity", "Horizontal Velocity");
        properties.setProperty("VerticalVelocity", "Vertical Velocity");
        properties.setProperty("LeftVelocity", "Left Velocity");
        properties.setProperty("RightVelocity", "Right Velocity");
        properties.setProperty("Fast", "Fast");
        properties.setProperty("Buoyancy", "Buoyancy");
        properties.setProperty("WaterSurfaceDeceleration", "Water Surface Deceleration");
        properties.setProperty("Vehicles", "Vehicles");
        properties.setProperty("Enemies", "Enemies");
        properties.setProperty("Missiles", "Missiles");
        properties.setProperty("Up", "Up");
        properties.setProperty("Down", "Down");
        properties.setProperty("Left", "Left");
        properties.setProperty("Right", "Right");
        properties.setProperty("Jump", "Jump");
        properties.setProperty("Walking", "Walking");
        properties.setProperty("Squatting", "Squatting");
        properties.setProperty("Airborne", "Airborne");
        properties.setProperty("Swimming", "Swimming");
        properties.setProperty("Motorcycle", "Motorcycle");
        properties.setProperty("Boat", "Boat");
        properties.setProperty("SunStone", "Sun Stone");
        properties.setProperty("Peticopter", "Peticopter");
        properties.setProperty("TeleportPowder", "Teleport Powder");
        properties.setProperty("OldMan", "Old Man");
        properties.setProperty("LetterToNibana", "Letter To Nibana");
        properties.setProperty("HirottaStone", "Hirotta Stone");
        properties.setProperty("Castle", "Castle");
        properties.setProperty("ShockingWavesOfDestruction", "Shocking Waves Of Destruction");
        properties.setProperty("TelepathyBall", "Telepathy Ball");
        properties.setProperty("Crown", "Crown");
        properties.setProperty("EmptySprite", "Empty Sprite");
        properties.setProperty("MagicCapsuleA", "Magic Capsule A");
        properties.setProperty("MagicCapsuleB", "Magic Capsule B");
        properties.setProperty("LightGreenBrick", "Light Green Brick");
        properties.setProperty("YellowBrick", "Yellow Brick");
        properties.setProperty("Brick", "Brick");
        properties.setProperty("PrincessLora", "Princess Lora");
        properties.setProperty("PrincessLoraPetrified", "Princess Lora Petrified");
        properties.setProperty("CloudOfDust", "Cloud Of Dust");
        properties.setProperty("HugeCloudOfDust", "Huge Cloud Of Dust");
        properties.setProperty("MonsterBird", "Monster Bird");
        properties.setProperty("Merman", "Merman");
        properties.setProperty("Bubble", "Bubble");
        properties.setProperty("Scorpion", "Scorpion");
        properties.setProperty("FlyingFish", "Flying Fish");
        properties.setProperty("Nurari", "Nurari");
        properties.setProperty("Egle", "Egle");
        properties.setProperty("ImprisonedEgle", "Imprisoned Egle");
        properties.setProperty("MoneyBagBig", "Money Bag Big");
        properties.setProperty("MoneyBagSmall", "Money Bag Small");
        properties.setProperty("Explosion", "Explosion");
        properties.setProperty("KillerFish", "Killer Fish");
        properties.setProperty("Ox", "Ox");
        properties.setProperty("Hopper", "Hopper");
        properties.setProperty("OctopusTentacle", "Octopus Tentacle");
        properties.setProperty("VehicleMissile", "Vehicle Missile");
        properties.setProperty("Monkey", "Monkey");
        properties.setProperty("Leaf", "Leaf");
        properties.setProperty("AlexFriend", "Alex Friend");
        properties.setProperty("MonsterFrog", "Monster Frog");
        properties.setProperty("MonsterFrogCrouching", "Monster Frog Crouching");
        properties.setProperty("MonsterFrogJumping", "Monster Frog Jumping");
        properties.setProperty("Vine", "Vine");
        properties.setProperty("RollingRock", "Rolling Rock");
        properties.setProperty("Flame", "Flame");
        properties.setProperty("CirclingFlame", "Circling Flame");
        properties.setProperty("LightningCloud", "Lightning Cloud");
        properties.setProperty("LightningCloudFiring", "Lightning Cloud Firing");
        properties.setProperty("Cursor", "Cursor");
        properties.setProperty("MoonStone", "MoonStone");
        properties.setProperty("GrizzlyBearWalking", "Grizzly Bear Walking");
        properties.setProperty("GrizzlyBearSlashing", "Grizzly Bear Slashing");
        properties.setProperty("Bat", "Bat");
        properties.setProperty("SmallPoisonousFish", "Small Poisonous Fish");
        properties.setProperty("SeaHorse", "Sea Horse");
        properties.setProperty("Life", "Life");
        properties.setProperty("Bracelet", "Bracelet");
        properties.setProperty("Ghost", "Ghost");
        properties.setProperty("RiceBall", "Rice Ball");
        properties.setProperty("Barrier", "Barrier");
        properties.setProperty("JankenMatchPreviewRock", "Janken Match Preview Rock");
        properties.setProperty("JankenMatchPreviewScissors", "Janken Match Preview Scissors");
        properties.setProperty("JankenMatchPreviewPaper", "Janken Match Preview Paper");
        properties.setProperty("OpponentStanding", "Opponent Standing");
        properties.setProperty("PaperAndRockHeadCountdown", "Paper And Rock Head Countdown");
        properties.setProperty("PaperAndRockHeadSplittingHead", "Paper And Rock Head Splitting Head");
        properties.setProperty("PaperAndRockHeadHead", "Paper And Rock Head Head");
        properties.setProperty("PaperAndRockHeadHeadless", "Paper And Rock Head Headless");
        properties.setProperty("PaperAndRockHeadShowingRock", "Paper And Rock Head Showing Rock");
        properties.setProperty("PaperAndRockHeadShowingScissors", "Paper And Rock Head Showing Scissors");
        properties.setProperty("PaperAndRockHeadShowingPaper", "Paper And Rock Head Showing Paper");
        properties.setProperty("ScissorsHeadCountdown", "Scissors Head Countdown");
        properties.setProperty("ScissorsHeadSplittingHead", "Scissors Head Splitting Head");
        properties.setProperty("ScissorsHeadHead", "Scissors Head Head");
        properties.setProperty("ScissorsHeadHeadLess", "Scissors Head HeadLess");
        properties.setProperty("ScissorsHeadShowingRock", "Scissors Head Showing Rock");
        properties.setProperty("ScissorsHeadShowingScissors", "Scissors Head Showing Scissors");
        properties.setProperty("ScissorsHeadShowingPaper", "Scissors Head Showing Paper");
        properties.setProperty("JankenDancing", "Janken Dancing");
        properties.setProperty("JankenCountdown", "Janken Countdown");
        properties.setProperty("JankenAngry", "Janken Angry");
        properties.setProperty("JankenShowingRock", "Janken Showing Rock");
        properties.setProperty("JankenShowingScissors", "Janken Showing Scissors");
        properties.setProperty("JankenShowingPaper", "Janken Showing Paper");
        properties.setProperty("JankenMatchMissile", "Janken Match Missile");
        properties.setProperty("AlexEating", "Alex Eating");
        properties.setProperty("AlexFriendRight", "$AlexFriend$Right");
        properties.setProperty("ShockingWavesOfDestructionRight", "$ShockingWavesOfDestruction$Right");
        properties.setProperty("ShockingWavesOfDestructionLeft", "$ShockingWavesOfDestruction$Left");
        properties.setProperty("AlexFriendLeft", "$AlexFriend$Left");
        properties.setProperty("MonsterBirdRight", "$MonsterBird$Right");
        properties.setProperty("GhostRight", "$Ghost$Right");
        properties.setProperty("MonsterBirdLeft", "$MonsterBird$Left");
        properties.setProperty("SmallPoisonousFishRight", "$SmallPoisonousFish$Right");
        properties.setProperty("GhostLeft", "$Ghost$Left");
        properties.setProperty("HopperRight", "$Hopper$Right");
        properties.setProperty("HopperLeft", "$Hopper$Left");
        properties.setProperty("GrizzlyBearSlashingRight", "$GrizzlyBearSlashing$Right");
        properties.setProperty("GrizzlyBearWalkingRight", "$GrizzlyBearWalking$Right");
        properties.setProperty("GrizzlyBearSlashingLeft", "$GrizzlyBearSlashing$Left");
        properties.setProperty("GrizzlyBearWalkingLeft", "$GrizzlyBearWalking$Left");
        properties.setProperty("SmallPoisonousFishLeft", "$SmallPoisonousFish$Left");
        properties.setProperty("FlyingFishDownLeft", "$FlyingFish$Down$Left");
        properties.setProperty("FlyingFishUpLeft", "$FlyingFish$Up$Left");
        properties.setProperty("FlyingFishDownRight", "$FlyingFish$Down$Right");
        properties.setProperty("FlyingFishUpRight", "$FlyingFish$Up$Right");
        properties.setProperty("OxLeft", "$Ox$Left");
        properties.setProperty("OxRight", "$Ox$Right");
        properties.setProperty("ScorpionRight", "$Scorpion$Right");
        properties.setProperty("ScorpionLeft", "$Scorpion$Left");
        properties.setProperty("KillerFishRight", "$KillerFish$Right");
        properties.setProperty("KillerFishLeft", "$KillerFish$Left");
        properties.setProperty("MonkeyLeaf", "$Monkey$Leaf");
        properties.setProperty("MermanBubble", "$Merman$Bubble");
        properties.setProperty("Explosion", "Explosion");
        properties.setProperty("Sprite@8000", "$SunStone");
        properties.setProperty("Sprite@800E", "$Peticopter");
        properties.setProperty("Sprite@801C", "$TeleportPowder");
        properties.setProperty("Sprite@802A", "$OldMan");
        properties.setProperty("Sprite@8057", "$LetterToNibana");
        properties.setProperty("Sprite@8065", "$HirottaStone");
        properties.setProperty("Sprite@8073", "$Castle");
        properties.setProperty("Sprite@8093", "$ShockingWavesOfDestructionLeft");
        properties.setProperty("Sprite@8098", "$ShockingWavesOfDestructionRight");
        properties.setProperty("Sprite@80C5", "$TelepathyBall");
        properties.setProperty("Sprite@80D3", "$Crown");
        properties.setProperty("Sprite@80E1", "$EmptySprite");
        properties.setProperty("Sprite@80E6", "$MagicCapsuleA");
        properties.setProperty("Sprite@80F4", "$MagicCapsuleB");
        properties.setProperty("Sprite@8102", "$LightGreenBrick");
        properties.setProperty("Sprite@8111", "$YellowBrick");
        properties.setProperty("Sprite@8120", "$Brick");
        properties.setProperty("Sprite@812F", "$PrincessLora");
        properties.setProperty("Sprite@815C", "$PrincessLoraPetrified");
        properties.setProperty("Sprite@8170", "$CloudOfDust");
        properties.setProperty("Sprite@8175", "$HugeCloudOfDust");
        properties.setProperty("Sprite@81B7", "$MonsterBirdLeft");
        properties.setProperty("Sprite@81E4", "$MonsterBirdRight");
        properties.setProperty("Sprite@8211", "$Merman");
        properties.setProperty("Sprite@825C", "$Bubble");
        properties.setProperty("Sprite@826B", "$ScorpionLeft");
        properties.setProperty("Sprite@8286", "$ScorpionRight");
        properties.setProperty("Sprite@82A1", "$FlyingFishUpRight");
        properties.setProperty("Sprite@82AF", "$FlyingFishDownRight");
        properties.setProperty("Sprite@82BD", "$FlyingFishUpLeft");
        properties.setProperty("Sprite@82CB", "$FlyingFishDownLeft");
        properties.setProperty("Sprite@82D9", "$Nurari");
        properties.setProperty("Sprite@8306", "$Egle");
        properties.setProperty("Sprite@830B", "$ImprisonedEgle");
        properties.setProperty("Sprite@8359", "$MoneyBagBig");
        properties.setProperty("Sprite@8367", "$MoneyBagSmall");
        properties.setProperty("Sprite@8372", "$Explosion");
        properties.setProperty("Sprite@83AB", "$KillerFishLeft");
        properties.setProperty("Sprite@83D8", "$KillerFishRight");
        properties.setProperty("Sprite@8405", "$OxRight");
        properties.setProperty("Sprite@8453", "$OxLeft");
        properties.setProperty("Sprite@84A1", "$HopperLeft");
        properties.setProperty("Sprite@84C2", "$HopperRight");
        properties.setProperty("Sprite@84E3", "$OctopusTentacle");
        properties.setProperty("Sprite@84E8", "$VehicleMissile");
        properties.setProperty("Sprite@84ED", "$Monkey");
        properties.setProperty("Sprite@851D", "$Leaf");
        properties.setProperty("Sprite@8522", "$AlexFriendLeft");
        properties.setProperty("Sprite@8537", "$AlexFriendRight");
        properties.setProperty("Sprite@854C", "$MonsterFrogCrouching");
        properties.setProperty("Sprite@855A", "$MonsterFrogJumping");
        properties.setProperty("Sprite@856E", "$Vine");
        properties.setProperty("Sprite@8585", "$RollingRock");
        properties.setProperty("Sprite@85A6", "$Flame");
        properties.setProperty("Sprite@85D5", "$LightningCloud");
        properties.setProperty("Sprite@85E9", "$LightningCloudFiring");
        properties.setProperty("Sprite@8A18", "$Cursor");
        properties.setProperty("Sprite@8A27", "$MoonStone");
        properties.setProperty("Sprite@8A35", "$GrizzlyBearWalkingLeft");
        properties.setProperty("Sprite@8A3A", "$GrizzlyBearSlashingLeft");
        properties.setProperty("Sprite@8A3F", "$GrizzlyBearWalkingRight");
        properties.setProperty("Sprite@8A44", "$GrizzlyBearSlashingRight");
        properties.setProperty("Sprite@8BBD", "$Bat");
        properties.setProperty("Sprite@8BD2", "$SmallPoisonousFishLeft");
        properties.setProperty("Sprite@8BF3", "$SeaHorse");
        properties.setProperty("Sprite@8C0E", "$Life");
        properties.setProperty("Sprite@8C1C", "$Bracelet");
        properties.setProperty("Sprite@8C2A", "$GhostLeft");
        properties.setProperty("Sprite@8C4B", "$SmallPoisonousFishRight");
        properties.setProperty("Sprite@8C6C", "$GhostRight");
        properties.setProperty("Sprite@8CC7", "$RiceBall");
        properties.setProperty("Sprite@8CD2", "$Barrier");
        properties.setProperty("Sprite@92C8", "$JankenMatchPreviewRock");
        properties.setProperty("Sprite@92D6", "$JankenMatchPreviewScissors");
        properties.setProperty("Sprite@92E4", "$JankenMatchPreviewPaper");
        properties.setProperty("Sprite@92F2", "$OpponentStanding");
        properties.setProperty("Sprite@92F7", "$PaperAndRockHeadCountdown");
        properties.setProperty("Sprite@936D", "$PaperAndRockHeadSplittingHead");
        properties.setProperty("Sprite@9387", "$PaperAndRockHeadHead");
        properties.setProperty("Sprite@9395", "$PaperAndRockHeadHeadless");
        properties.setProperty("Sprite@93A3", "$PaperAndRockHeadShowingRock");
        properties.setProperty("Sprite@93C9", "$PaperAndRockHeadShowingScissors");
        properties.setProperty("Sprite@93EF", "$PaperAndRockHeadShowingPaper");
        properties.setProperty("Sprite@9415", "$ScissorsHeadCountdown");
        properties.setProperty("Sprite@9458", "$ScissorsHeadSplittingHead");
        properties.setProperty("Sprite@9472", "$ScissorsHeadHead");
        properties.setProperty("Sprite@9480", "$ScissorsHeadHeadLess");
        properties.setProperty("Sprite@948E", "$ScissorsHeadShowingRock");
        properties.setProperty("Sprite@94B4", "$ScissorsHeadShowingScissors");
        properties.setProperty("Sprite@94DA", "$ScissorsHeadShowingPaper");
        properties.setProperty("Sprite@9500", "$JankenDancing");
        properties.setProperty("Sprite@9505", "$JankenCountdown");
        properties.setProperty("Sprite@961A", "$JankenAngry");
        properties.setProperty("Sprite@965B", "$JankenShowingRock");
        properties.setProperty("Sprite@96AB", "$JankenShowingScissors");
        properties.setProperty("Sprite@96FB", "$JankenShowingPaper");
        properties.setProperty("Sprite@974B", "$JankenMatchMissile");
        properties.setProperty("Sprite@9750", "$AlexEating");
        properties.setProperty("Sprite@8CE6", "$AlexFrame0");
        properties.setProperty("Sprite@8CEB", "$AlexFrame1");
        properties.setProperty("Sprite@8CF4", "$AlexFrame2");
        properties.setProperty("Sprite@8CFD", "$AlexFrame3");
        properties.setProperty("Sprite@8D02", "$AlexFrame4");
        properties.setProperty("Sprite@8D07", "$AlexFrame5");
        properties.setProperty("Sprite@8D10", "$AlexFrame6");
        properties.setProperty("Sprite@8D19", "$AlexFrame7");
        properties.setProperty("Sprite@8D1E", "$AlexFrame8");
        properties.setProperty("Sprite@8D23", "$AlexFrame9");
        properties.setProperty("Sprite@8D2A", "$AlexFrame10");
        properties.setProperty("Sprite@8DA7", "$AlexFrame11");
        properties.setProperty("Sprite@8DBC", "$AlexFrame12");
        properties.setProperty("Sprite@8DD1", "$AlexFrame13");
        properties.setProperty("Sprite@8DE9", "$AlexFrame14");
        properties.setProperty("Sprite@8E49", "$AlexFrame15");
        properties.setProperty("Sprite@8E5E", "$AlexFrame16");
        properties.setProperty("Sprite@8E9D", "$AlexFrame17");
        properties.setProperty("Sprite@8EBE", "$AlexFrame18");
        properties.setProperty("Sprite@8EDF", "$AlexFrame19");
        properties.setProperty("Sprite@8F00", "$AlexFrame20");
        properties.setProperty("Sprite@8F15", "$AlexFrame21");
        properties.setProperty("Sprite@8F60", "$AlexFrame22");
        properties.setProperty("Sprite@90A7", "$AlexFrame23");
        properties.setProperty("Sprite@90D1", "$AlexFrame24");
        properties.setProperty("Sprite@9122", "$AlexFrame25");
        properties.setProperty("Sprite@9137", "$AlexFrame26");
        properties.setProperty("Sprite@9188", "$AlexFrame27");
        properties.setProperty("AnimateLevelTiles@15D2", "Animate Water Tiles");
        properties.setProperty("AnimateLevelTiles@15DF", "Animate Mud Tiles");
        properties.setProperty("AnimateLevelTiles@15EC", "Animate Level 4 Lava Tiles");
        properties.setProperty("AnimateLevelTiles@15F9", "Animate Foam and Water Tiles");
        properties.setProperty("AnimateLevelTiles@1612", "Animate Level 7 Lava Tiles");
        properties.setProperty("AnimateLevelTiles@161F", "Animate No Tiles");
        TextProvider.properties = new Properties(properties);
    }

    private TextProvider() {
    }

    public static String get(String string) {
        return TextProvider.get(string, false);
    }

    public static String get(String string, boolean bl) {
        String string2 = properties.getProperty(string);
        if (string2 != null && !string2.isEmpty() && string2.charAt(0) == '$') {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (n >= 0) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(TextProvider.get(string2.substring(++n, Math.min(string2.length(), string2.indexOf(36, n) & Integer.MAX_VALUE)), bl));
                n = string2.indexOf(36, n);
            }
            return stringBuilder.toString();
        }
        if (!bl) {
            if (string2 == null) {
                System.err.println("Couldn't find text for " + string + "!");
            } else if (properties.size() > 0 && properties.get(string) == null) {
                System.err.println("Missing translation for " + string + "! Default: " + properties.getProperty(string));
            }
        }
        return string2;
    }

    public static void cleanUpOldLanguageFiles() {
        new File(new File(KiddEd.getHomeDirectory(), "lang"), "French.ini").delete();
        new File(new File(KiddEd.getHomeDirectory(), "lang"), "Portuguese.ini").delete();
    }

    public static void setLanguage(String string) {
        File file;
        if (string == null) {
            string = Locale.getDefault().getLanguage();
        }
        if (!(file = new File(new File(KiddEd.getHomeDirectory(), "lang"), String.valueOf(string) + ".ini")).exists()) {
            properties.clear();
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void writeEnglishLanguageFile() {
        Properties properties = new Properties();
        for (String object : TextProvider.properties.stringPropertyNames()) {
            properties.setProperty(object, TextProvider.properties.getProperty(object));
        }
        try {
            FileOutputStream iOException = new FileOutputStream(new File(KiddEd.getHomeDirectory(), "English.ini"));
            properties.store(iOException, null);
            iOException.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("English language file written!");
    }

    public static void writeMissingTranslationsFile() {
        Properties properties = new Properties();
        for (String object : TextProvider.properties.stringPropertyNames()) {
            if (TextProvider.properties.get(object) != null || TextProvider.properties.getProperty(object).indexOf(36) >= 0) continue;
            properties.setProperty(object, TextProvider.properties.getProperty(object));
        }
        try {
            FileOutputStream iOException = new FileOutputStream(new File(KiddEd.getHomeDirectory(), "Missing.ini"));
            properties.store(iOException, null);
            iOException.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Missing translations file written!");
    }
}

