/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Tiles;
import data.Tileset;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import mastersystem.TMS9918A;
import miracleworld.MiracleWorldEditorModel;
import rom.RomManager;
import transactions.TransactionManager;

public class SpriteTileset
extends Tileset {
    private List<Tiles> tilesList = new ArrayList<Tiles>();

    public SpriteTileset(int n) {
        super(n, 114688, 0);
        final int n2 = this.countDataSources();
        int n3 = 0;
        while (n3 < n2) {
            final int n4 = n3++;
            this.tilesList.add(new Tiles(0, 0, 16384, 0, true){

                @Override
                public int getLength() {
                    int n = SpriteTileset.this.getTilesLength(n4);
                    if (n4 + 1 < n2 && SpriteTileset.this.getTilesDestination(n4 + 1) < 0) {
                        n += SpriteTileset.this.getTilesLength(n4 + 1);
                    }
                    return n * 32;
                }

                @Override
                public int getDestination() {
                    return SpriteTileset.this.getTilesDestination(n4) & 0x1FFF;
                }

                @Override
                protected int writeByte(int n, int n22) {
                    throw new UnsupportedOperationException();
                }

                @Override
                protected int[] getVRAM(TMS9918A tMS9918A) {
                    throw new UnsupportedOperationException();
                }
            });
        }
    }

    @Override
    protected boolean contains(Tiles tiles) {
        return this.tilesList.contains(tiles);
    }

    @Override
    public Tiles getTilesAt(int n) {
        if (this.tilesList != null) {
            ListIterator<Tiles> listIterator = this.tilesList.listIterator(this.tilesList.size());
            while (listIterator.hasPrevious()) {
                Tiles tiles = listIterator.previous();
                if (n < tiles.getDestination() || n >= tiles.getDestination() + tiles.getLength()) continue;
                return tiles;
            }
        }
        return null;
    }

    public boolean canEditTiles(int n) {
        int n2 = 0;
        int n3 = MiracleWorldEditorModel.getSourceOfSpriteTiles() / 16384;
        int n4 = this.getAddress();
        while (n4 < 16384) {
            int n5 = this.memory[n4];
            if (n5 == 195) {
                if (n3 != MiracleWorldEditorModel.getSourceOfItemTiles() / 16384 && n3 != MiracleWorldEditorModel.getSourceOfSpriteTiles() / 16384) {
                    return false;
                }
                int n6 = this.memory[n4 + 2] << 8 | this.memory[n4 + 1];
                if (this.memory[n6] == 205) {
                    n6 = this.memory[n6 + 2] << 8 | this.memory[n6 + 1];
                }
                return n6 == 325 || n6 == 709 || n6 == 388;
            }
            if (n5 == 62) {
                n2 = 0;
                --n4;
            } else if (n5 == 50) {
                n3 = this.memory[n4 - 2] == 62 && this.memory[n4 + 1] == 255 && this.memory[n4 + 2] == 255 ? this.memory[n4 - 1] & 0x7F : 0;
            } else if (n5 == 46) {
                --n4;
            } else if (n5 == 205) {
                if (n == 0) {
                    if (n3 != MiracleWorldEditorModel.getSourceOfItemTiles() / 16384 && n3 != MiracleWorldEditorModel.getSourceOfSpriteTiles() / 16384) {
                        return false;
                    }
                    return RomManager.StaticAccess.readWord(n4 + 1) == 325 || RomManager.StaticAccess.readWord(n4 + 1) == 709 || RomManager.StaticAccess.readWord(n4 + 1) == 388;
                }
                --n;
            } else if (n5 == 254) {
                --n4;
            } else if ((n5 == 32 || n5 == 48) && n4 >= 2 && this.memory[n4 - 2] == 254 && n2 >= 49152 && n2 < 57344) {
                if (n5 == 32 && this.memory[n2] != this.memory[n4 - 1] || n5 == 48 && this.memory[n2] >= this.memory[n4 - 1]) {
                    n4 += this.memory[n4 + 1];
                }
                --n4;
            } else if (n5 == 58) {
                n2 = this.memory[n4 + 2] << 8 | this.memory[n4 + 1];
            } else if (n5 == 0) {
                n4 -= 2;
            } else if (n5 == 49 || (n5 & 0xCF) != 1) {
                return false;
            }
            n4 += 3;
        }
        return false;
    }

    private int getFunctionAddress(int n) {
        int n2 = 0;
        int n3 = this.getAddress();
        while (n3 < 16384) {
            int n4 = this.memory[n3];
            if (n4 == 195) {
                int n5 = this.memory[n3 + 2] << 8 | this.memory[n3 + 1];
                if (this.memory[n5] == 205) {
                    n3 = n5;
                }
                return n3 + 1;
            }
            if (n4 == 62) {
                n2 = 0;
                n3 += 2;
            } else if (n4 == 46) {
                --n3;
            } else if (n4 == 205) {
                if (n == 0) {
                    return n3 + 1;
                }
                --n;
            } else if (n4 == 254) {
                --n3;
            } else if ((n4 == 32 || n4 == 48) && n3 >= 2 && this.memory[n3 - 2] == 254 && n2 >= 49152 && n2 < 57344) {
                if (n4 == 32 && this.memory[n2] != this.memory[n3 - 1] || n4 == 48 && this.memory[n2] >= this.memory[n3 - 1]) {
                    n3 += this.memory[n3 + 1];
                }
                --n3;
            } else if (n4 == 58) {
                n2 = this.memory[n3 + 2] << 8 | this.memory[n3 + 1];
            } else if (n4 == 0) {
                n3 -= 2;
            } else if (n4 == 49 || (n4 & 0xCF) != 1) {
                return -1;
            }
            n3 += 3;
        }
        return -1;
    }

    private int getSourceAddress(int n) {
        int n2 = 0;
        int n3 = this.getAddress();
        while (n3 < 16384) {
            int n4 = this.memory[n3];
            if (n4 == 33 && n == 0) {
                return n3 + 1;
            }
            if (n4 == 195) {
                return -1;
            }
            if (n4 == 62) {
                n2 = 0;
                n3 += 2;
            } else if (n4 == 46) {
                --n3;
            } else if (n4 == 205) {
                --n;
            } else if (n4 == 254) {
                --n3;
            } else if ((n4 == 32 || n4 == 48) && n3 >= 2 && this.memory[n3 - 2] == 254 && n2 >= 49152 && n2 < 57344) {
                if (n4 == 32 && this.memory[n2] != this.memory[n3 - 1] || n4 == 48 && this.memory[n2] >= this.memory[n3 - 1]) {
                    n3 += this.memory[n3 + 1];
                }
                --n3;
            } else if (n4 == 58) {
                n2 = this.memory[n3 + 2] << 8 | this.memory[n3 + 1];
            } else if (n4 == 0) {
                n3 -= 2;
            } else if (n4 == 49 || (n4 & 0xCF) != 1) {
                return -1;
            }
            n3 += 3;
        }
        return -1;
    }

    public int getTilesSource(int n) {
        int n2 = this.getSourceAddress(n);
        if (n2 < 0) {
            return -1;
        }
        return RomManager.StaticAccess.readWord(n2);
    }

    public void setTilesSource(int n, int n2) {
        if (!this.isTiles(n) && !this.isMirroredTiles(n)) {
            return;
        }
        int n3 = this.getSourceAddress(n);
        if (n3 < 0) {
            return;
        }
        this.writeWord(n3, n2);
    }

    private int getDestinationAddress(int n) {
        int n2 = 0;
        int n3 = this.getAddress();
        while (n3 < 16384) {
            int n4 = this.memory[n3];
            if (n4 == 17 && n == 0) {
                return n3 + 1;
            }
            if (n4 == 195) {
                return -1;
            }
            if (n4 == 62) {
                n2 = 0;
                n3 += 2;
            } else if (n4 == 46) {
                --n3;
            } else if (n4 == 205) {
                --n;
            } else if (n4 == 254) {
                --n3;
            } else if ((n4 == 32 || n4 == 48) && n3 >= 2 && this.memory[n3 - 2] == 254 && n2 >= 49152 && n2 < 57344) {
                if (n4 == 32 && this.memory[n2] != this.memory[n3 - 1] || n4 == 48 && this.memory[n2] >= this.memory[n3 - 1]) {
                    n3 += this.memory[n3 + 1];
                }
                --n3;
            } else if (n4 == 58) {
                n2 = this.memory[n3 + 2] << 8 | this.memory[n3 + 1];
            } else if (n4 == 0) {
                n3 -= 2;
            } else if (n4 == 49 || (n4 & 0xCF) != 1) {
                return -1;
            }
            n3 += 3;
        }
        return -1;
    }

    public int getTilesDestination(int n) {
        int n2 = this.getDestinationAddress(n);
        if (n2 < 0) {
            return -1;
        }
        return RomManager.StaticAccess.readWord(n2);
    }

    private int getLengthAddress(int n) {
        int n2 = 0;
        int n3 = this.getAddress();
        while (n3 < 16384) {
            int n4 = this.memory[n3];
            if (n4 == 1 && n == 0) {
                return n3 + 1;
            }
            if (n4 == 195) {
                return -1;
            }
            if (n4 == 62) {
                n2 = 0;
                n3 += 2;
            } else if (n4 == 46) {
                --n3;
            } else if (n4 == 205) {
                --n;
            } else if (n4 == 254) {
                --n3;
            } else if ((n4 == 32 || n4 == 48) && n3 >= 2 && this.memory[n3 - 2] == 254 && n2 >= 49152 && n2 < 57344) {
                if (n4 == 32 && this.memory[n2] != this.memory[n3 - 1] || n4 == 48 && this.memory[n2] >= this.memory[n3 - 1]) {
                    n3 += this.memory[n3 + 1];
                }
                --n3;
            } else if (n4 == 58) {
                n2 = this.memory[n3 + 2] << 8 | this.memory[n3 + 1];
            } else if (n4 == 0) {
                n3 -= 2;
            } else if (n4 == 49 || (n4 & 0xCF) != 1) {
                return -1;
            }
            n3 += 3;
        }
        return -1;
    }

    public int getTilesLength(int n) {
        int n2 = this.getLengthAddress(n);
        if (n2 < 0) {
            return -1;
        }
        return RomManager.StaticAccess.readWord(n2) / 32;
    }

    public void setTilesLength(int n, int n2) {
        int n3 = this.getLengthAddress(n);
        if (n3 < 0) {
            return;
        }
        this.writeWord(n3, n2 * 32);
    }

    private int getFunction(int n) {
        int n2 = this.getFunctionAddress(n);
        if (n2 < 0) {
            return -1;
        }
        return RomManager.StaticAccess.readWord(n2);
    }

    public boolean canSetFunction(int n, int n2) {
        if (n == 0 && n2 == 709) {
            return false;
        }
        return this.getFunctionAddress(n) >= 0 && this.getSourceAddress(n) >= 0 && this.getBaseAddress(n) >= 0;
    }

    public void setFunction(int n, int n2) {
        if (n == 0 && n2 == 709) {
            throw new IllegalArgumentException("Mirrored tiles must not be loaded before setting the VDP Address.");
        }
        int n3 = this.getFunctionAddress(n);
        int n4 = this.getSourceAddress(n);
        int n5 = this.getBaseAddress(n);
        if (n3 < 0 || n4 < 0 || n5 < 0) {
            return;
        }
        if (n2 == 388) {
            this.writeByte(n4, 0);
        } else {
            this.writeWord(n4, Math.max(n5, this.getTilesSource(n) | n5 & 0x1F));
        }
        this.writeWord(n3, n2);
    }

    private int getBaseAddress(int n) {
        boolean bl = this.isItemTiles(n);
        boolean bl2 = this.isSpriteTiles(n);
        if (!bl && !bl2) {
            return -1;
        }
        return 0x8000 | (bl ? MiracleWorldEditorModel.getSourceOfItemTiles() : MiracleWorldEditorModel.getSourceOfSpriteTiles()) & 0x3FFF;
    }

    public boolean isItemTiles(int n) {
        return this.getBank(n) == MiracleWorldEditorModel.getSourceOfItemTiles() / 16384;
    }

    public boolean isSpriteTiles(int n) {
        return this.getBank(n) == MiracleWorldEditorModel.getSourceOfSpriteTiles() / 16384;
    }

    private int getBank(int n) {
        int n2 = 0;
        int n3 = MiracleWorldEditorModel.getSourceOfSpriteTiles() / 16384;
        int n4 = this.getAddress();
        while (n4 < 16384) {
            int n5 = this.memory[n4];
            if (n5 == 195) {
                return n3;
            }
            if (n5 == 62) {
                n2 = 0;
                --n4;
            } else if (n5 == 50) {
                n3 = this.memory[n4 - 2] == 62 && this.memory[n4 + 1] == 255 && this.memory[n4 + 2] == 255 ? this.memory[n4 - 1] & 0x7F : 0;
            } else if (n5 == 46) {
                --n4;
            } else if (n5 == 205) {
                if (n == 0) {
                    return n3;
                }
                --n;
            } else if (n5 == 254) {
                --n4;
            } else if ((n5 == 32 || n5 == 48) && n4 >= 2 && this.memory[n4 - 2] == 254 && n2 >= 49152 && n2 < 57344) {
                if (n5 == 32 && this.memory[n2] != this.memory[n4 - 1] || n5 == 48 && this.memory[n2] >= this.memory[n4 - 1]) {
                    n4 += this.memory[n4 + 1];
                }
                --n4;
            } else if (n5 == 58) {
                n2 = this.memory[n4 + 2] << 8 | this.memory[n4 + 1];
            } else if (n5 == 0) {
                n4 -= 2;
            } else if (n5 == 49 || (n5 & 0xCF) != 1) {
                return -1;
            }
            n4 += 3;
        }
        return -1;
    }

    public boolean isTiles(int n) {
        return this.getFunction(n) == 325;
    }

    public boolean isMirroredTiles(int n) {
        return this.getFunction(n) == 709;
    }

    public boolean isInvisible(int n) {
        return this.getFunction(n) == 388;
    }

    public int countDataSources() {
        int n = 0;
        int n2 = 0;
        int n3 = this.getAddress();
        while (n3 < 16384) {
            int n4 = this.memory[n3];
            if (n4 == 195) {
                return n + 1;
            }
            if (n4 == 62) {
                n2 = 0;
                n3 += 2;
            } else if (n4 == 46) {
                --n3;
            } else if (n4 == 205) {
                ++n;
            } else if (n4 == 254) {
                --n3;
            } else if ((n4 == 32 || n4 == 48) && n3 >= 2 && this.memory[n3 - 2] == 254 && n2 >= 49152 && n2 < 57344) {
                if (n4 == 32 && this.memory[n2] != this.memory[n3 - 1] || n4 == 48 && this.memory[n2] >= this.memory[n3 - 1]) {
                    n3 += this.memory[n3 + 1];
                }
                --n3;
            } else if (n4 == 58) {
                n2 = this.memory[n3 + 2] << 8 | this.memory[n3 + 1];
            } else if (n4 == 0) {
                n3 -= 2;
            } else if (n4 == 49 || (n4 & 0xCF) != 1) {
                return n;
            }
            n3 += 3;
        }
        return 0;
    }

    @Override
    public boolean isSprite() {
        return true;
    }

    @Override
    public boolean canSetTilesDestination(Tiles tiles) {
        return tiles != null;
    }

    @Override
    public void setTilesDestination(Tiles tiles, int n) {
        if (n < 0) {
            n = 0;
        }
        if (n + tiles.getLength() > 6144) {
            n = 6144 - tiles.getLength();
        }
        int n2 = this.getDestinationAddress(this.tilesList.indexOf(tiles));
        this.writeWord(n2, n |= 0x6000);
    }

    protected void writeByte(int n, int n2) {
        if (RomManager.StaticAccess.readByte(n) != n2) {
            TransactionManager.getInstance().addTransactionObject(this, -1);
            RomManager.getInstance().writeByte(n, n2);
            this.memory[n] = n2;
            this.memoryDirty = true;
        }
    }

    protected void writeWord(int n, int n2) {
        if (RomManager.StaticAccess.readWord(n) != n2) {
            TransactionManager.getInstance().addTransactionObject(this, -1);
            RomManager.getInstance().writeWord(n, n2);
            this.memory[n] = n2 & 0xFF;
            this.memory[n + 1] = n2 >> 8;
            this.memoryDirty = true;
        }
    }
}

