/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.exception;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.resources.UtilMessages;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public class LocatableWebServiceException
extends WebServiceException {
    private final Locator[] location;

    public LocatableWebServiceException(String string, Locator ... locatorArray) {
        this(string, (Throwable)null, locatorArray);
    }

    public LocatableWebServiceException(String string, Throwable throwable, Locator ... locatorArray) {
        super(LocatableWebServiceException.appendLocationInfo(string, locatorArray), throwable);
        this.location = locatorArray;
    }

    public LocatableWebServiceException(Throwable throwable, Locator ... locatorArray) {
        this(throwable.toString(), throwable, locatorArray);
    }

    public LocatableWebServiceException(String string, XMLStreamReader xMLStreamReader) {
        this(string, LocatableWebServiceException.toLocation(xMLStreamReader));
    }

    public LocatableWebServiceException(String string, Throwable throwable, XMLStreamReader xMLStreamReader) {
        this(string, throwable, LocatableWebServiceException.toLocation(xMLStreamReader));
    }

    public LocatableWebServiceException(Throwable throwable, XMLStreamReader xMLStreamReader) {
        this(throwable, LocatableWebServiceException.toLocation(xMLStreamReader));
    }

    @NotNull
    public List<Locator> getLocation() {
        return Arrays.asList(this.location);
    }

    private static String appendLocationInfo(String string, Locator[] locatorArray) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (Locator locator : locatorArray) {
            stringBuilder.append('\n').append(UtilMessages.UTIL_LOCATION(locator.getLineNumber(), locator.getSystemId()));
        }
        return stringBuilder.toString();
    }

    private static Locator toLocation(XMLStreamReader xMLStreamReader) {
        LocatorImpl locatorImpl = new LocatorImpl();
        Location location = xMLStreamReader.getLocation();
        locatorImpl.setSystemId(location.getSystemId());
        locatorImpl.setPublicId(location.getPublicId());
        locatorImpl.setLineNumber(location.getLineNumber());
        locatorImpl.setColumnNumber(location.getColumnNumber());
        return locatorImpl;
    }
}

