/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.axes;

import com.sun.org.apache.xml.internal.dtm.DTMAxisIterator;
import com.sun.org.apache.xml.internal.dtm.DTMAxisTraverser;
import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.axes.ChildTestIterator;
import com.sun.org.apache.xpath.internal.axes.WalkerFactory;
import com.sun.org.apache.xpath.internal.compiler.Compiler;
import com.sun.org.apache.xpath.internal.compiler.OpMap;
import javax.xml.transform.TransformerException;

public class OneStepIterator
extends ChildTestIterator {
    static final long serialVersionUID = 4623710779664998283L;
    protected int m_axis = -1;
    protected DTMAxisIterator m_iterator;

    OneStepIterator(Compiler compiler, int n, int n2) throws TransformerException {
        super(compiler, n, n2);
        int n3 = OpMap.getFirstChildPos(n);
        this.m_axis = WalkerFactory.getAxisFromStep(compiler, n3);
    }

    public OneStepIterator(DTMAxisIterator dTMAxisIterator, int n) throws TransformerException {
        super((DTMAxisTraverser)null);
        this.m_iterator = dTMAxisIterator;
        this.m_axis = n;
        int n2 = -1;
        this.initNodeTest(n2);
    }

    @Override
    public void setRoot(int n, Object object) {
        super.setRoot(n, object);
        if (this.m_axis > -1) {
            this.m_iterator = this.m_cdtm.getAxisIterator(this.m_axis);
        }
        this.m_iterator.setStartNode(this.m_context);
    }

    @Override
    public void detach() {
        if (this.m_allowDetach) {
            if (this.m_axis > -1) {
                this.m_iterator = null;
            }
            super.detach();
        }
    }

    @Override
    protected int getNextNode() {
        this.m_lastFetched = this.m_iterator.next();
        return this.m_lastFetched;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OneStepIterator oneStepIterator = (OneStepIterator)super.clone();
        if (this.m_iterator != null) {
            oneStepIterator.m_iterator = this.m_iterator.cloneIterator();
        }
        return oneStepIterator;
    }

    @Override
    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        OneStepIterator oneStepIterator = (OneStepIterator)super.cloneWithReset();
        oneStepIterator.m_iterator = this.m_iterator;
        return oneStepIterator;
    }

    @Override
    public boolean isReverseAxes() {
        return this.m_iterator.isReverse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getProximityPosition(int n) {
        if (!this.isReverseAxes()) {
            return super.getProximityPosition(n);
        }
        if (n < 0) {
            return -1;
        }
        if (this.m_proximityPositions[n] <= 0) {
            XPathContext xPathContext = this.getXPathContext();
            try {
                int n2;
                OneStepIterator oneStepIterator = (OneStepIterator)this.clone();
                int n3 = this.getRoot();
                xPathContext.pushCurrentNode(n3);
                oneStepIterator.setRoot(n3, xPathContext);
                oneStepIterator.m_predCount = n;
                int n4 = 1;
                while (-1 != (n2 = oneStepIterator.nextNode())) {
                    ++n4;
                }
                int n5 = n;
                this.m_proximityPositions[n5] = this.m_proximityPositions[n5] + n4;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
            }
            finally {
                xPathContext.popCurrentNode();
            }
        }
        return this.m_proximityPositions[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLength() {
        if (!this.isReverseAxes()) {
            return super.getLength();
        }
        boolean bl = this == this.m_execContext.getSubContextList();
        int n = this.getPredicateCount();
        if (-1 != this.m_length && bl && this.m_predicateIndex < 1) {
            return this.m_length;
        }
        int n2 = 0;
        XPathContext xPathContext = this.getXPathContext();
        try {
            int n3;
            OneStepIterator oneStepIterator = (OneStepIterator)this.cloneWithReset();
            int n4 = this.getRoot();
            xPathContext.pushCurrentNode(n4);
            oneStepIterator.setRoot(n4, xPathContext);
            oneStepIterator.m_predCount = this.m_predicateIndex;
            while (-1 != (n3 = oneStepIterator.nextNode())) {
                ++n2;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
        }
        finally {
            xPathContext.popCurrentNode();
        }
        if (bl && this.m_predicateIndex < 1) {
            this.m_length = n2;
        }
        return n2;
    }

    @Override
    protected void countProximityPosition(int n) {
        if (!this.isReverseAxes()) {
            super.countProximityPosition(n);
        } else if (n < this.m_proximityPositions.length) {
            int n2 = n;
            this.m_proximityPositions[n2] = this.m_proximityPositions[n2] - 1;
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (null != this.m_iterator) {
            this.m_iterator.reset();
        }
    }

    @Override
    public int getAxis() {
        return this.m_axis;
    }

    @Override
    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        return this.m_axis == ((OneStepIterator)expression).m_axis;
    }
}

