/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.serializer.WriterChain;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

final class WriterToUTF8Buffered
extends Writer
implements WriterChain {
    private static final int BYTES_MAX = 16384;
    private static final int CHARS_MAX = 5461;
    private final OutputStream m_os;
    private final byte[] m_outputBytes;
    private final char[] m_inputChars;
    private int count;

    public WriterToUTF8Buffered(OutputStream outputStream) throws UnsupportedEncodingException {
        this.m_os = outputStream;
        this.m_outputBytes = new byte[16387];
        this.m_inputChars = new char[5463];
        this.count = 0;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.count >= 16384) {
            this.flushBuffer();
        }
        if (n < 128) {
            this.m_outputBytes[this.count++] = (byte)n;
        } else if (n < 2048) {
            this.m_outputBytes[this.count++] = (byte)(192 + (n >> 6));
            this.m_outputBytes[this.count++] = (byte)(128 + (n & 0x3F));
        } else if (n < 65536) {
            this.m_outputBytes[this.count++] = (byte)(224 + (n >> 12));
            this.m_outputBytes[this.count++] = (byte)(128 + (n >> 6 & 0x3F));
            this.m_outputBytes[this.count++] = (byte)(128 + (n & 0x3F));
        } else {
            this.m_outputBytes[this.count++] = (byte)(240 + (n >> 18));
            this.m_outputBytes[this.count++] = (byte)(128 + (n >> 12 & 0x3F));
            this.m_outputBytes[this.count++] = (byte)(128 + (n >> 6 & 0x3F));
            this.m_outputBytes[this.count++] = (byte)(128 + (n & 0x3F));
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        char c;
        int n3;
        int n4 = 3 * n2;
        if (n4 >= 16384 - this.count) {
            this.flushBuffer();
            if (n4 > 16384) {
                int n5 = n2 / 5461;
                int n6 = n2 % 5461 > 0 ? n5 + 1 : n5;
                int n7 = n;
                for (int i = 1; i <= n6; ++i) {
                    int n8 = n7;
                    n7 = n + (int)((long)n2 * (long)i / (long)n6);
                    char c2 = cArray[n7 - 1];
                    char c3 = cArray[n7 - 1];
                    if (c2 >= '\ud800' && c2 <= '\udbff') {
                        n7 = n7 < n + n2 ? ++n7 : --n7;
                    }
                    int n9 = n7 - n8;
                    this.write(cArray, n8, n9);
                }
                return;
            }
        }
        int n10 = n2 + n;
        byte[] byArray = this.m_outputBytes;
        int n11 = this.count;
        for (n3 = n; n3 < n10 && (c = cArray[n3]) < '\u0080'; ++n3) {
            byArray[n11++] = (byte)c;
        }
        while (n3 < n10) {
            c = cArray[n3];
            if (c < '\u0080') {
                byArray[n11++] = (byte)c;
            } else if (c < '\u0800') {
                byArray[n11++] = (byte)(192 + (c >> 6));
                byArray[n11++] = (byte)(128 + (c & 0x3F));
            } else if (c >= '\ud800' && c <= '\udbff') {
                char c4 = c;
                char c5 = cArray[++n3];
                byArray[n11++] = (byte)(0xF0 | c4 + 64 >> 8 & 0xF0);
                byArray[n11++] = (byte)(0x80 | c4 + 64 >> 2 & 0x3F);
                byArray[n11++] = (byte)(0x80 | (c5 >> 6 & 0xF) + (c4 << 4 & 0x30));
                byArray[n11++] = (byte)(0x80 | c5 & 0x3F);
            } else {
                byArray[n11++] = (byte)(224 + (c >> 12));
                byArray[n11++] = (byte)(128 + (c >> 6 & 0x3F));
                byArray[n11++] = (byte)(128 + (c & 0x3F));
            }
            ++n3;
        }
        this.count = n11;
    }

    @Override
    public void write(String string) throws IOException {
        char c;
        int n;
        int n2 = string.length();
        int n3 = 3 * n2;
        if (n3 >= 16384 - this.count) {
            this.flushBuffer();
            if (n3 > 16384) {
                boolean bl = false;
                int n4 = n2 / 5461;
                int n5 = n2 % 5461 > 0 ? n4 + 1 : n4;
                int n6 = 0;
                for (int i = 1; i <= n5; ++i) {
                    int n7 = n6;
                    n6 = 0 + (int)((long)n2 * (long)i / (long)n5);
                    string.getChars(n7, n6, this.m_inputChars, 0);
                    int n8 = n6 - n7;
                    char c2 = this.m_inputChars[n8 - 1];
                    if (c2 >= '\ud800' && c2 <= '\udbff') {
                        --n6;
                        --n8;
                        if (i == n5) {
                            // empty if block
                        }
                    }
                    this.write(this.m_inputChars, 0, n8);
                }
                return;
            }
        }
        string.getChars(0, n2, this.m_inputChars, 0);
        char[] cArray = this.m_inputChars;
        int n9 = n2;
        byte[] byArray = this.m_outputBytes;
        int n10 = this.count;
        for (n = 0; n < n9 && (c = cArray[n]) < '\u0080'; ++n) {
            byArray[n10++] = (byte)c;
        }
        while (n < n9) {
            c = cArray[n];
            if (c < '\u0080') {
                byArray[n10++] = (byte)c;
            } else if (c < '\u0800') {
                byArray[n10++] = (byte)(192 + (c >> 6));
                byArray[n10++] = (byte)(128 + (c & 0x3F));
            } else if (c >= '\ud800' && c <= '\udbff') {
                char c3 = c;
                char c4 = cArray[++n];
                byArray[n10++] = (byte)(0xF0 | c3 + 64 >> 8 & 0xF0);
                byArray[n10++] = (byte)(0x80 | c3 + 64 >> 2 & 0x3F);
                byArray[n10++] = (byte)(0x80 | (c4 >> 6 & 0xF) + (c3 << 4 & 0x30));
                byArray[n10++] = (byte)(0x80 | c4 & 0x3F);
            } else {
                byArray[n10++] = (byte)(224 + (c >> 12));
                byArray[n10++] = (byte)(128 + (c >> 6 & 0x3F));
                byArray[n10++] = (byte)(128 + (c & 0x3F));
            }
            ++n;
        }
        this.count = n10;
    }

    public void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.m_outputBytes, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.m_os;
    }

    @Override
    public Writer getWriter() {
        return null;
    }
}

