/*
 * Decompiled with CFR 0.152.
 */
package util.list;

import java.util.Arrays;
import util.list.AbstractIntList;
import util.list.IntList;

public class IntArrayList
extends AbstractIntList {
    private int[] elementData;
    private int size;

    public IntArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new int[n];
    }

    public IntArrayList() {
        this(10);
    }

    public void trimToSize() {
        int n = this.elementData.length;
        if (this.size < n) {
            this.elementData = Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = Arrays.copyOf(this.elementData, n3);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int[] toArray() {
        this.trimToSize();
        return this.elementData;
    }

    @Override
    public int get(int n) {
        return this.elementData[n];
    }

    @Override
    public int set(int n, int n2) {
        int n3 = this.elementData[n];
        this.elementData[n] = n2;
        return n3;
    }

    @Override
    public boolean add(int n) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = n;
        return true;
    }

    @Override
    public int remove(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        int n2 = this.elementData[n];
        this.fastRemove(n);
        return n2;
    }

    protected void fastRemove(int n) {
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean addAll(IntList intList) {
        int[] nArray = intList.toArray();
        int n = nArray.length;
        this.ensureCapacity(this.size + n);
        System.arraycopy(nArray, 0, this.elementData, this.size, n);
        this.size += n;
        return n != 0;
    }

    @Override
    public IntList subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }
}

