/*
 * Decompiled with CFR 0.152.
 */
package platform;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import platform.Emulicious;

class VideoRecordingSettingsDialog
extends JDialog {
    private final JTextField ffmpegPath;
    private final JTextField recordingsPath;
    private final JComboBox<String> recordingCompression;
    private final JComboBox<String> scale;
    private final JCheckBox cropBorders;
    private final JCheckBox useY420pColorSpace;
    private final JTextField threads;
    private final JTextField par;
    private final JComboBox<String> encodingPreset;
    private final JComboBox<String> crf;
    private final JComboBox<String> audioCodec;

    public VideoRecordingSettingsDialog(JFrame jFrame) {
        super(jFrame, String.valueOf(Emulicious.TITLE) + " - Video Recording Settings", true);
        this.setIconImages(jFrame.getIconImages());
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Path to FFMPEG executable"));
        jPanel.add(jPanel2);
        this.ffmpegPath = new JTextField(Emulicious.getProperties().getProperty("FFMPEGPath"), 40);
        jPanel2.add(this.ffmpegPath);
        JButton jButton = new JButton(FileSystemView.getFileSystemView().getSystemIcon(Emulicious.getVideoRecordingsDirectory()));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoRecordingSettingsDialog.this.showFFMPEGFileChooser(VideoRecordingSettingsDialog.this);
            }
        });
        jPanel2.add(jButton);
        jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Folder for Video Recordings"));
        jPanel.add(jPanel2);
        this.recordingsPath = new JTextField(Emulicious.getVideoRecordingsDirectory().getAbsolutePath(), 40);
        jPanel2.add(this.recordingsPath);
        jButton = new JButton(FileSystemView.getFileSystemView().getSystemIcon(Emulicious.getVideoRecordingsDirectory()));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoRecordingSettingsDialog.this.showFolderFileChooser(VideoRecordingSettingsDialog.this);
            }
        });
        jPanel2.add(jButton);
        this.add((Component)jPanel, "North");
        JPanel jPanel3 = new JPanel(new GridLayout(8, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new JLabel("Compression While Recording:"));
        jPanel3.add(jPanel4);
        this.recordingCompression = new JComboBox<String>(new String[]{"Lower CPU Usage, Bigger Temporary File", "Balanced (Default)", "Higher CPU Usage, Smaller Temporary File"});
        jPanel4.add(this.recordingCompression);
        this.recordingCompression.setSelectedIndex(Emulicious.getProperties().getInt("VideoRecordingRecordingCompression", 1));
        JPanel jPanel5 = new JPanel();
        jPanel5.add(new JLabel("Scale: "));
        jPanel3.add(jPanel5);
        this.scale = new JComboBox<String>(new String[]{"1x", "2x", "3x", "4x", "5x", "6x", "7x", "8x", "9x", "10x", "11x", "12x", "13x", "14x", "15x", "16x", "17x", "18x", "19x", "20x", "21x", "22x", "23x", "24x"});
        jPanel5.add(this.scale);
        this.scale.setSelectedIndex(Math.max(0, Emulicious.getProperties().getInt("VideoRecordingScale", 1) - 1));
        this.cropBorders = new JCheckBox("Crop Borders", Boolean.parseBoolean(Emulicious.getProperties().getProperty("VideoRecordingCropBorders")));
        jPanel5.add(this.cropBorders);
        JPanel jPanel6 = new JPanel();
        jPanel6.add(new JLabel("Pixel Aspect Ratio (Leave blank to use displayed PAR): "));
        jPanel3.add(jPanel6);
        this.par = new JTextField(Emulicious.getProperties().getProperty("VideoRecordingPAR"), 3);
        jPanel6.add(this.par);
        JPanel jPanel7 = new JPanel();
        jPanel3.add(jPanel7);
        this.useY420pColorSpace = new JCheckBox("Use YUV420p Color Space (Better Compatibility, Lossy Colors)", Boolean.parseBoolean(Emulicious.getProperties().getProperty("VideoRecordingUseYUV420pColorSpace")));
        jPanel7.add(this.useY420pColorSpace);
        JPanel jPanel8 = new JPanel();
        jPanel8.add(new JLabel("FFMPEG Encoding Preset: "));
        jPanel3.add(jPanel8);
        this.encodingPreset = new JComboBox<String>(new String[]{"ultrafast", "superfast", "veryfast", "faster", "fast", "medium", "slow", "slower", "veryslow"});
        this.encodingPreset.setSelectedItem(Emulicious.getProperties().getProperty("VideoRecordingEncodingPreset"));
        jPanel8.add(this.encodingPreset);
        JPanel jPanel9 = new JPanel();
        jPanel9.add(new JLabel("Constant Rate Factor: "));
        jPanel3.add(jPanel9);
        String[] stringArray = new String[52];
        int n = 1;
        while (n < stringArray.length) {
            stringArray[n] = Integer.toString(n);
            ++n;
        }
        stringArray[0] = "0 (Lossless, Low Compatibility)";
        stringArray[17] = "17 (Visually Lossless)";
        stringArray[23] = "23 (High Quality)";
        stringArray[29] = "29 (Medium Quality)";
        stringArray[35] = "35 (Low Quality)";
        stringArray[41] = "41 (Very Low Quality)";
        stringArray[51] = "51 (Lowest Quality)";
        this.crf = new JComboBox<String>(stringArray);
        this.crf.setSelectedIndex(Emulicious.getProperties().getInt("VideoRecordingCRF", 17));
        jPanel9.add(this.crf);
        JPanel jPanel10 = new JPanel();
        jPanel10.add(new JLabel("Audio Codec: "));
        jPanel3.add(jPanel10);
        this.audioCodec = new JComboBox<String>(new String[]{"flac", "aac"});
        this.audioCodec.setSelectedItem(Emulicious.getProperties().getProperty("VideoRecordingAudioCodec"));
        jPanel10.add(this.audioCodec);
        JPanel jPanel11 = new JPanel();
        jPanel11.add(new JLabel("Number of threads to use for encoding (Leave blank for optimal speed): "));
        jPanel3.add(jPanel11);
        this.threads = new JTextField(Emulicious.getProperties().getProperty("VideoRecordingThreads"), 3);
        jPanel11.add(this.threads);
        this.add((Component)jPanel3, "Center");
        JPanel jPanel12 = new JPanel();
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Emulicious.getProperties().setProperty("FFMPEGPath", VideoRecordingSettingsDialog.this.ffmpegPath.getText());
                Emulicious.getProperties().setProperty("VideoRecordingsDir", VideoRecordingSettingsDialog.this.recordingsPath.getText());
                Emulicious.getProperties().setProperty("VideoRecordingScale", Integer.toString(VideoRecordingSettingsDialog.this.scale.getSelectedIndex() + 1));
                Emulicious.getProperties().setProperty("VideoRecordingCropBorders", Boolean.toString(VideoRecordingSettingsDialog.this.cropBorders.isSelected()));
                Emulicious.getProperties().setProperty("VideoRecordingThreads", VideoRecordingSettingsDialog.this.threads.getText());
                Emulicious.getProperties().setProperty("VideoRecordingPAR", VideoRecordingSettingsDialog.this.par.getText());
                Emulicious.getProperties().setProperty("VideoRecordingEncodingPreset", VideoRecordingSettingsDialog.this.encodingPreset.getSelectedItem().toString());
                Emulicious.getProperties().setProperty("VideoRecordingUseYUV420pColorSpace", Boolean.toString(VideoRecordingSettingsDialog.this.useY420pColorSpace.isSelected()));
                Emulicious.getProperties().setProperty("VideoRecordingCRF", Integer.toString(VideoRecordingSettingsDialog.this.crf.getSelectedIndex() < 0 ? 17 : VideoRecordingSettingsDialog.this.crf.getSelectedIndex()));
                Emulicious.getProperties().setProperty("VideoRecordingAudioCodec", VideoRecordingSettingsDialog.this.audioCodec.getSelectedItem().toString());
                VideoRecordingSettingsDialog.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(jButton2);
        jPanel12.add(jButton2);
        JButton jButton3 = new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VideoRecordingSettingsDialog.this.dispose();
            }
        });
        jPanel12.add(jButton3);
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    final JDialog jDialog = new JDialog((Dialog)VideoRecordingSettingsDialog.this, true);
                    jDialog.setUndecorated(true);
                    jDialog.setSize(0, 0);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jDialog.dispose();
                        }
                    });
                    jDialog.setVisible(true);
                }
            });
        }
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", jButton3.getAction());
        this.add((Component)jPanel12, "South");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.setVisible(true);
    }

    void showFolderFileChooser(Component component) {
        JFileChooser jFileChooser = new JFileChooser(new File(this.recordingsPath.getText()).getParentFile());
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle("Save Sound Recordings To...");
        jFileChooser.setSelectedFile(new File(new File(this.recordingsPath.getText()).getName()));
        if (jFileChooser.showSaveDialog(component) == 0) {
            this.recordingsPath.setText(jFileChooser.getSelectedFile().getPath());
        }
    }

    void showFFMPEGFileChooser(Component component) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        if (Emulicious.getProperties().containsKey("FFMPEGPath") && (file = new File(Emulicious.getProperties().getProperty("FFMPEGPath"))).exists()) {
            jFileChooser.setCurrentDirectory(file.getParentFile());
        }
        jFileChooser.setDialogTitle("Select the FFMPEG executable...");
        jFileChooser.setSelectedFile(new File(new File(this.ffmpegPath.getText()).getName()));
        if (jFileChooser.showSaveDialog(component) == 0) {
            this.ffmpegPath.setText(jFileChooser.getSelectedFile().getPath());
        }
    }
}

