/*
 * Decompiled with CFR 0.152.
 */
package platform;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import platform.DebuggableSystemDecorator;
import system.DebuggableSystem;

public class MemoryFreezer
extends DebuggableSystemDecorator {
    private final BitSet ramFreeze = new BitSet();
    private final BitSet vramFreeze = new BitSet();
    private final BitSet sramFreeze = new BitSet();
    private final Map<String, BitSet> locationFreeze = new HashMap<String, BitSet>();

    public MemoryFreezer(DebuggableSystem debuggableSystem) {
        super(debuggableSystem);
    }

    @Override
    public void writeByte(int n, int n2, int n3) {
        String string = this.getAdditionalMemoryLocationAt(n);
        if (!(string != null && this.isMemoryFreezeLocation(string, this.mapAddress(n)) || this.isRAMaddress(n) && this.ramFreeze.get(this.mapAddress(n)) || this.isVRAMaddress(n) && this.vramFreeze.get(this.mapAddress(n)) || this.isSRAMaddress(n) && this.sramFreeze.get(this.mapAddress(n)))) {
            super.writeByte(n, n2, n3);
        }
    }

    public boolean isMemoryFreezeRAM(int n) {
        return this.ramFreeze.get(n);
    }

    public void setMemoryFreezeRAM(int n, boolean bl) {
        this.ramFreeze.set(n, bl);
    }

    public boolean isMemoryFreezeVRAM(int n) {
        return this.vramFreeze.get(n);
    }

    public void setMemoryFreezeVRAM(int n, boolean bl) {
        this.vramFreeze.set(n, bl);
    }

    public boolean isMemoryFreezeSRAM(int n) {
        return this.sramFreeze.get(n);
    }

    public void setMemoryFreezeSRAM(int n, boolean bl) {
        this.sramFreeze.set(n, bl);
    }

    public boolean isMemoryFreezeLocation(String string, int n) {
        BitSet bitSet = this.locationFreeze.get(string);
        return bitSet != null && bitSet.get(n);
    }

    public void setMemoryFreezeLocation(String string, int n, boolean bl) {
        BitSet bitSet = this.locationFreeze.get(string);
        if (bitSet == null) {
            bitSet = new BitSet();
            this.locationFreeze.put(string, bitSet);
        }
        bitSet.set(n, bl);
    }
}

