/*
 * Decompiled with CFR 0.152.
 */
package expressions;

import expressions.ParseException;
import expressions.Token;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tokenizer {
    private final Pattern numberPattern;
    private final Pattern operatorPattern;
    private final Pattern variablePattern;
    private final Pattern parenthesisPattern;

    public Tokenizer(String string, String string2, String string3, String string4) {
        this.numberPattern = Pattern.compile("^(?:" + string + ")");
        this.operatorPattern = Pattern.compile("^(?:" + string2 + ")");
        this.variablePattern = Pattern.compile("^(?:" + string3 + ")");
        this.parenthesisPattern = Pattern.compile("^(?:" + string4 + ")");
    }

    public Token[] tokenize(CharSequence charSequence, int n) throws ParseException {
        charSequence = charSequence.toString();
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2 && charSequence.charAt(n3) <= ' ') {
            ++n3;
        }
        ArrayList<Token> arrayList = new ArrayList<Token>();
        while (n3 < n2) {
            Matcher matcher = this.numberPattern.matcher(charSequence);
            matcher.region(n3, n2);
            if (matcher.find()) {
                arrayList.add(new Token(0, matcher.group(), n));
            } else {
                matcher = this.operatorPattern.matcher(charSequence);
                matcher.region(n3, n2);
                if (matcher.find()) {
                    arrayList.add(new Token(1, matcher.group()));
                } else {
                    matcher = this.variablePattern.matcher(charSequence);
                    matcher.region(n3, n2);
                    if (matcher.find()) {
                        arrayList.add(new Token(2, matcher.group()));
                    } else {
                        matcher = this.parenthesisPattern.matcher(charSequence);
                        matcher.region(n3, n2);
                        if (!matcher.find()) {
                            throw new ParseException("Unexpected character encountered in expression \"" + charSequence + "\" at column " + n3 + ": " + charSequence.charAt(n3));
                        }
                        arrayList.add(new Token(3, matcher.group()));
                    }
                }
            }
            n3 = matcher.end();
            while (n3 < n2 && charSequence.charAt(n3) <= ' ') {
                ++n3;
            }
        }
        return arrayList.toArray(new Token[arrayList.size()]);
    }
}

