/*
 * Decompiled with CFR 0.152.
 */
package disassembler.dialects;

import assembler.HexStrings;
import disassembler.Section;
import disassembler.SectionProvider;
import disassembler.Symbols;
import disassembler.Z80Disassembler;
import disassembler.dialects.AssemblerDialect;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import util.map.HashIntMap;
import util.map.HashMap;
import util.map.Map;
import util.set.IntHashSet;

public class SjasmMsxDialect
implements AssemblerDialect {
    private static AssemblerDialect instance;

    protected SjasmMsxDialect() {
    }

    public static AssemblerDialect getInstance() {
        if (instance == null) {
            instance = new SjasmMsxDialect();
        }
        return instance;
    }

    @Override
    public void writeHeader(List<Z80Disassembler.SourceLine> list, int[] nArray, boolean bl) {
        this.writePageLayout(list, nArray, bl);
    }

    @Override
    public void writeRAMdefinitions(List<Z80Disassembler.SourceLine> list, Map<List<Symbols.Symbol>> map, SectionProvider sectionProvider, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        this.writeMapSections(list, map, hashMap, hashMap2, hashIntMap, hashIntMap2, string, string2);
    }

    @Override
    public void updateRAMdefinitions(List<Z80Disassembler.SourceLine> list, Map<List<Symbols.Symbol>> map, SectionProvider sectionProvider, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        this.rewriteMapSections(list, map, hashMap, hashMap2, hashIntMap, hashIntMap2, string, string2);
    }

    @Override
    public void writePortDefinitions(List<Z80Disassembler.SourceLine> list, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        SjasmMsxDialect.writePortEqus(list, map, hashMap, string);
    }

    @Override
    public void updatePortDefinitions(List<Z80Disassembler.SourceLine> list, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        SjasmMsxDialect.rewritePortEqus(list, map, hashMap, string);
    }

    @Override
    public void writeStartOfBank(List<Z80Disassembler.SourceLine> list, int n, int n2) {
        if (list.get(list.size() - 1) != Z80Disassembler.SourceLine.EMPTY_LINE) {
            list.add(Z80Disassembler.SourceLine.EMPTY_LINE);
        }
        list.add(new Z80Disassembler.SourceLine("\tcode page " + n));
        list.add(Z80Disassembler.SourceLine.EMPTY_LINE);
    }

    @Override
    public void writeSection(List<Z80Disassembler.SourceLine> list, Section section) {
    }

    @Override
    public char getChildLabelChar() {
        return '\u0000';
    }

    @Override
    public String getDataPrefix(int n) {
        if (n > 4) {
            return "\tds";
        }
        return n == 2 ? "\tdw" : "\tdb";
    }

    @Override
    public String getHighByte(String string) {
        return "high " + string;
    }

    @Override
    public String getLowByte(String string) {
        return "low " + string;
    }

    @Override
    public String getCurrentAddressSymbol() {
        return null;
    }

    @Override
    public boolean requiresDataCommas() {
        return true;
    }

    @Override
    public boolean requiresSquareBrackets() {
        return false;
    }

    @Override
    public boolean requiresAbsoluteAddressesForRelativeBranches() {
        return false;
    }

    @Override
    public boolean supportsAnonymousLabels() {
        return false;
    }

    @Override
    public String getIncBinLine(String string) {
        return string != null ? "\tincbin \"" + string + "\"" : "\tincbin ...";
    }

    protected void writePageLayout(List<Z80Disassembler.SourceLine> list, int[] nArray, boolean bl) {
        list.add(new Z80Disassembler.SourceLine("; You might need to adjust this page layout to reassemble the disassembly to an equal ROM"));
        list.add(new Z80Disassembler.SourceLine("\tdefpage 0, 0x4000, 0x4000"));
        if ((nArray.length - 1) / 16384 + 1 - 1 >= 1) {
            list.add(new Z80Disassembler.SourceLine("\tdefpage 1.." + ((nArray.length - 1) / 16384 + 1 - 1)));
        }
    }

    private void writeMapSections(List<Z80Disassembler.SourceLine> list, Map<List<Symbols.Symbol>> map, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        this.writeMapSections(list, list.size(), map, hashMap, hashMap2, hashIntMap, hashIntMap2, string, string2);
    }

    private void writeMapSections(List<Z80Disassembler.SourceLine> list, int n, Map<List<Symbols.Symbol>> map, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        int n2;
        int n3;
        if (n < 0) {
            return;
        }
        BitSet bitSet = hashMap.keyBitSet();
        BitSet bitSet2 = hashMap2.keyBitSet();
        BitSet bitSet3 = Symbols.getRamSymbolKeys(map);
        ArrayList<Z80Disassembler.SourceLine> arrayList = new ArrayList<Z80Disassembler.SourceLine>(2 * (hashMap.size() + hashMap2.size()));
        boolean bl = true;
        int n4 = 0;
        while (n4 < 65536) {
            Symbols.Symbol symbol;
            Symbols.Symbol symbol2 = symbol = bitSet3.get(0xC000 | n4) ? Symbols.findRAMSymbol(0xC000 | n4, map) : null;
            if (bitSet.get(n4) || symbol != null) {
                if (bl) {
                    arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
                    arrayList.add(new Z80Disassembler.SourceLine("\tmap 0x" + Integer.toHexString(0xC000 | n4)));
                    bl = false;
                }
                if ((n3 = (n2 = Math.min(bitSet.nextSetBit(n4 + 1) & Integer.MAX_VALUE, bitSet3.nextSetBit(n4 + 1) & Integer.MAX_VALUE)) - n4) > 1) {
                    int n5 = hashIntMap.get(n4);
                    n3 = n5 != Integer.MIN_VALUE ? Math.min(n3, n5) : 1;
                }
                String string3 = ": #0x" + Integer.toHexString(n3);
                if (symbol != null) {
                    arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(symbol.getLabel()) + string3 + (symbol.getComment() != null ? "\t" + symbol.getComment() : "")));
                } else {
                    arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(String.format(string, 0xC000 | n4)) + string3));
                }
                n4 += n3 - 1;
            } else {
                bl = true;
                n2 = Math.min(bitSet.nextSetBit(n4) & Integer.MAX_VALUE, bitSet3.nextSetBit(49152 + n4) - 49152 & Integer.MAX_VALUE);
                if (n2 > n4) {
                    n4 = n2 - 1;
                } else {
                    System.err.println("Missing symbol for symbol key at " + Integer.toHexString(n4));
                }
            }
            ++n4;
        }
        n4 = this.getSRAMsize();
        int n6 = n4 - 1;
        n2 = 0;
        while (n2 < this.getNumSRAMbanks()) {
            bl = true;
            n3 = 0;
            while (n3 < n4) {
                int n7 = n2 * n4 | n3 & n6;
                if (bitSet2.get(n7)) {
                    int n8;
                    int n9;
                    if (bl) {
                        arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
                        arrayList.add(new Z80Disassembler.SourceLine("\tmap 0x" + Integer.toHexString(this.getSRAMstart() + n3)));
                        bl = false;
                    }
                    if ((n9 = (n8 = bitSet2.nextSetBit(n7 + 1) & Integer.MAX_VALUE) - n7) > 1) {
                        int n10 = hashIntMap2.get(n7);
                        n9 = n10 != Integer.MIN_VALUE ? Math.min(n9, n10) : 1;
                    }
                    String string4 = ": #0x" + Integer.toHexString(n9);
                    arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(String.format(string2, n7)) + string4));
                    n3 += n9 - 1;
                } else {
                    bl = true;
                    n3 = (bitSet2.nextSetBit(n7) & Integer.MAX_VALUE) - n2 * n4 - 1;
                }
                ++n3;
            }
            ++n2;
        }
        arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
        list.addAll(n, arrayList);
    }

    protected int getNumSRAMbanks() {
        return 1;
    }

    protected int getSRAMsize() {
        return 16384;
    }

    protected int getSRAMstart() {
        return 32768;
    }

    /*
     * Unable to fully structure code
     */
    private static int removeMapSections(List<Z80Disassembler.SourceLine> var0) {
        var1_1 = Z80Disassembler.findBeginningOfDisassembly(var0);
        while (var1_1 < var0.size()) {
            block3: {
                var2_2 = var0.get(var1_1);
                if (!var2_2.toString().startsWith("map")) break block3;
                var3_3 = var1_1 - 1;
                ** GOTO lbl11
                {
                    var2_2 = var0.get(++var1_1);
                    do {
                        if (var2_2 != Z80Disassembler.SourceLine.PORTS_HEAD_COMMENT && !var2_2.toString().startsWith("map")) continue block1;
                        var2_2 = var0.get(++var1_1);
lbl11:
                        // 2 sources

                    } while (var2_2.toString().startsWith("map"));
                }
                var0.subList(var3_3, var1_1).clear();
                return var3_3;
            }
            ++var1_1;
        }
        return -1;
    }

    private void rewriteMapSections(List<Z80Disassembler.SourceLine> list, Map<List<Symbols.Symbol>> map, HashMap<IntHashSet> hashMap, HashMap<IntHashSet> hashMap2, HashIntMap hashIntMap, HashIntMap hashIntMap2, String string, String string2) {
        this.writeMapSections(list, SjasmMsxDialect.removeMapSections(list), map, hashMap, hashMap2, hashIntMap, hashIntMap2, string, string2);
    }

    private static void writePortEqus(List<Z80Disassembler.SourceLine> list, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        SjasmMsxDialect.writePortEqus(list, list.size(), map, hashMap, string);
    }

    private static void writePortEqus(List<Z80Disassembler.SourceLine> list, int n, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        if (n < 0) {
            return;
        }
        ArrayList<Z80Disassembler.SourceLine> arrayList = new ArrayList<Z80Disassembler.SourceLine>(hashMap.size() + 4);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        IntHashSet intHashSet = new IntHashSet();
        IntHashSet intHashSet2 = new IntHashSet();
        for (Map.Entry<IntHashSet> entry : hashMap.entrySet()) {
            int n2 = entry.getKey();
            treeSet.add(n2);
            boolean bl = false;
            boolean bl2 = false;
            if (map.get(n2) != map.get(-n2)) {
                int[] nArray = entry.getValue().keys();
                int n3 = nArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = nArray[n4];
                    if (Z80Disassembler.isPortRead(n2, n5)) {
                        bl = true;
                    } else {
                        bl2 = true;
                    }
                    if (!bl || !bl2) {
                        ++n4;
                        continue;
                    }
                    break;
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                intHashSet2.add(n2);
            }
            if (!bl) continue;
            intHashSet.add(n2);
        }
        if (!treeSet.isEmpty()) {
            arrayList.add(Z80Disassembler.SourceLine.PORTS_HEAD_COMMENT);
            Iterator<Map.Entry<IntHashSet>> iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                int n6 = (Integer)((Object)iterator.next());
                if (!intHashSet2.contains(n6) && intHashSet.contains(n6)) continue;
                String string2 = map.get(n6);
                if (string2 != null) {
                    arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(string2) + " equ " + HexStrings.PREFIXED_HEX_STRINGS[n6]));
                    continue;
                }
                if (intHashSet2.contains(n6)) {
                    arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(String.format(string, n6)) + " equ " + HexStrings.PREFIXED_HEX_STRINGS[n6]));
                    continue;
                }
                arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(String.format(string, n6)) + " equ " + HexStrings.PREFIXED_HEX_STRINGS[n6]));
            }
            if (!intHashSet.isEmpty()) {
                arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
                arrayList.add(new Z80Disassembler.SourceLine("; Input Ports"));
                iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    int n7 = (Integer)((Object)iterator.next());
                    if (!intHashSet.contains(n7)) continue;
                    String string3 = map.get(-n7);
                    if (string3 != null) {
                        arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(string3) + " equ " + HexStrings.PREFIXED_HEX_STRINGS[n7]));
                        continue;
                    }
                    if (intHashSet2.contains(n7)) {
                        arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(String.format(string, n7)) + " equ " + HexStrings.PREFIXED_HEX_STRINGS[n7]));
                        continue;
                    }
                    arrayList.add(new Z80Disassembler.SourceLine(String.valueOf(String.format(string, n7)) + " equ " + HexStrings.PREFIXED_HEX_STRINGS[n7]));
                }
            }
            arrayList.add(Z80Disassembler.SourceLine.EMPTY_LINE);
        }
        list.addAll(n, arrayList);
    }

    private static int removePortEqus(List<Z80Disassembler.SourceLine> list) {
        int n = Z80Disassembler.findBeginningOfDisassembly(list);
        while (n < list.size()) {
            Z80Disassembler.SourceLine sourceLine = list.get(n);
            if (sourceLine == Z80Disassembler.SourceLine.PORTS_HEAD_COMMENT) {
                int n2 = n++;
                sourceLine = list.get(n);
                while (sourceLine.toString().contains(" equ ")) {
                    sourceLine = list.get(++n);
                }
                if ("; Input Ports".equals(list.get(n + 1).toString())) {
                    ++n;
                    sourceLine = list.get(++n);
                    while (sourceLine.toString().startsWith(" equ ")) {
                        sourceLine = list.get(++n);
                    }
                }
                list.subList(n2, ++n).clear();
                return n2;
            }
            if (sourceLine.getAddress() >= 0) {
                while (n > 0 && sourceLine != Z80Disassembler.SourceLine.EMPTY_LINE) {
                    sourceLine = list.get(--n);
                }
                return n + 1;
            }
            ++n;
        }
        return -1;
    }

    private static void rewritePortEqus(List<Z80Disassembler.SourceLine> list, Map<String> map, HashMap<IntHashSet> hashMap, String string) {
        SjasmMsxDialect.writePortEqus(list, SjasmMsxDialect.removePortEqus(list), map, hashMap, string);
    }

    public String toString() {
        return "Sjasm";
    }
}

