/*
 * Decompiled with CFR 0.152.
 */
package dap.messages;

import dap.base.DebugAdapterProtocolMessage;
import dap.messages.Event;
import dap.messages.Request;
import dap.messages.Response;
import json.JSONObject;
import json.JSONParser;

public abstract class ProtocolMessage {
    private final int seq;
    private static int seqCounter;

    protected ProtocolMessage(int n) {
        this.seq = n;
    }

    protected ProtocolMessage(JSONObject jSONObject) {
        this(jSONObject.getInt("seq"));
    }

    protected ProtocolMessage() {
        this(++seqCounter);
    }

    public int getSeq() {
        return this.seq;
    }

    public abstract String getType();

    public static void resetCounter() {
        seqCounter = 0;
    }

    public static ProtocolMessage from(DebugAdapterProtocolMessage debugAdapterProtocolMessage) {
        return ProtocolMessage.from(JSONParser.parse(debugAdapterProtocolMessage.getContent()));
    }

    private static ProtocolMessage from(JSONObject jSONObject) {
        int n = jSONObject.getInt("seq");
        String string = jSONObject.getString("type");
        if ("request".equals(string)) {
            return Request.from(jSONObject);
        }
        if ("event".equals(string)) {
            return Event.from(n, jSONObject);
        }
        if ("respone".equals(string)) {
            return Response.from(n, jSONObject);
        }
        throw new IllegalArgumentException("Unhandled type: " + string);
    }

    public JSONObject toJSON() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("seq", this.getSeq());
        jSONObject.put("type", this.getType());
        return jSONObject;
    }

    public String toString() {
        return this.toJSON().toString();
    }
}

