/*
 * Decompiled with CFR 0.152.
 */
package assembler.gb;

import assembler.Z80Assembler;
import assembler.Z80ParseResult;
import assembler.parsers.ExpressionEvaluator;
import assembler.rgbds.RGBDSParser;
import assembler.wladx.WLAParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import util.string.StringUtilities;

public final class GBParserMultiplexer {
    private GBParserMultiplexer() {
    }

    public static Z80ParseResult readLines(File file, Z80Assembler z80Assembler, ExpressionEvaluator expressionEvaluator) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        int n = 0;
        String string = bufferedReader.readLine();
        while (string != null && n == 0) {
            if (!string.isEmpty() && string.charAt(0) != ';') {
                if (string.charAt(0) == '.') {
                    n = 1;
                } else {
                    int n2 = 0;
                    while (n2 < string.length() && string.charAt(n2) <= ' ') {
                        ++n2;
                    }
                    if (n2 < string.length()) {
                        if (string.charAt(n2) == '.') {
                            n = 1;
                        } else if (StringUtilities.startsWithIgnoreCase(string, "include", n2) || StringUtilities.startsWithIgnoreCase(string, "section", n2)) {
                            n = 2;
                        }
                    }
                }
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        if (n == 2) {
            return RGBDSParser.readLines(file, z80Assembler, expressionEvaluator);
        }
        return WLAParser.readLines(file, z80Assembler, expressionEvaluator);
    }
}

