/*
 * Decompiled with CFR 0.152.
 */
package variables;

import assembler.HexStrings;
import components.cartridge.SMSCartridge;
import components.sound.SN76489;
import components.sound.YM2413;
import components.video.TMS9918A;
import java.util.LinkedHashMap;
import java.util.Map;
import system.GameGear;
import system.MasterSystem;
import variables.AbstractVariable;
import variables.AbstractVariables;
import variables.Variable;

public final class MasterSystemVariables
extends AbstractVariables {
    private static final String[] VDP_REGISTER_NAMES = new String[]{"Mode Control No. 1", "Mode Control No. 2", "Name Table Base Address", "Color Table Base Address", "Pattern Generator Table Base Address", "Sprite Attribute Table Base Address", "Sprite Pattern Generator Table Base Address", "Overscan/Backdrop Color", "Background X Scroll", "Background Y Scroll", "Line counter"};

    protected MasterSystemVariables(MasterSystem masterSystem) {
        super(MasterSystemVariables.createVariables(masterSystem));
    }

    private static Map<String, Variable[]> createVariables(MasterSystem masterSystem) {
        LinkedHashMap<String, Variable[]> linkedHashMap = new LinkedHashMap<String, Variable[]>();
        linkedHashMap.put(masterSystem instanceof GameGear ? "Game Gear" : "Master System", MasterSystemVariables.createSystemVariables(masterSystem));
        linkedHashMap.put("VDP", MasterSystemVariables.createVDPVariables(masterSystem));
        linkedHashMap.put("PSG", MasterSystemVariables.createPSGVariables(masterSystem));
        linkedHashMap.put("Cartridge", MasterSystemVariables.createCartridgeVariables(masterSystem));
        if (masterSystem.hasFM()) {
            linkedHashMap.put("FM", MasterSystemVariables.createFMVariables(masterSystem));
        }
        return linkedHashMap;
    }

    private static Variable[] createVDPVariables(MasterSystem masterSystem) {
        final TMS9918A.State state = masterSystem.getState().getVDPstate();
        final Variable[] variableArray = MasterSystemVariables.createVDPRegisterVariables(state, masterSystem);
        final String string = "[" + VDP_REGISTER_NAMES.length + "]";
        return new Variable[]{new AbstractVariable("Scanline"){

            @Override
            public String getValue() {
                return Integer.toString(state.getLine());
            }
        }, new AbstractVariable("VDP Address"){

            @Override
            public String getValue() {
                return String.format("$%04X", state.getRegAddress());
            }
        }, new AbstractVariable("VDP Registers"){

            @Override
            public String getValue() {
                return string;
            }

            @Override
            public Variable[] getVariables() {
                return variableArray;
            }
        }};
    }

    private static Variable[] createVDPRegisterVariables(TMS9918A.State state, MasterSystem masterSystem) {
        Variable[] variableArray = new Variable[VDP_REGISTER_NAMES.length];
        int n = 0;
        while (n < variableArray.length) {
            variableArray[n] = MasterSystemVariables.createVDPRegisterVariable(state, n, masterSystem);
            ++n;
        }
        return variableArray;
    }

    private static Variable createVDPRegisterVariable(final TMS9918A.State state, final int n, final MasterSystem masterSystem) {
        Variable[] variableArray;
        String[][] stringArrayArray = new String[][]{{"Sync enable", "Extra height enable/TMS9918 mode select", "Mode 4 enable", "Shift sprites left 8 pixels", "Enable line interrupts", "Hide leftmost 8 pixels", "Horizontal scroll lock", "Vertical scroll lock"}, {"Doubled (stretched) sprites", "Large (tiled) sprites", "Unused", "240-line mode/TMS9918 mode select", "224-line mode/TMS9918 mode select", "Enable frame interrupts", "Enable display"}};
        if (n < stringArrayArray.length) {
            variableArray = new Variable[stringArrayArray[n].length];
            int n2 = 0;
            while (n2 < variableArray.length) {
                final int n3 = variableArray.length - 1 - n2;
                variableArray[n2] = new AbstractVariable("Bit " + n3 + " - " + stringArrayArray[n][n3]){

                    @Override
                    public String getValue() {
                        return Integer.toString(state.getReg(n) >> n3 & 1);
                    }
                };
                ++n2;
            }
        } else {
            variableArray = Variable.NO_VARIABLES;
        }
        return new AbstractVariable(String.format("[$%02X] - %s", n, VDP_REGISTER_NAMES[n])){

            @Override
            public String getValue() {
                return String.format("$%02X", state.getReg(n));
            }

            @Override
            public String getDisplayValue() {
                int n2 = MasterSystemVariables.toVDPaddress(masterSystem, n);
                return n2 >= 0 ? String.format("$%02X ($%04X)", state.getReg(n), n2) : String.format("$%02X", state.getReg(n));
            }

            @Override
            public boolean isEditable() {
                return true;
            }

            @Override
            public void setValue(String string) {
                try {
                    int n2 = Integer.parseInt(string.replaceAll("[^0-9A-Fa-f]", ""), 16);
                    masterSystem.setVdpReg(n, n2);
                }
                catch (Exception exception) {}
            }

            @Override
            public Variable[] getVariables() {
                return variableArray;
            }
        };
    }

    static int toVDPaddress(MasterSystem masterSystem, int n) {
        switch (n) {
            case 2: {
                return masterSystem.getScreenMapBaseAddress();
            }
            case 3: {
                return masterSystem.getColorTableAddress();
            }
            case 4: {
                return masterSystem.getPatternGeneratorTableAddress();
            }
            case 5: {
                return masterSystem.getSpriteAttributeTableAddress();
            }
            case 6: {
                return masterSystem.getSpritePatternAddress();
            }
        }
        return -1;
    }

    private static Variable[] createPSGVariables(final MasterSystem masterSystem) {
        final SN76489.State state = masterSystem.getState().getPSGstate();
        Variable[] variableArray = new Variable[8];
        int n = 0;
        while (n < variableArray.length) {
            final int n2 = n;
            variableArray[n] = new AbstractVariable(MasterSystemVariables.getPSGRegisterName(n2)){

                @Override
                public String getValue() {
                    if (n2 == 6) {
                        return String.format("$%02X", state.getRegNoise());
                    }
                    return (n2 & 1) == 0 ? String.format("$%04X", state.getRegTone(n2 / 2)) : Integer.toString(state.getRegVolume(n2 / 2));
                }

                @Override
                public boolean isEditable() {
                    return true;
                }

                @Override
                public void setValue(String string) {
                    try {
                        int n = Integer.parseInt(string.replaceAll("[^0-9A-Fa-f]", ""), 16);
                        masterSystem.setPsgReg(n2, n);
                    }
                    catch (Exception exception) {}
                }
            };
            ++n;
        }
        return variableArray;
    }

    private static String getPSGRegisterName(int n) {
        if (n >= 6) {
            return (n & 1) == 0 ? "Noise Channel" : "Noise Channel Volume";
        }
        return "Square Wave Channel " + (n / 2 + 1) + ((n & 1) == 0 ? " Frequency" : " Volume");
    }

    private static Variable[] createCartridgeVariables(final MasterSystem masterSystem) {
        final SMSCartridge.State state = masterSystem.getState().getCartridgeState();
        Variable[] variableArray = new Variable[masterSystem.hasSRAM() ? 6 : 4];
        variableArray[0] = new AbstractVariable("Mapper"){

            @Override
            public String getValue() {
                return masterSystem.getMapperName();
            }
        };
        variableArray[1] = new AbstractVariable("ROM Bank 0"){

            @Override
            public String getValue() {
                return HexStrings.PREFIXED_HEX_STRINGS[state.getFrame0ROMPageNumber() & 0xFF].substring(1);
            }
        };
        variableArray[2] = new AbstractVariable("ROM Bank 1"){

            @Override
            public String getValue() {
                return HexStrings.PREFIXED_HEX_STRINGS[state.getFrame1ROMPageNumber() & 0xFF].substring(1);
            }
        };
        variableArray[3] = new AbstractVariable("ROM Bank 2"){

            @Override
            public String getValue() {
                return HexStrings.PREFIXED_HEX_STRINGS[state.getFrame2ROMPageNumber() & 0xFF].substring(1);
            }
        };
        if (masterSystem.hasSRAM()) {
            variableArray[4] = new AbstractVariable("SRAM"){

                @Override
                public String getValue() {
                    return 11.toEnabledString(masterSystem.isSRAMenabled());
                }
            };
            variableArray[5] = new AbstractVariable("SRAM Bank"){

                @Override
                public String getValue() {
                    return HexStrings.PREFIXED_HEX_STRINGS[state.getRamPageNumber() & 0xFF].substring(1);
                }
            };
        }
        return variableArray;
    }

    private static Variable[] createFMVariables(final MasterSystem masterSystem) {
        final YM2413.State state = masterSystem.getState().getFMstate();
        Variable[] variableArray = new Variable[64];
        int n = 0;
        while (n < variableArray.length) {
            final int n2 = n;
            variableArray[n] = new AbstractVariable("[" + n2 + "]"){

                @Override
                public String getValue() {
                    return String.format("$%02X", state.getReg(n2));
                }

                @Override
                public boolean isEditable() {
                    return true;
                }

                @Override
                public void setValue(String string) {
                    try {
                        int n = Integer.parseInt(string.replaceAll("[^0-9A-Fa-f]", ""), 16);
                        masterSystem.setFmReg(n2, n);
                    }
                    catch (Exception exception) {}
                }
            };
            ++n;
        }
        return variableArray;
    }

    private static Variable createInputVariable(final MasterSystem masterSystem) {
        boolean bl = masterSystem instanceof GameGear && !((GameGear)masterSystem).isSmsMode();
        final Variable[] variableArray = new Variable[bl ? 3 : 4];
        variableArray[0] = MasterSystemVariables.createInputPortVariable(masterSystem, 0);
        variableArray[1] = MasterSystemVariables.createInputPortVariable(masterSystem, 1);
        if (bl) {
            variableArray[2] = new AbstractVariable("Start", "Boolean"){

                @Override
                public String getValue() {
                    return Boolean.toString(masterSystem.isButtonDown(2, 2));
                }

                @Override
                public boolean isEditable() {
                    return true;
                }

                @Override
                public void setValue(String string) {
                    masterSystem.setButtonDownOverride(2, 2, Boolean.parseBoolean(string));
                }
            };
        } else {
            variableArray[2] = new AbstractVariable("Pause", "Boolean"){

                @Override
                public String getValue() {
                    return Boolean.toString(masterSystem.isButtonDown(2, 0));
                }

                @Override
                public boolean isEditable() {
                    return true;
                }

                @Override
                public void setValue(String string) {
                    masterSystem.setButtonDownOverride(2, 0, Boolean.parseBoolean(string));
                }
            };
            variableArray[3] = new AbstractVariable("Reset", "Boolean"){

                @Override
                public String getValue() {
                    return Boolean.toString(masterSystem.isButtonDown(2, 1));
                }

                @Override
                public boolean isEditable() {
                    return true;
                }

                @Override
                public void setValue(String string) {
                    masterSystem.setButtonDownOverride(2, 1, Boolean.parseBoolean(string));
                }
            };
        }
        return new AbstractVariable("Input"){

            @Override
            public String getValue() {
                return null;
            }

            @Override
            public Variable[] getVariables() {
                return variableArray;
            }
        };
    }

    private static Variable createInputPortVariable(final MasterSystem masterSystem, final int n) {
        return new AbstractVariable("Player " + (char)(65 + n)){
            private Variable[] variables;
            {
                super(string);
                this.variables = new Variable[0];
            }

            @Override
            public String getValue() {
                return masterSystem.getInputDeviceName(n);
            }

            @Override
            public Variable[] getVariables() {
                String[] stringArray = masterSystem.getButtonNames(n);
                if (this.variables.length != stringArray.length) {
                    Variable[] variableArray = new Variable[stringArray.length];
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        final int n2 = n3++;
                        variableArray[n2] = new AbstractVariable(String.format("%-7s", stringArray[n2]), "Boolean"){

                            @Override
                            public String getValue() {
                                return Boolean.toString(masterSystem.isButtonDown(n, n2));
                            }

                            @Override
                            public boolean isEditable() {
                                return true;
                            }

                            @Override
                            public void setValue(String string) {
                                masterSystem.setButtonDownOverride(n, n2, Boolean.parseBoolean(string));
                            }
                        };
                    }
                    this.variables = variableArray;
                }
                return this.variables;
            }
        };
    }

    private static Variable[] createSystemVariables(MasterSystem masterSystem) {
        final MasterSystem.State state = masterSystem.getState();
        return new Variable[]{MasterSystemVariables.createInputVariable(masterSystem), new AbstractVariable("Enabled Slots"){

            @Override
            public String getValue() {
                String string = "";
                if (state.isBiosEnabled()) {
                    string = String.valueOf(string) + "BIOS ";
                }
                if (state.isCardEnabled()) {
                    string = String.valueOf(string) + "Card ";
                }
                if (state.isCartridgeEnabled()) {
                    string = String.valueOf(string) + "Cartridge ";
                }
                return string;
            }
        }, new AbstractVariable("RAM"){

            @Override
            public String getValue() {
                return 20.toEnabledString(state.isRamEnabled());
            }
        }, new AbstractVariable("IO"){

            @Override
            public String getValue() {
                return 21.toEnabledString(state.isIoEnabled());
            }
        }, new AbstractVariable("PSG"){

            @Override
            public String getValue() {
                return 22.toEnabledString(state.isPsgEnabled());
            }
        }, new AbstractVariable("FM"){

            @Override
            public String getValue() {
                return 23.toEnabledString(state.isFmEnabled());
            }
        }};
    }
}

