/*
 * Decompiled with CFR 0.152.
 */
package util.deque;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import util.IntIterator;
import util.deque.IntDeque;

public class ArrayIntDeque
implements IntDeque {
    int[] elements;
    int head;
    int tail;
    int mask;

    public ArrayIntDeque() {
        this.elements = new int[16];
        this.mask = this.elements.length - 1;
    }

    public ArrayIntDeque(int n) {
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        if (++n < 0) {
            n >>>= 1;
        }
        this.elements = new int[n];
        this.mask = this.elements.length - 1;
    }

    private void doubleCapacity() {
        if (this.head != this.tail) {
            throw new IllegalStateException();
        }
        int n = this.elements.length << 1;
        if (n < 0) {
            throw new IllegalStateException();
        }
        int[] nArray = new int[n];
        System.arraycopy(this.elements, this.head, nArray, 0, this.elements.length - this.head);
        System.arraycopy(this.elements, 0, nArray, this.elements.length - this.head, this.head);
        this.tail = this.elements.length;
        this.head = 0;
        this.elements = nArray;
        this.mask = this.elements.length - 1;
    }

    @Override
    public void addFirst(int n) {
        this.head = this.head - 1 & this.mask;
        this.elements[this.head] = n;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    @Override
    public void addLast(int n) {
        this.elements[this.tail] = n;
        this.tail = this.tail + 1 & this.mask;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    @Override
    public int removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int n = this.elements[this.head];
        this.head = this.head + 1 & this.mask;
        return n;
    }

    @Override
    public int removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.tail = this.tail - 1 & this.mask;
        return this.elements[this.tail];
    }

    @Override
    public int getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements[this.head];
    }

    @Override
    public int getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements[this.tail - 1 & this.mask];
    }

    @Override
    public int peek() {
        return this.elements[this.head];
    }

    @Override
    public boolean removeFirstOccurrence(int n) {
        int n2 = this.indexOf(n);
        if (n2 < 0) {
            return false;
        }
        this.delete(n2);
        return true;
    }

    @Override
    public boolean removeLastOccurrence(int n) {
        int n2 = this.lastIndexOf(n);
        if (n2 < 0) {
            return false;
        }
        this.delete(n2);
        return true;
    }

    @Override
    public boolean add(int n) {
        this.addLast(n);
        return true;
    }

    @Override
    public int remove() {
        return this.removeFirst();
    }

    @Override
    public int element() {
        return this.getFirst();
    }

    @Override
    public void push(int n) {
        this.addFirst(n);
    }

    @Override
    public int pop() {
        return this.removeFirst();
    }

    boolean delete(int n) {
        int n2 = this.head;
        int[] nArray = this.elements;
        int n3 = nArray.length - 1;
        int n4 = n - n2 & n3;
        int n5 = this.tail;
        int n6 = n5 - n & n3;
        if (n4 < n6) {
            if (n2 <= n) {
                System.arraycopy(nArray, n2, nArray, n2 + 1, n4);
            } else {
                System.arraycopy(nArray, 0, nArray, 1, n);
                nArray[0] = nArray[n3];
                System.arraycopy(nArray, n2, nArray, n2 + 1, n3 - n2);
            }
            this.head = n2 + 1 & n3;
            return false;
        }
        if (n < n5) {
            System.arraycopy(nArray, n + 1, nArray, n, n6);
        } else {
            System.arraycopy(nArray, n + 1, nArray, n, n3 - n);
            nArray[n3] = nArray[0];
            System.arraycopy(nArray, 1, nArray, 0, n5);
        }
        this.tail = n5 - 1 & n3;
        return true;
    }

    @Override
    public void pushAll(IntDeque intDeque) {
        if (!(intDeque instanceof ArrayIntDeque)) {
            throw new UnsupportedOperationException();
        }
        this.pushAll((ArrayIntDeque)intDeque);
    }

    private void pushAll(ArrayIntDeque arrayIntDeque) {
        int n = this.size();
        int n2 = arrayIntDeque.size();
        int n3 = n + n2;
        int n4 = this.elements.length;
        while (n4 > 0 && n4 <= n3) {
            n4 <<= 1;
        }
        if (n4 < 0) {
            throw new IllegalStateException();
        }
        int[] nArray = new int[n4];
        System.arraycopy(this.elements, this.head, nArray, 0, this.elements.length - this.head);
        System.arraycopy(this.elements, 0, nArray, this.elements.length - this.head, this.head);
        if (arrayIntDeque.tail < arrayIntDeque.head) {
            System.arraycopy(arrayIntDeque.elements, arrayIntDeque.head, nArray, nArray.length - n2, arrayIntDeque.elements.length - arrayIntDeque.head);
            System.arraycopy(arrayIntDeque.elements, 0, nArray, nArray.length - arrayIntDeque.tail, arrayIntDeque.tail);
        } else {
            System.arraycopy(arrayIntDeque.elements, arrayIntDeque.head, nArray, nArray.length - n2, n2);
        }
        this.elements = nArray;
        this.mask = this.elements.length - 1;
        this.head = -n2 & this.mask;
        this.tail = n;
    }

    @Override
    public boolean remove(int n) {
        return this.removeFirstOccurrence(n);
    }

    private int lastIndexOf(int n) {
        int n2 = this.tail - 1 & this.mask;
        while (n2 != this.head) {
            if (this.elements[n2] == n) {
                return n2;
            }
            n2 = n2 - 1 & this.mask;
        }
        return -1;
    }

    private int indexOf(int n) {
        int n2 = this.head;
        while (n2 != this.tail) {
            if (this.elements[n2] == n) {
                return n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        return -1;
    }

    @Override
    public boolean contains(int n) {
        return this.indexOf(n) >= 0;
    }

    @Override
    public void clear() {
        this.tail = 0;
        this.head = 0;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.mask;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public IntIterator intIterator() {
        return new IntIterator(){
            private int cursor;
            private int fence;
            private int lastRet;
            {
                this.cursor = ArrayIntDeque.this.head;
                this.fence = ArrayIntDeque.this.tail;
                this.lastRet = -1;
            }

            @Override
            public int next() {
                if (this.cursor == this.fence) {
                    throw new NoSuchElementException();
                }
                if (this.fence != ArrayIntDeque.this.tail) {
                    throw new ConcurrentModificationException();
                }
                this.lastRet = this.cursor;
                int n = ArrayIntDeque.this.elements[this.lastRet];
                this.cursor = this.cursor + 1 & ArrayIntDeque.this.mask;
                return n;
            }

            @Override
            public boolean hasNext() {
                return this.cursor != this.fence;
            }

            @Override
            public void remove() {
                if (this.lastRet < 0) {
                    throw new IllegalStateException();
                }
                if (ArrayIntDeque.this.delete(this.lastRet)) {
                    this.cursor = this.cursor - 1 & ArrayIntDeque.this.mask;
                    this.fence = ArrayIntDeque.this.tail;
                }
                this.lastRet = -1;
            }
        };
    }

    public String toString() {
        IntIterator intIterator = this.intIterator();
        if (!intIterator.hasNext()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(n);
        }
        return stringBuilder.append(']').toString();
    }
}

