/*
 * Decompiled with CFR 0.152.
 */
package platform;

import components.cartridge.SMSCartridge;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class StdioSMSCartridge
extends SMSCartridge {
    private static final String[] HEX_STRINGS = new String[65536];
    private static final String[] HEX_STRINGS2 = new String[256];
    private final Process process;
    private final PrintStream out;
    private final InputStream in;

    static {
        int n = 0;
        while (n < HEX_STRINGS.length) {
            StdioSMSCartridge.HEX_STRINGS[n] = String.format("%04X", n);
            ++n;
        }
        n = 0;
        while (n < HEX_STRINGS2.length) {
            StdioSMSCartridge.HEX_STRINGS2[n] = HEX_STRINGS[n].substring(2);
            ++n;
        }
    }

    public StdioSMSCartridge(final Process process) {
        super(new int[0]);
        this.process = process;
        this.out = new PrintStream(process.getOutputStream(), true);
        this.in = process.getInputStream();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        System.err.println(string);
                        string = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }, "SMSCartridgeProcess stderr reader").start();
    }

    @Override
    public void reset() {
        if (this.out != null) {
            this.out.print("t ");
            try {
                int n = this.read3Bytes();
                if (this.rom.length != n) {
                    this.rom = new int[n];
                    int n2 = 0;
                    while (n2 < n) {
                        this.rom[n2] = this.recvByteAbsolute(n2);
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public int mapAddress(int n) {
        this.out.print("m " + HEX_STRINGS[n]);
        try {
            return this.read3Bytes();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 255;
        }
    }

    @Override
    public int readByte(int n, int n2) {
        this.out.print("r " + HEX_STRINGS[n]);
        try {
            return this.readByte();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 255;
        }
    }

    @Override
    public void processWrite(int n, int n2, int n3) {
        this.out.print("w " + HEX_STRINGS[n] + " " + HEX_STRINGS2[n2]);
        try {
            this.readAck();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int recvByteAbsolute(int n) throws IOException {
        this.out.print("R " + HEX_STRINGS[n >> 8] + HEX_STRINGS2[n & 0xFF]);
        return this.readByte();
    }

    private void readAck() throws IOException {
        this.in.read();
    }

    private int readByte() throws IOException {
        return Integer.parseInt(String.valueOf(Character.toString((char)this.in.read())) + (char)this.in.read(), 16);
    }

    private int read3Bytes() throws IOException {
        return Integer.parseInt(String.valueOf(Character.toString((char)this.in.read())) + (char)this.in.read() + (char)this.in.read() + (char)this.in.read() + (char)this.in.read() + (char)this.in.read(), 16);
    }

    @Override
    public void shutdown() {
        this.out.print("x ");
        this.process.destroy();
    }
}

