/*
 * Decompiled with CFR 0.152.
 */
package platform;

import assembler.Z80Instruction;
import components.OutputListener;
import components.cartridge.Cartridge;
import components.cartridge.GBCartridge;
import components.cartridge.MSXCartridge;
import components.cartridge.SMSCartridge;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import platform.DebuggableSystemDecorator;
import platform.Emulicious;
import platform.GBMemoryTracer;
import platform.MSXMemoryTracer;
import platform.MemoryTracerWindow;
import platform.SMSMemoryTracer;
import system.DebuggableSystem;
import system.EmulatableSystem;
import system.GameBoy;
import system.MSX;
import system.MasterSystem;

public abstract class MemoryTracer
extends DebuggableSystemDecorator {
    protected static final int SOURCE_RAM_FLAG = 0x1000000;
    protected static final int SOURCE_ROM_FLAG = 0x2000000;
    protected static final int SOURCE_VRAM_FLAG = 0x4000000;
    protected static final int SOURCE_SRAM_FLAG = 0x8000000;
    protected static final int SOURCE_MASK = 0xFFFFFF;
    protected static final int DATA_TYPE_PALETTE = 1;
    protected static final int DATA_TYPE_TILE = 2;
    protected static final int DATA_TYPE_TILEMAP = 3;
    protected static final int DATA_TYPE_SPRITE = 4;
    protected static final int DATA_TYPE_SOUND = 16;
    private static final int TRACE_LENGTH = 50;
    private static LinkedList<OutputListener> listenerList = new LinkedList();
    private static OutputListener[] listeners = new OutputListener[0];
    protected final Cartridge cartridge;
    protected final long[] ramSources;
    protected long[] sramSources = new long[0];
    protected final long[] colorSources;
    protected final long[] vramSources;
    protected int[] dataTypes;
    protected final int[] ramDataTypes;
    protected int[] sramDataTypes = new int[0];
    protected final int[][] regSources = new int[this.getRegisterNames().length * 2][];
    protected LinkedList<int[]> trace = new LinkedList();
    protected LinkedList<int[]> exTrace;
    protected int prevPrevPC;
    protected static boolean enabled;
    private static boolean displayFileOffsetsForROM;
    protected static MemoryTracer instance;

    public MemoryTracer(DebuggableSystem debuggableSystem, Cartridge cartridge) {
        super(debuggableSystem);
        this.ramSources = new long[debuggableSystem.getRAM().length];
        this.ramDataTypes = new int[this.ramSources.length];
        this.vramSources = new long[debuggableSystem.getVRAM().length];
        this.colorSources = new long[debuggableSystem.getNumberOfPaletteEntries()];
        this.cartridge = cartridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearTrace() {
        boolean bl = enabled;
        enabled = false;
        this.prevPrevPC = -1;
        LinkedList<int[]> linkedList = this.trace;
        synchronized (linkedList) {
            this.trace.clear();
            int n = 0;
            while (n < 50) {
                this.trace.add(null);
                ++n;
            }
        }
        enabled = bl;
    }

    protected abstract boolean shouldTrace(Z80Instruction var1);

    private void updateTrace() {
        int n = this.toMappedAddress(this.getPC() - 1);
        Z80Instruction z80Instruction = this.disassemble(n);
        if (this.shouldTrace(z80Instruction)) {
            this.updateTrace(n, z80Instruction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTrace(int n, Z80Instruction z80Instruction) {
        LinkedList<int[]> linkedList = this.trace;
        synchronized (linkedList) {
            this.trace.removeLast();
            int[] nArray = this.getRegValues();
            int n2 = this.getIndexOfPC();
            nArray[n2] = nArray[n2] - 1;
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = this.toMappedAddress(nArray[n3]);
                ++n3;
            }
            this.trace.addFirst(nArray);
        }
    }

    protected abstract int getIndexOfPC();

    protected int toMappedAddress(int n) {
        if (this.isROMaddress(n)) {
            return 0x2000000 | this.mapAddress(n);
        }
        if (this.isSRAMaddress(n)) {
            return 0x8000000 | this.mapAddress(n);
        }
        if (this.isRAMaddress(n)) {
            return 0x1000000 | this.mapAddress(n);
        }
        if (this.isVRAMaddress(n)) {
            return 0x4000000 | this.mapAddress(n);
        }
        return n;
    }

    protected String locationToString(int n) {
        int n2 = n & 0xFF000000;
        switch (n2) {
            case 0x1000000: {
                return "RAM";
            }
            case 0x2000000: {
                return "ROM";
            }
            case 0x8000000: {
                return "SRAM";
            }
            case 0x4000000: {
                return "VRAM";
            }
        }
        return "CPU";
    }

    protected String addressToString(int n) {
        int n2 = n & 0xFF000000;
        n &= 0xFFFFFF;
        switch (n2) {
            case 0x1000000: {
                return this.ramAddressToString(n);
            }
            case 0x2000000: {
                return displayFileOffsetsForROM ? "$" + Integer.toHexString(n).toUpperCase() : this.romAddressToString(n);
            }
            case 0x8000000: {
                return this.sramAddressToString(n);
            }
            case 0x4000000: {
                return this.vramAddressToString(n);
            }
        }
        return this.cpuAddressToString(n).trim();
    }

    protected abstract void setListenersEnabled(boolean var1);

    protected abstract long traceMemory();

    protected abstract Z80Instruction disassemble(int var1);

    protected int getPrevMappedPC() {
        return this.toMappedAddress(this.getPrevPC());
    }

    protected int getPrevOpcode() {
        Z80Instruction z80Instruction = this.disassemble(this.getPrevMappedPC());
        if (z80Instruction != null) {
            return z80Instruction.getOpCode();
        }
        return -1;
    }

    protected void updateDataTypes(int[] nArray, int n) {
        long l;
        this.updateDataType(nArray, n);
        if ((nArray[1] & 0x8000000) != 0) {
            long l2 = MemoryTracer.getSRAMsource(nArray[1] & 0xFFFFFF);
            if ((int)l2 != 0 && (int)l2 != 1 && (int)l2 != 2) {
                nArray[0] = (int)(l2 >> 32);
                nArray[1] = (int)l2;
                this.updateDataType(nArray, n);
            }
        } else if ((nArray[1] & 0x1000000) != 0 && (int)(l = this.ramSources[nArray[1] & 0xFFFFFF]) != 0 && (int)l != 1 && (int)l != 2) {
            nArray[0] = (int)(l >> 32);
            nArray[1] = (int)l;
            this.updateDataType(nArray, n);
        }
    }

    private void updateDataType(int[] nArray, int n) {
        int n2 = nArray[0];
        if ((nArray[1] & 0x2000000) != 0) {
            this.dataTypes[nArray[1] & 0xFFFFFF] = (n2 & 0xFFFFFF) << 8 | n;
        } else if ((nArray[1] & 0x8000000) != 0) {
            if ((nArray[1] & 0xFFFFFF) < this.sramDataTypes.length) {
                this.sramDataTypes[nArray[1] & 0xFFFFFF] = (n2 & 0xFFFFFF) << 8 | n;
            }
        } else if ((nArray[1] & 0x1000000) != 0) {
            this.ramDataTypes[nArray[1] & 0xFFFFFF] = (n2 & 0xFFFFFF) << 8 | n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readByte(int n, int n2) {
        try {
            if (this.prevPrevPC != this.getPrevPC()) {
                if (this.exTrace != null) {
                    Z80Instruction z80Instruction = this.disassemble(this.toMappedAddress(n));
                    if (z80Instruction != null && (z80Instruction.getOpCode() == 251 || (z80Instruction.getOpCode() & 0xFFC7) == 60741)) {
                        LinkedList<int[]> linkedList = this.trace;
                        synchronized (linkedList) {
                            this.trace = this.exTrace;
                            this.exTrace = null;
                        }
                    }
                } else if (this.isInterruptAddress(n)) {
                    LinkedList<int[]> linkedList = this.trace;
                    synchronized (linkedList) {
                        this.exTrace = this.trace;
                        this.trace = new LinkedList();
                    }
                    this.clearTrace();
                }
                this.updateTrace();
            }
            this.prevPrevPC = this.getPrevPC();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.clearTrace();
        }
        return super.readByte(n, n2);
    }

    @Override
    public void writeByte(int n, int n2, int n3) {
        if (!this.isROMaddress(n)) {
            int n4 = super.peekByte(n);
            super.writeByte(n, n2, n3);
            if (!this.isCartridgeEnabled()) {
                return;
            }
            this.handleWriteByte(n, n2, n4);
        } else {
            super.writeByte(n, n2, n3);
        }
    }

    protected void handleWriteByte(int n, int n2, int n3) {
        try {
            if (this.isRAMaddress(n)) {
                long l;
                n = this.mapAddress(n);
                if (n2 != n3) {
                    this.ramDataTypes[n] = 0;
                }
                if ((l = this.traceMemory()) >= 0L && this.ramSources[n] != l) {
                    this.ramSources[n] = l;
                    MemoryTracer.fireOutputAvailable(0, n);
                }
            } else if (this.isSRAMaddress(n)) {
                long l;
                if (this.sramSources.length != this.getSRAM().length) {
                    this.sramSources = Arrays.copyOf(this.sramSources, this.getSRAM().length);
                    this.sramDataTypes = Arrays.copyOf(this.sramDataTypes, this.getSRAM().length);
                }
                n = this.mapAddress(n);
                if (n2 != n3) {
                    this.sramDataTypes[n] = 0;
                }
                if ((l = this.traceMemory()) >= 0L && this.sramSources[n] != l) {
                    this.sramSources[n] = l;
                    MemoryTracer.fireOutputAvailable(0, n);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.clearTrace();
        }
    }

    @Override
    public void setState(EmulatableSystem.State state, boolean bl, boolean bl2) {
        if (instance != null) {
            instance.setListenersEnabled(false);
        }
        super.setState(state, bl, bl2);
        instance.setListenersEnabled(enabled);
        this.clearTrace();
    }

    public static void create(EmulatableSystem emulatableSystem, Cartridge cartridge) {
        if (emulatableSystem instanceof MasterSystem) {
            MemoryTracer.create((MasterSystem)emulatableSystem, (SMSCartridge)cartridge);
        } else if (emulatableSystem instanceof GameBoy) {
            MemoryTracer.create((GameBoy)emulatableSystem, (GBCartridge)cartridge);
        } else if (emulatableSystem instanceof MSX) {
            MemoryTracer.create((MSX)emulatableSystem, (MSXCartridge)cartridge);
        }
    }

    private static void create(MSX mSX, MSXCartridge mSXCartridge) {
        if (instance != null) {
            instance.setListenersEnabled(false);
        }
        instance = new MSXMemoryTracer(mSX, mSXCartridge);
        instance.setListenersEnabled(true);
        MemoryTracerWindow.systemUpdated();
    }

    private static void create(MasterSystem masterSystem, SMSCartridge sMSCartridge) {
        if (instance != null) {
            instance.setListenersEnabled(false);
        }
        instance = new SMSMemoryTracer(masterSystem, sMSCartridge);
        instance.setListenersEnabled(enabled);
        MemoryTracerWindow.systemUpdated();
    }

    private static void create(GameBoy gameBoy, GBCartridge gBCartridge) {
        if (instance != null) {
            instance.setListenersEnabled(false);
        }
        instance = new GBMemoryTracer(gameBoy, gBCartridge);
        instance.setListenersEnabled(enabled);
        MemoryTracerWindow.systemUpdated();
    }

    public static void setDisplayFileOffsetsForROM(boolean bl) {
        displayFileOffsetsForROM = bl;
    }

    public static void setEnabled(boolean bl) {
        enabled = bl;
        if (instance != null) {
            instance.setListenersEnabled(bl);
        }
        Emulicious.setMemoryTracerEnabled(instance, bl);
        if (bl && instance != null) {
            if (MemoryTracer.instance.dataTypes == null) {
                MemoryTracer.instance.dataTypes = new int[MemoryTracer.instance.cartridge.getRom().length];
            }
            instance.clearTrace();
        }
    }

    public static void destroy() {
        MemoryTracer.setEnabled(false);
        instance = null;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    private static int getDataType(int n) {
        if (!MemoryTracer.isEnabled() || n < 0 || n >= MemoryTracer.instance.dataTypes.length) {
            return 0;
        }
        return MemoryTracer.instance.dataTypes[n] & 0xFF;
    }

    public static boolean hasDataType(int n) {
        return MemoryTracer.getDataType(n) > 0;
    }

    public static boolean isPaletteData(int n) {
        return MemoryTracer.getDataType(n) == 1;
    }

    public static boolean isTileData(int n) {
        return MemoryTracer.getDataType(n) == 2;
    }

    public static boolean isTilemapData(int n) {
        return MemoryTracer.getDataType(n) == 3;
    }

    public static boolean isSpriteData(int n) {
        return MemoryTracer.getDataType(n) == 4;
    }

    public static boolean isSoundData(int n) {
        return MemoryTracer.getDataType(n) == 16;
    }

    public static boolean isPaletteDataInRAM(int n) {
        return MemoryTracer.isEnabled() && (MemoryTracer.instance.ramDataTypes[n] & 0xFF) == 1;
    }

    public static boolean isTileDataInRAM(int n) {
        return MemoryTracer.isEnabled() && (MemoryTracer.instance.ramDataTypes[n] & 0xFF) == 2;
    }

    public static boolean isTilemapDataInRAM(int n) {
        return MemoryTracer.isEnabled() && (MemoryTracer.instance.ramDataTypes[n] & 0xFF) == 3;
    }

    public static boolean isSpriteDataInRAM(int n) {
        return MemoryTracer.isEnabled() && (MemoryTracer.instance.ramDataTypes[n] & 0xFF) == 4;
    }

    public static boolean isSoundDataInRAM(int n) {
        return MemoryTracer.isEnabled() && (MemoryTracer.instance.ramDataTypes[n] & 0xFF) == 16;
    }

    public static boolean isPaletteDataInSRAM(int n) {
        return MemoryTracer.isEnabled() && n < MemoryTracer.instance.sramDataTypes.length && (MemoryTracer.instance.sramDataTypes[n] & 0xFF) == 1;
    }

    public static boolean isTileDataInSRAM(int n) {
        return MemoryTracer.isEnabled() && n < MemoryTracer.instance.sramDataTypes.length && (MemoryTracer.instance.sramDataTypes[n] & 0xFF) == 2;
    }

    public static boolean isTilemapDataInSRAM(int n) {
        return MemoryTracer.isEnabled() && n < MemoryTracer.instance.sramDataTypes.length && (MemoryTracer.instance.sramDataTypes[n] & 0xFF) == 3;
    }

    public static boolean isSpriteDataInSRAM(int n) {
        return MemoryTracer.isEnabled() && n < MemoryTracer.instance.sramDataTypes.length && (MemoryTracer.instance.sramDataTypes[n] & 0xFF) == 4;
    }

    public static boolean isSoundDataInSRAM(int n) {
        return MemoryTracer.isEnabled() && n < MemoryTracer.instance.sramDataTypes.length && (MemoryTracer.instance.sramDataTypes[n] & 0xFF) == 16;
    }

    public static void printROMmap() {
        MemoryTracer.printROMMap(System.out);
    }

    public static void printROMMap(File file) throws FileNotFoundException {
        PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        MemoryTracer.printROMMap(printStream);
        printStream.close();
    }

    private static void printROMMap(PrintStream printStream) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < MemoryTracer.instance.dataTypes.length) {
            if ((MemoryTracer.instance.dataTypes[n4] & 0xFF) == 1 || (MemoryTracer.instance.dataTypes[n4] & 0xFF) == 4) {
                n3 = 3;
            }
            if ((MemoryTracer.instance.dataTypes[n4] & 0xFF) > 0) {
                n3 = 0;
            }
            if ((MemoryTracer.instance.dataTypes[n4] & 0xFF) != n && ((MemoryTracer.instance.dataTypes[n4] & 0xFF) > 0 || n > 0 && ++n3 > 2)) {
                switch (n) {
                    case 1: {
                        printStream.println("Palette Data: $" + Integer.toHexString(n2) + " - $" + Integer.toHexString(n4 - n3) + " by $" + Integer.toHexString(MemoryTracer.instance.dataTypes[n2] >> 8));
                        break;
                    }
                    case 2: {
                        printStream.println("Tile Data: $" + Integer.toHexString(n2) + " - $" + Integer.toHexString(n4 - n3) + " by $" + Integer.toHexString(MemoryTracer.instance.dataTypes[n2] >> 8));
                        break;
                    }
                    case 3: {
                        printStream.println("Tilemap Data: $" + Integer.toHexString(n2) + " - $" + Integer.toHexString(n4 - n3) + " by $" + Integer.toHexString(MemoryTracer.instance.dataTypes[n2] >> 8));
                        break;
                    }
                    case 4: {
                        printStream.println("Sprite Data: $" + Integer.toHexString(n2) + " - $" + Integer.toHexString(n4 - n3) + " by $" + Integer.toHexString(MemoryTracer.instance.dataTypes[n2] >> 8));
                        break;
                    }
                    case 16: {
                        printStream.println("Sound Data: $" + Integer.toHexString(n2) + " - $" + Integer.toHexString(n4 - n3) + " by $" + Integer.toHexString(MemoryTracer.instance.dataTypes[n2] >> 8));
                    }
                }
                n2 = n4;
                n = MemoryTracer.instance.dataTypes[n4] & 0xFF;
                n3 = 0;
            }
            ++n4;
        }
    }

    public static long getRAMsource(int n) {
        if (instance == null || !enabled) {
            return 0L;
        }
        return MemoryTracer.instance.ramSources[n];
    }

    public static long[] getRAMSources() {
        if (instance == null || !enabled) {
            return null;
        }
        return (long[])MemoryTracer.instance.ramSources.clone();
    }

    public static long getSRAMsource(int n) {
        if (instance == null || !enabled || n >= MemoryTracer.instance.sramSources.length) {
            return 0L;
        }
        return MemoryTracer.instance.sramSources[n];
    }

    public static long[] getSRAMSources() {
        if (instance == null || !enabled) {
            return null;
        }
        return (long[])MemoryTracer.instance.sramSources.clone();
    }

    public static long getColorSource(int n) {
        if (instance == null || !enabled || n >= MemoryTracer.instance.colorSources.length) {
            return 0L;
        }
        return MemoryTracer.instance.colorSources[n];
    }

    public static long[] getColorSources(long[] lArray) {
        if (instance == null || !enabled) {
            return null;
        }
        if (lArray == null || lArray.length != MemoryTracer.instance.colorSources.length) {
            return (long[])MemoryTracer.instance.colorSources.clone();
        }
        System.arraycopy(MemoryTracer.instance.colorSources, 0, lArray, 0, lArray.length);
        return lArray;
    }

    public static long getVRAMsource(int n) {
        if (instance == null || !enabled) {
            return 0L;
        }
        return MemoryTracer.instance.vramSources[n];
    }

    public static long[] getVRAMSources(long[] lArray) {
        if (instance == null || !enabled) {
            return null;
        }
        if (lArray == null || lArray.length != MemoryTracer.instance.vramSources.length) {
            return (long[])MemoryTracer.instance.vramSources.clone();
        }
        System.arraycopy(MemoryTracer.instance.vramSources, 0, lArray, 0, lArray.length);
        return lArray;
    }

    protected abstract long[] getInstanceSpriteSources(long[] var1);

    public static long[] getSpriteSources(long[] lArray) {
        if (instance == null || !enabled) {
            return null;
        }
        return instance.getInstanceSpriteSources(lArray);
    }

    protected static final void fireOutputAvailable(int n, int n2) {
        OutputListener[] outputListenerArray = listeners;
        int n3 = listeners.length;
        int n4 = 0;
        while (n4 < n3) {
            OutputListener outputListener = outputListenerArray[n4];
            outputListener.outputAvailable(n, n2, 0);
            ++n4;
        }
    }

    public static final void addOutputListener(OutputListener outputListener) {
        if (!listenerList.contains(outputListener)) {
            listenerList.addFirst(outputListener);
            listeners = listenerList.toArray(new OutputListener[listenerList.size()]);
        }
    }

    public static final void removeOutputListener(OutputListener outputListener) {
        if (listenerList.remove(outputListener)) {
            listeners = listenerList.toArray(new OutputListener[listenerList.size()]);
        }
    }

    public static String traceToString(long l) {
        if (!enabled) {
            return "Memory Tracer is disabled";
        }
        String string = MemoryTracer.toString(l);
        if (l != 0L) {
            long l2;
            int[] nArray = new int[]{(int)(l >> 32), (int)l};
            if ((nArray[1] & 0x8000000) != 0) {
                long l3 = MemoryTracer.getSRAMsource(nArray[1] & 0xFFFFFF);
                if ((int)l3 != 0 && (int)l3 != 1 && (int)l3 != 2) {
                    string = String.valueOf(string) + " <- " + MemoryTracer.toString(l3);
                }
            } else if (nArray[1] > 2 && (nArray[1] & 0x1000000) != 0 && (int)(l2 = MemoryTracer.instance.ramSources[nArray[1] & 0xFFFFFF]) != 0 && (int)l2 != 1 && (int)l2 != 2) {
                string = String.valueOf(string) + " <- " + MemoryTracer.toString(l2);
            }
        }
        return string;
    }

    public static String sourceToString(long l) {
        if (!enabled) {
            return "Memory Tracer is disabled";
        }
        return MemoryTracer.toString(MemoryTracer.resolveTrace(l));
    }

    public static long resolveTrace(long l) {
        if (l != 0L) {
            long l2;
            int[] nArray = new int[]{(int)(l >> 32), (int)l};
            if ((nArray[1] & 0x8000000) != 0) {
                long l3 = MemoryTracer.getSRAMsource(nArray[1] & 0xFFFFFF);
                if ((int)l3 != 0 && (int)l3 != 1 && (int)l3 != 2) {
                    return l3;
                }
            } else if ((nArray[1] & 0x1000000) != 0 && (int)(l2 = MemoryTracer.instance.ramSources[nArray[1] & 0xFFFFFF]) != 0 && (int)l2 != 1 && (int)l2 != 2) {
                return l2;
            }
        }
        return l;
    }

    public static boolean isRomSource(long l) {
        return (l & 0x2000000L) != 0L;
    }

    public static boolean isRamSource(long l) {
        return (l & 0x1000000L) != 0L;
    }

    public static boolean isSramSource(long l) {
        return (l & 0x8000000L) != 0L;
    }

    public static boolean isVramSource(long l) {
        return (l & 0x4000000L) != 0L;
    }

    public static int getSourceAddress(long l) {
        return (int)(l & 0xFFFFFFL);
    }

    public static boolean isRomInstruction(long l) {
        return (l >> 32 & 0x2000000L) != 0L;
    }

    public static int getInstructionAddress(long l) {
        return (int)(l >> 32) & 0xFFFFFF;
    }

    public static String toString(long l) {
        if (!enabled) {
            return "Memory Tracer is disabled";
        }
        int n = (int)l;
        String string = n == 0 || n == 2 ? "Unknown" : (n == 1 ? "None" : String.valueOf(instance.locationToString(n)) + " " + instance.addressToString(n));
        int n2 = (int)(l >> 32);
        if (n2 != 0) {
            string = String.valueOf(string) + " (see " + instance.locationToString(n2) + " " + instance.addressToString(n2) + ")";
        }
        return string;
    }
}

