/*
 * Decompiled with CFR 0.152.
 */
package platform;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.util.Arrays;
import overlays.OverlayModel;

public class DisplayWindowOverlayModel {
    private final OverlayModel overlays;
    private Color[] colors = new Color[0];
    private BasicStroke[] strokes = new BasicStroke[0];
    private Font[] fonts = new Font[0];

    public DisplayWindowOverlayModel(OverlayModel overlayModel) {
        this.overlays = overlayModel;
    }

    public int getOverlayCount() {
        return this.overlays.getOverlayCount();
    }

    public OverlayModel.OverlayType getType(int n) {
        return this.overlays.getType(n);
    }

    public int getX(int n) {
        return this.overlays.getX(n);
    }

    public int getY(int n) {
        return this.overlays.getY(n);
    }

    public int getWidth(int n) {
        return this.overlays.getWidth(n);
    }

    public int getHeight(int n) {
        return this.overlays.getHeight(n);
    }

    public Stroke getStroke(int n) {
        this.updateArrays();
        if (this.strokes[n] == null || (int)this.strokes[n].getLineWidth() != this.overlays.getThickness(n)) {
            this.strokes[n] = new BasicStroke(this.overlays.getThickness(n));
        }
        return this.strokes[n];
    }

    public Color getColor(int n) {
        this.updateArrays();
        if (this.colors[n] == null || (this.colors[n].getRGB() & 0xFFFFFF) != this.overlays.getColor(n) || this.colors[n].getAlpha() != 255 ^ this.overlays.hasAlpha(n)) {
            this.colors[n] = new Color(this.overlays.getColor(n), this.overlays.hasAlpha(n));
        }
        return this.colors[n];
    }

    public Font getFont(int n, Font font) {
        this.updateArrays();
        if (this.fonts[n] == null || this.fonts[n].getSize() != this.overlays.getHeight(n)) {
            this.fonts[n] = font.deriveFont((float)this.overlays.getHeight(n));
        }
        return this.fonts[n];
    }

    public String getText(int n) {
        return this.overlays.getText(n);
    }

    public boolean isVisible(int n) {
        return this.overlays.isVisible(n);
    }

    public boolean useWindowCoords(int n) {
        return this.overlays.useWindowCoords(n);
    }

    public boolean isFill(int n) {
        return this.overlays.isFill(n);
    }

    private void updateArrays() {
        int n = this.overlays.getOverlayCount();
        if (this.colors.length != n) {
            this.colors = Arrays.copyOf(this.colors, n);
            this.strokes = Arrays.copyOf(this.strokes, n);
            this.fonts = Arrays.copyOf(this.fonts, n);
        }
    }

    public void onAfterRender() {
        this.overlays.onAfterRender();
    }

    public void onBeforeRender() {
        this.overlays.onBeforeRender();
    }
}

