/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.RawDevice;
import net.java.games.input.RawDeviceInfo;
import net.java.games.input.RawInputEventQueue;
import net.java.games.input.SetupAPIDevice;
import net.java.games.util.plugins.Plugin;

public final class RawInputEnvironmentPlugin
extends ControllerEnvironment
implements Plugin {
    private static boolean supported = false;
    private final Controller[] controllers;

    static {
        String string = RawInputEnvironmentPlugin.getPrivilegedProperty("os.name", "").trim();
        if (string.startsWith("Windows")) {
            supported = true;
            if ("x86".equals(RawInputEnvironmentPlugin.getPrivilegedProperty("os.arch"))) {
                RawInputEnvironmentPlugin.loadLibrary("jinput-raw");
            } else {
                RawInputEnvironmentPlugin.loadLibrary("jinput-raw_64");
            }
        }
    }

    static void loadLibrary(final String string) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    String string2 = System.getProperty("net.java.games.input.librarypath");
                    if (string2 != null) {
                        System.load(String.valueOf(string2) + File.separator + System.mapLibraryName(string));
                    } else {
                        System.loadLibrary(string);
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    unsatisfiedLinkError.printStackTrace();
                    supported = false;
                }
                return null;
            }
        });
    }

    static String getPrivilegedProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string);
            }
        });
    }

    static String getPrivilegedProperty(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string, string2);
            }
        });
    }

    public RawInputEnvironmentPlugin() {
        Controller[] controllerArray = new Controller[]{};
        if (this.isSupported()) {
            try {
                RawInputEventQueue rawInputEventQueue = new RawInputEventQueue();
                controllerArray = this.enumControllers(rawInputEventQueue);
            }
            catch (IOException iOException) {
                RawInputEnvironmentPlugin.log("Failed to enumerate devices: " + iOException.getMessage());
            }
        }
        this.controllers = controllerArray;
    }

    @Override
    public final Controller[] getControllers() {
        return this.controllers;
    }

    private static final SetupAPIDevice lookupSetupAPIDevice(String string, List<SetupAPIDevice> list) {
        string = string.replaceAll("#", "\\\\").toUpperCase();
        int n = 0;
        while (n < list.size()) {
            SetupAPIDevice setupAPIDevice = list.get(n);
            if (string.contains(setupAPIDevice.getInstanceId().toUpperCase())) {
                return setupAPIDevice;
            }
            ++n;
        }
        return null;
    }

    private static final void createControllersFromDevices(RawInputEventQueue rawInputEventQueue, List<Controller> list, List<RawDevice> list2, List<SetupAPIDevice> list3) throws IOException {
        ArrayList<RawDevice> arrayList = new ArrayList<RawDevice>();
        int n = 0;
        while (n < list2.size()) {
            RawDeviceInfo rawDeviceInfo;
            Controller controller;
            RawDevice rawDevice = list2.get(n);
            SetupAPIDevice setupAPIDevice = RawInputEnvironmentPlugin.lookupSetupAPIDevice(rawDevice.getName(), list3);
            if (setupAPIDevice != null && (controller = (rawDeviceInfo = rawDevice.getInfo()).createControllerFromDevice(rawDevice, setupAPIDevice)) != null) {
                list.add(controller);
                arrayList.add(rawDevice);
            }
            ++n;
        }
        rawInputEventQueue.start(arrayList);
    }

    private static final native void enumerateDevices(RawInputEventQueue var0, List<RawDevice> var1) throws IOException;

    private final Controller[] enumControllers(RawInputEventQueue rawInputEventQueue) throws IOException {
        ArrayList<Controller> arrayList = new ArrayList<Controller>();
        ArrayList<RawDevice> arrayList2 = new ArrayList<RawDevice>();
        RawInputEnvironmentPlugin.enumerateDevices(rawInputEventQueue, arrayList2);
        List<SetupAPIDevice> list = RawInputEnvironmentPlugin.enumSetupAPIDevices();
        RawInputEnvironmentPlugin.createControllersFromDevices(rawInputEventQueue, arrayList, arrayList2, list);
        Controller[] controllerArray = new Controller[arrayList.size()];
        arrayList.toArray(controllerArray);
        return controllerArray;
    }

    @Override
    public boolean isSupported() {
        return supported;
    }

    private static final List<SetupAPIDevice> enumSetupAPIDevices() throws IOException {
        ArrayList<SetupAPIDevice> arrayList = new ArrayList<SetupAPIDevice>();
        RawInputEnvironmentPlugin.nEnumSetupAPIDevices(RawInputEnvironmentPlugin.getKeyboardClassGUID(), arrayList);
        RawInputEnvironmentPlugin.nEnumSetupAPIDevices(RawInputEnvironmentPlugin.getMouseClassGUID(), arrayList);
        return arrayList;
    }

    private static final native void nEnumSetupAPIDevices(byte[] var0, List<SetupAPIDevice> var1) throws IOException;

    private static final native byte[] getKeyboardClassGUID();

    private static final native byte[] getMouseClassGUID();
}

