/*
 * Decompiled with CFR 0.152.
 */
package jinput;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import util.io.IOUtilities;

public final class JInputHandler {
    private static final String[] POV_NAMES = new String[]{" U", " R", " D", " L"};
    private static final JComponent dummyComponent = new JLabel();
    private static final String[] LIB_FILENAMES = new String[]{"jinput-dx8_64.dll", "jinput-dx8.dll", "jinput-raw_64.dll", "jinput-raw.dll", "jinput-wintab.dll", "libjinput-linux.so", "libjinput-linux64.so", "libjinput-linux-arm.so", "libjinput-osx.jnilib", "libjinput-osx-aarch64.jnilib"};
    private static Boolean supported;
    private static List<KeyListener>[] listeners;
    private static Controller[] controllers;
    private static float[] thresholds;
    private static Map<Component.Identifier, Integer>[] componentIDs;
    private static Map<Integer, Component>[] components;
    private static float[][] componentValues;
    private static int[][] componentStates;
    private static volatile Thread pollThread;
    private static int[] controllerPOV;
    private static int[] controllerXaxis;
    private static int[] controllerYaxis;
    private static int[] controllerButtonStart;
    private static int[] controllerButtonSelect;
    private static int[] controllerButtonA;
    private static int[] controllerButtonB;

    static {
        thresholds = new float[0];
    }

    private JInputHandler() {
    }

    public static boolean isSupported() {
        if (supported == null) {
            supported = JInputHandler.checkSupported();
        }
        return supported;
    }

    private static boolean checkSupported() {
        try {
            ControllerEnvironment.getDefaultEnvironment();
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            return false;
        }
        catch (ClassFormatError classFormatError) {
            return false;
        }
        return true;
    }

    private static Controller[] getControllers() {
        if (controllers == null) {
            Controller[] controllerArray = ControllerEnvironment.getDefaultEnvironment().getControllers();
            ArrayList<Controller> arrayList = new ArrayList<Controller>();
            Controller[] controllerArray2 = controllerArray;
            int n = controllerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Controller controller = controllerArray2[n2];
                if (Controller.Type.GAMEPAD.equals(controller.getType()) || Controller.Type.STICK.equals(controller.getType())) {
                    arrayList.add(controller);
                }
                ++n2;
            }
            controllers = arrayList.toArray(new Controller[arrayList.size()]);
            listeners = new List[controllers.length];
            componentIDs = new Map[controllers.length];
            components = new Map[controllers.length];
            componentStates = new int[controllers.length][];
            componentValues = new float[controllers.length][];
            thresholds = new float[controllers.length];
            controllerPOV = new int[controllers.length];
            Arrays.fill(controllerPOV, -1);
            controllerXaxis = new int[controllers.length];
            Arrays.fill(controllerXaxis, -1);
            controllerYaxis = new int[controllers.length];
            Arrays.fill(controllerYaxis, -1);
            controllerButtonStart = new int[controllers.length];
            Arrays.fill(controllerButtonStart, -1);
            controllerButtonSelect = new int[controllers.length];
            Arrays.fill(controllerButtonSelect, -1);
            controllerButtonA = new int[controllers.length];
            Arrays.fill(controllerButtonA, -1);
            controllerButtonB = new int[controllers.length];
            Arrays.fill(controllerButtonB, -1);
            int n3 = 0;
            while (n3 < controllers.length) {
                JInputHandler.thresholds[n3] = 0.5f;
                JInputHandler.listeners[n3] = new LinkedList<KeyListener>();
                JInputHandler.componentIDs[n3] = new HashMap<Component.Identifier, Integer>();
                JInputHandler.components[n3] = new HashMap<Integer, Component>();
                Component[] componentArray = controllers[n3].getComponents();
                n = 0;
                while (n < componentArray.length) {
                    componentIDs[n3].put(componentArray[n].getIdentifier(), n * 4);
                    components[n3].put(n, componentArray[n]);
                    if (componentArray[n].getIdentifier() == Component.Identifier.Axis.POV) {
                        JInputHandler.controllerPOV[n3] = n * 4;
                    } else if (componentArray[n].getIdentifier() == Component.Identifier.Axis.X) {
                        JInputHandler.controllerXaxis[n3] = n * 4;
                    } else if (componentArray[n].getIdentifier() == Component.Identifier.Axis.Y) {
                        JInputHandler.controllerYaxis[n3] = n * 4;
                    } else if (componentArray[n].getIdentifier() == Component.Identifier.Button.START) {
                        JInputHandler.controllerButtonStart[n3] = n * 4;
                    } else if (componentArray[n].getIdentifier() == Component.Identifier.Button.SELECT) {
                        JInputHandler.controllerButtonSelect[n3] = n * 4;
                    } else if (componentArray[n].getIdentifier() == Component.Identifier.Button.A) {
                        JInputHandler.controllerButtonA[n3] = n * 4;
                    } else if (componentArray[n].getIdentifier() == Component.Identifier.Button.B) {
                        JInputHandler.controllerButtonB[n3] = n * 4;
                    }
                    ++n;
                }
                JInputHandler.componentStates[n3] = new int[componentArray.length];
                JInputHandler.componentValues[n3] = new float[componentArray.length];
                ++n3;
            }
        }
        return controllers;
    }

    private static void startPollThread() {
        if (pollThread == null) {
            pollThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    EventQueue eventQueue;
                    Event event = new Event();
                    int n = 0;
                    while (n < controllers.length) {
                        controllers[n].poll();
                        eventQueue = controllers[n].getEventQueue();
                        while (eventQueue.getNextEvent(event)) {
                            eventQueue.getNextEvent(event);
                        }
                        ++n;
                    }
                    while (!Thread.interrupted()) {
                        n = 0;
                        while (n < controllers.length) {
                            controllers[n].poll();
                            eventQueue = controllers[n].getEventQueue();
                            while (eventQueue.getNextEvent(event)) {
                                JInputHandler.handleEvent(n, event);
                            }
                            ++n;
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    pollThread = null;
                    List[] listArray = listeners;
                    int n2 = listArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        List list = listArray[n3];
                        if (!list.isEmpty()) {
                            JInputHandler.startPollThread();
                            break;
                        }
                        ++n3;
                    }
                }
            }, "JInput Poll Thread");
            pollThread.start();
        }
    }

    private static void stopPollThread() {
        if (pollThread != null) {
            pollThread.interrupt();
        }
    }

    private static int getComponentId(int n, Component.Identifier identifier) {
        if (!JInputHandler.isSupported()) {
            return -1;
        }
        Integer n2 = componentIDs[n].get(identifier);
        return n2 == null ? -1 : n2;
    }

    public static int getPovUp(int n) {
        int n2 = controllerPOV[n];
        if (n2 < 0) {
            return -1;
        }
        return n2;
    }

    public static int getPovRight(int n) {
        int n2 = controllerPOV[n];
        if (n2 < 0) {
            return -1;
        }
        return n2 + 1;
    }

    public static int getPovDown(int n) {
        int n2 = controllerPOV[n];
        if (n2 < 0) {
            return -1;
        }
        return n2 + 2;
    }

    public static int getPovLeft(int n) {
        int n2 = controllerPOV[n];
        if (n2 < 0) {
            return -1;
        }
        return n2 + 3;
    }

    public static int getStickUp(int n) {
        int n2 = controllerYaxis[n];
        if (n2 < 0) {
            return -1;
        }
        return n2;
    }

    public static int getStickRight(int n) {
        int n2 = controllerXaxis[n];
        if (n2 < 0) {
            return -1;
        }
        return n2 + 1;
    }

    public static int getStickDown(int n) {
        int n2 = controllerYaxis[n];
        if (n2 < 0) {
            return -1;
        }
        return n2 + 1;
    }

    public static int getStickLeft(int n) {
        int n2 = controllerXaxis[n];
        if (n2 < 0) {
            return -1;
        }
        return n2;
    }

    public static int getStartButton(int n) {
        return controllerButtonStart[n];
    }

    public static int getSelectButton(int n) {
        return controllerButtonSelect[n];
    }

    public static int getAButton(int n) {
        return controllerButtonA[n];
    }

    public static int getBButton(int n) {
        return controllerButtonB[n];
    }

    public static float getX(int n) {
        return componentValues[n][controllerXaxis[n] / 4];
    }

    public static float getY(int n) {
        return componentValues[n][controllerYaxis[n] / 4];
    }

    public static void setThreshold(int n, float f) {
        if (!JInputHandler.isSupported() || n < 0 || n >= thresholds.length) {
            return;
        }
        JInputHandler.thresholds[n] = f;
    }

    public static String getComponentName(int n, int n2) {
        if (!JInputHandler.isSupported()) {
            return null;
        }
        Component component = components[n].get(n2 / 4);
        if (component == null) {
            return "Unknown";
        }
        if (component.getIdentifier() == Component.Identifier.Axis.POV) {
            return component + POV_NAMES[n2 & 3];
        }
        if (component.getIdentifier() instanceof Component.Identifier.Axis) {
            return component + ((n2 & 3) > 0 ? "+" : "-");
        }
        return component.toString();
    }

    private static void handleEvent(int n, Event event) {
        Component component = event.getComponent();
        Component.Identifier identifier = component.getIdentifier();
        float f = event.getValue();
        int n2 = JInputHandler.getComponentId(n, identifier);
        int n3 = n2 / 4;
        JInputHandler.componentValues[n][n3] = f;
        if (identifier == Component.Identifier.Axis.POV) {
            int n4 = componentStates[n][n3];
            int n5 = (int)(f * 4.0f) - 1 & 3;
            if (f == 0.0f) {
                JInputHandler.componentStates[n][n3] = 0;
            } else {
                JInputHandler.componentStates[n][n3] = 1 << n5;
                if (((int)(f * 8.0f) & 1) != 0) {
                    int[] nArray = componentStates[n];
                    int n6 = n3;
                    nArray[n6] = nArray[n6] | 1 << (n5 + 1 & 3);
                }
            }
            int n7 = 0;
            while (n7 < 4) {
                if ((componentStates[n][n3] & 1 << n7) != (n4 & 1 << n7)) {
                    JInputHandler.fireKeyEvent(n, (componentStates[n][n3] & 1 << n7) != 0, n2 + n7);
                }
                ++n7;
            }
        } else if (component.isAnalog()) {
            int n8 = componentStates[n][n3];
            int n9 = (int)Math.signum(f);
            boolean bl = Math.abs(f) >= thresholds[n];
            JInputHandler.componentStates[n][n3] = !bl ? 0 : n9;
            if (componentStates[n][n3] != n8) {
                if (n8 != 0) {
                    JInputHandler.fireKeyEvent(n, false, n2 + (n8 + 1) / 2);
                }
                if (componentStates[n][n3] != 0) {
                    JInputHandler.fireKeyEvent(n, bl, n2 + (componentStates[n][n3] + 1) / 2);
                }
            }
        } else {
            JInputHandler.fireKeyEvent(n, f != 0.0f, JInputHandler.getComponentId(n, identifier));
        }
    }

    private static void fireKeyEvent(int n, boolean bl, int n2) {
        KeyEvent keyEvent = new KeyEvent(dummyComponent, 0, System.currentTimeMillis(), 0, n2, (char)n2);
        if (bl) {
            for (KeyListener keyListener : listeners[n]) {
                keyListener.keyPressed(keyEvent);
            }
        } else {
            for (KeyListener keyListener : listeners[n]) {
                keyListener.keyReleased(keyEvent);
            }
        }
    }

    public static void addKeyListener(int n, KeyListener keyListener) {
        if (!JInputHandler.isSupported()) {
            return;
        }
        if (!listeners[n].contains(keyListener)) {
            listeners[n].add(keyListener);
        }
        JInputHandler.startPollThread();
    }

    public static void removeKeyListener(int n, KeyListener keyListener) {
        if (!JInputHandler.isSupported()) {
            return;
        }
        listeners[n].remove(keyListener);
        boolean bl = true;
        List<KeyListener>[] listArray = listeners;
        int n2 = listeners.length;
        int n3 = 0;
        while (n3 < n2) {
            List<KeyListener> list = listArray[n3];
            if (!list.isEmpty()) {
                bl = false;
                break;
            }
            ++n3;
        }
        if (bl) {
            JInputHandler.stopPollThread();
        }
    }

    public static String[] getControllerNames() {
        if (!JInputHandler.isSupported()) {
            return new String[0];
        }
        Controller[] controllerArray = JInputHandler.getControllers();
        String[] stringArray = new String[controllerArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = "Port " + n + " " + controllerArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    public static void extractJInputLibraries(File file) throws IOException {
        if (!JInputHandler.isSupported()) {
            return;
        }
        System.setProperty("net.java.games.input.librarypath", file.getAbsolutePath());
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.arch");
        String string3 = "Linux".equals(string) ? ("arm".equals(string2) ? "-arm.so" : ".so") : ("Mac OS X".equals(string) ? ("aarch64".equals(string2) ? "-aarch64.jnilib" : ".jnilib") : (string.startsWith("Windows") ? ".dll" : null));
        boolean bl = (!"Mac OS X".equals(string) || "aarch64".equals(string2)) && !"x86".equals(string2) && !"arm".equals(string2);
        String[] stringArray = LIB_FILENAMES;
        int n = LIB_FILENAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String string4 = stringArray[n2];
            if (string3 == null || string4.endsWith(string3) && !bl ^ (string4.contains("64") || string4.contains("wintab"))) {
                String string5 = string4.substring(string4.startsWith("lib") ? 3 : 0, string3 != null ? string4.length() - string3.length() : string4.indexOf(46));
                String string6 = System.mapLibraryName(string5);
                File file2 = new File(file, string6);
                String string7 = "lib/" + string4;
                if (!file2.exists() || file2.length() != (long)IOUtilities.getResourceSize(string7)) {
                    IOUtilities.extractResource(string7, file2);
                }
            }
            ++n2;
        }
    }
}

