/*
 * Decompiled with CFR 0.152.
 */
package dap.messages.events;

import dap.messages.Event;
import dap.types.Source;
import json.JSONObject;

public class OutputEvent
extends Event {
    private final Category category;
    private final String output;
    private final Group group;
    private final int variablesReference;
    private final Source source;
    private final int line;
    private final int column;

    public OutputEvent(String string) {
        this(null, string, null, -1, null, -1, -1);
    }

    public OutputEvent(Category category, String string, Group group, int n, Source source, int n2, int n3) {
        this.category = category;
        this.output = string;
        this.group = group;
        this.variablesReference = n;
        this.source = source;
        this.line = n2;
        this.column = n3;
    }

    @Override
    public String getEvent() {
        return "output";
    }

    @Override
    public JSONObject getBody() {
        JSONObject jSONObject = new JSONObject();
        if (this.category != null) {
            jSONObject.put("category", this.category.toString().toLowerCase());
        }
        jSONObject.put("output", this.output);
        if (this.group != null) {
            jSONObject.put("group", this.group == Group.START_COLLAPSED ? "startCollapsed" : this.group.toString().toLowerCase());
        }
        if (this.variablesReference >= 0) {
            jSONObject.put("variablesReference", this.variablesReference);
        }
        jSONObject.put("source", this.source);
        if (this.line >= 0) {
            jSONObject.put("line", this.line);
        }
        if (this.column >= 0) {
            jSONObject.put("column", this.column);
        }
        return jSONObject;
    }

    public static enum Category {
        CONSOLE,
        STDOUT,
        STDERR,
        TELEMETRY;

    }

    public static enum Group {
        START,
        START_COLLAPSED,
        END;

    }
}

