/*
 * Decompiled with CFR 0.152.
 */
package assembler.sjasm;

import assembler.AbstractZ80ParseResult;
import assembler.Z80Assembler;
import assembler.Z80Instruction;
import assembler.Z80SourceLine;
import assembler.parsers.ExpressionEvaluator;
import assembler.parsers.ParseException;
import assembler.parsers.UnknownIdentifierException;
import assembler.sjasm.SjasmPageMap;
import assembler.sjasm.SjasmSourceLine;
import disassembler.dialects.AssemblerDialect;
import disassembler.dialects.SjasmMsxDialect;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import util.string.StringUtilities;

public final class SjasmParser {
    private static final String OPERATORS = "|&^<>+-!=#~*/";
    private static final String OPERATORS_AND_IDENTIFIER_SYMBOLS = "|&^<>+-!=#~*/:?%.@";
    private static final int EVALUATION_FAILED = -1073741824;

    private SjasmParser() {
    }

    public static ParseResult readLines(File file, Z80Assembler z80Assembler, ExpressionEvaluator expressionEvaluator) throws IOException {
        return SjasmParser.readLines(file, new ParsingState(file, z80Assembler, expressionEvaluator, 4));
    }

    public static ParseResult readLines(String string, int n, Z80Assembler z80Assembler, ExpressionEvaluator expressionEvaluator) throws IOException {
        return SjasmParser.readLines(new StringReader(string), null, n, z80Assembler, expressionEvaluator);
    }

    public static ParseResult readLines(Reader reader, File file, int n, Z80Assembler z80Assembler, ExpressionEvaluator expressionEvaluator) throws IOException {
        return SjasmParser.readLines(reader, new ParsingState(file, z80Assembler, expressionEvaluator, n));
    }

    private static ParseResult readLines(File file, ParsingState parsingState) throws IOException {
        return SjasmParser.readLines(new FileInputStream(file), parsingState);
    }

    private static ParseResult readLines(InputStream inputStream, ParsingState parsingState) throws IOException {
        return SjasmParser.readLines(new InputStreamReader(inputStream), parsingState);
    }

    private static ParseResult readLines(Reader reader, ParsingState parsingState) throws IOException {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        String string = bufferedReader.readLine();
        while (string != null) {
            SjasmParser.readLine(parsingState, string, 0);
            string = bufferedReader.readLine();
        }
        reader.close();
        return new ParseResult(parsingState);
    }

    private static void readLine(ParsingState parsingState, CharSequence charSequence, int n) {
        List<Z80SourceLine> list = parsingState.lines;
        SjasmPageMap sjasmPageMap = parsingState.pageMap;
        Z80Assembler z80Assembler = parsingState.assembler;
        ExpressionEvaluator expressionEvaluator = parsingState.expressionEvaluator;
        try {
            Object object;
            int n2;
            int n3;
            Object object2;
            if (charSequence.length() < 8 || !Character.isDigit(charSequence.charAt(7)) || charSequence.charAt(0) > ' ' && !Character.isDigit(charSequence.charAt(0))) {
                if (parsingState.rootFile == null && charSequence.length() > 0 && StringUtilities.indexOf(charSequence, ' ') < 0) {
                    parsingState.setRootFile(charSequence);
                }
                return;
            }
            if (charSequence.length() < 20 || charSequence.charAt(13) != ':') {
                return;
            }
            CharSequence charSequence2 = StringUtilities.trim(charSequence.subSequence(0, 8));
            int n4 = charSequence2.length() > 0 ? Integer.parseInt(charSequence2.toString()) - 1 : -1;
            int n5 = SjasmParser.parseHexDigit(charSequence.charAt(11)) << 4 | SjasmParser.parseHexDigit(charSequence.charAt(12));
            int n6 = SjasmParser.parseHexDigit(charSequence.charAt(14)) << 12 | SjasmParser.parseHexDigit(charSequence.charAt(15)) << 8 | SjasmParser.parseHexDigit(charSequence.charAt(16)) << 4 | SjasmParser.parseHexDigit(charSequence.charAt(17));
            if (n <= 0 && n4 == parsingState.prevLineNumber && (object2 = list.get(n3 = list.size() - 1)).getInstruction() == null) {
                n2 = object2.getAddress() >= 0 ? object2.getAddress() : sjasmPageMap.resolveAddress(n5, n6);
                int[] nArray = SjasmParser.parseBytePrefix(charSequence);
                int[] nArray2 = Arrays.copyOf(parsingState.prevBytePrefix, parsingState.prevBytePrefix.length + nArray.length);
                System.arraycopy(nArray, 0, nArray2, parsingState.prevBytePrefix.length, nArray.length);
                parsingState.prevBytePrefix = nArray2;
                list.set(n3, new SjasmSourceLine(n2, nArray2.length, n4, object2.getFile(), object2.toString(), nArray2));
            }
            parsingState.prevLineNumber = n4;
            if (charSequence.length() < 40 || charSequence.charAt(39) > ' ') {
                return;
            }
            if (StringUtilities.indexOf((CharSequence)"~<", charSequence.charAt(38)) >= 0) {
                list.add(new SjasmSourceLine(StringUtilities.concat("; ", StringUtilities.subSequence(charSequence, 40))));
                return;
            }
            File file = parsingState.setIncludeDepth(SjasmParser.parseIncludeDepth(charSequence));
            if (charSequence.charAt(20) == '(' && charSequence.charAt(25) == ')' && StringUtilities.indexOf(charSequence, "incbin") >= 0) {
                int n7 = SjasmParser.parseHexDigit(charSequence.charAt(21)) << 12 | SjasmParser.parseHexDigit(charSequence.charAt(22)) << 8 | SjasmParser.parseHexDigit(charSequence.charAt(23)) << 4 | SjasmParser.parseHexDigit(charSequence.charAt(24));
                list.add(new SjasmSourceLine(sjasmPageMap.resolveAddress(n5, n6), n7, n4, file, StringUtilities.subSequence(charSequence, 40), null));
                return;
            }
            if (n <= 0 && charSequence.length() > 40 && charSequence.charAt(40) == '[') {
                int n8;
                list.add(new SjasmSourceLine(StringUtilities.concat("; ", StringUtilities.subSequence(charSequence, 40))));
                n2 = n8 = SjasmParser.parseRepeat(charSequence);
                while (n2 > 0) {
                    SjasmParser.readLine(parsingState, charSequence, n8 - n2 + 1);
                    --n2;
                }
                return;
            }
            object2 = n <= 0 ? SjasmParser.parseBytePrefix(charSequence) : null;
            parsingState.prevBytePrefix = (int[])object2;
            CharSequence charSequence3 = charSequence = StringUtilities.subSequence(charSequence, n > 0 ? StringUtilities.indexOf(charSequence, ']') + 1 : 40);
            char c = (StringUtilities.indexOf(charSequence3, "//") & Integer.MAX_VALUE) < (StringUtilities.indexOf(charSequence3, ';') & Integer.MAX_VALUE) ? (char)'/' : ';';
            int n9 = (StringUtilities.indexOf(charSequence3, '\"') & Integer.MAX_VALUE) < StringUtilities.indexOf(charSequence3, c) ? StringUtilities.indexOf(charSequence3, c, StringUtilities.lastIndexOf(charSequence3, '\"') + 1) : StringUtilities.indexOf(charSequence3, c);
            if (StringUtilities.isEmpty(charSequence3 = StringUtilities.trim(n9 >= 0 ? StringUtilities.subSequence(charSequence3, 0, n9) : charSequence3))) {
                list.add(new SjasmSourceLine(charSequence));
                return;
            }
            if (object2 == null || ((Object)object2).length == 0) {
                if (StringUtilities.startsWith(charSequence3, "defpage")) {
                    charSequence3 = StringUtilities.subSequence(charSequence3, "defpage".length());
                    CharSequence[] charSequenceArray = SjasmParser.splitOperands(charSequence3);
                    try {
                        int n10;
                        int n11 = charSequenceArray.length > 1 ? expressionEvaluator.evaluate(charSequenceArray[1]) : -1;
                        int n12 = charSequenceArray.length > 2 ? expressionEvaluator.evaluate(charSequenceArray[2]) : -1;
                        int n13 = StringUtilities.indexOf(charSequenceArray[0], "..");
                        int n14 = n13 >= 0 ? expressionEvaluator.evaluate(StringUtilities.subSequence(charSequenceArray[0], 0, n13)) : -1;
                        int n15 = n10 = n13 >= 0 ? expressionEvaluator.evaluate(StringUtilities.subSequence(charSequenceArray[0], n13 + "..".length())) : -1;
                        if (n10 > n14) {
                            sjasmPageMap.addPages(n10 - n14 + 1, n11, n12);
                        } else {
                            sjasmPageMap.addPage(n11, n12);
                        }
                    }
                    catch (UnknownIdentifierException unknownIdentifierException) {
                        unknownIdentifierException.printStackTrace();
                    }
                    list.add(new SjasmSourceLine(charSequence));
                    return;
                }
                if (StringUtilities.indexOf(charSequence3, "include") >= 0 && ((CharSequence[])(object = SjasmParser.splitOperands(StringUtilities.subSequence(charSequence3, "include".length())))).length > 0) {
                    if (StringUtilities.indexOf(object[0], '\"') >= 0) {
                        parsingState.pushInclude(object[0].subSequence(1, object[0].length() - 1));
                    } else {
                        parsingState.pushInclude(object[0]);
                    }
                }
            }
            if ((StringUtilities.indexOf(charSequence3, '\"') & Integer.MAX_VALUE) > StringUtilities.indexOf(charSequence3, ':')) {
                charSequence3 = StringUtilities.trim(StringUtilities.subSequence(charSequence3, StringUtilities.indexOf(charSequence3, ':') + 1));
            }
            if (StringUtilities.startsWith(charSequence3, "db") || StringUtilities.startsWith(charSequence3, "dw")) {
                SjasmParser.parseDataDirective(charSequence3, n4, file, charSequence, sjasmPageMap.resolveAddress(n5, n6), parsingState);
                return;
            }
            try {
                object = z80Assembler.assemble(charSequence3.toString());
                list.add(new SjasmSourceLine(sjasmPageMap.resolveAddress(n5, n6) + Math.max(0, n - 1) * ((Z80Instruction)object).getSize(), n4, file, charSequence, (Z80Instruction)object, (int[])object2));
                return;
            }
            catch (ParseException parseException) {
                if (object2 != null && ((Object)object2).length > 0) {
                    list.add(new SjasmSourceLine(sjasmPageMap.resolveAddress(n5, n6), ((Object)object2).length, n4, file, charSequence, (int[])object2));
                } else {
                    list.add(new SjasmSourceLine(charSequence, file));
                }
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            list.add(new SjasmSourceLine(charSequence));
            return;
        }
    }

    private static int parseHexDigit(char c) {
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return c - 48;
    }

    private static int parseRepeat(CharSequence charSequence) {
        int n = 0;
        int n2 = StringUtilities.indexOf(charSequence, '[');
        while (charSequence.charAt(++n2) != ']') {
            n = n * 10 + (charSequence.charAt(n2) - 48);
        }
        return n;
    }

    private static int[] parseBytePrefix(CharSequence charSequence) {
        int n = 20;
        char c = '\u0000';
        while (n < charSequence.length() && ((c = charSequence.charAt(n)) >= '0' && c <= '9' || c >= 'A' && c <= 'F')) {
            n += 3;
        }
        int n2 = n > 20 && c == '(' ? Integer.parseInt(charSequence.subSequence(n + 1, StringUtilities.indexOf(charSequence, ')', n + 1)).toString()) : (n - 20) / 3;
        int[] nArray = new int[n2];
        while (n > 20 && (n - 3 - 20) / 3 < nArray.length) {
            nArray[((n -= 3) - 20) / 3] = SjasmParser.parseHexDigit(charSequence.charAt(n)) << 4 | SjasmParser.parseHexDigit(charSequence.charAt(n + 1));
        }
        return nArray;
    }

    private static int parseIncludeDepth(CharSequence charSequence) {
        switch (charSequence.charAt(9)) {
            case '>': {
                return 5;
            }
            case ':': {
                return 4;
            }
            case '.': {
                return 3;
            }
        }
        switch (charSequence.charAt(8)) {
            case ':': {
                return 2;
            }
            case '.': {
                return 1;
            }
        }
        return 0;
    }

    private static CharSequence[] splitOperands(CharSequence charSequence) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < charSequence.length()) {
            char c = charSequence.charAt(n2);
            if (c == ';') {
                SjasmParser.addOperandToList(charSequence, n, n2, bl, arrayList);
                n = n2 = charSequence.length();
            } else if (c == '\'') {
                SjasmParser.addOperandToList(charSequence, n, n2, bl, arrayList);
                n = n2++;
                if (++n2 < charSequence.length() && charSequence.charAt(n2) == '\'') {
                    arrayList.add(StringUtilities.subSequence(charSequence, n, n2 + 1));
                }
                n = n2 + 1;
                bl = false;
            } else if (c == '\"' && (n2 <= 0 || charSequence.charAt(n2 - 1) != '\\')) {
                SjasmParser.addOperandToList(charSequence, n, n2, bl, arrayList);
                n = n2++;
                while (n2 < charSequence.length() && (charSequence.charAt(n2) != '\"' || charSequence.charAt(n2 - 1) == '\\')) {
                    ++n2;
                }
                if (n2 >= charSequence.length()) {
                    throw new IllegalArgumentException("Missing closing quotation mark in " + charSequence);
                }
                arrayList.add(StringUtilities.subSequence(charSequence, n, n2 + 1));
                n = n2 + 1;
            } else if (c == '(') {
                SjasmParser.addOperandToList(charSequence, n, n2, bl, arrayList);
                int n3 = 0;
                n = n2;
                while (n2 < charSequence.length()) {
                    char c2 = charSequence.charAt(n2);
                    if (c2 == '\"') {
                        ++n2;
                        while (n2 < charSequence.length() && (charSequence.charAt(n2) != '\"' || charSequence.charAt(n2 - 1) == '\\')) {
                            ++n2;
                        }
                    } else if (c2 == '(') {
                        ++n3;
                    } else if (c2 == ')' && --n3 == 0) break;
                    ++n2;
                }
                bl = false;
                SjasmParser.addOperandToList(charSequence, n, Math.min(charSequence.length(), n2 + 1), bl, arrayList);
                n = n2 + 1;
            } else if (!Character.isJavaIdentifierPart(c) && OPERATORS_AND_IDENTIFIER_SYMBOLS.indexOf(c) < 0 || c == '$' && n != n2) {
                if (SjasmParser.addOperandToList(charSequence, n, n2, bl, arrayList)) {
                    bl = false;
                }
                if (c > ' ') {
                    boolean bl2 = bl = c == ',';
                }
                if (charSequence.charAt(n) == '.') {
                    bl = true;
                }
                n = c == '$' ? n2 : n2 + 1;
            }
            ++n2;
        }
        SjasmParser.addOperandToList(charSequence, n, charSequence.length(), bl, arrayList);
        return arrayList.toArray(new CharSequence[arrayList.size()]);
    }

    private static boolean addOperandToList(CharSequence charSequence, int n, int n2, boolean bl, List<CharSequence> list) {
        if (n2 > n) {
            CharSequence charSequence2;
            CharSequence charSequence3 = StringUtilities.subSequence(charSequence, n, n2);
            CharSequence charSequence4 = charSequence2 = list.isEmpty() ? null : list.get(list.size() - 1);
            if (!list.isEmpty() && !bl && (OPERATORS.indexOf(charSequence.charAt(n)) >= 0 || charSequence2 != null && OPERATORS.indexOf(charSequence2.charAt(charSequence2.length() - 1)) >= 0)) {
                list.set(list.size() - 1, StringUtilities.concat(list.get(list.size() - 1), charSequence3));
            } else {
                list.add(charSequence3);
            }
            return true;
        }
        return false;
    }

    private static void parseDataDirective(CharSequence charSequence, int n, File file, CharSequence charSequence2, int n2, ParsingState parsingState) {
        ExpressionEvaluator expressionEvaluator = parsingState.expressionEvaluator;
        List<Z80SourceLine> list = parsingState.lines;
        int n3 = parsingState.maxPrefixLength;
        CharSequence[] charSequenceArray = SjasmParser.splitOperands(charSequence);
        if (charSequenceArray[0].length() > 1 && Character.toUpperCase(charSequenceArray[0].charAt(0)) == 'D') {
            int n4;
            char c = Character.toUpperCase(charSequenceArray[0].charAt(1));
            int n5 = c == 'W' ? 2 : (c == 'B' ? 1 : (c == 'S' ? (charSequenceArray[0].length() > 3 && Character.toUpperCase(charSequenceArray[0].charAt(2)) == 'W' ? 2 : 1) : 0));
            int n6 = 0;
            int[] nArray = null;
            if (c == 'S') {
                n6 = SjasmParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]);
                if (charSequenceArray.length > 2 && (n4 = SjasmParser.evaluateExpression(expressionEvaluator, charSequenceArray[2])) != -1073741824) {
                    if (n5 == 1 && n6 > 0) {
                        nArray = new int[]{n4};
                    } else {
                        nArray = new int[Math.min(n3, n6)];
                        int n7 = 0;
                        while (n7 < nArray.length) {
                            nArray[n7] = n4 >> 8 * (n7 & n5 - 1) & 0xFF;
                            ++n7;
                        }
                    }
                }
            } else if (charSequenceArray[0].length() > 3) {
                if (StringUtilities.startsWithIgnoreCase(charSequenceArray[0], "RND", 3)) {
                    n6 = SjasmParser.evaluateExpression(expressionEvaluator, charSequenceArray[1]);
                } else if (StringUtilities.startsWithIgnoreCase(charSequenceArray[0], "SIN", 3) || StringUtilities.startsWithIgnoreCase(charSequenceArray[0], "COS", 3)) {
                    n6 = SjasmParser.evaluateExpression(expressionEvaluator, charSequenceArray[2]);
                }
            } else {
                n4 = 1;
                while (n4 < charSequenceArray.length) {
                    n6 = charSequenceArray[n4].charAt(0) == '\"' ? (n6 += charSequenceArray[n4].length() - StringUtilities.countEscapedChars(charSequenceArray[n4]) - 2) : ++n6;
                    ++n4;
                }
                nArray = new int[Math.min(n3, n6 * n5)];
                n4 = 0;
                int n8 = 0;
                while (n8 < nArray.length) {
                    try {
                        int n9;
                        CharSequence charSequence3 = charSequenceArray[1 + n4 / n5];
                        if (charSequence3.charAt(0) == '\"') {
                            n9 = 1;
                            while (n9 < charSequence3.length() - 1 && n8 < nArray.length) {
                                if (charSequence3.charAt(n9) == '\\') {
                                    switch (charSequence3.charAt(++n9)) {
                                        case '\"': 
                                        case '\'': 
                                        case '\\': {
                                            nArray[n8++] = charSequence3.charAt(n9);
                                            break;
                                        }
                                        case 'r': {
                                            nArray[n8++] = 13;
                                            break;
                                        }
                                        case 'n': {
                                            nArray[n8++] = 10;
                                            break;
                                        }
                                        case 't': {
                                            nArray[n8++] = 9;
                                            break;
                                        }
                                        case '0': {
                                            nArray[n8++] = 0;
                                        }
                                    }
                                } else {
                                    nArray[n8++] = charSequence3.charAt(n9) < '\u0100' ? (int)charSequence3.charAt(n9) : -1;
                                }
                                ++n9;
                            }
                            --n8;
                        } else {
                            n9 = SjasmParser.evaluateExpression(expressionEvaluator, charSequence3);
                            nArray[n8] = n9 != -1073741824 ? n9 >> 8 * (n4 & n5 - 1) & 0xFF : -1;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        nArray[n8] = -1;
                    }
                    ++n8;
                    ++n4;
                }
            }
            int n10 = n4 = n6 < 0 ? 0 : n6 * n5;
            if (n4 > 0) {
                list.add(new SjasmSourceLine(n2, n4, n, file, charSequence2, nArray));
            } else {
                list.add(new SjasmSourceLine(charSequence2));
            }
        } else if (StringUtilities.startsWithIgnoreCase(charSequenceArray[0], ".ASC")) {
            int n11 = charSequenceArray[1].length() - StringUtilities.countEscapedChars(charSequenceArray[1]) - 2;
            list.add(new SjasmSourceLine(n2, n11, n, file, charSequence2, null));
        } else {
            list.add(new SjasmSourceLine(charSequence2));
        }
    }

    private static int evaluateExpression(ExpressionEvaluator expressionEvaluator, CharSequence charSequence) {
        try {
            return expressionEvaluator.evaluate(charSequence);
        }
        catch (UnknownIdentifierException unknownIdentifierException) {
            return -1073741824;
        }
    }

    public static class ParseResult
    extends AbstractZ80ParseResult {
        private final List<Z80SourceLine> lines;
        private final SjasmPageMap pageMap;

        public ParseResult(ParsingState parsingState) {
            this.lines = parsingState.lines;
            this.pageMap = parsingState.pageMap;
        }

        @Override
        public List<Z80SourceLine> getLines() {
            return this.lines;
        }

        public SjasmPageMap getPageMap() {
            return this.pageMap;
        }

        @Override
        public AssemblerDialect getDialect() {
            return SjasmMsxDialect.getInstance();
        }
    }

    private static class ParsingState {
        SjasmPageMap pageMap = new SjasmPageMap();
        final List<Z80SourceLine> lines = new ArrayList<Z80SourceLine>();
        final File parentFile;
        File rootFile;
        final int maxPrefixLength;
        final Deque<File> includeStack = new ArrayDeque<File>();
        int prevLineNumber = -1;
        int[] prevBytePrefix;
        final Z80Assembler assembler;
        final ExpressionEvaluator expressionEvaluator;

        public ParsingState(File file, Z80Assembler z80Assembler, ExpressionEvaluator expressionEvaluator, int n) {
            this.parentFile = file.getParentFile();
            this.assembler = z80Assembler;
            this.expressionEvaluator = expressionEvaluator;
            this.maxPrefixLength = n;
        }

        public File setIncludeDepth(int n) {
            while (this.includeStack.size() > n) {
                this.includeStack.pop();
            }
            return this.includeStack.isEmpty() ? this.rootFile : this.includeStack.peek();
        }

        public void pushInclude(CharSequence charSequence) {
            this.includeStack.push(new File(this.parentFile, charSequence.toString()));
        }

        public void setRootFile(CharSequence charSequence) {
            this.rootFile = new File(this.parentFile, charSequence.toString());
        }
    }
}

