/*
 * Decompiled with CFR 0.152.
 */
package util.map;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import util.map.Map;

public class HashMap<T>
implements Map<T> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int KEY_FREE = 0;
    int[] keys;
    T[] values;
    boolean hasFreeKey;
    T freeValue;
    int size;
    private int threshold;
    private int mask;
    private final float loadFactor;
    private final T nullValue;
    private Set<Map.Entry<T>> entrySet;
    private Collection<T> valuesCollection;

    public HashMap(int n, float f, T t) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || f >= 1.0f) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        int n2 = 1;
        while (n2 < n) {
            n2 <<= 1;
        }
        this.mask = n2 - 1;
        this.loadFactor = f;
        this.nullValue = t;
        this.threshold = (int)((float)n2 * f);
        this.keys = new int[n2];
        this.values = new Object[n2];
        this.clear();
    }

    public HashMap(int n, float f) {
        this(n, f, null);
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap(Map<T> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        for (Map.Entry<T> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public HashMap(T t) {
        this(16, 0.75f, t);
    }

    public HashMap() {
        this(16, 0.75f);
    }

    private static final int hash(int n) {
        int n2 = n * -1640531527;
        return n2 ^ n2 >> 16;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(int n) {
        return this.get(n) != this.nullValue;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            int n = 0;
            while (n < this.keys.length) {
                if (this.keys[n] != 0 && this.values[n] == null) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        int n = 0;
        while (n < this.values.length) {
            if (this.keys[n] != 0 && object.equals(this.values[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public T get(int n) {
        if (n == 0) {
            return this.hasFreeKey ? this.freeValue : this.nullValue;
        }
        int n2 = HashMap.hash(n) & this.mask;
        int n3 = this.keys[n2];
        while (n3 != 0) {
            if (n3 == n) {
                return this.values[n2];
            }
            n2 = n2 + 1 & this.mask;
            n3 = this.keys[n2];
        }
        return this.nullValue;
    }

    @Override
    public T put(int n, T t) {
        if (n == 0) {
            return this.putFreeKey(t);
        }
        int n2 = HashMap.hash(n) & this.mask;
        int n3 = this.keys[n2];
        while (n3 != 0) {
            if (n3 == n) {
                T t2 = this.values[n2];
                this.values[n2] = t;
                return t2;
            }
            n2 = n2 + 1 & this.mask;
            n3 = this.keys[n2];
        }
        this.addEntry(n, t, n2);
        return null;
    }

    private final void addEntry(int n, T t, int n2) {
        this.keys[n2] = n;
        this.values[n2] = t;
        if (this.size++ >= this.threshold) {
            this.resize(this.keys.length << 1);
        }
    }

    private final T putFreeKey(T t) {
        T t2 = this.freeValue;
        if (!this.hasFreeKey) {
            ++this.size;
        }
        this.hasFreeKey = true;
        this.freeValue = t;
        return t2;
    }

    private final synchronized void resize(int n) {
        if (this.keys.length == 0x40000000) {
            return;
        }
        int[] nArray = this.keys;
        T[] TArray = this.values;
        this.keys = new int[n];
        this.values = new Object[n];
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.size = this.hasFreeKey ? 1 : 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            if (n3 != 0) {
                this.put(n3, TArray[n2]);
            }
            ++n2;
        }
    }

    @Override
    public T remove(int n) {
        if (n == 0) {
            return this.removeFreeKey();
        }
        int n2 = HashMap.hash(n) & this.mask;
        int n3 = this.keys[n2];
        while (n3 != 0) {
            if (n3 == n) {
                T t = this.values[n2];
                int n4 = n2 + 1 & this.mask;
                int n5 = this.keys[n4];
                while (n3 != 0 && n5 != 0) {
                    int n6 = HashMap.hash(n5) & this.mask;
                    if (n4 != n6 && (n2 - n6 & this.mask) < this.mask >> 1) {
                        this.keys[n2] = n5;
                        this.values[n2] = this.values[n4];
                        n2 = n4;
                        n3 = n5;
                    }
                    n4 = n4 + 1 & this.mask;
                    n5 = this.keys[n4];
                }
                this.keys[n2] = 0;
                --this.size;
                return t;
            }
            n2 = n2 + 1 & this.mask;
            n3 = this.keys[n2];
        }
        return null;
    }

    private final T removeFreeKey() {
        if (!this.hasFreeKey) {
            return null;
        }
        this.hasFreeKey = false;
        --this.size;
        return this.freeValue;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0);
        this.hasFreeKey = false;
        this.size = 0;
    }

    @Override
    public int[] keySet() {
        int[] nArray = new int[this.size];
        int n = 0;
        if (this.hasFreeKey) {
            nArray[n++] = 0;
        }
        int[] nArray2 = this.keys;
        int n2 = this.keys.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            if (n4 != 0) {
                nArray[n++] = n4;
            }
            ++n3;
        }
        return nArray;
    }

    @Override
    public BitSet keyBitSet() {
        BitSet bitSet = new BitSet();
        if (this.hasFreeKey) {
            bitSet.set(0);
        }
        int[] nArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 != 0) {
                bitSet.set(n3);
            }
            ++n2;
        }
        return bitSet;
    }

    @Override
    public Collection<T> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new Values();
        }
        return this.valuesCollection;
    }

    @Override
    public Set<Map.Entry<T>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        return this.entrySet().toString();
    }

    final class EntryIterator
    implements Iterator<Map.Entry<T>> {
        private int knownSize;
        private int cursor;
        private int counter;

        EntryIterator() {
            this.knownSize = HashMap.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.counter < HashMap.this.size;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Map.Entry<T> next() {
            if (HashMap.this.size != this.knownSize) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!HashMap.this.hasFreeKey || this.counter != 0) ** GOTO lbl9
            ++this.counter;
            return new HashMapEntry<T>(0, HashMap.this.freeValue);
lbl-1000:
            // 1 sources

            {
                ++this.cursor;
lbl9:
                // 2 sources

                ** while (HashMap.this.keys[this.cursor] == 0)
            }
lbl10:
            // 1 sources

            ++this.counter;
            var1_1 = new HashMapEntry<T>(HashMap.this.keys[this.cursor], HashMap.this.values[this.cursor]);
            ++this.cursor;
            return var1_1;
        }

        @Override
        public void remove() {
            if (HashMap.this.size != this.knownSize) {
                throw new ConcurrentModificationException();
            }
            if (this.counter >= HashMap.this.keys.length || HashMap.this.keys[this.cursor] == 0) {
                throw new IllegalStateException();
            }
            HashMap.this.keys[this.cursor] = 0;
            --HashMap.this.size;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<T>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<T>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return HashMap.this.size;
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }
    }

    public static class HashMapEntry<T>
    implements Map.Entry<T> {
        private final int key;
        private final T value;

        public HashMapEntry(int n, T t) {
            this.key = n;
            this.value = t;
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + this.value;
        }
    }

    final class Values
    extends AbstractCollection<T> {
        Values() {
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int knownSize;
                private int cursor;
                private int counter;
                {
                    this.knownSize = ((Values)Values.this).HashMap.this.size;
                }

                @Override
                public boolean hasNext() {
                    return this.counter < ((Values)Values.this).HashMap.this.size;
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public T next() {
                    if (Values.access$0((Values)Values.this).size != this.knownSize) {
                        throw new ConcurrentModificationException();
                    }
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    if (!Values.access$0((Values)Values.this).hasFreeKey || this.counter != 0) ** GOTO lbl9
                    ++this.counter;
                    return Values.access$0((Values)Values.this).freeValue;
lbl-1000:
                    // 1 sources

                    {
                        ++this.cursor;
lbl9:
                        // 2 sources

                        ** while (Values.access$0((Values)Values.this).keys[this.cursor] == 0)
                    }
lbl10:
                    // 1 sources

                    ++this.counter;
                    return Values.access$0((Values)Values.this).values[this.cursor++];
                }

                @Override
                public void remove() {
                    if (((Values)Values.this).HashMap.this.size != this.knownSize) {
                        throw new ConcurrentModificationException();
                    }
                    if (this.counter >= ((Values)Values.this).HashMap.this.keys.length || ((Values)Values.this).HashMap.this.keys[this.cursor] == 0) {
                        throw new IllegalStateException();
                    }
                    if (((Values)Values.this).HashMap.this.hasFreeKey && this.counter == 1) {
                        ((Values)Values.this).HashMap.this.hasFreeKey = false;
                    } else {
                        ((Values)Values.this).HashMap.this.keys[this.cursor] = 0;
                    }
                    --((Values)Values.this).HashMap.this.size;
                    --this.counter;
                }
            };
        }

        @Override
        public int size() {
            return HashMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return HashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }
    }
}

