/*
 * Decompiled with CFR 0.152.
 */
package platform.viewers;

import common.CheckBoxMenuItem;
import common.ScreenUtilities;
import events.AbstractEventSelectionModel;
import events.DefaultEventFilterModel;
import events.EventColorModel;
import events.EventFilterModel;
import events.EventModel;
import events.EventScreenPixelModel;
import events.EventViewer;
import events.EventViewerTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import output.PixelProvider;
import platform.Emulicious;

public class EventViewerWindow {
    static PixelProvider pixelProvider;
    private static EventViewerWindow viewer;
    final Window window;
    final EventViewerTable eventViewerTable;
    final EventViewer eventViewer;
    private final JSplitPane splitPane;
    private int prevTimestamp = -1;
    private int prevFrame = -1;
    private int prevTableFrame = -1;
    private boolean wasSameTimestamp;
    private boolean tableNeedsUpdate;
    private String eventFiltersProperty;
    private int refreshTableCounter;
    boolean paused = false;
    private final Timer refreshTimer = new Timer(16, new ActionListener(){
        private int exceptionCounter;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                EventViewerWindow.refresh();
                this.exceptionCounter = 0;
            }
            catch (RuntimeException runtimeException) {
                if (++this.exceptionCounter >= 2) {
                    throw runtimeException;
                }
                runtimeException.printStackTrace();
            }
        }
    });

    private EventViewerWindow(Window window, EventModel eventModel, boolean bl) {
        this.window = bl ? new JFrame() : new JDialog();
        final Timer timer = this.refreshTimer;
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - Event Viewer");
        this.window.setIconImages(window.getIconImages());
        this.window.setLayout(new BorderLayout());
        this.eventViewerTable = new EventViewerTable(eventModel){

            @Override
            public int getFrame() {
                if (!EventViewerWindow.this.paused) {
                    return -1;
                }
                return super.getFrame();
            }

            @Override
            protected JPopupMenu getPopupMenu() {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem("Open PC In Debugger");
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Emulicious.openVirtualAddress((this).EventViewerWindow.this.eventViewerTable.getModel().getPC(this.getFrame(), (this).EventViewerWindow.this.eventViewerTable.getSelectedEvent()));
                    }
                });
                return jPopupMenu;
            }
        };
        AbstractEventSelectionModel abstractEventSelectionModel = new AbstractEventSelectionModel(){
            private long lastScrollMillis;
            {
                EventViewerWindow.this.eventViewerTable.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        int n = listSelectionEvent.getFirstIndex();
                        while (n <= listSelectionEvent.getLastIndex()) {
                            this.fireEventSelectionChanged(n, this.isEventSelected(n));
                            ++n;
                        }
                    }
                });
            }

            @Override
            public void setEventSelected(int n, boolean bl) {
                long l;
                EventViewerWindow.this.eventViewerTable.setEventSelected(n, bl);
                if (bl && (l = System.currentTimeMillis()) - this.lastScrollMillis > 10L) {
                    EventViewerWindow.this.eventViewerTable.scrollEventToVisible(n);
                    this.lastScrollMillis = l;
                }
                this.fireEventSelectionChanged(n, bl);
            }

            @Override
            public boolean isEventSelected(int n) {
                return EventViewerWindow.this.eventViewerTable.isEventSelected(n);
            }

            @Override
            public void clearSelection() {
                EventViewerWindow.this.eventViewerTable.clearSelection();
                this.fireEventSelectionChanged(-1, false);
            }
        };
        EventScreenPixelModel eventScreenPixelModel = new EventScreenPixelModel(){

            @Override
            public void getScreenPixels(int[] nArray) {
                pixelProvider.getPixels(nArray);
            }

            @Override
            public String getPixelDescription(int n, int n2) {
                return pixelProvider.getPixelDescription(n, n2);
            }

            @Override
            public int getNumScanlines() {
                return pixelProvider.getNumScanlines();
            }

            @Override
            public int getDotsPerLine() {
                return pixelProvider.getDotsPerLine();
            }

            @Override
            public String getMode(int n, int n2) {
                return pixelProvider.getMode(n, n2);
            }
        };
        this.eventViewer = new EventViewer(eventModel, this.eventViewerTable.getFilterModel(), eventScreenPixelModel, EventViewerWindow.createColorModel(eventModel)){

            @Override
            public int getFrame() {
                return EventViewerWindow.this.eventViewerTable != null ? EventViewerWindow.this.eventViewerTable.getFrame() : super.getFrame();
            }
        };
        this.eventViewer.setIntegerScaling(Boolean.parseBoolean(Emulicious.getProperties().getProperty("EventViewerIntegerScaling")));
        this.eventViewer.setSelectionModel(abstractEventSelectionModel);
        this.eventViewerTable.setEventColorModel(this.eventViewer.getEventColorModel());
        this.splitPane = new JSplitPane(0, true, this.eventViewer, this.eventViewerTable);
        this.window.add((Component)this.splitPane, "Center");
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                timer.stop();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = this.makeMenuView();
        jMenuBar.add(jMenu);
        this.eventViewer.setScale(1.0f);
        this.window.pack();
        this.window.setMinimumSize(this.window.getSize());
        this.eventViewer.setScale(2.0f);
        this.splitPane.setDividerLocation(Math.max(this.splitPane.getDividerLocation(), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Divider", -1)));
        if (viewer == null || !viewer.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.eventViewer.setScale(2.0f);
                this.window.pack();
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(window);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(window);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private void setJMenuBar(JMenuBar jMenuBar) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setJMenuBar(jMenuBar);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setJMenuBar(jMenuBar);
        }
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    private JMenu makeMenuView() {
        JMenu jMenu = new JMenu("View");
        jMenu.setMnemonic('v');
        final CheckBoxMenuItem checkBoxMenuItem = new CheckBoxMenuItem("Always Scale to Integer Multiples", this.eventViewer.isIntegerScaling());
        checkBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EventViewerWindow.setIntegerScaling(checkBoxMenuItem.isSelected());
            }
        });
        jMenu.add(checkBoxMenuItem);
        return jMenu;
    }

    private static EventColorModel createColorModel(EventModel eventModel) {
        return new EventColorModel(eventModel){
            private final Color[] colors;
            {
                int n = 1;
                int n2 = 0;
                while (n2 < eventModel.getNumberOfEventGroups()) {
                    n += eventModel.getEventTypes(n2).length;
                    ++n2;
                }
                this.colors = new Color[n];
                this.colors[this.colors.length - 1] = Color.YELLOW.darker();
                n2 = 0;
                while (n2 < this.colors.length - 1) {
                    this.colors[n2] = new Color(n2 * 67 % 256, (n2 + 2) * 47 % 256, n2 * 29 % 256);
                    ++n2;
                }
                this.colors[eventModel.getBreakpointEventId()] = Color.RED;
                this.colors[eventModel.getExceptionEventId()] = Color.YELLOW;
            }

            @Override
            public Color getColor(int n) {
                return this.colors[n];
            }
        };
    }

    public static void setModel(EventModel eventModel) {
        if (viewer != null) {
            viewer.saveFilters();
            if (eventModel != null) {
                EventViewerWindow.viewer.eventViewerTable.setModel(eventModel);
                viewer.loadFilters();
                EventViewerWindow.viewer.eventViewer.setModel(eventModel, EventViewerWindow.viewer.eventViewerTable.getFilterModel(), EventViewerWindow.createColorModel(eventModel));
                EventViewerWindow.viewer.eventViewerTable.setEventColorModel(EventViewerWindow.viewer.eventViewer.getEventColorModel());
                EventViewerWindow.viewer.window.revalidate();
            } else {
                EventViewerWindow.close();
            }
        }
    }

    private void saveFilters() {
        EventFilterModel eventFilterModel = this.eventViewerTable.getFilterModel();
        if (eventFilterModel instanceof DefaultEventFilterModel) {
            Emulicious.getProperties().setProperty(this.eventFiltersProperty, ((DefaultEventFilterModel)eventFilterModel).toString(this.eventViewerTable.getModel()));
        }
    }

    private void loadFilters() {
        this.eventFiltersProperty = "EventViewer" + Emulicious.getEventFiltersProperty();
        EventFilterModel eventFilterModel = this.eventViewerTable.getFilterModel();
        if (eventFilterModel instanceof DefaultEventFilterModel) {
            ((DefaultEventFilterModel)eventFilterModel).updateFromString(Emulicious.getProperties().getProperty(this.eventFiltersProperty), this.eventViewerTable.getModel());
        }
    }

    static void setIntegerScaling(boolean bl) {
        if (viewer != null) {
            EventViewerWindow.viewer.eventViewer.setIntegerScaling(bl);
            Emulicious.getProperties().setProperty("EventViewerIntegerScaling", Boolean.toString(bl));
        }
    }

    public static boolean isOpen() {
        return viewer != null && viewer.isVisible();
    }

    public static void open(Window window, EventModel eventModel, boolean bl) {
        if (viewer == null) {
            viewer = new EventViewerWindow(window, eventModel, Emulicious.isUseFrames());
            viewer.loadFilters();
            viewer.setVisible(true);
        } else if (!bl) {
            viewer.setVisible(true);
        }
        if (viewer.isShowing()) {
            EventViewerWindow.viewer.refreshTimer.restart();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EventViewerWindow.refresh();
            }
        });
    }

    public static void setPixelProvider(PixelProvider pixelProvider) {
        EventViewerWindow.pixelProvider = pixelProvider;
    }

    public static void close() {
        if (viewer != null) {
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Open", "" + viewer.isVisible());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "X", "" + viewer.getX());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Y", "" + viewer.getY());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Width", "" + viewer.getWidth());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Height", "" + viewer.getHeight());
            Emulicious.getProperties().setProperty("Window" + viewer.getClass().getSimpleName() + "Divider", "" + EventViewerWindow.viewer.splitPane.getDividerLocation());
            viewer.saveFilters();
            EventViewerWindow.viewer.refreshTimer.stop();
            viewer.dispose();
            viewer = null;
        }
    }

    static void refresh() {
        if (viewer != null) {
            int n = EventViewerWindow.viewer.eventViewerTable.getFrame();
            int n2 = pixelProvider.getFrame();
            int n3 = EventViewerWindow.viewer.prevTimestamp;
            EventViewerWindow.viewer.prevTimestamp = pixelProvider.getTimestamp();
            boolean bl = n3 == EventViewerWindow.viewer.prevTimestamp;
            EventViewerWindow.viewer.paused = EventViewerWindow.viewer.paused && n2 == EventViewerWindow.viewer.prevFrame || bl && EventViewerWindow.viewer.wasSameTimestamp;
            EventViewerWindow.viewer.wasSameTimestamp = bl;
            EventViewerWindow.viewer.prevFrame = n2;
            if (EventViewerWindow.viewer.eventViewer.getHeight() < EventViewerWindow.viewer.eventViewer.getMinimumSize().height) {
                EventViewerWindow.viewer.splitPane.setDividerLocation(-1);
            }
            if (!bl || n != EventViewerWindow.viewer.prevTableFrame) {
                EventViewerWindow.viewer.eventViewer.updateImage();
                EventViewerWindow.viewer.tableNeedsUpdate = true;
            }
            EventViewerWindow.viewer.prevTableFrame = n;
            if (--EventViewerWindow.viewer.refreshTableCounter < 0) {
                if (EventViewerWindow.viewer.tableNeedsUpdate) {
                    EventViewerWindow.viewer.eventViewerTable.updateTable();
                    EventViewerWindow.viewer.tableNeedsUpdate = false;
                }
                EventViewerWindow.viewer.refreshTableCounter = 4;
            }
        }
    }
}

