/*
 * Decompiled with CFR 0.152.
 */
package platform;

import common.ImprovedTabbedPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.OverlayLayout;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class TabbedPane
extends JPanel {
    private final List<JLabel> tabbedPaneLabels = new ArrayList<JLabel>();
    private final List<List<Component>> toolBarComponents = new ArrayList<List<Component>>();
    private Font boldFont;

    public TabbedPane() {
        super(null, true);
        this.setLayout(new OverlayLayout(this));
        JToolBar jToolBar = new JToolBar(){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Border getBorder() {
                return null;
            }

            @Override
            protected void paintBorder(Graphics graphics) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        jToolBar.setFloatable(false);
        jToolBar.setOpaque(false);
        jToolBar.setBackground(null);
        jToolBar.setBorder(null);
        jToolBar.setAlignmentX(1.0f);
        jToolBar.setAlignmentY(0.0f);
        this.add(jToolBar);
        JTabbedPane jTabbedPane = new JTabbedPane(){

            @Override
            public void setUI(TabbedPaneUI tabbedPaneUI) {
                if (tabbedPaneUI instanceof BasicTabbedPaneUI) {
                    tabbedPaneUI = new ImprovedTabbedPaneUI(){

                        @Override
                        public Color getLightHighlight() {
                            return TabbedPane.this.getLightHighlight();
                        }

                        @Override
                        public Color getShadow() {
                            return TabbedPane.this.getShadow();
                        }

                        @Override
                        public Color getDarkShadow() {
                            return TabbedPane.this.getDarkShadow();
                        }

                        @Override
                        protected void paintContentBorder(Graphics graphics, int n, int n2) {
                            Color color = (Color)UIManager.getDefaults().remove("TabbedPane.contentAreaColor");
                            super.paintContentBorder(graphics, n, -1);
                            UIManager.put("TabbedPane.contentAreaColor", color);
                        }
                    };
                }
                super.setUI(tabbedPaneUI);
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                if (!(this.getUI() instanceof BasicTabbedPaneUI)) {
                    dimension.height /= 2;
                }
                return dimension;
            }

            @Override
            public Color getBackground() {
                Color color = TabbedPane.this.getBackground();
                return color != null ? color : super.getBackground();
            }

            @Override
            public Color getForeground() {
                Color color = TabbedPane.this.getForeground();
                return color != null ? color : super.getForeground();
            }

            @Override
            public Color getBackgroundAt(int n) {
                Color color = TabbedPane.this.getBackgroundAt(n);
                return color != null ? color : super.getBackgroundAt(n);
            }

            @Override
            public Color getForegroundAt(int n) {
                Color color = TabbedPane.this.getForegroundAt(n);
                return color != null ? color : super.getForegroundAt(n);
            }
        };
        jTabbedPane.setAlignmentX(1.0f);
        jTabbedPane.setAlignmentY(0.0f);
        this.add(jTabbedPane);
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TabbedPane.this.updateToolBar();
            }
        });
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    private JToolBar getToolBar() {
        if (this.getComponentCount() < 2) {
            return null;
        }
        Component component = this.getComponent(0);
        return component instanceof JToolBar ? (JToolBar)component : null;
    }

    private JTabbedPane getTabbedPane() {
        if (this.getComponentCount() < 2) {
            return null;
        }
        Component component = this.getComponent(1);
        return component instanceof JTabbedPane ? (JTabbedPane)component : null;
    }

    void updateToolBar() {
        JToolBar jToolBar = this.getToolBar();
        jToolBar.removeAll();
        int n = this.getTabbedPane().getSelectedIndex();
        if (n >= 0 && n < this.toolBarComponents.size()) {
            for (Component component : this.toolBarComponents.get(n)) {
                jToolBar.add(component);
            }
        }
        jToolBar.revalidate();
    }

    public void addTab(String string, Component component) {
        this.getTabbedPane().addTab(string, component);
        this.toolBarComponents.add(new ArrayList());
        this.tabbedPaneLabels.add(new TabbedPaneLabel(string));
    }

    public void addTab(String string, Icon icon, Component component) {
        this.getTabbedPane().addTab(string, icon, component);
        this.toolBarComponents.add(new ArrayList());
        this.tabbedPaneLabels.add(new TabbedPaneLabel(string));
    }

    public void addTab(String string, Icon icon, Component component, String string2) {
        this.getTabbedPane().addTab(string, icon, component, string2);
        this.toolBarComponents.add(new ArrayList());
        this.tabbedPaneLabels.add(new TabbedPaneLabel(string));
    }

    public void removeAllTabs() {
        this.getTabbedPane().removeAll();
        this.toolBarComponents.clear();
        this.tabbedPaneLabels.clear();
    }

    public void addToolBarComponent(int n, Component component) {
        component.setBackground(null);
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(false);
            ((JComponent)component).setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }
        if (component instanceof AbstractButton && !(component instanceof JToggleButton)) {
            ((AbstractButton)component).setBorderPainted(false);
        }
        if (component instanceof AbstractButton) {
            ((AbstractButton)component).setMargin(new Insets(0, 0, 0, 0));
        }
        this.toolBarComponents.get(n).add(component);
        if (this.getTabbedPane().getSelectedIndex() == n) {
            this.updateToolBar();
        }
    }

    public void setBold(int n, boolean bl) {
        JLabel jLabel;
        JLabel jLabel2 = jLabel = bl ? this.tabbedPaneLabels.get(n) : null;
        if (jLabel != null && jLabel.getFont() != this.boldFont) {
            jLabel.setFont(this.boldFont);
        }
        this.getTabbedPane().setTabComponentAt(n, jLabel);
    }

    public boolean hasBasicTabbedPaneUI() {
        JTabbedPane jTabbedPane = this.getTabbedPane();
        return jTabbedPane != null && jTabbedPane.getUI() instanceof BasicTabbedPaneUI;
    }

    public Color getLightHighlight() {
        return null;
    }

    public Color getShadow() {
        return null;
    }

    public Color getDarkShadow() {
        return null;
    }

    public Color getBackgroundAt(int n) {
        return null;
    }

    public Color getForegroundAt(int n) {
        return null;
    }

    public int getSelectedIndex() {
        return this.getTabbedPane().getSelectedIndex();
    }

    public void setSelectedIndex(int n) {
        this.getTabbedPane().setSelectedIndex(n);
    }

    public Component getSelectedComponent() {
        return this.getTabbedPane().getSelectedComponent();
    }

    public int getTabCount() {
        return this.getTabbedPane().getTabCount();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.getTabbedPane().addChangeListener(changeListener);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (font != null) {
            this.boldFont = font.deriveFont(1);
            if (font instanceof FontUIResource) {
                this.boldFont = new FontUIResource(this.boldFont);
            }
        }
    }

    class TabbedPaneLabel
    extends JLabel {
        public TabbedPaneLabel(String string) {
            super(string);
        }

        @Override
        public Color getForeground() {
            return TabbedPane.this.getForeground();
        }
    }
}

