/*
 * Decompiled with CFR 0.152.
 */
package msx;

import components.input.InputDevice;
import components.input.KeyInputProvider;

public class MSXKeyboard
implements InputDevice {
    private static final int[][] MATRIX = new int[][]{{55, 54, 53, 52, 51, 50, 49, 48}, {59, 93, 91, 92, 61, 45, 57, 56}, {66, 65, 514, 47, 46, 44, 192, 222}, {74, 73, 72, 71, 70, 69, 68, 67}, {82, 81, 80, 79, 78, 77, 76, 75}, {90, 89, 88, 87, 86, 85, 84, 83}, {114, 113, 112, 65406, 20, 18, 17, 16}, {10, 122, 8, 123, 9, 27, 116, 115}, {39, 40, 38, 37, 127, 155, 36, 32}, {100, 99, 98, 97, 96, 111, 107, 106}, {110, 108, 109, 105, 104, 103, 102, 101}};
    private final KeyInputProvider inputProvider;
    private final boolean[][] keyOverride = new boolean[MATRIX.length][MATRIX[0].length];
    private int line;

    public MSXKeyboard(KeyInputProvider keyInputProvider) {
        this.inputProvider = keyInputProvider;
    }

    public static int getNumberOfKeyboardLines() {
        return MATRIX.length;
    }

    public void setSelectedLine(int n) {
        this.line = n % MATRIX.length;
    }

    public int getSelectedLine() {
        return this.line;
    }

    private boolean shouldPressShift() {
        if (this.inputProvider.isKeyDown(521)) {
            return true;
        }
        if (this.inputProvider.isKeyDown(153) || this.inputProvider.isKeyDown(160)) {
            return true;
        }
        int n = 0;
        while (n < 5) {
            if (this.inputProvider.isKeyDown(117 + n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean shouldPressAlt() {
        return this.inputProvider.isKeyDown(33) || this.inputProvider.isKeyDown(34);
    }

    @Override
    public int readData(int n) {
        if (this.line >= MATRIX.length) {
            return 255;
        }
        int[] nArray = MATRIX[this.line];
        boolean[] blArray = this.keyOverride[this.line];
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            block8: {
                block7: {
                    block6: {
                        n2 <<= 1;
                        if (!(nArray[n3] >= 112 && nArray[n3] <= 116 && this.inputProvider.isKeyDown(nArray[n3] + 5) || nArray[n3] == 40 && this.inputProvider.isKeyDown(34) && !this.inputProvider.isKeyDown(18) || nArray[n3] == 38 && this.inputProvider.isKeyDown(33) && !this.inputProvider.isKeyDown(18) || nArray[n3] == 61 && this.inputProvider.isKeyDown(521) || nArray[n3] == 46 && this.inputProvider.isKeyDown(160) || nArray[n3] == 44 && this.inputProvider.isKeyDown(153)) && (nArray[n3] != 108 || !this.inputProvider.isKeyDown(266))) break block6;
                        n2 |= 0;
                        break block7;
                    }
                    if (this.inputProvider.isKeyDown(nArray[n3])) break block7;
                    if (nArray[n3] == 16 && this.shouldPressShift() || nArray[n3] == 18 && this.shouldPressAlt()) break block8;
                    n2 |= 1;
                }
                if (blArray[n3] && (n2 & 1) != 0) {
                    n2 ^= 1;
                }
            }
            ++n3;
        }
        return n2;
    }

    public void setState(long l) {
        int n = (int)(l >> 16);
        boolean[] blArray = this.keyOverride[n];
        int n2 = 0;
        while (n2 < blArray.length) {
            this.setKeyDownOverride(n, n2, (l & 1L << n2) != 0L);
            ++n2;
        }
    }

    public void setKeyDownOverride(int n, int n2, boolean bl) {
        boolean[] blArray = this.keyOverride[n];
        if (n2 >= 0 && n2 < blArray.length) {
            blArray[n2] = bl;
        }
    }
}

