/*
 * Decompiled with CFR 0.152.
 */
package dap.types;

import dap.types.Checksum;
import java.io.File;
import java.io.IOException;
import json.JSONArray;
import json.JSONObject;

public class Source
extends JSONObject {
    public Source(File file) {
        this(file.getName(), Source.tryCanonicalPath(file), 0, null, null, null, null, null);
    }

    public Source(File file, int n) {
        this(file.getName(), Source.tryCanonicalPath(file), n, null, null, null, null, null);
    }

    private static String tryCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return file.getAbsolutePath();
        }
    }

    private Source(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        this.put("name", object);
        this.put("path", object2);
        this.put("sourceReference", object3);
        this.put("presentationHint", object4);
        this.put("origin", object5);
        this.put("sources", object6);
        this.put("adapterData", object7);
        this.put("checksums", object8);
    }

    public Source(String string, String string2, int n, PresentationHit presentationHit, String string3, Source[] sourceArray, JSONObject jSONObject, Checksum[] checksumArray) {
        this((Object)string, (Object)string2, n >= 0 ? Integer.valueOf(n) : null, presentationHit != null ? presentationHit.toString().toLowerCase() : null, (Object)string3, Source.toArray(sourceArray), (Object)jSONObject, Source.toArray(checksumArray));
    }

    private Source(JSONObject jSONObject) {
        this(jSONObject.get("name"), jSONObject.get("path"), jSONObject.get("sourceReference"), jSONObject.get("presentationHint"), jSONObject.get("origin"), jSONObject.get("sources"), jSONObject.get("adapterData"), jSONObject.get("checksums"));
    }

    private static JSONArray toArray(Source[] sourceArray) {
        if (sourceArray == null) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        Source[] sourceArray2 = sourceArray;
        int n = sourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Source source = sourceArray2[n2];
            jSONArray.add(source);
            ++n2;
        }
        return jSONArray;
    }

    private static JSONArray toArray(Checksum[] checksumArray) {
        if (checksumArray == null) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        Checksum[] checksumArray2 = checksumArray;
        int n = checksumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Checksum checksum = checksumArray2[n2];
            jSONArray.add(checksum);
            ++n2;
        }
        return jSONArray;
    }

    public static Source from(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        return new Source(jSONObject);
    }

    public String getName() {
        return this.getString("name");
    }

    public String getPath() {
        return this.getString("path");
    }

    public int getSourceReference() {
        return this.getInt("sourceReference", 0);
    }

    static enum PresentationHit {
        NORMAL,
        EMPHASIZE,
        DEEMPHASIZE;

    }
}

