/*
 * Decompiled with CFR 0.152.
 */
package components.cartridge;

import components.cartridge.SMSCartridge;
import components.input.ButtonInputProvider;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import patching.IPS;
import util.io.IOUtilities;

public class GGXTerminator
extends SMSCartridge {
    private final int[] rom;
    private final int[] ram = new int[8192];
    private final ButtonInputProvider buttonInputProvider;
    private boolean cartridgeEnabled;
    private boolean cartridgeShouldEnable;
    private boolean actionMode = true;

    public GGXTerminator(String string, String string2, IPS iPS, ButtonInputProvider buttonInputProvider) throws IOException {
        super(string2, iPS);
        byte[] byArray = IOUtilities.toByteArray(new FileInputStream(string));
        this.rom = new int[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            this.rom[n] = byArray[n] & 0xFF;
            ++n;
        }
        this.buttonInputProvider = buttonInputProvider;
    }

    @Override
    public int readByte(int n, int n2) {
        if (n == 56) {
            if (this.cartridgeShouldEnable) {
                this.cartridgeEnabled = true;
                this.cartridgeShouldEnable = false;
            } else if (this.cartridgeEnabled && (this.actionMode || this.isResetButtonDown())) {
                this.cartridgeEnabled = false;
                this.cartridgeShouldEnable = true;
            }
        }
        if (this.cartridgeEnabled) {
            return super.readByte(n, n2);
        }
        if (n == 7) {
            return 0xFE | (this.isResetButtonDown() ? 0 : 1);
        }
        if (n < 8192) {
            return this.rom[n];
        }
        if (n < 16384) {
            return this.ram[n & 0x1FFF];
        }
        return super.readByte(n, n2);
    }

    public boolean isActionMode() {
        return this.actionMode;
    }

    public void setActionMode(boolean bl) {
        this.actionMode = bl;
    }

    private boolean isResetButtonDown() {
        return this.buttonInputProvider.isButtonDown(37);
    }

    @Override
    public void reset() {
        super.reset();
        if (this.ram != null) {
            Arrays.fill(this.ram, 0);
        }
        this.cartridgeShouldEnable = true;
        this.cartridgeEnabled = false;
    }

    @Override
    public void processWrite(int n, int n2, int n3) {
        if (!this.cartridgeEnabled && n >= 8192 && n < 16384) {
            this.ram[n & 0x1FFF] = n2;
        } else {
            super.processWrite(n, n2, n3);
        }
    }

    @Override
    public boolean isROMaddress(int n) {
        return this.cartridgeEnabled && super.isROMaddress(n);
    }
}

