/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class ComponentTraversalGroup {
    private final List<Component> components = new ArrayList<Component>();

    public void add(JComponent jComponent) {
        this.components.add(jComponent);
        jComponent.setFocusTraversalKeysEnabled(false);
        Set set = Collections.emptySet();
        jComponent.setFocusTraversalKeys(0, set);
        jComponent.setFocusTraversalKeys(1, set);
        jComponent.getActionMap().put("Previous", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentTraversalGroup.this.focusOtherComponentInGroup(false);
            }
        });
        jComponent.getActionMap().put("Next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentTraversalGroup.this.focusOtherComponentInGroup(true);
            }
        });
        jComponent.getActionMap().put("PreviousComponent", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentTraversalGroup.this.focusOtherComponent(false);
            }
        });
        jComponent.getActionMap().put("NextComponent", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComponentTraversalGroup.this.focusOtherComponent(true);
            }
        });
        jComponent.getInputMap(1).put(KeyStroke.getKeyStroke("UP"), "Previous");
        jComponent.getInputMap(1).put(KeyStroke.getKeyStroke("DOWN"), "Next");
        jComponent.getInputMap(1).put(KeyStroke.getKeyStroke("LEFT"), "Previous");
        jComponent.getInputMap(1).put(KeyStroke.getKeyStroke("RIGHT"), "Next");
        jComponent.getInputMap(1).put(KeyStroke.getKeyStroke("shift TAB"), "PreviousComponent");
        jComponent.getInputMap(1).put(KeyStroke.getKeyStroke("TAB"), "NextComponent");
    }

    private Component getActiveComponent() {
        for (Component component : this.components) {
            if (!component.hasFocus()) continue;
            return component;
        }
        return null;
    }

    private Component getFirstComponent() {
        return this.components.get(0);
    }

    private Component getLastComponent() {
        return this.components.get(this.components.size() - 1);
    }

    private Component getPrevComponent() {
        int n = this.components.indexOf(this.getActiveComponent());
        return n > 0 ? this.components.get(n - 1) : this.getLastComponent();
    }

    private Component getNextComponent() {
        int n = this.components.indexOf(this.getActiveComponent());
        return n < this.components.size() - 1 ? this.components.get(n + 1) : this.getFirstComponent();
    }

    private Component getFocusTransferBaseComponent(boolean bl) {
        Component component = this.getActiveComponent();
        Container container = component.getFocusCycleRootAncestor();
        if (container != null) {
            Component component2;
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            Component component3 = component2 = bl ? focusTraversalPolicy.getComponentAfter(container, this.getActiveComponent()) : focusTraversalPolicy.getComponentBefore(container, this.getActiveComponent());
            if (this.components.contains(component2)) {
                return bl ? this.getLastComponent() : this.getFirstComponent();
            }
        }
        return component;
    }

    void focusOtherComponentInGroup(boolean bl) {
        Component component;
        Component component2 = component = bl ? this.getNextComponent() : this.getPrevComponent();
        if (component != null && component != this.getActiveComponent()) {
            component.requestFocusInWindow();
        }
    }

    void focusOtherComponent(boolean bl) {
        Component component = this.getFocusTransferBaseComponent(bl);
        if (component != null) {
            if (bl) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(component);
            } else {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(component);
            }
        }
    }
}

