/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import common.ComponentWrapper;
import common.ScreenUtilities;
import expressions.UnknownVariableException;
import expressions.VariableProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;
import platform.Emulicious;
import platform.debugger.Debugger;
import platform.debugger.IsConstantException;
import platform.debugger.PlotterIcons;
import platform.plotting.ArrayPlotModel;
import platform.plotting.DynamicPlotModel;
import plotting.Plot;
import util.queue.CyclicIntBuffer;

class RAMWatchWindow {
    static final String[] TYPES = new String[]{"Signed 1 Byte", "Signed 2 Bytes", "Unsigned 1 Byte", "Unsigned 2 Bytes"};
    static final int[] TYPE_VALUES = new int[]{129, 130, 1, 2};
    static final Border RED_BORDER = BorderFactory.createLineBorder(Color.RED);
    private static RAMWatchWindow ramWatchWindow;
    private final Debugger debugger;
    private final ArrayList<Debugger.Expression> expressions = new ArrayList();
    private final ArrayList<CyclicIntBuffer> buffers = new ArrayList();
    private final ArrayList<VariableProvider> variables = new ArrayList();
    private final LinkedList<DynamicPlotModel> models = new LinkedList();
    private final LinkedList<JPanel> panels = new LinkedList();
    private final LinkedList<JPanel> rows = new LinkedList();
    private final LinkedList<JLabel> fillers = new LinkedList();
    private final JPanel buttons;
    private final JButton removeButton = new JButton(new PlotterIcons.RemoveIcon(true));
    final Window window;

    private RAMWatchWindow(Window window, Debugger debugger, boolean bl) {
        this.window = bl ? new JFrame() : new JDialog();
        this.setTitle(String.valueOf(Emulicious.TITLE) + " - RAM Watch");
        this.window.setIconImages(window.getIconImages());
        this.debugger = debugger;
        this.window.setLayout(new GridLayout(1, 1));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RAMWatchWindow.this.removePlot();
            }
        });
        this.removeButton.setDisabledIcon(new PlotterIcons.RemoveIcon(false));
        JButton jButton = new JButton(new PlotterIcons.AddIcon(true));
        jButton.setDisabledIcon(new PlotterIcons.AddIcon(false));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RAMWatchWindow.this.addPlot();
            }
        });
        this.buttons = new JPanel();
        this.buttons.add(jButton);
        this.buttons.add(this.removeButton);
        debugger.installRunActions(this.getRootPane());
        if (ramWatchWindow == null || !ramWatchWindow.isVisible()) {
            try {
                this.window.setSize(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Width"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Height"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.pack();
            }
            try {
                this.window.setLocation(Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "X"), Emulicious.getProperties().getInt("Window" + this.getClass().getSimpleName() + "Y"));
            }
            catch (NumberFormatException numberFormatException) {
                this.window.setLocationRelativeTo(window);
            }
        }
        if (ScreenUtilities.getScreenAt(this.getX(), this.getY()) == null) {
            this.window.setLocationRelativeTo(window);
        }
    }

    private void setTitle(String string) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setTitle(string);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setTitle(string);
        }
    }

    private JRootPane getRootPane() {
        if (this.window instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)this.window)).getRootPane();
        }
        return null;
    }

    void dispose() {
        this.window.dispose();
    }

    int getX() {
        return this.window.getX();
    }

    int getY() {
        return this.window.getY();
    }

    int getWidth() {
        return this.window.getWidth();
    }

    int getHeight() {
        return this.window.getHeight();
    }

    boolean isShowing() {
        return this.window.isShowing();
    }

    boolean isVisible() {
        return this.window.isVisible();
    }

    void setVisible(boolean bl) {
        this.window.setVisible(bl);
    }

    void addPlot() {
        this.addPlot(null);
    }

    private void addPlot(Debugger.Expression expression) {
        JComponent jComponent;
        final Debugger debugger = this.debugger;
        final LinkedList<DynamicPlotModel> linkedList = this.models;
        final ArrayList<Debugger.Expression> arrayList = this.expressions;
        int n = 1;
        while (linkedList.size() / n > n) {
            ++n;
        }
        final int n2 = this.panels.size();
        if (!this.rows.isEmpty()) {
            this.rows.getLast().remove(this.buttons);
            jComponent = new JLabel(" ");
            this.fillers.add((JLabel)jComponent);
            this.rows.getLast().add(jComponent);
        }
        this.window.setLayout(new GridLayout(linkedList.size() / n, n));
        jComponent = new JPanel(new BorderLayout());
        Plot plot = new Plot(new ArrayPlotModel(new int[0]));
        jComponent.add((Component)plot, "Center");
        this.panels.add((JPanel)jComponent);
        this.window.add(jComponent);
        JPanel jPanel = new JPanel(new GridLayout(3, 2));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        this.rows.add(jPanel);
        final JTextField jTextField = new JTextField(10);
        if (expression != null) {
            jTextField.setText(expression.toString());
        }
        final JComboBox<String> jComboBox = new JComboBox<String>(TYPES);
        final JTextField jTextField2 = new JTextField(10);
        final JComboBox<String> jComboBox2 = new JComboBox<String>(TYPES);
        final String[] stringArray = new String[]{" ", " "};
        final JLabel jLabel = new JLabel(" ");
        jLabel.setForeground(Color.RED);
        final CyclicIntBuffer cyclicIntBuffer = new CyclicIntBuffer(512);
        final CyclicIntBuffer cyclicIntBuffer2 = new CyclicIntBuffer(512);
        plot.setMinX(0.0);
        plot.setMinY(-128.0);
        plot.setMaxX(cyclicIntBuffer2.capacity() - 1);
        plot.setMaxY(127.0);
        final VariableProvider variableProvider = new VariableProvider(){

            @Override
            public int readValue(int n, boolean bl, boolean bl2) {
                if ((TYPE_VALUES[jComboBox.getSelectedIndex()] & 0x7F) == 2) {
                    return debugger.getVariables().readValue(n + 1, bl, bl2) << 8 | debugger.getVariables().readValue(n, bl, bl2);
                }
                return debugger.getVariables().readValue(n, bl, bl2);
            }

            @Override
            public int readLocation(String string, int n, boolean bl) throws UnknownVariableException {
                if ((TYPE_VALUES[jComboBox.getSelectedIndex()] & 0x7F) == 2) {
                    return debugger.getVariables().readLocation(string, n + 1, bl) << 8 | debugger.getVariables().readLocation(string, n, bl);
                }
                return debugger.getVariables().readLocation(string, n, bl);
            }

            @Override
            public int getBankAt(int n) {
                return debugger.getVariables().getBankAt(n);
            }

            @Override
            public long mapBank(int n, int n2) {
                return debugger.mapAddress(n, n2);
            }

            @Override
            public long getValue(String string, boolean bl) throws UnknownVariableException {
                if (string.equalsIgnoreCase("y")) {
                    return cyclicIntBuffer.get(0);
                }
                if (string.equalsIgnoreCase("x")) {
                    return cyclicIntBuffer2.get(0);
                }
                return debugger.getVariables().getValue(string, bl);
            }

            @Override
            public boolean isConstant(String string) throws UnknownVariableException {
                if (string.equalsIgnoreCase("y") || string.equalsIgnoreCase("x")) {
                    return false;
                }
                return debugger.getVariables().isConstant(string);
            }

            @Override
            public boolean isConstantRead(int n) {
                if ((TYPE_VALUES[jComboBox.getSelectedIndex()] & 0x7F) == 2) {
                    return debugger.getVariables().isConstantRead(n + 1) && debugger.getVariables().isConstantRead(n);
                }
                return debugger.getVariables().isConstantRead(n);
            }
        };
        final VariableProvider variableProvider2 = new VariableProvider(){

            @Override
            public int readValue(int n, boolean bl, boolean bl2) {
                if ((TYPE_VALUES[jComboBox2.getSelectedIndex()] & 0x7F) == 2) {
                    return debugger.getVariables().readValue(n + 1, bl, bl2) << 8 | debugger.getVariables().readValue(n, bl, bl2);
                }
                return debugger.getVariables().readValue(n, bl, bl2);
            }

            @Override
            public int readLocation(String string, int n, boolean bl) throws UnknownVariableException {
                if ((TYPE_VALUES[jComboBox2.getSelectedIndex()] & 0x7F) == 2) {
                    return debugger.getVariables().readLocation(string, n + 1, bl) << 8 | debugger.getVariables().readLocation(string, n, bl);
                }
                return debugger.getVariables().readLocation(string, n, bl);
            }

            @Override
            public int getBankAt(int n) {
                return debugger.getVariables().getBankAt(n);
            }

            @Override
            public long mapBank(int n, int n2) {
                return debugger.mapAddress(n, n2);
            }

            @Override
            public long getValue(String string, boolean bl) throws UnknownVariableException {
                if (string.equalsIgnoreCase("y")) {
                    return cyclicIntBuffer.get(0);
                }
                if (string.equalsIgnoreCase("x")) {
                    return cyclicIntBuffer2.get(0);
                }
                return debugger.getVariables().getValue(string, bl);
            }

            @Override
            public boolean isConstant(String string) throws UnknownVariableException {
                if (string.equalsIgnoreCase("y") || string.equalsIgnoreCase("x")) {
                    return false;
                }
                return debugger.getVariables().isConstant(string);
            }

            @Override
            public boolean isConstantRead(int n) {
                if ((TYPE_VALUES[jComboBox2.getSelectedIndex()] & 0x7F) == 2) {
                    return debugger.getVariables().isConstantRead(n + 1) && debugger.getVariables().isConstantRead(n);
                }
                return debugger.getVariables().isConstantRead(n);
            }
        };
        plot.setModel(this.createModel(cyclicIntBuffer, expression, cyclicIntBuffer2, null, variableProvider, variableProvider2));
        final Border border = jTextField.getBorder();
        final Border border2 = jTextField2.getBorder();
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                block4: {
                    stringArray[0] = " ";
                    jTextField.setBorder(border);
                    jLabel.setText(stringArray[1]);
                    try {
                        Debugger.Expression expression = debugger.parseExpression(jTextField.getText());
                        if (expression.isConstant(variableProvider)) {
                            throw new IsConstantException(expression.getValueString(variableProvider));
                        }
                        arrayList.set(n2 * 2, expression);
                        ((DynamicPlotModel)linkedList.get(n2)).setY(0, cyclicIntBuffer);
                    }
                    catch (Exception exception) {
                        if (n2 * 2 + 1 < arrayList.size()) {
                            arrayList.set(n2 * 2, null);
                        }
                        ((DynamicPlotModel)linkedList.get(n2)).setY(0, null);
                        if (jTextField.getText().isEmpty()) break block4;
                        stringArray[0] = "Error in Y: " + exception.getMessage();
                        jLabel.setText(stringArray[0]);
                        jTextField.setBorder(RED_BORDER);
                    }
                }
            }
        });
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((DynamicPlotModel)linkedList.get(n2)).setYtype(0, TYPE_VALUES[jComboBox.getSelectedIndex()]);
                }
                catch (Exception exception) {}
            }
        });
        jTextField2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                block4: {
                    stringArray[1] = " ";
                    jTextField2.setBorder(border2);
                    jLabel.setText(stringArray[0]);
                    try {
                        Debugger.Expression expression = debugger.parseExpression(jTextField2.getText());
                        if (expression.isConstant(variableProvider2)) {
                            throw new IsConstantException(expression.getValueString(variableProvider2));
                        }
                        arrayList.set(n2 * 2 + 1, expression);
                        ((DynamicPlotModel)linkedList.get(n2)).setX(0, cyclicIntBuffer2);
                    }
                    catch (Exception exception) {
                        if (n2 * 2 + 1 < arrayList.size()) {
                            arrayList.set(n2 * 2 + 1, null);
                        }
                        ((DynamicPlotModel)linkedList.get(n2)).setX(0, null);
                        if (jTextField2.getText().isEmpty()) break block4;
                        stringArray[1] = "Error in X: " + exception.getMessage();
                        jLabel.setText(stringArray[1]);
                        jTextField2.setBorder(RED_BORDER);
                    }
                }
            }
        });
        jComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ((DynamicPlotModel)linkedList.get(n2)).setXtype(0, TYPE_VALUES[jComboBox2.getSelectedIndex()]);
                }
                catch (Exception exception) {}
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel.add(jPanel3);
        jPanel3.add(new JLabel("Y"));
        jPanel3.add(jTextField);
        JPanel jPanel4 = new JPanel();
        jPanel.add(jPanel4);
        jPanel4.add(new JLabel("Type"));
        jPanel4.add(jComboBox);
        JPanel jPanel5 = new JPanel();
        jPanel.add(jPanel5);
        jPanel5.add(new JLabel("X"));
        jPanel5.add(jTextField2);
        jPanel4 = new JPanel();
        jPanel.add(jPanel4);
        jPanel4.add(new JLabel("Type"));
        jPanel4.add(jComboBox2);
        jPanel.add(this.buttons);
        jPanel2.add((Component)jLabel, "South");
        this.removeButton.setEnabled(linkedList.size() > 1);
        jComponent.add((Component)ComponentWrapper.wrapComponent(jPanel2), "South");
        this.window.pack();
    }

    private DynamicPlotModel createModel(CyclicIntBuffer cyclicIntBuffer, Debugger.Expression expression, CyclicIntBuffer cyclicIntBuffer2, Debugger.Expression expression2, VariableProvider variableProvider, VariableProvider variableProvider2) {
        DynamicPlotModel dynamicPlotModel = new DynamicPlotModel(expression != null ? cyclicIntBuffer : null, expression2 != null ? cyclicIntBuffer2 : null);
        this.models.add(dynamicPlotModel);
        this.expressions.add(expression);
        this.expressions.add(expression2);
        this.buffers.add(cyclicIntBuffer);
        this.buffers.add(cyclicIntBuffer2);
        this.variables.add(variableProvider);
        this.variables.add(variableProvider2);
        return dynamicPlotModel;
    }

    void removePlot() {
        if (this.models.size() > 1) {
            this.models.removeLast();
            int n = this.expressions.size();
            this.expressions.remove(n - 2);
            this.expressions.remove(n - 2);
            this.buffers.remove(n - 2);
            this.buffers.remove(n - 2);
            this.variables.remove(n - 2);
            this.variables.remove(n - 2);
            this.window.remove(this.panels.pollLast());
            this.rows.removeLast();
            this.rows.getLast().remove(this.fillers.pollLast());
            this.rows.getLast().add(this.buttons);
            int n2 = 1;
            while (this.models.size() / n2 > n2) {
                ++n2;
            }
            this.window.setLayout(new GridLayout(this.models.size() / n2, n2));
            this.removeButton.setEnabled(this.models.size() > 1);
            this.window.revalidate();
            this.window.repaint();
            this.window.pack();
        }
    }

    private void updatePlots() {
        int n = 0;
        while (n < this.expressions.size()) {
            try {
                Debugger.Expression expression = this.expressions.get(n);
                if (expression != null) {
                    this.buffers.get(n).add(this.expressions.get(n).getValue(this.variables.get(n)));
                }
            }
            catch (Exception exception) {}
            ++n;
        }
        for (DynamicPlotModel dynamicPlotModel : this.models) {
            dynamicPlotModel.firePlotModelChanged();
        }
    }

    public static void update() {
        if (ramWatchWindow != null && ramWatchWindow.isVisible()) {
            ramWatchWindow.updatePlots();
        }
    }

    public static void open(Window window, Debugger debugger, boolean bl) {
        RAMWatchWindow.open(window, debugger, null, false);
    }

    public static void open(Window window, Debugger debugger, Debugger.Expression expression, boolean bl) {
        if (ramWatchWindow == null) {
            ramWatchWindow = new RAMWatchWindow(window, debugger, Emulicious.isUseFrames());
            ramWatchWindow.addPlot(expression);
            ramWatchWindow.setVisible(true);
        } else {
            if (!bl) {
                ramWatchWindow.setVisible(true);
            }
            if (expression != null) {
                ramWatchWindow.addPlot(expression);
            }
        }
    }

    public static void close() {
        if (ramWatchWindow != null) {
            Emulicious.getProperties().setProperty("Window" + ramWatchWindow.getClass().getSimpleName() + "Open", "" + ramWatchWindow.isVisible());
            Emulicious.getProperties().setProperty("Window" + ramWatchWindow.getClass().getSimpleName() + "X", "" + ramWatchWindow.getX());
            Emulicious.getProperties().setProperty("Window" + ramWatchWindow.getClass().getSimpleName() + "Y", "" + ramWatchWindow.getY());
            Emulicious.getProperties().setProperty("Window" + ramWatchWindow.getClass().getSimpleName() + "Width", "" + ramWatchWindow.getWidth());
            Emulicious.getProperties().setProperty("Window" + ramWatchWindow.getClass().getSimpleName() + "Height", "" + ramWatchWindow.getHeight());
            ramWatchWindow.dispose();
            ramWatchWindow = null;
        }
    }
}

