/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import platform.debugger.Debugger;
import platform.debugger.OutlineElement;

public class OutlineTree
extends JPanel {
    private final Debugger debugger;
    private final JTree tree = new JTree(){

        @Override
        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (this.getCellRenderer() != null && this.getMaxIconHeight() != n - 2) {
                    try {
                        this.scaleIcons((float)(n - 2) / (float)this.getMaxDefaultIconHeight());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        private int getMaxIconHeight() {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.getCellRenderer();
            if (defaultTreeCellRenderer == null) {
                return 0;
            }
            return Math.max(this.getIconHeight(defaultTreeCellRenderer.getOpenIcon()), Math.max(this.getIconHeight(defaultTreeCellRenderer.getClosedIcon()), this.getIconHeight(defaultTreeCellRenderer.getLeafIcon())));
        }

        private int getIconHeight(Icon icon) {
            if (icon == null) {
                return 0;
            }
            return icon.getIconHeight();
        }

        private int getMaxDefaultIconHeight() {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.getCellRenderer();
            if (defaultTreeCellRenderer == null) {
                return 0;
            }
            return Math.max(this.getIconHeight(defaultTreeCellRenderer.getDefaultOpenIcon()), Math.max(this.getIconHeight(defaultTreeCellRenderer.getDefaultClosedIcon()), this.getIconHeight(defaultTreeCellRenderer.getDefaultLeafIcon())));
        }

        private Icon scaleIcon(Icon icon, float f) {
            if (icon == null || (int)((float)icon.getIconWidth() * f) >= Integer.MAX_VALUE || (int)((float)icon.getIconHeight() * f) >= Integer.MAX_VALUE) {
                return icon;
            }
            BufferedImage bufferedImage = new BufferedImage(Math.round((float)icon.getIconWidth() * f), Math.round((float)icon.getIconHeight() * f), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.scale(f, f);
            icon.paintIcon(this, graphics2D, 0, 0);
            graphics2D.dispose();
            return new ImageIcon(bufferedImage);
        }

        private void scaleIcons(float f) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.getCellRenderer();
            if (defaultTreeCellRenderer != null) {
                if (defaultTreeCellRenderer.getOpenIcon() != null) {
                    defaultTreeCellRenderer.setOpenIcon(this.scaleIcon(defaultTreeCellRenderer.getDefaultOpenIcon(), f));
                }
                if (defaultTreeCellRenderer.getClosedIcon() != null) {
                    defaultTreeCellRenderer.setClosedIcon(this.scaleIcon(defaultTreeCellRenderer.getDefaultClosedIcon(), f));
                }
                if (defaultTreeCellRenderer.getLeafIcon() != null) {
                    defaultTreeCellRenderer.setLeafIcon(this.scaleIcon(defaultTreeCellRenderer.getDefaultLeafIcon(), f));
                }
            }
        }

        @Override
        public boolean isLargeModel() {
            return true;
        }

        @Override
        public Color getForeground() {
            return OutlineTree.this.getForeground();
        }

        @Override
        public Color getBackground() {
            return OutlineTree.this.getTreeBackground();
        }

        @Override
        public Font getFont() {
            return OutlineTree.this.getFont();
        }

        @Override
        public void doLayout() {
            this.setRowHeight(this.getCellRenderer().getTreeCellRendererComponent((JTree)this, (Object)"Outline", (boolean)false, (boolean)false, (boolean)false, (int)-1, (boolean)false).getPreferredSize().height);
            super.doLayout();
        }
    };
    OutlineTreeNode root;
    boolean updatingSelection;
    private boolean codeNodesVisible = true;
    private boolean dataNodesVisible = true;

    public void selectNodeByAddress(int n) {
        this.selectNodeByAddress(this.root, n);
    }

    private boolean selectNodeByAddress(OutlineTreeNode outlineTreeNode, int n) {
        if (outlineTreeNode != this.root && outlineTreeNode.getAddress() == n) {
            this.selectNode(outlineTreeNode);
            return true;
        }
        for (OutlineTreeNode outlineTreeNode2 : outlineTreeNode.getChildren()) {
            if (!this.selectNodeByAddress(outlineTreeNode2, n)) continue;
            return true;
        }
        return false;
    }

    public void selectNodeByRow(int n) {
        this.selectNode(this.findNodeByRow(this.root, n, this.root));
    }

    private OutlineTreeNode findNodeByRow(OutlineTreeNode outlineTreeNode, int n, OutlineTreeNode outlineTreeNode2) {
        for (OutlineTreeNode outlineTreeNode3 : outlineTreeNode.getChildren()) {
            outlineTreeNode2 = this.findNodeByRow(outlineTreeNode3, n, outlineTreeNode2);
            if (outlineTreeNode2.getRow() != n) continue;
            return outlineTreeNode2;
        }
        if (n >= outlineTreeNode.getRow() && outlineTreeNode.getRow() > outlineTreeNode2.getRow()) {
            return outlineTreeNode;
        }
        return outlineTreeNode2;
    }

    private void selectNode(OutlineTreeNode outlineTreeNode) {
        this.updatingSelection = true;
        TreePath treePath = new TreePath(outlineTreeNode.getPathToRoot());
        this.tree.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
        this.updatingSelection = false;
    }

    public boolean update() {
        Object object;
        TreePath treePath = this.tree.getSelectionPath();
        this.root = new OutlineTreeNode(this.debugger.generateOutline(this.codeNodesVisible, this.dataNodesVisible));
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.setRoot(this.root);
        Object object2 = object = treePath != null ? treePath.getLastPathComponent() : null;
        if (object instanceof OutlineTreeNode) {
            this.selectNode((OutlineTreeNode)object);
        }
        this.tree.repaint();
        return true;
    }

    public void printTree() {
        OutlineTree.printTree(this.root, 0);
    }

    private static void printTree(OutlineTreeNode outlineTreeNode, int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print("  ");
            ++n2;
        }
        System.out.println(outlineTreeNode);
        for (OutlineTreeNode outlineTreeNode2 : outlineTreeNode.getChildren()) {
            OutlineTree.printTree(outlineTreeNode2, n + 1);
        }
    }

    public void setCodeNodesVisible(boolean bl) {
        this.codeNodesVisible = bl;
        this.update();
    }

    public void setDataNodesVisible(boolean bl) {
        this.dataNodesVisible = bl;
        this.update();
    }

    public Color getTreeBackground() {
        return null;
    }

    public Color getSelectionForeground() {
        return null;
    }

    public Color getSelectionBackground() {
        return null;
    }

    public OutlineTree(final Debugger debugger) {
        Object object;
        Object object2;
        this.debugger = debugger;
        this.update();
        final JTree jTree = this.tree;
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object;
                TreePath treePath;
                if (!OutlineTree.this.updatingSelection && (treePath = jTree.getSelectionPath()) != null && (object = treePath.getLastPathComponent()) != OutlineTree.this.root && object instanceof OutlineTreeNode) {
                    OutlineTreeNode outlineTreeNode = (OutlineTreeNode)object;
                    int n = outlineTreeNode.getAddress();
                    if (n >= 0) {
                        debugger.setSelectedAddress(n);
                    } else {
                        debugger.setSelectedRow(outlineTreeNode.getRow());
                    }
                }
            }
        });
        jTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    Object object;
                    TreePath treePath = jTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    jTree.setSelectionPath(treePath);
                    if (treePath != null && (object = treePath.getLastPathComponent()) != OutlineTree.this.root && object instanceof OutlineTreeNode) {
                        debugger.showPopupMenu(jTree, mouseEvent.getPoint());
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    Object object;
                    TreePath treePath = jTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    jTree.setSelectionPath(treePath);
                    if (treePath != null && (object = treePath.getLastPathComponent()) != OutlineTree.this.root && object instanceof OutlineTreeNode) {
                        debugger.showPopupMenu(jTree, mouseEvent.getPoint());
                    }
                }
            }
        });
        jTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree2, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                Component component = super.getTreeCellRendererComponent(jTree2, object, bl, bl2, bl3, n, bl4);
                if (object instanceof OutlineTreeNode && object != OutlineTree.this.root) {
                    OutlineTreeNode outlineTreeNode = (OutlineTreeNode)object;
                    this.setIcon(debugger.getDefaultIcon(this.getIcon(), bl3, outlineTreeNode.getIconChar()));
                } else if (n < 0) {
                    this.setIcon(null);
                }
                return component;
            }

            @Override
            public Color getTextSelectionColor() {
                return OutlineTree.this.getSelectionForeground();
            }

            @Override
            public Color getTextNonSelectionColor() {
                return jTree.getForeground();
            }

            @Override
            public Color getBackgroundSelectionColor() {
                return OutlineTree.this.getSelectionBackground();
            }

            @Override
            public Color getBackgroundNonSelectionColor() {
                return jTree.getBackground();
            }

            @Override
            public Font getFont() {
                return jTree.getFont();
            }
        });
        Object object3 = jTree.getActionMap().getParent().keys();
        int n = ((Object[])object3).length;
        int n2 = 0;
        while (n2 < n) {
            object2 = object3[n2];
            object = jTree.getActionMap().getParent().get(object2);
            if (object.equals(jTree.getActionForKeyStroke(KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()))) || object.equals(jTree.getActionForKeyStroke(KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())))) {
                jTree.getActionMap().getParent().remove(object2);
            }
            ++n2;
        }
        this.setLayout(new BorderLayout());
        Debugger debugger2 = debugger;
        debugger2.getClass();
        this.add((Component)debugger2.new Debugger.DebuggerScrollPane(jTree), "Center");
        object2 = new JToolBar(){

            @Override
            protected void paintBorder(Graphics graphics) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintBorder(graphics);
            }
        };
        ((JComponent)object2).setOpaque(false);
        ((JComponent)object2).setBackground(null);
        ((JToolBar)object2).setFloatable(false);
        this.add((Component)object2, "First");
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)jTree.getCellRenderer();
        Icon icon = defaultTreeCellRenderer.getClosedIcon();
        object3 = new JToggleButton(debugger.getDefaultIcon(icon, false, 'C'), true);
        ((Component)object3).setFocusable(false);
        ((JComponent)object3).setOpaque(false);
        ((JComponent)object3).setBackground(null);
        ((JComponent)object3).setToolTipText("Toggle visibility of code nodes");
        ((AbstractButton)object3).addActionListener(new ActionListener((JToggleButton)object3){
            private final /* synthetic */ JToggleButton val$code;
            {
                this.val$code = jToggleButton;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutlineTree.this.setCodeNodesVisible(this.val$code.isSelected());
            }
        });
        ((Container)object2).add((Component)object3);
        object = new JToggleButton(debugger.getDefaultIcon(icon, false, 'D'), true);
        ((Component)object).setFocusable(false);
        ((JComponent)object).setOpaque(false);
        ((JComponent)object).setBackground(null);
        ((JComponent)object).setToolTipText("Toggle visibility of data nodes");
        ((AbstractButton)object).addActionListener(new ActionListener((JToggleButton)object){
            private final /* synthetic */ JToggleButton val$data;
            {
                this.val$data = jToggleButton;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutlineTree.this.setDataNodesVisible(this.val$data.isSelected());
            }
        });
        ((Container)object2).add((Component)object);
    }

    private class OutlineTreeNode
    implements TreeNode {
        private final OutlineTreeNode parent;
        private final OutlineElement outlineElement;
        private ArrayList<OutlineTreeNode> children;

        private OutlineTreeNode(OutlineElement outlineElement, OutlineTreeNode outlineTreeNode) {
            this.parent = outlineTreeNode;
            this.outlineElement = outlineElement;
            if (outlineElement != null) {
                this.children = new ArrayList();
                for (OutlineElement outlineElement2 : outlineElement.getChildren()) {
                    this.children.add(new OutlineTreeNode(outlineElement2, this));
                }
            }
        }

        public OutlineTreeNode(OutlineElement outlineElement) {
            this(outlineElement, null);
        }

        public Enumeration<OutlineTreeNode> children() {
            return Collections.enumeration(this.getChildren());
        }

        public ArrayList<OutlineTreeNode> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList();
                for (OutlineElement outlineElement : this.outlineElement.getChildren()) {
                    this.children.add(new OutlineTreeNode(outlineElement, this));
                }
            }
            return this.children;
        }

        public int getAddress() {
            return this.outlineElement.getAddress();
        }

        public int getRow() {
            return this.outlineElement.getRow();
        }

        public char getIconChar() {
            return this.outlineElement.getIconChar();
        }

        public TreeNode[] getPathToRoot() {
            return this.getPathToRoot(this, 0);
        }

        private TreeNode[] getPathToRoot(TreeNode treeNode, int n) {
            if (treeNode == null) {
                return new TreeNode[n];
            }
            TreeNode[] treeNodeArray = this.getPathToRoot(treeNode.getParent(), ++n);
            treeNodeArray[treeNodeArray.length - n] = treeNode;
            return treeNodeArray;
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int n) {
            return this.getChildren().get(n);
        }

        @Override
        public int getChildCount() {
            return this.getChildren().size();
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            return this.getChildren().indexOf(treeNode);
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return this.getChildren().isEmpty();
        }

        public String toString() {
            if (this.parent == null) {
                return "Outline";
            }
            return this.outlineElement.toString();
        }
    }
}

