/*
 * Decompiled with CFR 0.152.
 */
package platform.debugger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OutlineElement {
    private final List<OutlineElement> children = new ArrayList<OutlineElement>();
    private final String text;
    private final int row;
    private final int address;
    private final char iconChar;

    public OutlineElement(String string, int n, int n2, char c) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("text must be a non-empty string");
        }
        this.text = string;
        this.row = n;
        this.address = n2;
        this.iconChar = c;
    }

    public OutlineElement(String string, int n, char c) {
        this(string, n, -1, c);
    }

    public OutlineElement() {
        this("Outline", -1, -1, ' ');
    }

    public List<OutlineElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(OutlineElement outlineElement) {
        if (!this.children.contains(outlineElement)) {
            this.children.add(outlineElement);
        }
    }

    public char getIconChar() {
        return this.iconChar;
    }

    public int getRow() {
        return this.row;
    }

    public int getAddress() {
        return this.address;
    }

    public String toString() {
        return this.text;
    }
}

