/*
 * Decompiled with CFR 0.152.
 */
package hexeditor;

import hexeditor.DefaultHexEditorAnnotationModel;
import hexeditor.DefaultHexEditorColorModel;
import hexeditor.DefaultHexEditorSelectionModel;
import hexeditor.DefaultHexEditorStyleModel;
import hexeditor.HexEditorAnnotationModel;
import hexeditor.HexEditorColorModel;
import hexeditor.HexEditorModel;
import hexeditor.HexEditorModelEvent;
import hexeditor.HexEditorModelListener;
import hexeditor.HexEditorSelectionEvent;
import hexeditor.HexEditorSelectionListener;
import hexeditor.HexEditorSelectionModel;
import hexeditor.HexEditorStyleModel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class HexEditor
extends JComponent
implements HexEditorModelListener,
HexEditorSelectionListener,
Scrollable {
    private static final String[] HEX_STRINGS = new String[256];
    private static final JLabel LABEL = new JLabel();
    protected HexEditorModel model;
    protected HexEditorSelectionModel selectionModel;
    protected HexEditorColorModel colorModel;
    protected HexEditorAnnotationModel annotationModel;
    protected HexEditorStyleModel styleModel;
    protected int fontHeight;
    protected int digitWidth;
    protected int fontDescent;
    protected int rowHeight;
    protected int columnWidth;
    protected int symbolWidth;
    protected Collection<String> symbols;
    protected int prevSelectedFirstRow;
    protected int prevSelectedFirstColumn;
    protected int prevSelectedLastRow;
    protected int prevSelectedLastColumn;
    protected boolean lowNybbleSelected;
    protected int selectionHiNybbleValue;
    protected boolean cursorVisible;
    protected boolean headSelection;
    protected int textStartX;
    protected boolean hideAnnotations;
    protected Font annotationFont;
    protected Color invertedForeground;
    protected final Font[] fonts = new Font[4];
    protected Timer cursorTimer = new Timer(500, new ActionListener(){
        {
            HexEditor.this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    (this).HexEditor.this.cursorTimer.stop();
                    (this).HexEditor.this.cursorVisible = true;
                    this.repaintSelection();
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    (this).HexEditor.this.cursorTimer.restart();
                    (this).HexEditor.this.cursorVisible = true;
                    this.repaintSelection();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (HexEditor.this.getFirstSelectedRow() != HexEditor.this.getLastSelectedRow() || HexEditor.this.getFirstSelectedColumn() != HexEditor.this.getLastSelectedColumn()) {
                HexEditor.this.cursorVisible = true;
            } else {
                HexEditor.this.cursorVisible = !HexEditor.this.cursorVisible;
                this.repaintSelection();
            }
        }

        protected void repaintSelection() {
            HexEditor.this.repaintRange(HexEditor.this.getFirstSelectedRow(), HexEditor.this.getFirstSelectedColumn(), HexEditor.this.getLastSelectedRow(), HexEditor.this.getLastSelectedColumn());
        }
    });

    static {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] cArray2 = new char[]{'0', '0'};
        int n = 0;
        while (n < HEX_STRINGS.length) {
            cArray2[0] = cArray[n >> 4];
            cArray2[1] = cArray[n & 0xF];
            HexEditor.HEX_STRINGS[n] = new String(cArray2);
            ++n;
        }
    }

    public HexEditor(HexEditorModel hexEditorModel) {
        this(hexEditorModel, null, null, null, null);
    }

    public HexEditor(HexEditorModel hexEditorModel, HexEditorSelectionModel hexEditorSelectionModel, HexEditorColorModel hexEditorColorModel, HexEditorAnnotationModel hexEditorAnnotationModel, HexEditorStyleModel hexEditorStyleModel) {
        if (hexEditorSelectionModel == null) {
            hexEditorSelectionModel = new DefaultHexEditorSelectionModel();
        }
        if (hexEditorColorModel == null) {
            hexEditorColorModel = new DefaultHexEditorColorModel();
        }
        if (hexEditorAnnotationModel == null) {
            hexEditorAnnotationModel = new DefaultHexEditorAnnotationModel();
        }
        if (hexEditorStyleModel == null) {
            hexEditorStyleModel = new DefaultHexEditorStyleModel();
        }
        this.setSelectionModel(hexEditorSelectionModel);
        this.setColorModel(hexEditorColorModel);
        this.setAnnotationModel(hexEditorAnnotationModel);
        this.setStyleModel(hexEditorStyleModel);
        this.setModel(hexEditorModel);
        this.setOpaque(true);
        this.setAutoscrolls(true);
        this.setFocusable(true);
        this.installListeners();
        this.updateUI();
    }

    private void installListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    Point point = mouseEvent.getPoint();
                    if (mouseEvent.isShiftDown()) {
                        HexEditor.this.setSelectionEnd(HexEditor.this.rowAtPoint(point), HexEditor.this.columnAtPoint(point));
                    } else {
                        HexEditor.this.setSelection(HexEditor.this.rowAtPoint(point), HexEditor.this.columnAtPoint(point));
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    Point point = mouseEvent.getPoint();
                    HexEditor.this.setSelectionEnd(HexEditor.this.rowAtPoint(point), HexEditor.this.columnAtPoint(point));
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if ((keyEvent.getModifiers() & ~(1 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) != 0) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 38: {
                        if (keyEvent.isShiftDown()) {
                            HexEditor.this.setSelectionEnd(HexEditor.this.getSelectedRow() - 1, HexEditor.this.getSelectedColumn());
                        } else {
                            HexEditor.this.setSelection(HexEditor.this.getSelectedRow() - 1, HexEditor.this.getSelectedColumn());
                        }
                        keyEvent.consume();
                        break;
                    }
                    case 40: {
                        if (keyEvent.isShiftDown()) {
                            HexEditor.this.setSelectionEnd(HexEditor.this.getSelectedRow() + 1, HexEditor.this.getSelectedColumn());
                        } else {
                            HexEditor.this.setSelection(HexEditor.this.getSelectedRow() + 1, HexEditor.this.getSelectedColumn());
                        }
                        keyEvent.consume();
                        break;
                    }
                    case 37: {
                        if ((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                            if (keyEvent.isShiftDown()) {
                                HexEditor.this.setSelectionEnd(HexEditor.this.getSelectedRow(), 0);
                            } else {
                                HexEditor.this.setSelection(HexEditor.this.getSelectedRow(), 0);
                            }
                        } else if (keyEvent.isShiftDown()) {
                            HexEditor.this.setSelectionEnd(HexEditor.this.getSelectedRow(), HexEditor.this.getSelectedColumn() - 1);
                        } else {
                            HexEditor.this.setSelection(HexEditor.this.getSelectedRow(), HexEditor.this.getSelectedColumn() - 1);
                        }
                        keyEvent.consume();
                        break;
                    }
                    case 39: {
                        if ((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                            if (keyEvent.isShiftDown()) {
                                HexEditor.this.setSelectionEnd(HexEditor.this.getSelectedRow(), HexEditor.this.getModel().getColumnCount(HexEditor.this.getSelectedRow()) - 1);
                            } else {
                                HexEditor.this.setSelection(HexEditor.this.getSelectedRow(), HexEditor.this.getModel().getColumnCount(HexEditor.this.getSelectedRow()) - 1);
                            }
                        } else if (keyEvent.isShiftDown()) {
                            HexEditor.this.setSelectionEnd(HexEditor.this.getSelectedRow(), HexEditor.this.getSelectedColumn() + 1);
                        } else {
                            HexEditor.this.setSelection(HexEditor.this.getSelectedRow(), HexEditor.this.getSelectedColumn() + 1);
                        }
                        keyEvent.consume();
                        break;
                    }
                    case 33: {
                        if (keyEvent.isShiftDown()) {
                            HexEditor.this.setSelectionEnd(HexEditor.this.getSelectedRow() - HexEditor.this.getVisibleRect().height / HexEditor.this.rowHeight, HexEditor.this.getSelectedColumn());
                        } else {
                            HexEditor.this.setSelection(HexEditor.this.getSelectedRow() - HexEditor.this.getVisibleRect().height / HexEditor.this.rowHeight, HexEditor.this.getSelectedColumn());
                        }
                        keyEvent.consume();
                        break;
                    }
                    case 34: {
                        if (keyEvent.isShiftDown()) {
                            HexEditor.this.setSelectionEnd(HexEditor.this.getSelectedRow() + HexEditor.this.getVisibleRect().height / HexEditor.this.rowHeight, HexEditor.this.getSelectedColumn());
                        } else {
                            HexEditor.this.setSelection(HexEditor.this.getSelectedRow() + HexEditor.this.getVisibleRect().height / HexEditor.this.rowHeight, HexEditor.this.getSelectedColumn());
                        }
                        keyEvent.consume();
                        break;
                    }
                    case 36: {
                        if ((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                            if (keyEvent.isShiftDown()) {
                                HexEditor.this.setSelectionEnd(0, 0);
                                break;
                            }
                            HexEditor.this.setSelection(0, 0);
                            break;
                        }
                        if (keyEvent.isShiftDown()) {
                            HexEditor.this.setSelectionEnd(HexEditor.this.getSelectedRow(), 0);
                            break;
                        }
                        HexEditor.this.setSelection(HexEditor.this.getSelectedRow(), 0);
                        break;
                    }
                    case 35: {
                        if ((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                            if (keyEvent.isShiftDown()) {
                                HexEditor.this.setSelectionEnd(HexEditor.this.getModel().getRowCount(), HexEditor.this.getModel().getColumnCount(HexEditor.this.getModel().getRowCount()) - 1);
                                break;
                            }
                            HexEditor.this.setSelection(HexEditor.this.getModel().getRowCount(), HexEditor.this.getModel().getColumnCount(HexEditor.this.getModel().getRowCount()) - 1);
                            break;
                        }
                        if (keyEvent.isShiftDown()) {
                            HexEditor.this.setSelectionEnd(HexEditor.this.getSelectedRow(), HexEditor.this.getModel().getColumnCount(HexEditor.this.getSelectedRow()) - 1);
                            break;
                        }
                        HexEditor.this.setSelection(HexEditor.this.getSelectedRow(), HexEditor.this.getModel().getColumnCount(HexEditor.this.getSelectedRow()) - 1);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        HexEditor.this.valueTyped(c - 48);
                        break;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        HexEditor.this.valueTyped(c - 97 + 10);
                        break;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': {
                        HexEditor.this.valueTyped(c - 65 + 10);
                    }
                }
            }
        });
    }

    protected void valueTyped(int n) {
        if (this.lowNybbleSelected) {
            int n2 = this.getFirstSelectedRow();
            while (n2 <= this.getLastSelectedRow()) {
                int n3 = n2 == this.getFirstSelectedRow() ? this.getFirstSelectedColumn() : 0;
                while (n3 <= (n2 == this.getLastSelectedRow() ? this.getLastSelectedColumn() : this.model.getColumnCount(n2) - 1)) {
                    this.model.setValueAt(this.selectionHiNybbleValue | n, n2, n3);
                    ++n3;
                }
                ++n2;
            }
            this.setSelection(this.getSelectedRow(), this.getSelectedColumn() + 1);
        } else {
            this.lowNybbleSelected = true;
            this.selectionHiNybbleValue = n << 4;
        }
        this.repaintRange(this.getFirstSelectedRow(), this.getFirstSelectedColumn(), this.getLastSelectedRow(), this.getLastSelectedColumn());
    }

    public void setCursorBlinkDelay(int n) {
        this.cursorTimer.setDelay(n);
    }

    @Override
    public void updateUI() {
        LookAndFeel.installColorsAndFont(this, "Table.background", "Table.foreground", "Table.font");
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.annotationFont = this.getFont().deriveFont((float)((int)((float)this.getFont().getSize() * 2.0f / 3.0f + 0.5f)));
        this.fontHeight = this.getFontMetrics(this.getFont()).getHeight();
        this.setRowHeight(this.fontHeight);
        this.digitWidth = this.getFontMetrics(this.getFont()).charWidth('0');
        this.updateColumnWidth();
        this.fontDescent = this.getFontMetrics(this.getFont()).getDescent();
        int n = 0;
        while (n < this.fonts.length) {
            this.fonts[n] = this.getFont().deriveFont(n);
            ++n;
        }
        this.updateSymbolWidth(this.symbols);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        color = this.getForeground();
        this.invertedForeground = new Color(color.getRGB() ^ Color.WHITE.getRGB());
    }

    private void updateColumnWidth() {
        this.setColumnWidth(this.digitWidth * 2 + (!this.hideAnnotations ? (int)((float)this.getFontMetrics(this.annotationFont).charWidth('0') * 2.5f) : this.digitWidth));
    }

    private Font getFont(int n) {
        if (n >= 0 && n < this.fonts.length) {
            return this.fonts[n];
        }
        return this.getFont();
    }

    public void setHideAnnotations(boolean bl) {
        this.hideAnnotations = bl;
        this.updateColumnWidth();
    }

    public void setModel(HexEditorModel hexEditorModel) {
        if (hexEditorModel == null) {
            throw new IllegalArgumentException("Cannot set a null HexEditorModel");
        }
        if (this.model != hexEditorModel) {
            if (this.model != null) {
                this.model.removeHexEditorModelListener(this);
            }
            this.model = hexEditorModel;
            hexEditorModel.addHexEditorModelListener(this);
            this.modelChanged(null);
        }
    }

    public void setSelectionModel(HexEditorSelectionModel hexEditorSelectionModel) {
        if (hexEditorSelectionModel == null) {
            throw new IllegalArgumentException("Cannot set a null HexEditorSelectionModel");
        }
        if (this.selectionModel != hexEditorSelectionModel) {
            if (this.selectionModel != null) {
                this.selectionModel.removeHexEditorSelectionListener(this);
            }
            this.selectionModel = hexEditorSelectionModel;
            hexEditorSelectionModel.addHexEditorSelectionListener(this);
            this.repaint();
        }
    }

    public void setColorModel(HexEditorColorModel hexEditorColorModel) {
        if (hexEditorColorModel == null) {
            throw new IllegalArgumentException("Cannot set a null HexEditorColorModel");
        }
        if (this.colorModel != hexEditorColorModel) {
            this.colorModel = hexEditorColorModel;
            this.repaint();
        }
    }

    public void setAnnotationModel(HexEditorAnnotationModel hexEditorAnnotationModel) {
        if (hexEditorAnnotationModel == null) {
            throw new IllegalArgumentException("Cannot set a null HexEditorAnnotationModel");
        }
        if (this.annotationModel != hexEditorAnnotationModel) {
            this.annotationModel = hexEditorAnnotationModel;
            this.repaint();
        }
    }

    public void setStyleModel(HexEditorStyleModel hexEditorStyleModel) {
        if (this.annotationModel == null) {
            throw new IllegalArgumentException("Cannot set a null HexEditorStyleModel");
        }
        if (this.styleModel != hexEditorStyleModel) {
            this.styleModel = hexEditorStyleModel;
            this.repaint();
        }
    }

    public HexEditorModel getModel() {
        return this.model;
    }

    public HexEditorSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setRowHeight(int n) {
        if (n < this.fontHeight) {
            throw new IllegalArgumentException("New row height less than font height");
        }
        this.rowHeight = n;
        this.resizeAndRepaint();
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setColumnWidth(int n) {
        if (n < this.digitWidth * 2) {
            throw new IllegalArgumentException("New column width less than two times digit width");
        }
        this.columnWidth = n;
        this.resizeAndRepaint();
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public void setSelection(int n, int n2) {
        if (n2 >= this.model.getColumnCount(n)) {
            if (n < this.model.getRowCount() - 1) {
                n2 = 0;
                ++n;
            } else {
                n2 = this.model.getColumnCount(n) - 1;
            }
        } else if (n2 < 0) {
            n2 = n > 0 ? this.model.getColumnCount(--n) - 1 : 0;
        }
        if (n < 0) {
            n = 0;
        } else if (n >= this.model.getRowCount()) {
            n = this.model.getRowCount() - 1;
        }
        this.lowNybbleSelected = false;
        this.selectionModel.setSelection(n, n2);
        this.requestFocusInWindow();
    }

    public void setSelectionEnd(int n, int n2) {
        if (n < 0 || this.selectionModel.isSelectionEmpty()) {
            return;
        }
        if (n < this.getFirstSelectedRow() || n == this.getFirstSelectedRow() && n2 < this.getFirstSelectedColumn()) {
            this.headSelection = true;
        } else if (n > this.getLastSelectedRow() || n == this.getLastSelectedRow() && n2 > this.getLastSelectedColumn()) {
            this.headSelection = false;
        }
        if (n2 >= this.model.getColumnCount(n)) {
            if (n < this.model.getRowCount() - 1) {
                n2 = 0;
                ++n;
            } else {
                n2 = this.model.getColumnCount(n) - 1;
            }
        } else if (n2 < 0) {
            n2 = n > 0 ? this.model.getColumnCount(--n) - 1 : 0;
        }
        if (n < 0) {
            n = 0;
        } else if (n >= this.model.getRowCount()) {
            n = this.model.getRowCount() - 1;
        }
        this.lowNybbleSelected = false;
        if (this.headSelection) {
            this.selectionModel.setSelection(n, n2, this.getLastSelectedRow(), this.getLastSelectedColumn());
        } else {
            this.selectionModel.setSelection(this.getFirstSelectedRow(), this.getFirstSelectedColumn(), n, n2);
        }
        this.requestFocusInWindow();
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
    }

    public int getSelectedRow() {
        if (this.headSelection) {
            return this.getFirstSelectedRow();
        }
        return this.getLastSelectedRow();
    }

    public int getSelectedColumn() {
        if (this.headSelection) {
            return this.getFirstSelectedColumn();
        }
        return this.getLastSelectedColumn();
    }

    public int getFirstSelectedRow() {
        return this.selectionModel.getFirstSelectedRow();
    }

    public int getLastSelectedRow() {
        return this.selectionModel.getLastSelectedRow();
    }

    public int getFirstSelectedColumn() {
        return this.selectionModel.getFirstSelectedColumn();
    }

    public int getLastSelectedColumn() {
        return this.selectionModel.getLastSelectedColumn();
    }

    public int columnAtPoint(Point point) {
        int n = this.rowAtPoint(point);
        if (n < 0) {
            return -1;
        }
        int n2 = point.x >= this.textStartX ? (point.x - this.textStartX) / this.symbolWidth : point.x / this.columnWidth;
        if (n2 < 0 || n2 >= this.model.getColumnCount(n)) {
            return -1;
        }
        return n2;
    }

    public int rowAtPoint(Point point) {
        int n = point.y / this.rowHeight;
        if (n < 0 || n >= this.model.getRowCount()) {
            return -1;
        }
        return n;
    }

    private void resizeAndRepaint() {
        this.textStartX = (int)(((float)this.model.getColumnCount(0) + 0.25f) * (float)this.columnWidth);
        this.revalidate();
        this.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.textStartX + this.model.getColumnCount(0) * this.symbolWidth, this.model.getRowCount() * this.rowHeight);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this.getPreferredSize().width, Math.min(400, this.model.getRowCount() * this.rowHeight));
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return rectangle.height - rectangle.height % this.rowHeight;
        }
        if (n == 0) {
            return rectangle.width - rectangle.width % this.columnWidth;
        }
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return this.rowHeight;
        }
        if (n == 0) {
            return this.columnWidth;
        }
        return 0;
    }

    @Override
    public void modelChanged(HexEditorModelEvent hexEditorModelEvent) {
        if (hexEditorModelEvent == null || hexEditorModelEvent.getLastRow() >= this.model.getRowCount()) {
            this.clearSelection();
            this.resizeAndRepaint();
            return;
        }
        if (hexEditorModelEvent.getFirstRow() == hexEditorModelEvent.getLastRow()) {
            this.repaint(hexEditorModelEvent.getFirstColumn() * this.columnWidth, hexEditorModelEvent.getFirstRow() * this.rowHeight, this.columnWidth * (hexEditorModelEvent.getLastColumn() - hexEditorModelEvent.getFirstColumn()), this.rowHeight);
        } else {
            this.repaint(0, hexEditorModelEvent.getFirstRow() * this.rowHeight, this.columnWidth * this.model.getColumnCount(hexEditorModelEvent.getFirstRow()), (hexEditorModelEvent.getLastRow() - hexEditorModelEvent.getFirstRow() + 1) * this.rowHeight);
        }
    }

    @Override
    public void valueChanged(HexEditorSelectionEvent hexEditorSelectionEvent) {
        int n = hexEditorSelectionEvent.getFirstColumn();
        int n2 = hexEditorSelectionEvent.getFirstRow();
        int n3 = hexEditorSelectionEvent.getLastColumn();
        int n4 = hexEditorSelectionEvent.getLastRow();
        this.repaintRange(this.prevSelectedFirstRow, this.prevSelectedFirstColumn, this.prevSelectedLastRow, this.prevSelectedLastColumn);
        this.prevSelectedFirstRow = n2;
        this.prevSelectedFirstColumn = n;
        this.prevSelectedLastRow = n4;
        this.prevSelectedLastColumn = n3;
        if (n2 >= 0 && n >= 0) {
            if (this.cursorTimer.isRunning()) {
                this.cursorTimer.restart();
            }
            this.cursorVisible = true;
            if (this.headSelection) {
                this.scrollRectToVisible(new Rectangle(n * this.columnWidth, n2 * this.rowHeight, this.columnWidth, this.rowHeight));
            } else {
                this.scrollRectToVisible(new Rectangle(n3 * this.columnWidth, n4 * this.rowHeight, this.columnWidth, this.rowHeight));
            }
            this.repaintRange(n2, n, n4, n3);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container container = this.getParent();
        while (container != null && !(container instanceof JViewport)) {
            container = container.getParent();
        }
        if (container instanceof JViewport && (container = container.getParent()) instanceof JScrollPane) {
            ((JScrollPane)container).getActionMap().getParent().remove("scrollEnd");
        }
    }

    public Rectangle getCellRect(int n, int n2) {
        return new Rectangle(n2 * this.columnWidth, n * this.rowHeight, this.columnWidth, this.rowHeight);
    }

    protected void repaintRange(int n, int n2, int n3, int n4) {
        if (n == n3) {
            this.repaint(n2 * this.columnWidth, n * this.rowHeight, this.columnWidth * (n4 - n2 + 1), this.rowHeight);
            this.repaint(this.textStartX + n2 * this.symbolWidth, n * this.rowHeight, this.symbolWidth * (n4 - n2 + 1), this.rowHeight);
        } else {
            this.repaint(0, n * this.rowHeight, this.columnWidth * this.model.getColumnCount(n), this.rowHeight * (n3 - n + 1));
            this.repaint(this.textStartX, n * this.rowHeight, this.symbolWidth * this.model.getColumnCount(n), this.rowHeight * (n3 - n + 1));
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fill(graphics2D.getClip());
        }
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.setColor(this.getForeground());
        int n3 = rectangle.y / this.rowHeight;
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = (rectangle.y + rectangle.height - 1) / this.rowHeight) >= this.model.getRowCount()) {
            n2 = this.model.getRowCount() - 1;
        }
        if ((n = rectangle.x / this.columnWidth) < 0) {
            n = 0;
        }
        int n4 = n3;
        while (n4 <= n2) {
            int n5 = (rectangle.x + rectangle.width - 1) / this.columnWidth;
            if (n5 >= this.model.getColumnCount(n4)) {
                n5 = this.model.getColumnCount(n4) - 1;
            }
            int n6 = n;
            while (n6 <= n5) {
                this.paintValue(n4, n6, graphics2D);
                if (!this.hideAnnotations) {
                    this.paintAnnotation(n4, n6, graphics2D);
                }
                ++n6;
            }
            n6 = (rectangle.x - this.textStartX) / this.symbolWidth;
            if (n6 < 0) {
                n6 = 0;
            }
            if ((n5 = (rectangle.x - this.textStartX + rectangle.width - 1) / this.symbolWidth) >= this.model.getColumnCount(n4)) {
                n5 = this.model.getColumnCount(n4) - 1;
            }
            int n7 = n6;
            while (n7 <= n5) {
                this.paintSymbol(n4, n7, graphics2D);
                ++n7;
            }
            ++n4;
        }
    }

    private void paintValue(int n, int n2, Graphics2D graphics2D) {
        Object object;
        int n3 = 0;
        if (this.styleModel.isBold(n, n2)) {
            n3 |= 1;
        }
        if (this.styleModel.isItalic(n, n2)) {
            n3 |= 2;
        }
        LABEL.setFont(this.getFont(n3));
        if (this.selectionModel.isSelected(n, n2)) {
            object = !this.lowNybbleSelected ? HEX_STRINGS[this.model.getValueAt(n, n2) & 0xFF] : HEX_STRINGS[this.selectionHiNybbleValue | this.model.getValueAt(n, n2) & 0xF];
            if (this.cursorVisible) {
                int n4 = this.getFontMetrics(LABEL.getFont()).charWidth(((String)object).charAt(0));
                if (this.lowNybbleSelected) {
                    this.drawString(graphics2D, ((String)object).substring(0, 1), n2 * this.columnWidth, n * this.rowHeight, this.colorModel.getForegroundAt(n, n2), this.colorModel.getBackgroundAt(n, n2));
                    this.drawString(graphics2D, ((String)object).substring(1), n2 * this.columnWidth + n4, n * this.rowHeight, this.colorModel.getSelectionForegroundAt(n, n2), this.colorModel.getSelectionBackgroundAt(n, n2));
                } else {
                    this.drawString(graphics2D, ((String)object).substring(0, 1), n2 * this.columnWidth, n * this.rowHeight, this.colorModel.getSelectionForegroundAt(n, n2), this.colorModel.getSelectionBackgroundAt(n, n2));
                    this.drawString(graphics2D, ((String)object).substring(1), n2 * this.columnWidth + n4, n * this.rowHeight, this.colorModel.getForegroundAt(n, n2), this.colorModel.getBackgroundAt(n, n2));
                }
            } else {
                this.drawString(graphics2D, (String)object, n2 * this.columnWidth, n * this.rowHeight, this.colorModel.getForegroundAt(n, n2), this.colorModel.getBackgroundAt(n, n2));
            }
        } else {
            this.drawString(graphics2D, HEX_STRINGS[this.model.getValueAt(n, n2) & 0xFF], n2 * this.columnWidth, n * this.rowHeight, this.colorModel.getForegroundAt(n, n2), this.colorModel.getBackgroundAt(n, n2));
        }
        object = this.colorModel.getForegroundAt(n, n2);
        graphics2D.setColor((Color)(object != null ? object : this.getForeground()));
        if (this.styleModel.isStrikedThrough(n, n2)) {
            graphics2D.drawLine(n2 * this.columnWidth, (n + 1) * this.rowHeight + 1 - this.fontHeight / 2, n2 * this.columnWidth + 2 * this.digitWidth - 1, (n + 1) * this.rowHeight + 1 - this.fontHeight / 2);
        }
        if (this.styleModel.isUnderlined(n, n2)) {
            graphics2D.drawLine(n2 * this.columnWidth, (n + 1) * this.rowHeight - 1, n2 * this.columnWidth + 2 * this.digitWidth - 1, (n + 1) * this.rowHeight - 1);
        }
    }

    private void drawString(Graphics2D graphics2D, String string, int n, int n2, Color color, Color color2) {
        if (color2 != null) {
            graphics2D.setColor(color2);
            graphics2D.fillRect(n, n2 + 1, this.digitWidth * string.length(), this.fontHeight - 1);
        }
        color = this.getForegroundOrVisibleForeground(color, color2);
        this.paintText(string, graphics2D, color, n, n2, this.columnWidth, this.fontHeight);
    }

    private Color getForegroundOrVisibleForeground(Color color, Color color2) {
        int n;
        if (color != null || color2 == null) {
            return color;
        }
        color = this.getForeground();
        int n2 = HexEditor.toGrayScale(color);
        if (Math.abs(n2 - (n = HexEditor.toGrayScale(color2))) < 100) {
            color = this.invertedForeground;
        }
        return color;
    }

    private static int toGrayScale(Color color) {
        return color.getRed() * 299 / 1000 + color.getGreen() * 587 / 1000 + color.getBlue() * 114 / 1000;
    }

    private void paintAnnotation(int n, int n2, Graphics2D graphics2D) {
        String string = this.annotationModel.getAnnotation(n, n2);
        if (string != null) {
            LABEL.setFont(this.annotationFont);
            this.paintText(string, graphics2D, null, n2 * this.columnWidth + 2 * this.digitWidth, n * this.rowHeight, this.columnWidth, this.fontHeight);
        }
    }

    private void paintSymbol(int n, int n2, Graphics2D graphics2D) {
        Color color;
        Color color2;
        int n3 = 0;
        if (this.styleModel.isBold(n, n2)) {
            n3 |= 1;
        }
        if (this.styleModel.isItalic(n, n2)) {
            n3 |= 2;
        }
        LABEL.setFont(this.getFont(n3));
        String string = this.model.getSymbolAt(n, n2);
        if (string == null) {
            string = " ";
        }
        if (string.length() == 1) {
            if (!this.getFont().canDisplay(string.charAt(0))) {
                string = ".";
            }
            if (Character.isWhitespace(string.charAt(0))) {
                string = " ";
            }
        }
        if (this.selectionModel.isSelected(n, n2) && this.cursorVisible) {
            color2 = this.colorModel.getSelectionForegroundAt(n, n2);
            color = this.colorModel.getSelectionBackgroundAt(n, n2);
        } else {
            color2 = this.colorModel.getForegroundAt(n, n2);
            color = this.colorModel.getBackgroundAt(n, n2);
        }
        this.drawSymbol(graphics2D, string, this.textStartX + n2 * this.symbolWidth, n * this.rowHeight, color2, color);
        Color color3 = this.colorModel.getForegroundAt(n, n2);
        graphics2D.setColor(color3 != null ? color3 : this.getForeground());
        if (this.styleModel.isStrikedThrough(n, n2)) {
            graphics2D.drawLine(this.textStartX + n2 * this.symbolWidth, (n + 1) * this.rowHeight + 1 - this.fontHeight / 2, this.textStartX + (n2 + 1) * this.symbolWidth - 1, (n + 1) * this.rowHeight + 1 - this.fontHeight / 2);
        }
        if (this.styleModel.isUnderlined(n, n2)) {
            graphics2D.drawLine(this.textStartX + n2 * this.symbolWidth, (n + 1) * this.rowHeight - 1, this.textStartX + (n2 + 1) * this.symbolWidth - 1, (n + 1) * this.rowHeight - 1);
        }
    }

    private void drawSymbol(Graphics2D graphics2D, String string, int n, int n2, Color color, Color color2) {
        if (color2 != null) {
            graphics2D.setColor(color2);
            graphics2D.fillRect(n, n2 + 1, this.symbolWidth, this.fontHeight - 1);
        }
        color = this.getForegroundOrVisibleForeground(color, color2);
        Font font = this.getFont();
        if (string.length() > 1) {
            try {
                LABEL.setFont(this.annotationFont);
                this.paintText(string, graphics2D, color, n + (this.symbolWidth - this.getFontMetrics(this.annotationFont).stringWidth(string)) / 2, n2, this.symbolWidth, this.fontHeight);
            }
            finally {
                LABEL.setFont(font);
            }
        } else {
            this.paintText(string, graphics2D, color, n + (this.symbolWidth - this.getFontMetrics(font).stringWidth(string)) / 2, n2, this.symbolWidth, this.fontHeight);
        }
    }

    public void updateSymbolWidth(Collection<String> collection) {
        int n = this.getFontMetrics(this.getFont()).charWidth('A');
        if (collection != null) {
            for (String string : collection) {
                int n2;
                if (string == null || (n2 = this.getFontMetrics(string.length() == 1 ? this.getFont() : this.annotationFont).stringWidth(string)) <= n) continue;
                n = n2;
            }
        }
        this.symbols = collection;
        this.symbolWidth = n;
        this.resizeAndRepaint();
    }

    private void paintText(String string, Graphics2D graphics2D, Color color, int n, int n2, int n3, int n4) {
        LABEL.setForeground(color != null ? color : this.getForeground());
        LABEL.setText(string);
        LABEL.setBounds(n, n2, n3, n4);
        graphics2D.setFont(LABEL.getFont());
        graphics2D.translate(n, n2);
        LABEL.getUI().update(graphics2D, LABEL);
        graphics2D.translate(-n, -n2);
    }

    public int[] getSelectedBytes() {
        int n;
        if (this.selectionModel.isSelectionEmpty()) {
            return new int[0];
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = this.getFirstSelectedRow();
        while (n2 <= this.getLastSelectedRow()) {
            n = n2 == this.getFirstSelectedRow() ? this.getFirstSelectedColumn() : 0;
            while (n <= (n2 == this.getLastSelectedRow() ? this.getLastSelectedColumn() : this.model.getColumnCount(n2) - 1)) {
                arrayList.add(this.model.getValueAt(n2, n));
                ++n;
            }
            ++n2;
        }
        int[] nArray = new int[arrayList.size()];
        n = 0;
        while (n < nArray.length) {
            nArray[n] = (Integer)arrayList.get(n);
            ++n;
        }
        return nArray;
    }

    public boolean canCopyToClipboard() {
        return !this.selectionModel.isSelectionEmpty();
    }

    public void copyToClipboard() {
        if (!this.canCopyToClipboard()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int[] nArray = this.getSelectedBytes();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            if (n++ >= 16) {
                stringBuilder.append('\n');
                n = 1;
            } else if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('$').append(HEX_STRINGS[n4]);
            ++n3;
        }
        final String string = stringBuilder.toString();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new Transferable(){

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.stringFlavor.equals(dataFlavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor};
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return string;
            }
        }, null);
    }

    public void copyTextToClipboard() {
        if (!this.canCopyToClipboard()) {
            return;
        }
        String string = "";
        int n = this.getFirstSelectedRow();
        while (n <= this.getLastSelectedRow()) {
            int n2 = n == this.getFirstSelectedRow() ? this.getFirstSelectedColumn() : 0;
            while (n2 <= (n == this.getLastSelectedRow() ? this.getLastSelectedColumn() : this.model.getColumnCount(n) - 1)) {
                string = String.valueOf(string) + this.model.getSymbolAt(n, n2);
                ++n2;
            }
            ++n;
        }
        final String string2 = string;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new Transferable(){

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return DataFlavor.stringFlavor.equals(dataFlavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor};
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (!this.isDataFlavorSupported(dataFlavor)) {
                    throw new UnsupportedFlavorException(dataFlavor);
                }
                return string2;
            }
        }, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canPasteFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            if (this.selectionModel.isSelectionEmpty()) return false;
            if (!clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) return false;
            String[] stringArray = ((String)clipboard.getData(DataFlavor.stringFlavor)).replaceAll("[^0-9A-Fa-f\\s]", "").split("\\s");
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return true;
                }
                try {
                    Integer.parseInt(stringArray[n], 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                ++n;
            }
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    public void pasteFromClipboard() {
        block12: {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                if (!clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) break block12;
                Object object = clipboard.getData(DataFlavor.stringFlavor);
                String string = (String)object;
                String[] stringArray = string.replaceAll("[^0-9A-Fa-f\\s]", "").split("\\s+");
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                int n = this.model.getRowCount();
                int n2 = this.getFirstSelectedRow();
                int n3 = this.getFirstSelectedColumn();
                int n4 = 0;
                while (n4 < stringArray.length) {
                    int n5 = Integer.parseInt(stringArray[n4], 16);
                    do {
                        arrayList.add(n5 & 0xFF);
                        if (++n3 < this.model.getColumnCount(n2)) continue;
                        if (++n2 >= n) {
                            --n2;
                            break;
                        }
                        n3 = 0;
                    } while ((n5 >>= 8) > 0);
                    ++n4;
                }
                if (--n3 < 0) {
                    n3 = this.model.getColumnCount(--n2) - 1;
                }
                this.selectionModel.setSelection(this.getFirstSelectedRow(), this.getFirstSelectedColumn(), n2, n3);
                n2 = this.getFirstSelectedRow();
                n3 = this.getFirstSelectedColumn();
                n4 = 0;
                while (n4 < arrayList.size()) {
                    this.model.setValueAt((Integer)arrayList.get(n4), n2, n3++);
                    if (n3 >= this.model.getColumnCount(n2)) {
                        if (++n2 >= n) break;
                        n3 = 0;
                    }
                    ++n4;
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

