/*
 * Decompiled with CFR 0.152.
 */
package filesystem;

import filesystem.File;
import filesystem.FileLastModificationTime;
import filesystem.MemoryFAT;
import filesystem.Time;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class MountFAT
extends MemoryFAT {
    private static final int[] memory;
    private final boolean supportVFAT;
    private final java.io.File mountPoint;
    private final List<PendingWrite> pendingWrites = new ArrayList<PendingWrite>();
    private final List<File> allFiles = new ArrayList<File>();
    private final RootDirectory rootDir = new RootDirectory();
    final Map<File, File> parents = new IdentityHashMap<File, File>();
    final List<File> filesToDelete = new ArrayList<File>();
    private final int[] directoryEntryBuffer = new int[32];
    final WriteBuffer dataAreaWriteBuffer;
    final ReadBuffer dataAreaReadBuffer;
    final WriteBuffer fatWriteBuffer;
    private long lastUpdateTime;

    static {
        int[] nArray = new int[32];
        nArray[0] = 235;
        nArray[1] = 254;
        nArray[2] = 144;
        nArray[3] = 67;
        nArray[4] = 65;
        nArray[5] = 76;
        nArray[6] = 73;
        nArray[7] = 78;
        nArray[8] = 68;
        nArray[9] = 82;
        nArray[10] = 79;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 1;
        nArray[16] = 2;
        nArray[17] = 112;
        nArray[19] = 160;
        nArray[20] = 5;
        nArray[21] = 249;
        nArray[22] = 3;
        nArray[24] = 9;
        nArray[26] = 2;
        nArray[30] = 24;
        nArray[31] = 254;
        memory = nArray;
    }

    public MountFAT(int n, java.io.File file) throws IOException {
        this(n, file, false);
    }

    protected MountFAT(int n, java.io.File file, boolean bl) throws IOException {
        super(n, memory);
        if (!file.exists()) {
            throw new FileNotFoundException(String.valueOf(file.getAbsolutePath()) + " does not exist.");
        }
        if (!file.isDirectory()) {
            throw new FileNotFoundException(String.valueOf(file.getAbsolutePath()) + " is no directory.");
        }
        this.mountPoint = file;
        this.supportVFAT = bl;
        this.dataAreaWriteBuffer = new WriteBuffer(this.getBytesPerCluster());
        this.dataAreaReadBuffer = new ReadBuffer(this.getBytesPerCluster());
        this.fatWriteBuffer = new WriteBuffer(this.getBytesPerLogicalSector());
        this.updateFiles(true);
    }

    public boolean updateFiles() {
        return this.updateFiles(false);
    }

    private boolean updateFiles(boolean bl) {
        this.dataAreaReadBuffer.reset();
        long l = System.currentTimeMillis();
        if (!bl && l - this.lastUpdateTime < 1000L) {
            return false;
        }
        this.lastUpdateTime = l;
        if (!bl && this.filesToDelete.isEmpty() && this.pendingWrites.isEmpty() && this.allFiles.size() == this.countFiles()) {
            return this.updateModifiedFiles();
        }
        this.finalizePendingWrites();
        this.finalizePendingDeletions();
        this.allFiles.clear();
        this.rootDir.clearChildren();
        this.parents.clear();
        this.dataAreaWriteBuffer.clear();
        this.fatWriteBuffer.clear();
        this.addFiles(this.mountPoint);
        return true;
    }

    public void finalizePendingWrites() {
        for (PendingWrite pendingWrite : this.pendingWrites) {
            try {
                this.writeFile(pendingWrite.getFile(), pendingWrite.getCluster(), pendingWrite.getSize(), pendingWrite.getAttributes());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.pendingWrites.clear();
    }

    public void finalizePendingDeletions() {
        ArrayList<File> arrayList = new ArrayList<File>(this.filesToDelete);
        this.filesToDelete.clear();
        for (File file : arrayList) {
            this.toIOfile(file).delete();
        }
    }

    private boolean updateModifiedFiles() {
        boolean bl = false;
        for (File file : this.allFiles) {
            RealFile realFile;
            if (!(file instanceof RealFile) || !(realFile = (RealFile)file).update()) continue;
            if (!realFile.exists()) {
                this.updateFiles(true);
                return true;
            }
            bl = true;
        }
        return bl;
    }

    private int countFiles() {
        return this.countFiles(this.mountPoint) - 1;
    }

    private int countFiles(java.io.File file) {
        if (!file.isDirectory()) {
            return 1;
        }
        int n = 1;
        java.io.File[] fileArray = file.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            java.io.File file2 = fileArray[n3];
            n += this.countFiles(file2);
            ++n3;
        }
        return n;
    }

    private File toFile(java.io.File file) {
        if (file == this.mountPoint) {
            return this.rootDir;
        }
        if (file.isDirectory()) {
            return new RealDirectory(file);
        }
        return new RealFile(file);
    }

    java.io.File toIOfile(File file) {
        if (file == this.rootDir) {
            return this.mountPoint;
        }
        java.io.File file2 = new java.io.File(file.getName());
        File file3 = file.getParent();
        while (file3 != null) {
            file2 = new java.io.File(new java.io.File(file3.getName()), file2.getPath());
            file3 = file3.getParent();
        }
        return new java.io.File(this.mountPoint, file2.getPath());
    }

    private void addFiles(java.io.File file) {
        this.addFiles(file, this.rootDir);
    }

    void addFiles(java.io.File file, File file2) {
        File file3 = this.toFile(file);
        this.addFile(file3, file2);
        if (file.isDirectory()) {
            java.io.File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                java.io.File file4 = fileArray[n2];
                this.addFiles(file4, file3);
                ++n2;
            }
        }
    }

    private File addFile(File file, File file2) {
        if (file == this.rootDir) {
            return file;
        }
        this.allFiles.add(file);
        if (!(file2 instanceof AbstractDirectory)) {
            throw new IllegalArgumentException("Cannot add files to " + file2);
        }
        ((AbstractDirectory)file2).addChild(file);
        return file;
    }

    void removeFiles(File file) {
        this.allFiles.remove(file);
        this.parents.remove(file);
        if (file instanceof AbstractDirectory) {
            AbstractDirectory abstractDirectory = (AbstractDirectory)file;
            for (File file2 : abstractDirectory.listFiles()) {
                this.removeFiles(file2);
            }
            abstractDirectory.clearChildren();
        }
    }

    private File createFile(String string, File file, int n) {
        java.io.File file2 = new java.io.File(this.toIOfile(file), string);
        if ((n & 0x10) != 0) {
            file2.mkdir();
        }
        return this.addFile(this.toFile(file2), file);
    }

    private void deleteFile(File file) {
        System.out.println("Deleting file: " + file);
        this.filesToDelete.add(file);
    }

    private File renameFile(File file, String string) {
        int n = this.allFiles.indexOf(file);
        if (n < 0) {
            throw new IllegalArgumentException("MountFAT failed to locate file " + file);
        }
        this.finalizePendingWrites();
        this.finalizePendingDeletions();
        java.io.File file2 = this.toIOfile(file);
        java.io.File file3 = new java.io.File(this.toIOfile(file.getParent()), string);
        if (!file2.renameTo(file3)) {
            throw new IllegalStateException("MountFAT failed to rename " + file + " to " + string);
        }
        File file4 = this.toFile(file3);
        this.allFiles.set(n, file4);
        System.out.print("Renamed file " + file);
        if (!(file.getParent() instanceof AbstractDirectory)) {
            throw new IllegalStateException("parent is " + file.getParent() + " but should be a directory.");
        }
        AbstractDirectory abstractDirectory = (AbstractDirectory)file.getParent();
        abstractDirectory.replaceChild(file, file4);
        System.out.println(" to " + file4);
        return file4;
    }

    private void writeFile(File file, int n, int n2, int n3) throws IOException {
        if (n < 2) {
            return;
        }
        for (File object : this.filesToDelete) {
            if (n != this.getClusterNumber(object)) continue;
            this.filesToDelete.remove(object);
            System.out.println("Moving file " + object + " to " + file);
            this.toIOfile(object).renameTo(this.toIOfile(file));
            return;
        }
        if (file.isDirectory()) {
            return;
        }
        if (this.getNextClusterInBuffer(n) == 0) {
            this.pendingWrites.add(new PendingWrite(file, n, n2, n3));
        } else {
            System.out.println("Writing file " + file);
            FileOutputStream fileOutputStream = new FileOutputStream(this.toIOfile(file));
            int n4 = this.getBytesPerCluster();
            while (n != -1) {
                int n5 = Math.min(n4, n2);
                this.dataAreaWriteBuffer.writeToStream(fileOutputStream, this.getAddressOfCluster(n), n5);
                n = this.getNextClusterInBuffer(n);
                n2 -= n4;
            }
            ((OutputStream)fileOutputStream).close();
        }
    }

    private int getNextClusterInBuffer(int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("There is no next cluster after a last cluster");
        }
        int n3 = this.getBitsPerFATentry();
        int n4 = n * n3;
        int n5 = n4 / 8;
        try {
            n2 = n3 == 12 ? (n4 % 8 == 4 ? this.fatWriteBuffer.readByte(n5 + 1) << 4 | this.fatWriteBuffer.readByte(n5) >> 4 : (this.fatWriteBuffer.readByte(n5 + 1) & 0xF) << 8 | this.fatWriteBuffer.readByte(n5)) : this.fatWriteBuffer.readBytes(n5, n3 / 8);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
        return (long)n2 == (1L << n3) - 1L ? -1 : n2;
    }

    @Override
    public int readByte(int n) throws IOException {
        if (n < memory.length) {
            return super.readByte(n);
        }
        if ((n -= this.getAddressOfFirstFileAllocationTable()) < 0) {
            return 0;
        }
        int n2 = this.getLogicalSectorsPerFileAllocationTable() * this.getBytesPerLogicalSector();
        int n3 = this.getNumberOfFileAllocationTables() - 1;
        while (n3 > 0) {
            if (n >= n2) {
                n -= n2;
            }
            --n3;
        }
        if (n < n2) {
            return this.readFAT(n);
        }
        n3 = this.getSizeOfRootDirectory();
        if ((n -= n2) < n3) {
            return this.readDirectoryEntry(this.rootDir, n);
        }
        return this.readDataArea(n - n3);
    }

    private int readFAT(int n) throws IOException {
        int n2 = this.getBitsPerFATentry();
        int n3 = n * 8 / n2;
        if (n2 == 12) {
            switch (n % 3) {
                case 0: {
                    return this.readNextCluster(n3) & 0xFF;
                }
                case 1: {
                    return (this.readNextCluster(n3 + 1) & 0xF) << 4 | (this.readNextCluster(n3) & 0xF00) >> 8;
                }
            }
            return (this.readNextCluster(n3) & 0xFF0) >> 4;
        }
        return this.readNextCluster(n3) >> n * 8 % n2 & 0xFF;
    }

    private int readNextCluster(int n) throws IOException {
        switch (n) {
            case 0: {
                return 0xFFFFFF9;
            }
            case 1: {
                return 0xFFFFFFF;
            }
        }
        int n2 = 2;
        if (this.getBitsPerFATentry() >= 32) {
            n2 += this.getSizeInClusters(this.rootDir);
        }
        for (File file : this.allFiles) {
            int n3 = this.getSizeInClusters(file);
            int n4 = n2 + n3 - 1;
            if (n == n4) {
                return 0xFFFFFFF;
            }
            if (n < n4) {
                return n + 1;
            }
            n2 += n3;
        }
        return 0;
    }

    private int getSizeOnDisk(File file) throws IOException {
        return this.getSizeInClusters(file) * this.getBytesPerCluster();
    }

    private int getSizeInClusters(File file) throws IOException {
        return (file.getSize() - 1) / this.getBytesPerCluster() + 1;
    }

    int readDirectoryEntry(File file, int n) throws IOException {
        if (file != this.rootDir) {
            if (n < 64) {
                if ((n & 0x1F) <= n / 32) {
                    return 46;
                }
                if ((n & 0x1F) < 11) {
                    return 32;
                }
                if ((n & 0x1F) == 11) {
                    return 16;
                }
                if ((n & 0x1E) == 26) {
                    if (n / 32 == 0) {
                        return MountFAT.getByteOfValue(this.getClusterNumber(file), n & 1);
                    }
                    if (file.getParent() == this.rootDir) {
                        return 0;
                    }
                    return MountFAT.getByteOfValue(this.getClusterNumber(file.getParent()), n & 1);
                }
                return 0;
            }
            n -= 64;
        }
        List<File> list = file.listFiles();
        for (File file2 : list) {
            int n2 = this.getSizeOfDirectoryEntry(file2) / 32 - 1 - ((n & 0xFFFFFFE0) >> 5);
            if (n2 == 0) {
                switch (n & 0x1F) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return Character.toUpperCase(MountFAT.getFilenameWithoutExtensionCharacter(file2, n & 7, ' '));
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        return Character.toUpperCase(MountFAT.getFileExtensionCharacter(file2, n & 3, ' '));
                    }
                    case 11: {
                        if (file2 instanceof VolumeLabel) {
                            return 8;
                        }
                        if (file2.isDirectory()) {
                            return 16;
                        }
                        return 32;
                    }
                    case 22: 
                    case 23: {
                        return MountFAT.getByteOfValue(MountFAT.getLastModificationTime(file2), n & 1);
                    }
                    case 24: 
                    case 25: {
                        return MountFAT.getByteOfValue(MountFAT.getLastModificationDate(file2), n & 1);
                    }
                    case 26: 
                    case 27: {
                        return MountFAT.getByteOfValue(this.getClusterNumber(file2), n & 1);
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        if (file2.isDirectory()) {
                            return 0;
                        }
                        return MountFAT.getByteOfValue(file2.getSize(), n & 3);
                    }
                }
                return 0;
            }
            if (this.supportVFAT && n2 >= 0) {
                switch (n & 0x1F) {
                    case 0: {
                        if ((n & 0xFFFFFFE0) == 0) {
                            return 0x40 | n2;
                        }
                        return n2;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        return MountFAT.getByteOfValue(MountFAT.getVFATFilenameCharacter(file2, 13 * (n2 - 1) + ((n - 1 & 0x1F) >> 1), '\uffff'), n - 1 & 1);
                    }
                    case 11: {
                        return 15;
                    }
                    case 13: {
                        return MountFAT.calcFilenameChecksum(file2);
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        return MountFAT.getByteOfValue(MountFAT.getVFATFilenameCharacter(file2, 13 * (n2 - 1) + ((n & 0x1F) >> 1) - 2, '\uffff'), n & 1);
                    }
                    case 26: {
                        return 0;
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        return MountFAT.getByteOfValue(MountFAT.getVFATFilenameCharacter(file2, 13 * (n2 - 1) + ((n & 0x1F) >> 1) - 3, '\uffff'), n & 1);
                    }
                }
                return 0;
            }
            n -= this.getSizeOfDirectoryEntry(file2);
        }
        return 0;
    }

    private int readDataArea(int n) throws IOException {
        for (File file : this.allFiles) {
            if (n < this.getSizeOnDisk(file)) {
                return file.readByte(n);
            }
            n -= this.getSizeOnDisk(file);
        }
        return 0;
    }

    private int getClusterNumber(File file) throws IOException {
        int n = 2;
        if (file == this.rootDir) {
            return n;
        }
        if (this.getBitsPerFATentry() >= 32) {
            n += this.getSizeInClusters(this.rootDir);
        }
        for (File file2 : this.allFiles) {
            if (file2 == file) {
                return n;
            }
            n += this.getSizeInClusters(file2);
        }
        throw new IllegalArgumentException(file + " is not part of this FAT.");
    }

    int getSizeOfDirectoryEntry(File file) {
        if (!this.supportVFAT) {
            return 32;
        }
        return (file.getName().length() / 13 + 2) * 32;
    }

    @Override
    public void writeByte(int n, int n2) throws IOException {
        if (n < memory.length) {
            super.writeByte(n, n2);
            return;
        }
        if ((n -= this.getAddressOfFirstFileAllocationTable()) < 0) {
            return;
        }
        int n3 = this.getLogicalSectorsPerFileAllocationTable() * this.getBytesPerLogicalSector();
        if (n < n3) {
            this.writeFAT(n, n2);
            return;
        }
        if ((n -= n3 * this.getNumberOfFileAllocationTables()) < 0) {
            return;
        }
        int n4 = this.getSizeOfRootDirectory();
        if (n < n4) {
            this.writeDirectoryEntry(this.rootDir, n, n2);
        } else {
            this.writeDataArea(n - n4, n2);
        }
    }

    private void writeFAT(int n, int n2) throws IOException {
        this.fatWriteBuffer.writeByte(n, n2);
        int n3 = this.getBytesPerLogicalSector() - 1;
        if ((n & n3) == n3 && !this.pendingWrites.isEmpty()) {
            for (PendingWrite pendingWrite : new ArrayList<PendingWrite>(this.pendingWrites)) {
                int n4 = this.getNextClusterInBuffer(pendingWrite.getCluster());
                while (n4 > 0) {
                    n4 = this.getNextClusterInBuffer(n4);
                }
                if (n4 != -1) continue;
                this.writeFile(pendingWrite.getFile(), pendingWrite.getCluster(), pendingWrite.getSize(), pendingWrite.getAttributes());
                this.pendingWrites.remove(pendingWrite);
            }
        }
    }

    void writeDirectoryEntry(File file, int n, int n2) throws IOException {
        if (file != this.rootDir) {
            n -= 64;
        }
        if (n < 0) {
            return;
        }
        this.directoryEntryBuffer[n & 0x1F] = n2;
        if ((n & 0x1F) == 31) {
            File object2 = null;
            for (File object3 : file.listFiles()) {
                int stringBuffer = this.getSizeOfDirectoryEntry(object3);
                if (n < stringBuffer) {
                    object2 = object3;
                    break;
                }
                n -= stringBuffer;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            while (n4 < 8) {
                stringBuffer.append((char)this.directoryEntryBuffer[n4]);
                ++n4;
            }
            String string = stringBuffer.toString().trim();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n3 = 8;
            while (n3 < 11) {
                stringBuffer2.append((char)this.directoryEntryBuffer[n3]);
                ++n3;
            }
            n3 = this.directoryEntryBuffer[11];
            String string2 = stringBuffer2.toString().trim();
            String string3 = (string.isEmpty() || string2.isEmpty() ? string : String.valueOf(string) + "." + string2).toLowerCase();
            int n5 = this.directoryEntryBuffer[27] << 8 | this.directoryEntryBuffer[26];
            int n6 = this.directoryEntryBuffer[31] << 24 | this.directoryEntryBuffer[30] << 16 | this.directoryEntryBuffer[29] << 8 | this.directoryEntryBuffer[28];
            if (!string3.isEmpty() && string3.charAt(0) != '\u00e5') {
                if (object2 == null) {
                    this.writeFile(this.createFile(string3, file, n3), n5, n6, n3);
                } else {
                    if (!string3.equals(object2.getName().toLowerCase())) {
                        object2 = this.renameFile(object2, string3);
                    }
                    if (n5 >= 2 && this.dataAreaWriteBuffer.contains(this.getAddressOfCluster(n5))) {
                        this.writeFile(object2, n5, n6, n3);
                    }
                }
            } else if (object2 != null) {
                this.deleteFile(object2);
            }
        }
    }

    private void writeDataArea(int n, int n2) throws IOException {
        if (n >= 0) {
            int n3 = n;
            for (File file : this.allFiles) {
                if (n3 < this.getSizeOnDisk(file)) {
                    if (!file.isDirectory()) break;
                    file.writeByte(n3, n2);
                    return;
                }
                n3 -= this.getSizeOnDisk(file);
            }
            this.dataAreaWriteBuffer.writeByte(n, n2);
        }
    }

    private static char getVFATFilenameCharacter(File file, int n, char c) {
        return MountFAT.getCharacterAt(String.valueOf(file.getName()) + '\u0000', n, c);
    }

    private static char getFilenameWithoutExtensionCharacter(File file, int n, char c) {
        int n2 = file.getName().lastIndexOf(46);
        if (n2 < 0) {
            return MountFAT.getCharacterAt(file.getName(), n, c);
        }
        return MountFAT.getCharacterAt(file.getName().substring(0, n2), n, c);
    }

    private static char getFileExtensionCharacter(File file, int n, char c) {
        int n2 = file.getName().lastIndexOf(46);
        if (n2 < 0) {
            return c;
        }
        return MountFAT.getCharacterAt(file.getName().substring(n2 + 1), n, c);
    }

    private static char getCharacterAt(String string, int n, char c) {
        if (n >= string.length()) {
            return c;
        }
        return string.charAt(n);
    }

    private static int calcFilenameChecksum(File file) {
        int n = 0;
        int n2 = 0;
        while (n2 < 8) {
            n = ((n & 1) << 7) + ((n & 0xFF) >>> 1) + Character.toUpperCase(MountFAT.getFilenameWithoutExtensionCharacter(file, n2, ' '));
            ++n2;
        }
        n2 = 8;
        while (n2 < 11) {
            n = ((n & 1) << 7) + ((n & 0xFF) >>> 1) + Character.toUpperCase(MountFAT.getFileExtensionCharacter(file, n2 & 3, ' '));
            ++n2;
        }
        return n & 0xFF;
    }

    private static int getByteOfValue(int n, int n2) {
        return n >> 8 * n2 & 0xFF;
    }

    private static int getLastModificationTime(File file) {
        Time time = file.getLastModificationTime();
        int n = (time.getHours() & 0x1F) << 11;
        return (n |= (time.getMinutes() & 0x1F) << 5) | time.getSeconds() >> 1 & 0x1F;
    }

    private static int getLastModificationDate(File file) {
        Time time = file.getLastModificationTime();
        int n = (time.getYear() - 1980 & 0x7F) << 9;
        return (n |= (time.getMonth() + 1 & 0xF) << 5) | time.getDayOfMonth() & 0x1F;
    }

    public abstract class AbstractDirectory
    implements File {
        private final List<File> children = new ArrayList<File>();

        public void addChild(File file) {
            if (file instanceof RootDirectory) {
                throw new IllegalArgumentException("Root Directory cannot be a child.");
            }
            MountFAT.this.parents.put(file, this);
            this.children.add(file);
        }

        public void replaceChild(File file, File file2) {
            int n = this.children.indexOf(file);
            if (n >= 0) {
                MountFAT.this.parents.put(file2, MountFAT.this.parents.remove(file));
                this.children.set(n, file2);
                if (file instanceof AbstractDirectory && file2 instanceof AbstractDirectory) {
                    AbstractDirectory abstractDirectory = (AbstractDirectory)file;
                    AbstractDirectory abstractDirectory2 = (AbstractDirectory)file2;
                    MountFAT.this.removeFiles(abstractDirectory);
                    abstractDirectory.children.clear();
                    MountFAT.this.addFiles(MountFAT.this.toIOfile(abstractDirectory), abstractDirectory2);
                }
            }
        }

        public void clearChildren() {
            this.children.clear();
        }

        @Override
        public final int readByte(int n) throws IOException {
            return MountFAT.this.readDirectoryEntry(this, n);
        }

        @Override
        public void writeByte(int n, int n2) throws IOException {
            MountFAT.this.writeDirectoryEntry(this, n, n2);
        }

        @Override
        public int getSize() throws IOException {
            int n = 64;
            if (MountFAT.this.supportVFAT) {
                for (File file : this.listFiles()) {
                    n += MountFAT.this.getSizeOfDirectoryEntry(file);
                }
            } else {
                n += this.listFiles().size() * 32;
            }
            return n;
        }

        @Override
        public List<File> listFiles() {
            return this.children;
        }

        @Override
        public final boolean isDirectory() {
            return true;
        }

        @Override
        public File getParent() {
            return MountFAT.this.parents.get(this);
        }

        @Override
        public int mapAddress(int n) throws IOException {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(this.getParent() != null ? this.getParent() + this.getName() : this.getName()) + "/";
        }
    }

    public abstract class AbstractFile
    implements File {
        @Override
        public final boolean isDirectory() {
            return false;
        }

        @Override
        public final List<File> listFiles() {
            return File.NO_FILES;
        }

        @Override
        public File getParent() {
            return MountFAT.this.parents.get(this);
        }

        @Override
        public int mapAddress(int n) throws IOException {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getParent() + this.getName();
        }
    }

    private class PendingWrite {
        private final File file;
        private final int cluster;
        private final int size;
        private final int attributes;

        public PendingWrite(File file, int n, int n2, int n3) {
            this.file = file;
            this.cluster = n;
            this.size = n2;
            this.attributes = n3;
        }

        public File getFile() {
            return this.file;
        }

        public int getCluster() {
            return this.cluster;
        }

        public int getSize() {
            return this.size;
        }

        public int getAttributes() {
            return this.attributes;
        }
    }

    private class ReadBuffer {
        private final byte[] data;
        private int offset;
        private File file;

        public ReadBuffer(int n) {
            this.data = new byte[n];
        }

        public int readByte(File file, java.io.File file2, int n) throws IOException {
            if (this.file == file && n >= this.offset && n < this.offset + this.data.length) {
                return this.data[n - this.offset] & 0xFF;
            }
            int n2 = n & ~(this.data.length - 1);
            FileInputStream fileInputStream = new FileInputStream(file2);
            ((InputStream)fileInputStream).skip(n2);
            ((InputStream)fileInputStream).read(this.data, 0, this.data.length);
            ((InputStream)fileInputStream).close();
            this.offset = n2;
            this.file = file;
            return this.data[n - n2] & 0xFF;
        }

        public void reset() {
            this.file = null;
        }
    }

    private class RealDirectory
    extends AbstractDirectory {
        private final java.io.File file;
        private final Time lastModificationTime;

        public RealDirectory(java.io.File file) {
            this.file = file;
            this.lastModificationTime = new FileLastModificationTime(file);
        }

        @Override
        public Time getLastModificationTime() {
            return this.lastModificationTime;
        }

        @Override
        public String getName() {
            return this.file.getName();
        }
    }

    private class RealFile
    extends AbstractFile {
        private final java.io.File file;
        private final FileLastModificationTime lastModificationTime;
        private int length;

        public RealFile(java.io.File file) {
            this.file = file;
            this.lastModificationTime = new FileLastModificationTime(file);
            this.length = (int)file.length();
        }

        @Override
        public String getName() {
            if (MountFAT.this.filesToDelete.contains(this)) {
                return String.valueOf('\u00e5') + this.file.getName().substring(1);
            }
            return this.file.getName();
        }

        @Override
        public int getSize() {
            return this.length;
        }

        public boolean exists() {
            return this.file.exists();
        }

        public boolean update() {
            if (this.lastModificationTime.update()) {
                this.length = (int)this.file.length();
                return true;
            }
            return false;
        }

        @Override
        public Time getLastModificationTime() {
            return this.lastModificationTime;
        }

        @Override
        public int readByte(int n) throws IOException {
            return MountFAT.this.dataAreaReadBuffer.readByte(this, this.file, n);
        }

        @Override
        public void writeByte(int n, int n2) {
        }
    }

    class RootDirectory
    extends AbstractDirectory {
        RootDirectory() {
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public Time getLastModificationTime() {
            throw new UnsupportedOperationException();
        }
    }

    private class VolumeLabel
    extends AbstractFile {
        private final Time lastModificationTime;

        private VolumeLabel() {
            this.lastModificationTime = new FileLastModificationTime(MountFAT.this.mountPoint);
        }

        @Override
        public String getName() {
            return MountFAT.this.mountPoint.getName();
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public int readByte(int n) {
            return 0;
        }

        @Override
        public void writeByte(int n, int n2) {
        }

        @Override
        public Time getLastModificationTime() {
            return this.lastModificationTime;
        }
    }

    private class WriteBuffer {
        private final int blockSize;
        private int offset;
        private byte[] data;
        private BitSet written = new BitSet();

        public WriteBuffer(int n) {
            this.blockSize = n;
        }

        public void writeByte(int n, int n2) {
            if (this.data == null) {
                this.data = new byte[this.blockSize];
                this.offset = n & ~(this.blockSize - 1);
            }
            this.written.set(n / this.blockSize);
            if ((n -= this.offset) < 0) {
                int n3 = (-n - 1) / this.blockSize + 1;
                byte[] byArray = this.data;
                this.data = new byte[this.data.length + n3 * this.blockSize];
                System.arraycopy(byArray, 0, this.data, n3 * this.blockSize, byArray.length);
                this.offset -= n3 * this.blockSize;
                n += n3 * this.blockSize;
            } else if (n >= this.data.length) {
                int n4 = (n - this.data.length) / this.blockSize + 1;
                byte[] byArray = this.data;
                this.data = new byte[this.data.length + n4 * this.blockSize];
                System.arraycopy(byArray, 0, this.data, 0, byArray.length);
            }
            this.data[n] = (byte)n2;
        }

        public void writeToStream(OutputStream outputStream, int n, int n2) throws IOException {
            if (this.data != null) {
                outputStream.write(this.data, n - this.offset, n2);
            }
        }

        public boolean contains(int n) {
            return this.data != null && n >= this.offset && n < this.offset + this.data.length && this.written.get(n / this.blockSize);
        }

        public int readByte(int n) {
            if (this.data == null || n < this.offset || n >= this.offset + this.data.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.data[n - this.offset] & 0xFF;
        }

        public int readBytes(int n, int n2) {
            int n3 = 0;
            while (n2-- > 0) {
                n3 = n3 << 8 | this.readByte(n + n2) & 0xFF;
            }
            return n3;
        }

        public void clear() {
            this.data = null;
            this.written.clear();
        }
    }
}

