/*
 * Decompiled with CFR 0.152.
 */
package dap.messages.requests;

import dap.messages.Request;
import dap.types.ValueFormat;
import json.JSONObject;

public class EvaluateRequest
extends Request {
    private final String expression;
    private final int frameId;
    private final Context context;
    private final ValueFormat format;

    public EvaluateRequest(JSONObject jSONObject) {
        super(jSONObject);
        JSONObject jSONObject2 = this.getArguments();
        this.expression = jSONObject2.getString("expression");
        this.frameId = jSONObject2.getInt("frameId", -1);
        String string = jSONObject2.getString("context");
        this.context = string != null ? Context.valueOf(string.toUpperCase()) : null;
        this.format = ValueFormat.from(jSONObject2.getObjectOptional("format"));
    }

    public String getExpression() {
        return this.expression;
    }

    public int getFrameId() {
        return this.frameId;
    }

    public Context getContext() {
        return this.context;
    }

    public ValueFormat getFormat() {
        return this.format;
    }

    public static enum Context {
        WATCH,
        REPL,
        HOVER,
        VARIABLES,
        CLIPBOARD;

    }
}

