/*
 * Decompiled with CFR 0.152.
 */
package dap.messages;

import dap.messages.ProtocolMessage;
import dap.messages.Request;
import json.JSONObject;

public abstract class Response
extends ProtocolMessage {
    private final int request_seq;
    private final String command;
    private final String message;

    public Response(Request request, String string) {
        this.request_seq = request.getSeq();
        this.command = request.getCommand();
        this.message = string;
    }

    @Override
    public String getType() {
        return "response";
    }

    public abstract JSONObject getBody();

    private boolean isSuccess() {
        return this.getMessage() == null;
    }

    private String getMessage() {
        return this.message;
    }

    protected static Response from(int n, JSONObject jSONObject) {
        String string = jSONObject.getString("command");
        throw new IllegalArgumentException("Unhandled response: " + string);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject jSONObject = super.toJSON();
        jSONObject.put("request_seq", this.request_seq);
        jSONObject.put("success", this.isSuccess());
        jSONObject.put("command", this.command);
        jSONObject.put("message", this.getMessage());
        jSONObject.put("body", this.getBody());
        return jSONObject;
    }
}

