/*
 * Decompiled with CFR 0.152.
 */
package components.video;

import components.video.SMS2VDP;
import components.video.TMS9918A;

public class GGVDP
extends SMS2VDP {
    private int cramLatch;

    public GGVDP() {
        super(262);
    }

    public boolean isSmsMode() {
        return false;
    }

    @Override
    protected int makeModeBits() {
        if (this.isSmsMode()) {
            return 0x10 | super.makeModeBits();
        }
        return super.makeModeBits();
    }

    @Override
    public int getModeBits() {
        return super.getModeBits() & 0xF;
    }

    @Override
    public int getColorBlue(int n) {
        if (this.isSmsMode()) {
            return super.getColorBlue(n);
        }
        return (this.cram[n] & 0xF00) >> 8;
    }

    @Override
    public int getColorGreen(int n) {
        if (this.isSmsMode()) {
            return super.getColorGreen(n);
        }
        return (this.cram[n] & 0xF0) >> 4;
    }

    @Override
    public int getColorRed(int n) {
        if (this.isSmsMode()) {
            return super.getColorRed(n);
        }
        return this.cram[n] & 0xF;
    }

    @Override
    public int getColorMaxIntensity() {
        if (this.isSmsMode()) {
            return super.getColorMaxIntensity();
        }
        return 15;
    }

    @Override
    public boolean isSyncEnabled() {
        return false;
    }

    @Override
    protected void cramWrite(int n, int n2) {
        if (this.isSmsMode()) {
            super.cramWrite(n, n2);
        } else if ((n & 1) != 0) {
            this.cramLatch = n2 << 8 | this.cramLatch & 0xFF;
            boolean bl = this.cram[(n & 0x3F) >> 1] != this.cramLatch;
            this.fireOutputAvailable(0x110002, n2 << 8 | n & 0x3F);
            this.cram[(n & 0x3F) >> 1] = this.cramLatch;
            this.fireOutputAvailable(0x110003, bl ? 0x20 | (n & 0x3F) >> 1 : (n & 0x3F) >> 1);
            this.regAddress = this.regAddress + 1 & 0x3FFF;
        } else {
            this.fireOutputAvailable(0x110002, n2 << 8 | n & 0x3F);
            this.cramLatch = this.cramLatch & 0xFF00 | n2;
            this.regAddress = this.regAddress + 1 & 0x3FFF;
        }
    }

    @Override
    public TMS9918A.State getState() {
        final TMS9918A.State state = super.getState();
        return new TMS9918A.UnmodifiableState(){

            @Override
            public TMS9918A.State clone() {
                return new StateClone(this);
            }

            @Override
            public int getTimer() {
                return state.getTimer();
            }

            @Override
            public int getReg(int n) {
                return state.getReg(n);
            }

            @Override
            public int[] getCram() {
                return state.getCram();
            }

            @Override
            public int[] getVram() {
                return state.getVram();
            }

            @Override
            public boolean isHiByteNext() {
                return state.isHiByteNext();
            }

            @Override
            public int getLine() {
                return state.getLine();
            }

            @Override
            public int getRegAddress() {
                return state.getRegAddress();
            }

            @Override
            public int getRegStatus() {
                return state.getRegStatus();
            }

            @Override
            public int getRegCode() {
                return state.getRegCode();
            }

            @Override
            public int getBuffer() {
                return state.getBuffer();
            }

            @Override
            public int getCounter() {
                return state.getCounter();
            }

            @Override
            public boolean isLineInterruptPending() {
                return state.isLineInterruptPending();
            }

            @Override
            public int getCramLatch() {
                return GGVDP.this.cramLatch;
            }
        };
    }

    @Override
    public void setState(TMS9918A.State state, boolean bl) {
        super.setState(state, bl);
        this.cramLatch = state.getCramLatch();
    }

    private static class StateClone
    extends TMS9918A.StateClone {
        private final int cramLatch;

        public StateClone(TMS9918A.State state) {
            super(state);
            this.cramLatch = state.getCramLatch();
        }

        @Override
        public TMS9918A.State clone() {
            return new StateClone(this);
        }

        @Override
        public int getCramLatch() {
            return this.cramLatch;
        }
    }
}

