/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class AutoCompleteBox<E extends Comparable<? super E>>
extends JComboBox<E> {
    public AutoCompleteBox(Collection<E> collection) {
        super(AutoCompleteBox.asSortedVector(collection));
        final JTextComponent jTextComponent = this.getEditorComponent();
        this.setEditable(true);
        this.setSelectedItem(null);
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                String string = AutoCompleteBox.this.getText();
                int n = jTextComponent.getCaretPosition();
                String string2 = string.toUpperCase();
                Object object = AutoCompleteBox.this.getSelectedItem();
                if (object != null && object.toString().toUpperCase().startsWith(string2)) {
                    return;
                }
                int n2 = 0;
                while (n2 < AutoCompleteBox.this.getItemCount()) {
                    Comparable comparable = (Comparable)AutoCompleteBox.this.getItemAt(n2);
                    if (comparable.toString().toUpperCase().startsWith(string2)) {
                        AutoCompleteBox.this.setSelectedItem(comparable);
                        return;
                    }
                    ++n2;
                }
                AutoCompleteBox.this.setSelectedItem(null);
                jTextComponent.setText(string);
                jTextComponent.setCaretPosition(n);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        jTextComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AutoCompleteBox.this.selectAll();
            }
        });
        jTextComponent.setFocusTraversalKeysEnabled(false);
        jTextComponent.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "MaximumMatch");
        jTextComponent.getActionMap().put("MaximumMatch", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AutoCompleteBox.this.getSelectedItem() == null) {
                    return;
                }
                int n = AutoCompleteBox.this.getSelectedIndex() + 1;
                if (n >= AutoCompleteBox.this.getItemCount()) {
                    return;
                }
                String string = AutoCompleteBox.this.getText().toUpperCase();
                String string2 = string.substring(0, jTextComponent.getSelectionStart());
                Comparable comparable = (Comparable)AutoCompleteBox.this.getItemAt(n);
                String string3 = comparable.toString().toUpperCase();
                int n2 = string.length();
                if (string3.startsWith(string2)) {
                    int n3 = string2.length();
                    while (n3 < string3.length()) {
                        if (string3.charAt(n3) != string.charAt(n3)) {
                            n2 = n3;
                            break;
                        }
                        ++n3;
                    }
                }
                jTextComponent.moveCaretPosition(n2);
            }
        });
        jTextComponent.setDocument(new PlainDocument(){
            private boolean replacing;
            private boolean triggeringPopup;

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                super.insertString(n, string, attributeSet);
                if (!this.triggeringPopup && AutoCompleteBox.this.isDisplayable()) {
                    this.triggeringPopup = true;
                    AutoCompleteBox.this.showPopup();
                    this.triggeringPopup = false;
                    Object object = AutoCompleteBox.this.getSelectedItem();
                    if (object != null) {
                        this.setText(object.toString());
                        jTextComponent.setCaretPosition(this.getLength());
                        jTextComponent.moveCaretPosition(n + string.length());
                    } else {
                        AutoCompleteBox.this.hidePopup();
                    }
                }
                AutoCompleteBox.this.fireInsertUpdate(n, string.length());
            }

            @Override
            public void remove(int n, int n2) throws BadLocationException {
                if (this.replacing || !AutoCompleteBox.this.isDisplayable()) {
                    super.remove(n, n2);
                    return;
                }
                if (n2 < this.getLength()) {
                    int n3 = jTextComponent.getSelectionEnd() > jTextComponent.getSelectionStart() ? n - 1 : n;
                    String string = this.getText(0, this.getLength());
                    int n4 = jTextComponent.getCaretPosition();
                    String string2 = this.getText(0, n3);
                    super.remove(0, this.getLength());
                    if (n3 > 0) {
                        super.insertString(0, string2.substring(0, n3 - 1), null);
                        this.insertString(this.getLength(), string2.substring(n3 - 1), null);
                        if (!AutoCompleteBox.this.isPopupVisible()) {
                            this.setText(string);
                            jTextComponent.setCaretPosition(n4);
                            super.remove(n, n2);
                        }
                    } else {
                        AutoCompleteBox.this.hidePopup();
                        AutoCompleteBox.this.setSelectedItem(null);
                        if (n != 1 || n2 != string.length() - n) {
                            this.setText(string);
                            jTextComponent.setCaretPosition(n4);
                            super.remove(n, n2);
                        }
                    }
                } else {
                    super.remove(n, n2);
                    AutoCompleteBox.this.hidePopup();
                    AutoCompleteBox.this.setSelectedItem(null);
                }
                AutoCompleteBox.this.fireRemoveUpdate(n, n2);
            }

            @Override
            public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                this.replacing = true;
                super.replace(n, n2, string, attributeSet);
                this.replacing = false;
            }

            private void setText(String string) throws BadLocationException {
                super.remove(0, this.getLength());
                super.insertString(0, string, null);
            }
        });
    }

    private static <T extends Comparable<? super T>> Vector<T> asSortedVector(Collection<T> collection) {
        if (collection instanceof SortedSet) {
            return new Vector<T>(collection);
        }
        Vector<T> vector = new Vector<T>(collection);
        Collections.sort(vector);
        return vector;
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.listenerList.add(DocumentListener.class, documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.listenerList.remove(DocumentListener.class, documentListener);
    }

    public DocumentListener[] getDocumentListeners() {
        return (DocumentListener[])this.listenerList.getListeners(DocumentListener.class);
    }

    public void fireInsertUpdate(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        DocumentEvent documentEvent = null;
        int n3 = objectArray.length - 2;
        while (n3 >= 0) {
            if (objectArray[n3] == DocumentListener.class) {
                if (documentEvent == null) {
                    documentEvent = this.createDocumentEvent(n, n2, DocumentEvent.EventType.INSERT);
                }
                ((DocumentListener)objectArray[n3 + 1]).insertUpdate(documentEvent);
            }
            n3 -= 2;
        }
    }

    public void fireRemoveUpdate(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        DocumentEvent documentEvent = null;
        int n3 = objectArray.length - 2;
        while (n3 >= 0) {
            if (objectArray[n3] == DocumentListener.class) {
                if (documentEvent == null) {
                    documentEvent = this.createDocumentEvent(n, n2, DocumentEvent.EventType.REMOVE);
                }
                ((DocumentListener)objectArray[n3 + 1]).removeUpdate(documentEvent);
            }
            n3 -= 2;
        }
    }

    private DocumentEvent createDocumentEvent(final int n, final int n2, final DocumentEvent.EventType eventType) {
        return new DocumentEvent(){

            @Override
            public DocumentEvent.EventType getType() {
                return eventType;
            }

            @Override
            public int getOffset() {
                return n;
            }

            @Override
            public int getLength() {
                return n2;
            }

            @Override
            public Document getDocument() {
                return AutoCompleteBox.this.getEditorComponent().getDocument();
            }

            @Override
            public DocumentEvent.ElementChange getChange(Element element) {
                return null;
            }
        };
    }

    public String getText() {
        return this.getEditorComponent().getText();
    }

    public void selectAll() {
        this.getEditorComponent().selectAll();
    }

    public Document getDocument() {
        return this.getEditorComponent().getDocument();
    }

    protected JTextComponent getEditorComponent() {
        return (JTextComponent)this.getEditor().getEditorComponent();
    }

    @Override
    public void setEditor(ComboBoxEditor comboBoxEditor) {
        if (this.getEditor() != null) {
            throw new UnsupportedOperationException("The editor of an AutoCompleteBox must not be changed.");
        }
        super.setEditor(comboBoxEditor);
    }
}

