/*
 * Decompiled with CFR 0.152.
 */
package disassembler;

import disassembler.Address;

public class Value {
    public static final Value ZERO = new Value(0);
    public static final Value ONE = new Value(1){

        @Override
        public int getOffset() {
            return 1;
        }
    };
    public static final Value TWO = new Value(2);
    private static final Address NO_SOURCE = null;
    private static final Value UNKNOWN_BYTE = new Unknown(NO_SOURCE, 255);
    protected final int min;
    protected final int max;
    protected final int multiplier;
    protected final Address source;

    protected Value(int n, int n2, int n3, Address address) {
        if (n3 < 1) {
            throw new IllegalArgumentException("multiplier must not be negative.");
        }
        if (n3 > n2) {
            n3 = 1;
        }
        this.min = n;
        this.max = n2;
        this.multiplier = n3;
        this.source = address;
    }

    public Value(int n, Address address) {
        this(n, n, 1, address);
    }

    public Value(int n) {
        this(n, NO_SOURCE);
    }

    public Value add(Value value) {
        int n = this.multiplier;
        if (this.isUnique() && n < value.multiplier || value.isUnique() && value.multiplier < n) {
            n = value.multiplier;
        }
        if (this.source != null && this.source.equals(value.source)) {
            return this.newValue(this.min + value.min, this.max + value.max, n + value.multiplier);
        }
        return new Value(this.min + value.min, this.max + value.max, n, Address.combine(this.source, value.source));
    }

    public Value add(int n) {
        return this.newValue(this.min + n, this.max + n, n % this.multiplier != 0 ? 1 : this.multiplier);
    }

    public Value adc(Value value) {
        if (this.source != null && this.source.equals(value.source)) {
            return this.newValue(this.min + value.min, this.max + value.max + 1, this.multiplier + value.multiplier);
        }
        return this.newValue(this.min + value.min, this.max + value.max + 1);
    }

    public Value adc(int n) {
        return this.newValue(this.min + n, this.max + n + 1, n % this.multiplier != 0 ? 1 : this.multiplier);
    }

    public Value sub(Value value) {
        if (this.source != null && this.source.equals(value.source)) {
            if (this.max - value.max < this.min - value.min) {
                return this.newValue(this.min - value.min, this.min - value.min + 1, 1);
            }
            return this.newValue(this.min - value.min, this.max - value.max, 1);
        }
        return this.newValue(this.min - value.max, this.max - value.min, 1);
    }

    public Value sub(int n) {
        return this.newValue(this.min - n, this.max - n, n % this.multiplier != 0 ? 1 : this.multiplier);
    }

    public Value and(Value value) {
        if (value instanceof Unknown) {
            return value.and(this);
        }
        int n = value.getMin();
        int n2 = value.getMin();
        while (n2 <= value.getMax() && n > 0) {
            n &= n2;
            ++n2;
        }
        n2 = value.getMax() >> 1;
        int n3 = 0;
        while (n3 < 32 && n2 < value.getMax()) {
            n2 |= 1 << n3;
            ++n3;
        }
        return this.newValue(this.min & n, this.max & n2);
    }

    public Value and(int n) {
        int n2 = this.multiplier;
        while ((n2 & n) == 0 && n2 < 256) {
            n2 <<= 1;
        }
        return this.newValue(this.min & n, this.max & n, n2);
    }

    public Value bound(int n, int n2) {
        return this.newValue(Math.max(n, this.min), Math.min(n2, this.max) & n2);
    }

    public Value xor(Value value) {
        if (this.equals(value)) {
            return ZERO;
        }
        if (value instanceof Unknown) {
            return value.xor(this);
        }
        return this.newValue(this.min ^ value.min, this.max ^ value.max, 1);
    }

    public Value xor(int n) {
        return this.newValue(this.min ^ n, this.max ^ n, 1);
    }

    public Value or(Value value) {
        if (value instanceof Unknown) {
            return value.or(this);
        }
        return this.newValue(this.min | value.min, this.max | value.max, 1);
    }

    public Value or(int n) {
        return this.newValue(this.min | n, this.max | n, 1);
    }

    public Value inc() {
        return this.inc(false);
    }

    public Value inc(boolean bl) {
        if (bl) {
            return this.newValue(this.min, this.max + 1);
        }
        return this.newValue(this.min + 1, this.max + 1);
    }

    public Value dec() {
        return this.newValue(this.min - 1, this.max - 1);
    }

    public Value neg() {
        return this.newValue(-this.max, -this.min);
    }

    public Value resBit(int n) {
        return this.newValue(this.min & ~(1 << n), this.max & ~(1 << n));
    }

    public Value setBit(int n) {
        return this.newValue(this.min | 1 << n, this.max | 1 << n);
    }

    public Value rlc() {
        return this.newValue(this.min << 1 | this.min >> 7, this.max << 1 | this.max >> 7, 1);
    }

    public Value rrc() {
        return this.newValue(this.min >> 1, (this.max & 1) << 7 | this.max >> 1, Math.max(1, this.multiplier >> 1));
    }

    public Value rl() {
        return this.newValue(this.min << 1, this.max << 1 | 1, 1);
    }

    public Value rr() {
        return this.newValue(this.min >> 1, 0x80 | this.max >> 1, Math.max(1, this.multiplier >> 1));
    }

    public Value sla() {
        return this.add(this);
    }

    public Value sra() {
        return this.newValue(this.min & 0x80 | this.min >> 1, this.max & 0x80 | this.max >> 1, Math.max(1, this.multiplier >> 1));
    }

    public Value sll() {
        return this.sla();
    }

    public Value srl() {
        return this.srl(1);
    }

    public Value srl(int n) {
        return this.newValue(this.min >> n, this.max >> n, Math.max(1, this.multiplier >> n));
    }

    public Value swap() {
        if (this.isUnique()) {
            return this.newValue((this.min & 0xF) << 4 | this.min >> 4, (this.max & 0xF) << 4 | this.max >> 4, 1);
        }
        return new Unknown(this.source, this.max);
    }

    public Value mapToBank(int n, int n2) {
        return this.sub(this.getMin() / n2 * n2).add(n * n2).newMultiplier(this.multiplier);
    }

    public static Value newUnknownValue(Address address, int n) {
        return new Unknown(address, n);
    }

    public static Value newUnknownValue(int n) {
        if (n == 255) {
            return UNKNOWN_BYTE;
        }
        return Value.newUnknownValue(NO_SOURCE, n);
    }

    public static Value newStackPointerValue(int n) {
        return new StackPointerValue(n);
    }

    public static Value newCalculatedIncValue(Value value) {
        if (value.getOffset() < 80) {
            return new CalculatedValue(value, CalculatedValue.Operator.ADD, ONE);
        }
        return value;
    }

    public static Value newCalculatedDecValue(Value value) {
        if (value instanceof CalculatedValue) {
            return ((CalculatedValue)value).getLeft();
        }
        return value;
    }

    public Value newValue(int n, int n2, int n3) {
        if (n == this.min && n2 == this.max && n3 == this.multiplier) {
            return this;
        }
        return new Value(n, n2, n3, this.source);
    }

    public Value newValue(int n, int n2) {
        if (n == this.min && n2 == this.max) {
            return this;
        }
        return new Value(n, n2, this.multiplier, this.source);
    }

    public Value newSource(Address address) {
        if (address == this.source) {
            return this;
        }
        return new Value(this.min, this.max, this.multiplier, address);
    }

    public Value newMultiplier(int n) {
        if (n == this.multiplier) {
            return this;
        }
        return new Value(this.min, this.max, n, this.source);
    }

    public boolean isStackPointerValue() {
        return this instanceof StackPointerValue;
    }

    public boolean isUnique() {
        return this.min == this.max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public Address getSource() {
        return this.source;
    }

    public int getOffset() {
        return 0;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.max;
        n = 31 * n + this.min;
        n = 31 * n + this.getOffset();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof Unknown) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Value value = (Value)object;
        if (this.max != value.max) {
            return false;
        }
        if (this.min != value.min) {
            return false;
        }
        if (this.getOffset() != value.getOffset()) {
            return false;
        }
        if (this.source == null) {
            return value.source == null;
        }
        return this.source.equals(value.source);
    }

    public String toString() {
        if (this.isUnique()) {
            if (this.source != null) {
                return String.format("%02x from " + this.source, this.min);
            }
            return String.format("%02x", this.min);
        }
        if (this.source != null) {
            return String.format("[%02x..%02x * %d] from " + this.source, this.min, this.max, this.multiplier);
        }
        return String.format("[%02x..%02x * %d]", this.min, this.max, this.multiplier);
    }

    private static class CalculatedValue
    extends Value {
        private final Value left;
        private final Operator operator;
        private final Value right;

        public CalculatedValue(Value value, Operator operator, Value value2) {
            super(value.min, value.max, value.multiplier, value.source);
            this.left = value;
            this.operator = operator;
            this.right = value2;
        }

        public Value getLeft() {
            return this.left;
        }

        @Override
        public Value add(Value value) {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value add(int n) {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value sub(Value value) {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value sub(int n) {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value and(Value value) {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value bound(int n, int n2) {
            return this;
        }

        @Override
        public Value and(int n) {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value xor(Value value) {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value xor(int n) {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value or(Value value) {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value or(int n) {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value dec() {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value inc(boolean bl) {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value resBit(int n) {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value setBit(int n) {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value rlc() {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value rrc() {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value rl() {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value rr() {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value sla() {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value sra() {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value sll() {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value srl() {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value swap() {
            return this.newValue(this.getMin(), this.getMax());
        }

        @Override
        public Value mapToBank(int n, int n2) {
            return this;
        }

        @Override
        public int getOffset() {
            switch (this.operator) {
                case ADD: {
                    return this.left.getOffset() + this.right.getOffset();
                }
            }
            return super.getOffset();
        }

        @Override
        public Value newValue(int n, int n2, int n3) {
            return new Unknown(this.min, n2, n3, this.source);
        }

        @Override
        public Value newValue(int n, int n2) {
            return new Unknown(this.min, n2, this.multiplier, this.source);
        }

        @Override
        public Value newMultiplier(int n) {
            return new Unknown(this.min, this.max, n, this.source);
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }

        @Override
        public String toString() {
            return (Object)((Object)this.operator) + "(" + this.left + ", " + this.right + ")";
        }

        protected static enum Operator {
            ADD;

        }
    }

    private static class StackPointerValue
    extends CalculatedValue {
        public StackPointerValue(int n) {
            super(ZERO, CalculatedValue.Operator.ADD, new Value(n){

                @Override
                public int getOffset() {
                    return this.getMin();
                }
            });
        }

        @Override
        public Value inc(boolean bl) {
            return new StackPointerValue(this.getOffset() + 1);
        }

        @Override
        public Value newValue(int n, int n2) {
            if (n == n2) {
                return this;
            }
            return super.newValue(n, n2);
        }

        @Override
        public int getMin() {
            return this.getOffset();
        }

        @Override
        public int getMax() {
            return this.getOffset();
        }
    }

    private static class Unknown
    extends Value {
        public Unknown(Address address, int n) {
            this(0, n, 1, address);
        }

        public Unknown(int n, int n2, int n3, Address address) {
            super(n, n2, n3, address);
        }

        @Override
        public Value add(Value value) {
            if (!(value instanceof Unknown) && value.getSource() != null && value.getSource().isUnique()) {
                return value.add(this);
            }
            if (this.source != null && this.source.equals(value.source)) {
                return new Unknown(this.min + value.min, this.max + value.max, this.multiplier + value.multiplier, this.source);
            }
            return this.newValue(0, 255).newSource(Address.combine(this.source, value.source));
        }

        @Override
        public Value add(int n) {
            return this.newValue(0, 255);
        }

        @Override
        public Value sub(Value value) {
            return this.newValue(0, 255);
        }

        @Override
        public Value sub(int n) {
            return this.newValue(0, 255);
        }

        @Override
        public Value and(Value value) {
            return this.newValue(0, 255);
        }

        @Override
        public Value and(int n) {
            int n2 = this.multiplier;
            while ((n2 & n) == 0 && n2 < 256) {
                n2 <<= 1;
            }
            return new Unknown(this.min & n, this.max & n, n2, this.source);
        }

        @Override
        public Value xor(Value value) {
            return this.newValue(0, 255);
        }

        @Override
        public Value xor(int n) {
            return this.newValue(0, 255);
        }

        @Override
        public Value or(Value value) {
            return this.newValue(0, 255);
        }

        @Override
        public Value or(int n) {
            return new Unknown(n, 255, 1, this.source);
        }

        @Override
        public Value dec() {
            return this.newValue(0, 255);
        }

        @Override
        public Value inc(boolean bl) {
            return this.newValue(0, 255);
        }

        @Override
        public Value neg() {
            return this.newValue(0, 255);
        }

        @Override
        public Value resBit(int n) {
            return this.newValue(0, 255);
        }

        @Override
        public Value setBit(int n) {
            return this.newValue(0, 255);
        }

        @Override
        public Value rlc() {
            return this.newValue(0, 255);
        }

        @Override
        public Value rrc() {
            return this.newValue(0, 255);
        }

        @Override
        public Value rl() {
            return this.newValue(0, 255);
        }

        @Override
        public Value rr() {
            return this.newValue(0, 255, Math.max(1, this.multiplier >> 1));
        }

        @Override
        public Value sla() {
            return this.newValue(0, 255);
        }

        @Override
        public Value sra() {
            return this.newValue(0, 255);
        }

        @Override
        public Value sll() {
            return this.newValue(0, 255);
        }

        @Override
        public Value srl() {
            return this.newValue(0, 255);
        }

        @Override
        public Value swap() {
            return this.newValue(0, 255);
        }

        @Override
        public Value mapToBank(int n, int n2) {
            return new Unknown(n * n2 | this.min & n2 - 1, n * n2 | this.max & n2 - 1, this.multiplier, this.source);
        }

        @Override
        public Value newValue(int n, int n2, int n3) {
            if (n == this.min && n2 == this.max && n3 == this.multiplier) {
                return this;
            }
            if (n2 < (this.getMax() & 0xFF)) {
                return super.newValue(n, n2);
            }
            return new Unknown(n, n2, n3, this.source);
        }

        @Override
        public Value newValue(int n, int n2) {
            if (n == this.min && n2 == this.max) {
                return this;
            }
            if (n2 < (this.getMax() & 0xFF)) {
                return super.newValue(n, n2);
            }
            return new Unknown(n, n2, this.multiplier, this.source);
        }

        @Override
        public Value newMultiplier(int n) {
            if (n == this.multiplier) {
                return this;
            }
            return new Unknown(this.min, this.max, n, this.source);
        }

        @Override
        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.source == null ? 0 : this.source.hashCode());
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Value value = (Value)object;
            return !(this.source == null ? value.source != null : !this.source.equals(value.source));
        }

        @Override
        public String toString() {
            return "Unknown(" + super.toString() + ")";
        }
    }
}

