/*
 * Decompiled with CFR 0.152.
 */
package debugfiles;

import assembler.EnumTrie;
import debugfiles.Action;
import debugfiles.ActionGroup;
import debugfiles.Address;
import debugfiles.AddressExpression;
import debugfiles.AddressRange;
import debugfiles.BankLValue;
import debugfiles.Condition;
import debugfiles.LValue;
import debugfiles.MemoryAccess;
import debugfiles.Symbol;
import debugfiles.Variable;
import debugfiles.VariableLValue;
import debugfiles.WarningHandler;
import debugfiles.commands.AlertCommand;
import debugfiles.commands.BasicCommand;
import debugfiles.commands.Command;
import debugfiles.commands.CommandKeyword;
import debugfiles.commands.DisableCommand;
import debugfiles.commands.EnableCommand;
import debugfiles.commands.IfCommand;
import debugfiles.commands.JumpCommand;
import debugfiles.commands.MessageCommand;
import debugfiles.commands.SetCommand;
import debugfiles.commands.SkipCommand;
import debugfiles.commands.ToggleCommand;
import disassembler.Symbols;
import expressions.Expression;
import expressions.ParseException;
import expressions.Token;
import expressions.Tokenizer;
import expressions.UnknownVariableException;
import expressions.VariableProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DebugFile {
    private static final Tokenizer tokenizer = new Tokenizer("\\$\\p{XDigit}+|%[01]+|#?\\d+", "<=|>=|<>|==|!=|<<|>>|&&|\\|\\||\\^\\^|\\*\\*|:|[+\\-*/%=<>&\\|\\^~!?]", "(?:\\p{Alpha}|_|@)(?:\\p{Alpha}|\\d|[$#.@_])*", "[\\(\\)\\[\\]]");
    private final Map<String, Symbols.Symbol> symbols = new HashMap<String, Symbols.Symbol>();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private final Map<String, Variable> variables = new HashMap<String, Variable>();
    private final Map<String, String> strings = new HashMap<String, String>();
    private final Map<String, ActionGroup> groups = new HashMap<String, ActionGroup>();
    private final Set<File> includedFiles = new HashSet<File>();
    private final Collection<String> internalVariables;
    private boolean firstLine;
    private int debugfileMajorVersion;
    private Map<String, Symbols.Symbol> locals = new HashMap<String, Symbols.Symbol>();
    private final VariableProvider variableProvider = new VariableProvider(){

        @Override
        public int readValue(int n, boolean bl, boolean bl2) {
            throw new UnsupportedOperationException("Expression must be constant");
        }

        @Override
        public int readLocation(String string, int n, boolean bl) throws UnknownVariableException {
            throw new UnsupportedOperationException("Expression must be constant");
        }

        @Override
        public int getBankAt(int n) {
            throw new UnsupportedOperationException("Expression must be constant");
        }

        @Override
        public long mapBank(int n, int n2) {
            return n2 << 16 | n & 0xFFFF;
        }

        @Override
        public boolean isConstantRead(int n) {
            return false;
        }

        @Override
        public boolean isConstant(String string) throws UnknownVariableException {
            if (DebugFile.this.symbols.containsKey(string) || DebugFile.this.locals.containsKey(string) || DebugFile.this.aliases.containsKey(string)) {
                return true;
            }
            if (!DebugFile.this.variables.containsKey(string)) {
                throw new UnknownVariableException(string);
            }
            return false;
        }

        @Override
        public long getValue(String string, boolean bl) throws UnknownVariableException {
            Symbols.Symbol symbol;
            Symbols.Symbol symbol2;
            String string2 = (String)DebugFile.this.aliases.get(string);
            if (string2 != null) {
                string = string2;
            }
            Symbols.Symbol symbol3 = symbol2 = (symbol = (Symbols.Symbol)DebugFile.this.locals.get(string)) != null ? symbol : (Symbols.Symbol)DebugFile.this.symbols.get(string);
            if (symbol2 == null) {
                throw new UnknownVariableException(string);
            }
            if (symbol2.getBank() >= 0) {
                return symbol2.getBank() << 16 | symbol2.getAddress() & 0xFFFF;
            }
            return symbol2.getAddress();
        }
    };
    private final ActionGroup DEFAULT_GROUP = new ActionGroup(null, null);

    private DebugFile(File file, List<Symbols.Symbol> list, Collection<String> collection, String string, WarningHandler warningHandler) throws IOException {
        this.internalVariables = collection;
        for (Symbols.Symbol symbol : list) {
            this.symbols.put(symbol.getLabel(), symbol);
        }
        this.parse(new ParsingState(file, string, warningHandler));
    }

    public static Tokenizer getTokenizer() {
        return tokenizer;
    }

    public Map<String, ActionGroup> getGroups() {
        return Collections.unmodifiableMap(this.groups);
    }

    public List<Action> getUngroupedActions() {
        return Collections.unmodifiableList(this.DEFAULT_GROUP.getActions());
    }

    public Map<String, Variable> getVariables() {
        return Collections.unmodifiableMap(this.variables);
    }

    public Set<File> getIncludedFiles() {
        return Collections.unmodifiableSet(this.includedFiles);
    }

    public String getString(String string) {
        return this.strings.get(string);
    }

    private void parse(ParsingState parsingState) throws IOException {
        String string = parsingState.readLine();
        while (string != null) {
            if (!(string = DebugFile.normalizeLine(string)).isEmpty()) {
                if (parsingState.accumulatedActionString.isEmpty()) {
                    parsingState.numAccumulated = 0;
                }
                if (string.charAt(0) == '@') {
                    this.parseDirective(string, parsingState);
                } else {
                    this.parseAction(string, parsingState);
                }
                this.firstLine = false;
            }
            string = parsingState.readLine();
        }
        if (!parsingState.accumulatedActionString.isEmpty()) {
            string = parsingState.accumulatedActionString.trim();
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Unexpected end of file encountered.\nA debugfile cannot end on: " + string.charAt(string.length() - 1));
        }
        parsingState.close();
    }

    private void parseDirective(String string, ParsingState parsingState) throws IOException {
        if ((string = string.substring(1)).isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Invalid directive \"@\" encountered.");
        }
        Directive directive = (Directive)((Object)parsingState.directiveTrie.get(string));
        if (parsingState.skipNonConditionals && !DebugFile.isConditional(directive)) {
            return;
        }
        if (string.charAt(0) == '@') {
            DebugFile.parsePrivateUse(string, parsingState);
            return;
        }
        if (directive == null) {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Invalid directive \"" + string + "\" encountered.");
        }
        if (this.firstLine && directive != Directive.DEBUGFILE) {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "First directive must be \"@debugfile\" directive but \"" + string + "\" was encountered.");
        }
        this.handleDirective(parsingState, directive, string.substring(directive.toString().length()).trim());
    }

    private void handleDirective(ParsingState parsingState, Directive directive, String string) throws IOException {
        switch (directive) {
            case DEBUGFILE: {
                String[] stringArray = string.split("\\.");
                int n = Integer.parseInt(stringArray[0]);
                if (n == 0) {
                    throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Illegal \"@debugfile\" directive encountered. Leading zeros are forbidden in the version number.");
                }
                if (this.debugfileMajorVersion != 0 && n != this.debugfileMajorVersion) {
                    throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Debugfile version conflicts with current debugfile version: " + n + " != " + this.debugfileMajorVersion);
                }
                this.debugfileMajorVersion = n;
                int n2 = 1;
                while (n2 < stringArray.length) {
                    Integer.parseInt(stringArray[n2]);
                    ++n2;
                }
                break;
            }
            case ALWAYS: {
                parsingState.skipNonConditionals = false;
                break;
            }
            case IFEMU: 
            case IFNOTEMU: {
                parsingState.skipNonConditionals = DebugFile.handleIfEmu(parsingState, string.split("\\s*,\\s*")) ^ directive == Directive.IFEMU;
                break;
            }
            case ELSE: {
                if (!parsingState.skipNonConditionals) break;
                Directive directive2 = (Directive)((Object)parsingState.directiveTrie.get(string));
                if (directive2 != null) {
                    if (!DebugFile.isConditional(directive2)) {
                        throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Encountered " + string + " after @else. Only conditional directives are allowed after an \"@else\" directive.");
                    }
                    this.handleDirective(parsingState, directive2, string.substring(directive2.toString().length()).trim());
                    break;
                }
                parsingState.skipNonConditionals = false;
                break;
            }
            case WARNING: {
                parsingState.warningHandler.handleWarning(string);
                break;
            }
            case ERROR: {
                throw new IllegalArgumentException(string);
            }
            case RADIX: {
                if ("2".equals(string)) {
                    parsingState.radix = 2;
                    break;
                }
                if ("10".equals(string)) {
                    parsingState.radix = 10;
                    break;
                }
                if ("16".equals(string)) {
                    parsingState.radix = 16;
                    break;
                }
                throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Illegal argument for @radix directive: " + string);
            }
            case SIGNEDNESS: {
                if ("SIGNED".equalsIgnoreCase(string)) {
                    parsingState.signedness = true;
                    break;
                }
                if ("UNSIGNED".equalsIgnoreCase(string)) {
                    parsingState.signedness = false;
                    break;
                }
                throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Illegal signedness \"" + string + "\" encountered.");
            }
            case IFDEF: 
            case IFNOTDEF: {
                parsingState.skipNonConditionals = this.isDefined(parsingState, string) ^ directive == Directive.IFDEF;
                break;
            }
            case ALIAS: {
                this.handleAlias(parsingState, string);
                break;
            }
            case GROUP: {
                this.handleGroup(parsingState, string);
                break;
            }
            case ENDGROUP: {
                parsingState.currentGroup = this.DEFAULT_GROUP;
                break;
            }
            case STR: {
                this.handleStr(parsingState, string);
                break;
            }
            case INCLUDE: {
                try {
                    Map<String, Symbols.Symbol> map = this.locals;
                    this.locals = new HashMap<String, Symbols.Symbol>(map);
                    this.parse(parsingState.include(this.parseString(parsingState, string)));
                    this.locals = map;
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(String.valueOf(parsingState.getContext(1)) + "An error occurred handling an @include directive: " + iOException.getMessage());
                }
            }
            case SYMFILE: {
                for (Symbols.Symbol symbol : Symbols.loadSymbols(parsingState.getSymFile(this.parseString(parsingState, string)))) {
                    this.symbols.put(symbol.getLabel(), symbol);
                }
                break;
            }
            case IF: {
                parsingState.skipNonConditionals = this.handleIf(parsingState, string);
                break;
            }
            case SYM: {
                this.handleSym(parsingState, string);
                break;
            }
            case LOCAL: {
                this.handleLocal(parsingState, string);
                break;
            }
            case VAR: {
                this.handleVar(parsingState, string);
            }
        }
    }

    private void handleVar(ParsingState parsingState, String string) {
        try {
            Token[] tokenArray = tokenizer.tokenize(string, parsingState.radix);
            if (tokenArray.length == 0) {
                throw new ParseException("Invalid \"@var\" directive encountered. Name and value missing.");
            }
            if (tokenArray.length == 1) {
                throw new ParseException("Invalid \"@var\" directive encountered. Value missing.");
            }
            if (tokenArray[0].getToken().charAt(0) != '_') {
                throw new ParseException("Invalid \"@var\" directive encountered. Names of user variables must begin with an underscore (_).");
            }
            this.variables.put(tokenArray[0].getToken(), new Variable(tokenArray[0].getToken(), this.evaluate(parsingState, string.substring(tokenArray[0].getToken().length()))));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + parseException.getMessage());
        }
        catch (UnknownVariableException unknownVariableException) {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + unknownVariableException.getMessage());
        }
    }

    private long evaluate(ParsingState parsingState, String string) throws UnknownVariableException, ParseException {
        return new Expression(string, tokenizer, parsingState.radix, true).getValue(this.variableProvider, null, parsingState.signedness);
    }

    private void handleSym(ParsingState parsingState, String string) {
        try {
            Token[] tokenArray = tokenizer.tokenize(string, parsingState.radix);
            if (tokenArray.length == 0) {
                throw new ParseException("Invalid \"@sym\" directive encountered. Name and address missing.");
            }
            if (tokenArray.length == 1) {
                throw new ParseException("Invalid \"@sym\" directive encountered. address missing.");
            }
            Address address = this.parseAddress(parsingState, string.substring(tokenArray[0].getToken().length()), false);
            this.symbols.put(tokenArray[0].getToken(), new Symbol(tokenArray[0].getToken(), address.getBank(), address.getAddress()));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + parseException.getMessage());
        }
    }

    private void handleLocal(ParsingState parsingState, String string) {
        try {
            Token[] tokenArray = tokenizer.tokenize(string, parsingState.radix);
            if (tokenArray.length == 0) {
                throw new ParseException("Invalid \"@local\" directive encountered. Name and address missing.");
            }
            if (tokenArray.length == 1) {
                throw new ParseException("Invalid \"@local\" directive encountered. address missing.");
            }
            Address address = this.parseAddress(parsingState, string.substring(tokenArray[0].getToken().length()), false);
            this.locals.put(tokenArray[0].getToken(), new Symbol(tokenArray[0].getToken(), address.getBank(), address.getAddress()));
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + parseException.getMessage());
        }
    }

    private boolean handleIf(ParsingState parsingState, String string) {
        try {
            return this.evaluate(parsingState, string) == 0L;
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + parseException.getMessage());
        }
        catch (UnknownVariableException unknownVariableException) {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + unknownVariableException.getMessage());
        }
    }

    private void handleGroup(ParsingState parsingState, String string) {
        int n = string.indexOf(32);
        if (n < 0) {
            n = string.length();
        }
        String string2 = string.substring(0, n);
        String string3 = this.parseString(parsingState, string, n, true);
        parsingState.currentGroup = this.groups.get(string2);
        if (parsingState.currentGroup != null) {
            if (string3 != null && !string3.equals(parsingState.currentGroup.getDisplayName())) {
                parsingState.warningHandler.handleWarning(String.valueOf(parsingState.getContext(1)) + "Ignored new display name \"" + string3 + "\" for group " + string2 + " (\"" + parsingState.currentGroup.getDisplayName() + "\")");
            }
        } else {
            parsingState.currentGroup = new ActionGroup(string2, string3);
        }
        this.groups.put(string2, parsingState.currentGroup);
    }

    private void handleStr(ParsingState parsingState, String string) {
        int n = string.indexOf(32);
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Invalid \"@str\" directive encountered.");
        }
        String string2 = string.substring(0, n);
        int n2 = string.indexOf(34, n);
        int n3 = string.lastIndexOf(34);
        if (n3 <= n2) {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Invalid \"@str\" directive encountered.");
        }
        this.strings.put(string2, string.substring(n2 + 1, n3));
    }

    private void handleAlias(ParsingState parsingState, String string) {
        String[] stringArray = string.split(" ");
        String string2 = stringArray[1].replace("\"", "");
        if (!this.symbols.containsKey(string2)) {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Symbol '" + string2 + "' is undefined.");
        }
        this.aliases.put(stringArray[0], string2);
    }

    private static boolean isConditional(Directive directive) {
        return directive == Directive.ALWAYS || directive == Directive.ELSE || directive == Directive.IF || directive == Directive.IFDEF || directive == Directive.IFEMU || directive == Directive.IFNOTDEF || directive == Directive.IFNOTEMU;
    }

    private boolean isDefined(ParsingState parsingState, String string) {
        if (string.isEmpty()) {
            return false;
        }
        if (string.charAt(0) == '@') {
            return this.variables.containsKey(string.substring(1)) || this.internalVariables.contains(string.substring(1).toLowerCase());
        }
        return this.resolveSymbol(string) != null;
    }

    public Symbols.Symbol resolveSymbol(String string) {
        Symbols.Symbol symbol;
        String string2 = this.aliases.get(string);
        if (string2 != null) {
            string = string2;
        }
        if ((symbol = this.locals.get(string)) != null) {
            return symbol;
        }
        return this.symbols.get(string);
    }

    public void setLocals(Map<String, Symbols.Symbol> map) {
        this.locals = map;
    }

    private static boolean handleIfEmu(ParsingState parsingState, String[] stringArray) throws NumberFormatException {
        boolean bl = false;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            String[] stringArray3 = string.split("\\s+");
            if (stringArray3.length > 0 && "Emulicious".equalsIgnoreCase(stringArray3[0])) {
                if (stringArray3.length == 1) {
                    return true;
                }
                if (stringArray3.length == 2) {
                    return DebugFile.checkVersion("=", parsingState.emuliciousVersion, DebugFile.parseEmuliciousVersion(stringArray3[1], parsingState.warningHandler));
                }
                if ((stringArray3.length - 1) % 2 == 0) {
                    bl = true;
                    int n3 = 2;
                    while (n3 < stringArray3.length) {
                        if (!DebugFile.checkVersion(stringArray3[n3 - 1], parsingState.emuliciousVersion, DebugFile.parseEmuliciousVersion(stringArray3[n3], parsingState.warningHandler))) {
                            bl = false;
                            break;
                        }
                        n3 += 2;
                    }
                } else {
                    throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Syntax error in emulator spec: " + string);
                }
            }
            ++n2;
        }
        return bl;
    }

    private static boolean checkVersion(String string, int n, int n2) {
        switch (string.charAt(0)) {
            case '=': {
                if (string.length() != 1 && (string.length() != 2 || string.charAt(1) != '=')) break;
                return n == n2;
            }
            case '<': {
                if (string.length() == 1) {
                    return n < n2;
                }
                if (string.length() != 2) break;
                if (string.charAt(1) == '=') {
                    return n <= n2;
                }
                if (string.charAt(1) != '>') break;
                return n != n2;
            }
            case '>': {
                if (string.length() == 1) {
                    return n > n2;
                }
                if (string.length() != 2 || string.charAt(1) != '=') break;
                return n >= n2;
            }
            case '!': {
                if (string.length() != 2 || string.charAt(1) != '=') break;
                return n != n2;
            }
        }
        throw new IllegalArgumentException("Invalid operator encountered in emulator spec.");
    }

    static int parseEmuliciousVersion(String string, WarningHandler warningHandler) {
        if (string == null) {
            warningHandler.handleWarning("Invalid version number encountered: " + string);
            return 0;
        }
        try {
            return Integer.parseInt(string.replaceAll("-|\\.", ""));
        }
        catch (NumberFormatException numberFormatException) {
            warningHandler.handleWarning("Invalid version number encountered: " + string);
            return 0;
        }
    }

    private static void parsePrivateUse(String string, ParsingState parsingState) {
        throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Private-use directive \"" + string + "\" encountered. Currently no private-use directives are defined for Emulicious.");
    }

    private void parseAction(String string, ParsingState parsingState) {
        if (parsingState.skipNonConditionals) {
            return;
        }
        char c = string.charAt(string.length() - 1);
        if (c == ';' || c == ':') {
            parsingState.accumulatedActionString = String.valueOf(parsingState.accumulatedActionString) + string + "\n";
            ++parsingState.numAccumulated;
        } else {
            string = String.valueOf(parsingState.accumulatedActionString) + string;
            parsingState.accumulatedActionString = "";
            int n = string.indexOf(32);
            if (n < 0) {
                throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Invalid action line encountered: " + string);
            }
            String string2 = string.substring(n).trim();
            int n2 = Math.min(string2.indexOf(32) & Integer.MAX_VALUE, string2.indexOf(58) & Integer.MAX_VALUE);
            if (n2 >= string2.length()) {
                throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Invalid action line encountered: " + string);
            }
            String string3 = string2.substring(0, n2).toLowerCase();
            boolean bl = !string3.contains("ss") && (string3.contains("s") || parsingState.signedness);
            AddressRange[] addressRangeArray = this.parseAddressRanges(string, n, parsingState, bl);
            String string4 = string2.substring(n2).trim();
            int n3 = DebugFile.endIndexOfConditionExpression(string4);
            Expression expression = DebugFile.parseExpression(parsingState, string4.substring(0, n3));
            String string5 = string4.substring(n3).trim();
            if (string5.isEmpty() || string5.charAt(0) != ':') {
                throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Action line is missing commands.");
            }
            Condition condition = new Condition(addressRangeArray, string3, expression);
            parsingState.currentGroup.addAction(new Action(condition, this.parseCommands(parsingState, string5.substring(1).trim()), parsingState.radix, bl, this.locals));
        }
    }

    private static Expression parseExpression(ParsingState parsingState, String string) {
        if (string != null && !string.isEmpty()) {
            try {
                return new Expression(string, tokenizer, parsingState.radix, true);
            }
            catch (ParseException parseException) {
                throw new RuntimeException(String.valueOf(parsingState.getContext(1)) + parseException.getMessage());
            }
        }
        return null;
    }

    private static int endIndexOfConditionExpression(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '[') {
                ++n2;
                while (n2 < n && string.charAt(n2) != ']') {
                    ++n2;
                }
            } else if (c == ':') {
                return n2;
            }
            ++n2;
        }
        return n;
    }

    private Command[] parseCommands(ParsingState parsingState, String string) {
        String[] stringArray = DebugFile.splitCommands(parsingState, string);
        Command[] commandArray = new Command[stringArray.length];
        int n = 0;
        while (n < commandArray.length) {
            commandArray[n] = this.parseCommand(parsingState, stringArray[n]);
            ++n;
        }
        n = 0;
        while (n < commandArray.length) {
            if (commandArray[n] instanceof SkipCommand && n + ((SkipCommand)commandArray[n]).getAmount() >= commandArray.length) {
                throw new RuntimeException(String.valueOf(parsingState.getContext(1)) + "Invalid argument for @skip directive: " + ((SkipCommand)commandArray[n]).getAmount() + "\nCannot skip past the end of the list of commands.");
            }
            ++n;
        }
        return commandArray;
    }

    private static String[] splitCommands(ParsingState parsingState, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c == ';') {
                arrayList.add(string.substring(n2, n3).trim());
                n2 = n3 + 1;
            } else if (c == '\"') {
                ++n3;
                while (n3 < n) {
                    char c2 = string.charAt(n3);
                    if (c2 == '\n') {
                        throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Closing quotation mark is missing.");
                    }
                    if (c2 == '{') {
                        int n4 = n3 + 1;
                        while (n4 < n && string.charAt(n4) != '}') {
                            ++n4;
                        }
                        if (n4 < n) {
                            n3 = n4;
                        }
                    } else if (c2 == '\"') break;
                    ++n3;
                }
            }
            ++n3;
        }
        if (n2 < n) {
            arrayList.add(string.substring(n2).trim());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private Command parseCommand(ParsingState parsingState, String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Command expected but was not there.");
        }
        if (string.charAt(0) == '_') {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Private-use directive \"" + string + "\" encountered. Currently no private-use directives are defined for Emulicious.");
        }
        CommandKeyword commandKeyword = (CommandKeyword)((Object)parsingState.commandTrie.get(string));
        if (commandKeyword == null) {
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Illegal command encountered: " + string);
        }
        switch (commandKeyword) {
            case ALERT: {
                return new AlertCommand(this.parseString(parsingState, string, commandKeyword.toString().length()));
            }
            case BREAK: {
                return new BasicCommand(CommandKeyword.BREAK);
            }
            case DISABLE: {
                return new DisableCommand(string.substring(commandKeyword.toString().length()).trim());
            }
            case DONE: {
                return new BasicCommand(CommandKeyword.DONE);
            }
            case ELSE: {
                return new BasicCommand(CommandKeyword.ELSE);
            }
            case ENABLE: {
                return new EnableCommand(string.substring(commandKeyword.toString().length()).trim());
            }
            case IF: {
                return new IfCommand(DebugFile.parseExpression(parsingState, string.substring(commandKeyword.toString().length())));
            }
            case JUMP: {
                return new JumpCommand(DebugFile.parseAddressExpression(parsingState, string.substring(commandKeyword.toString().length()).trim()));
            }
            case MESSAGE: {
                return new MessageCommand(this.parseString(parsingState, string, commandKeyword.toString().length()));
            }
            case NOP: {
                return new BasicCommand(CommandKeyword.NOP);
            }
            case RESET: {
                return new BasicCommand(CommandKeyword.RESET);
            }
            case SET: {
                String[] stringArray = string.substring(commandKeyword.toString().length()).split(":=");
                try {
                    LValue lValue;
                    if (stringArray.length != 2) {
                        throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Invalid set command encountered.");
                    }
                    stringArray[0] = stringArray[0].trim();
                    Token[] tokenArray = tokenizer.tokenize(stringArray[0], parsingState.radix);
                    String string2 = tokenArray[0].getToken();
                    if ("&".equals(string2)) {
                        lValue = new BankLValue(DebugFile.parseExpression(parsingState, stringArray[0].substring(1)));
                    } else if ("[".equals(string2)) {
                        lValue = new MemoryAccess(tokenArray, DebugFile.parseAddressExpression(parsingState, DebugFile.stripMemoryAccess(stringArray[0])));
                    } else if (tokenArray.length == 1) {
                        String string3;
                        if (this.symbols.containsKey(string2) || this.locals.containsKey(string2)) {
                            throw new RuntimeException(String.valueOf(parsingState.getContext(1)) + "Invalid set command encountered. Cannot set value of a symbol: " + string2);
                        }
                        String string4 = string3 = string2.charAt(0) == '@' ? string2.substring(1) : string2;
                        if (string3.charAt(0) == '_' && !this.variables.containsKey(string3)) {
                            throw new RuntimeException(String.valueOf(parsingState.getContext(1)) + "Undefined variable encountered: " + string3);
                        }
                        lValue = new VariableLValue(string3);
                    } else {
                        throw new RuntimeException(String.valueOf(parsingState.getContext(0)) + "Invalid set command encountered.");
                    }
                    return new SetCommand(lValue, DebugFile.parseExpression(parsingState, stringArray[1]));
                }
                catch (ParseException parseException) {
                    throw new RuntimeException(String.valueOf(parsingState.getContext(1)) + parseException.getMessage());
                }
            }
            case SKIP: {
                try {
                    return new SkipCommand((int)this.evaluate(parsingState, string.substring(commandKeyword.toString().length())));
                }
                catch (UnknownVariableException unknownVariableException) {
                    throw new RuntimeException(String.valueOf(parsingState.getContext(1)) + unknownVariableException.getMessage());
                }
                catch (ParseException parseException) {
                    throw new RuntimeException(String.valueOf(parsingState.getContext(1)) + parseException.getMessage());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new RuntimeException(String.valueOf(parsingState.getContext(1)) + arrayIndexOutOfBoundsException.getMessage());
                }
            }
            case TOGGLE: {
                return new ToggleCommand(string.substring(commandKeyword.toString().length()).trim());
            }
        }
        throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Illegal command encountered: " + string);
    }

    private static String stripMemoryAccess(String string) {
        int n = 0;
        int n2 = string.length();
        while (string.charAt(n) <= ' ') {
            ++n;
        }
        if (string.charAt(n) != '[') {
            throw new IllegalArgumentException("Not a memory access");
        }
        ++n;
        while (string.charAt(n2 - 1) <= ' ') {
            --n2;
        }
        if (string.charAt(n2 - 1) != ']') {
            throw new IllegalArgumentException("Not a memory access");
        }
        --n2;
        while ("!?^".indexOf(string.charAt(n2 - 1)) >= 0) {
            --n2;
        }
        return string.substring(n, n2);
    }

    private AddressRange[] parseAddressRanges(String string, int n, ParsingState parsingState, boolean bl) {
        if (string.charAt(0) == '*') {
            return new AddressRange[]{new AddressRange(new Address(-1, 0), new Address(-1, 65535))};
        }
        String string2 = string.substring(0, n);
        String[] stringArray = string2.split(",");
        AddressRange[] addressRangeArray = new AddressRange[stringArray.length];
        int n2 = 0;
        while (n2 < addressRangeArray.length) {
            addressRangeArray[n2] = this.parseAddressRange(parsingState, stringArray[n2], bl);
            ++n2;
        }
        return addressRangeArray;
    }

    private AddressRange parseAddressRange(ParsingState parsingState, String string, boolean bl) {
        int n = Math.max(string.indexOf("--"), string.indexOf("++"));
        if (n >= 0) {
            char c = string.charAt(n);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 2);
            Address address = this.parseAddress(parsingState, string2, true, bl);
            Address address2 = this.parseAddress(parsingState, string3, true, bl);
            if (c == '+' && (address2.getAddress() & 0xFFFF) == 0) {
                throw new RuntimeException(String.valueOf(parsingState.getContext(1)) + "The length in an address range must not be zero: " + string);
            }
            return new AddressRange(address, c == '+' ? DebugFile.addAddresses(address, address2) : address2);
        }
        return new AddressRange(this.parseAddress(parsingState, string, true, bl), null);
    }

    private Address parseAddress(ParsingState parsingState, String string, boolean bl) {
        return this.parseAddress(parsingState, string, bl, parsingState.signedness);
    }

    private Address parseAddress(ParsingState parsingState, String string, boolean bl, boolean bl2) {
        int n;
        string = string.trim();
        int n2 = string.length();
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            n = string.charAt(n4);
            if (n == 58 || bl && n == 32) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        Expression expression = DebugFile.parseExpression(parsingState, string.substring(n3 + 1));
        try {
            if (!expression.isConstant(this.variableProvider, null)) {
                throw new RuntimeException(String.valueOf(parsingState.getContext(1)) + "Address '" + string + "' is not constant.");
            }
        }
        catch (UnknownVariableException unknownVariableException) {
            throw new RuntimeException(String.valueOf(parsingState.getContext(1)) + unknownVariableException.getMessage());
        }
        try {
            int n5 = (int)expression.getValue(this.variableProvider, null, bl2);
            if (n3 >= 0 && string.charAt(n3) == ':') {
                n = (int)(n3 == 0 ? -1L : DebugFile.parseExpression(parsingState, string.substring(0, n3)).getValue(this.variableProvider, null, bl2));
            } else if (!expression.getVariableNames().isEmpty()) {
                int n6 = -1;
                try {
                    Token[] tokenArray = tokenizer.tokenize(string, parsingState.radix);
                    int n7 = 0;
                    while (n7 < tokenArray.length && tokenArray[n7].isParenthesis()) {
                        ++n7;
                    }
                    if (n7 < tokenArray.length && tokenArray[n7].isIdentifier()) {
                        n6 = (int)(DebugFile.parseExpression(parsingState, tokenArray[n7].toString()).getValue(this.variableProvider, null, bl2) >> 16);
                    }
                }
                catch (ParseException parseException) {}
                n = n6;
            } else {
                n = -1;
            }
            return new Address(n, n5 & 0xFFFF);
        }
        catch (UnknownVariableException unknownVariableException) {
            throw new RuntimeException(String.valueOf(parsingState.getContext(1)) + unknownVariableException.getMessage());
        }
    }

    private static AddressExpression parseAddressExpression(ParsingState parsingState, String string) {
        int n = string.indexOf(58);
        return new AddressExpression(n >= 0 && string.charAt(n) == ':' ? DebugFile.parseExpression(parsingState, string.substring(0, n)) : null, DebugFile.parseExpression(parsingState, string.substring(n + 1)));
    }

    private static Address addAddresses(Address address, Address address2) {
        return new Address(address.getBank(), address.getAddress() + (address2.getAddress() & 0xFFFF) - 1);
    }

    private String parseString(ParsingState parsingState, String string) {
        return this.parseString(parsingState, string, 0);
    }

    private String parseString(ParsingState parsingState, String string, int n) {
        return this.parseString(parsingState, string, n, false);
    }

    private String parseString(ParsingState parsingState, String string, int n, boolean bl) {
        int n2 = string.length();
        int n3 = n;
        while (n3 < n2 && string.charAt(n3) <= ' ') {
            ++n3;
        }
        if (n3 >= n2 || string.charAt(n3) != '\"') {
            if (bl) {
                return null;
            }
            String string2 = this.strings.get(string.substring(n3));
            if (string2 != null) {
                return string2;
            }
            throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "The directive in this line expectes a string.");
        }
        int n4 = ++n3;
        while (n3 < n2) {
            int n5;
            char c = string.charAt(n3);
            if (c == '{') {
                n5 = n3 + 1;
                while (n5 < n2 && string.charAt(n5) != '}') {
                    ++n5;
                }
                if (n5 < n2) {
                    n3 = n5;
                }
            } else if (c == '\"') {
                n5 = n3 + 1;
                while (n5 < n2) {
                    if (string.charAt(n3) > ' ') {
                        throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Syntax error. Encountered the following after a string expression: " + string.substring(n3 + 1));
                    }
                    ++n5;
                }
                return string.substring(n4, n3);
            }
            ++n3;
        }
        throw new IllegalArgumentException(String.valueOf(parsingState.getContext(1)) + "Closing quotation mark is missing.");
    }

    private static String normalizeLine(String string) {
        string = string.replace('\t', ' ');
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == ';') {
                return "";
            }
            if (c > ' ') break;
            ++n2;
        }
        return string.trim();
    }

    public static DebugFile from(File file, List<Symbols.Symbol> list, Collection<String> collection, String string, WarningHandler warningHandler) throws IOException {
        return new DebugFile(file, list, collection, string, warningHandler);
    }

    private static enum Directive {
        DEBUGFILE,
        ALWAYS,
        IF,
        IFDEF,
        IFEMU,
        IFNOTDEF,
        IFNOTEMU,
        ELSE,
        SYM,
        LOCAL,
        ALIAS,
        VAR,
        STR,
        GROUP,
        ENDGROUP,
        INCLUDE,
        SYMFILE,
        RADIX,
        SIGNEDNESS,
        WARNING,
        ERROR;

    }

    private class ParsingState {
        final EnumTrie directiveTrie = new EnumTrie(Directive.class);
        final EnumTrie commandTrie = new EnumTrie(CommandKeyword.class);
        final File file;
        final BufferedReader reader;
        final String filename;
        final int emuliciousVersion;
        final WarningHandler warningHandler;
        int lineNumber;
        boolean skipNonConditionals;
        boolean signedness;
        int radix;
        ActionGroup currentGroup;
        String accumulatedActionString;
        int numAccumulated;

        ParsingState(File file, String string, WarningHandler warningHandler) throws IOException {
            this(file, DebugFile.parseEmuliciousVersion(string, warningHandler), warningHandler);
        }

        ParsingState(File file, int n, WarningHandler warningHandler) throws IOException {
            this.currentGroup = DebugFile.this.DEFAULT_GROUP;
            this.accumulatedActionString = "";
            this.file = file;
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            this.filename = file.getName();
            this.emuliciousVersion = n;
            this.warningHandler = warningHandler;
            this.radix = 10;
            this.lineNumber = 0;
        }

        ParsingState include(String string) throws IOException {
            File file = new File(this.file.getParentFile(), string);
            DebugFile.this.includedFiles.add(file);
            return new ParsingState(file, this.emuliciousVersion, this.warningHandler);
        }

        File getSymFile(String string) {
            return new File(this.file.getParentFile(), string);
        }

        String readLine() throws IOException {
            ++this.lineNumber;
            return this.reader.readLine();
        }

        String getContext(int n) {
            return String.valueOf(this.filename) + " (" + (this.numAccumulated > 0 ? String.valueOf(this.lineNumber - this.numAccumulated) + "-" + this.lineNumber : Integer.valueOf(this.lineNumber)) + "): ";
        }

        void close() throws IOException {
            this.reader.close();
        }
    }
}

