/*
 * Decompiled with CFR 0.152.
 */
package components.input;

import components.input.ButtonInputProvider;
import components.input.MDJoypad3;
import components.input.MDJoypad6;
import components.input.SMSInputDevice;
import components.input.SMSJoypad;
import components.input.SMSLightPhaser;
import components.input.SegaGraphicBoard;

public class SMSButtons {
    public static final int SMSKEY_BEGIN = 8;
    public static final int SMSKEY_A_UP = 8;
    public static final int SMSKEY_A_DOWN = 9;
    public static final int SMSKEY_A_LEFT = 10;
    public static final int SMSKEY_A_RIGHT = 11;
    public static final int SMSKEY_A_1 = 12;
    public static final int SMSKEY_A_2 = 13;
    public static final int SMSKEY_B_UP = 14;
    public static final int SMSKEY_B_DOWN = 15;
    public static final int SMSKEY_B_LEFT = 16;
    public static final int SMSKEY_B_RIGHT = 17;
    public static final int SMSKEY_B_1 = 18;
    public static final int SMSKEY_B_2 = 19;
    public static final int SMSKEY_RESET = 20;
    public static final int SMSKEY_A_TH = 21;
    public static final int SMSKEY_B_TH = 22;
    public static final int SMSKEY_PAUSE = 23;
    public static final int MDKEY_A_START = 24;
    public static final int MDKEY_A_A = 25;
    public static final int MDKEY_B_START = 26;
    public static final int MDKEY_B_A = 27;
    public static final int GGKEY_START = 28;
    public static final int MDKEY_A_MODE = 29;
    public static final int MDKEY_A_X = 30;
    public static final int MDKEY_A_Y = 31;
    public static final int MDKEY_A_Z = 32;
    public static final int MDKEY_B_MODE = 33;
    public static final int MDKEY_B_X = 34;
    public static final int MDKEY_B_Y = 35;
    public static final int MDKEY_B_Z = 36;
    public static final int GGKEY_XTERMINATOR_RESET = 37;
    public static final int SMSKEY_END = 38;
    private final ButtonInputProvider buttonInputProvider;
    private boolean pauseOverride;
    private boolean resetOverride;
    private boolean ggStartOverride;

    public SMSButtons(ButtonInputProvider buttonInputProvider) {
        this.buttonInputProvider = buttonInputProvider;
    }

    public static int indexOfInputDevice(SMSInputDevice sMSInputDevice) {
        if (sMSInputDevice == SMSInputDevice.NULL_DEVICE) {
            return 0;
        }
        if (sMSInputDevice instanceof SegaGraphicBoard) {
            return 5;
        }
        if (sMSInputDevice instanceof SMSLightPhaser) {
            return 4;
        }
        if (sMSInputDevice instanceof MDJoypad6) {
            return 3;
        }
        if (sMSInputDevice instanceof MDJoypad3) {
            return 2;
        }
        if (sMSInputDevice instanceof SMSJoypad) {
            return 1;
        }
        return -1;
    }

    public static String getInputDeviceName(SMSInputDevice sMSInputDevice) {
        return SMSInputDevice.DEVICE_NAMES[SMSButtons.indexOfInputDevice(sMSInputDevice)];
    }

    public static String[] getButtonNames(SMSInputDevice sMSInputDevice) {
        return SMSInputDevice.BUTTON_NAMES[SMSButtons.indexOfInputDevice(sMSInputDevice)];
    }

    public boolean isPauseButtonPressed() {
        boolean bl = this.buttonInputProvider.isButtonDown(23);
        if (bl) {
            this.pauseOverride = false;
        }
        return bl || this.pauseOverride;
    }

    public boolean isStartButtonPressed() {
        boolean bl = this.buttonInputProvider.isButtonDown(28);
        if (bl) {
            this.ggStartOverride = false;
        }
        return bl || this.ggStartOverride;
    }

    public boolean isResetButtonPressed() {
        boolean bl = this.buttonInputProvider.isButtonDown(20);
        if (bl) {
            this.resetOverride = false;
        }
        return bl || this.resetOverride;
    }

    public int getResetButtonState() {
        return this.isResetButtonPressed() ? 0 : 16;
    }

    public boolean isButtonDown(int n) {
        if (n == 2) {
            return this.isStartButtonPressed();
        }
        if (n == 1) {
            return this.isResetButtonPressed();
        }
        return this.isPauseButtonPressed();
    }

    public void setButtonDownOverride(int n, boolean bl) {
        if (n == 2) {
            this.ggStartOverride = bl;
        } else if (n == 1) {
            this.resetOverride = bl;
        } else {
            this.pauseOverride = bl;
        }
    }

    public int getState() {
        return (this.isPauseButtonPressed() ? 32768 : 0) | (this.isResetButtonPressed() ? 4096 : 0) | (this.isStartButtonPressed() ? 0x100000 : 0);
    }

    public void setState(long l) {
        this.pauseOverride = (l & 0x8000L) != 0L;
        this.resetOverride = (l & 0x1000L) != 0L;
        this.ggStartOverride = (l & 0x100000L) != 0L;
    }
}

