/*
 * Decompiled with CFR 0.152.
 */
package replay;

import java.io.IOException;
import replay.Bk2InputLogIterator;
import replay.Bk2ReplayData;
import replay.MSXInputLog;
import replay.ParseException;

public class Bk2MSXInputLog
implements MSXInputLog {
    private final Bk2InputLogIterator it;

    public Bk2MSXInputLog(Bk2ReplayData bk2ReplayData) throws IOException {
        this.it = new Bk2InputLogIterator(bk2ReplayData);
    }

    @Override
    public void getNextInput(int[] nArray) throws ParseException {
        int n = this.it.getLineNumber();
        String string = this.it.next();
        try {
            int n2 = 0;
            int n3 = 0;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                if (c != '|') {
                    try {
                        boolean bl;
                        ++n3;
                        boolean bl2 = bl = c == '.';
                        if (bl) {
                            if (n3 >= string.length()) {
                                throw new ParseException("Second dot is missing in line " + n + ", column " + n3);
                            }
                            if (string.charAt(n3) != '.') {
                                throw new ParseException("Illegal character encountered in line " + n + ", column " + n3 + ": '" + c + "' but '.' expected.");
                            }
                        } else if (n3 >= string.length()) {
                            throw new ParseException("Second digit of hex number is missing in line " + n + ", column " + n3);
                        }
                        nArray[n2++] = bl ? 0 : Bk2MSXInputLog.parseHexDigit(c) << 4 | Bk2MSXInputLog.parseHexDigit(string.charAt(n3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Illegal character encountered in line " + n + ", column " + n3 + ": '" + c + "' but hex digit expected.");
                    }
                }
                ++n3;
            }
        }
        catch (ParseException parseException) {
            this.it.close();
            throw parseException;
        }
    }

    private static int parseHexDigit(char c) {
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new NumberFormatException();
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }
}

